/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.cidr.lang.editor.completion.SymbolLookupBuilderUtil;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OCSymbolsToLookupConverter
implements Processor<OCSymbol> {
    private final OCSymbolGroupContext myContext;
    private final ConverterState myState;
    private final CompletionResultSet myResult;
    private final boolean myAllowAutocomplete;
    private final PsiElement myContextExpression;
    private final Condition<OCSymbol> myCondition;
    private final ArrayList<OCStructSymbol> myAccumulatedStructSymbols;
    private final VirtualFile myContextFile;
    private final boolean myInCpp;
    private boolean myEmpty = true;

    public static OCSymbolsToLookupConverter createLookupConverter(OCSymbolGroupContext ctx, ConverterState state, CompletionResultSet result2, boolean autocomplete, PsiElement element, Condition<OCSymbol> condition) {
        return new OCSymbolsToLookupConverter(ctx, state, result2, autocomplete, element, condition);
    }

    public OCSymbolsToLookupConverter(OCSymbolGroupContext ctx, ConverterState state, CompletionResultSet result2, boolean allowAutocomplete, PsiElement contextExpression, Condition<OCSymbol> condition) {
        OCFile ocFile;
        this.myContext = ctx;
        this.myState = state;
        this.myResult = result2;
        this.myAllowAutocomplete = allowAutocomplete;
        this.myContextExpression = contextExpression;
        this.myCondition = condition;
        this.myAccumulatedStructSymbols = new ArrayList();
        boolean bl = this.myInCpp = !OCCodeInsightUtil.isInPlainOldC(contextExpression);
        this.myContextFile = this.myContextExpression instanceof OCElement ? ((ocFile = ((OCElement)this.myContextExpression).getContainingOCFile()) != null ? ocFile.getOriginalFile().getVirtualFile() : null) : null;
    }

    public boolean process(OCSymbol symbol) {
        if (!(symbol instanceof OCStructSymbol)) {
            return this.doProcess(symbol);
        }
        this.myAccumulatedStructSymbols.add((OCStructSymbol)symbol);
        return true;
    }

    public boolean finish() {
        for (OCSymbol oCSymbol : this.myAccumulatedStructSymbols) {
            if (this.doProcess(oCSymbol)) continue;
            return false;
        }
        return true;
    }

    public boolean doProcess(OCSymbol symbol) {
        if (symbol instanceof OCMethodSymbol) {
            return true;
        }
        if (symbol instanceof OCClassSymbol && ((OCClassSymbol)symbol).getCategoryName() != null) {
            return true;
        }
        if (symbol instanceof OCUsingSymbol) {
            return true;
        }
        if (!OCSymbol.NON_FANTOM_SYMBOL_CONDITION.value((Object)symbol)) {
            return true;
        }
        String name = symbol.getName();
        int spaceIdx = name.lastIndexOf(32);
        if (spaceIdx >= 0) {
            name = name.substring(spaceIdx + 1);
        }
        if (!this.myResult.getPrefixMatcher().prefixMatches(name)) {
            return true;
        }
        if (this.myContext != null && !this.myContext.isSuitableSymbol(symbol)) {
            if (this.myInCpp && (this.myContext.isSuitableSymbolKind(OCSymbolKind.GLOBAL_VARIABLE) || this.myContext.isSuitableSymbolKind(OCSymbolKind.FUNCTION_DECLARATION))) {
                if (!(symbol instanceof OCStructSymbol) && symbol.getKind() != OCSymbolKind.TYPEDEF && symbol.getKind() != OCSymbolKind.TEMPLATE_TYPE_PARAMETER) {
                    return true;
                }
            } else {
                return true;
            }
        }
        if (this.myCondition != null && !this.myCondition.value((Object)symbol)) {
            return true;
        }
        if (symbol.isUnavailable() || symbol.isForbiddenByARC(this.myContextExpression)) {
            return true;
        }
        VirtualFile containingFile = symbol.getContainingFile();
        if (Comparing.equal((Object)containingFile, (Object)this.myContextFile) && this.myContextExpression.getParent().getTextOffset() == symbol.getOffset()) {
            return true;
        }
        if (this.myState.registerSymbol(symbol)) {
            Object lookup = this.myAllowAutocomplete ? this.createLookup(symbol) : this.createLookup(symbol).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
            this.myResult.addElement((LookupElement)lookup);
            this.myEmpty = false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.myEmpty;
    }

    public LookupElementBuilder createLookup(OCSymbol symbol) {
        return SymbolLookupBuilderUtil.lookup(symbol, this.myContextExpression, this.myContext);
    }

    public static class ConverterState {
        private final Set<String> myNames;
        private final Map<String, OCFunctionSymbol> myFunctionNamesToSymbol;
        private final MultiMap<String, String> myFunctionNamesToType = MultiMap.createSet();

        public ConverterState() {
            this.myFunctionNamesToSymbol = new HashMap();
            this.myNames = new HashSet<String>();
        }

        boolean registerSymbol(OCSymbol symbol) {
            String name = symbol.getName();
            if (symbol instanceof OCFunctionSymbol) {
                if (this.myFunctionNamesToSymbol.containsKey(name)) {
                    if (!this.myFunctionNamesToType.containsKey((Object)name)) {
                        this.myFunctionNamesToType.putValue((Object)name, (Object)ConverterState.getTypeSignature(this.myFunctionNamesToSymbol.get(name)));
                    }
                    Collection types = this.myFunctionNamesToType.get((Object)name);
                    return types.add(ConverterState.getTypeSignature(symbol));
                }
                this.myFunctionNamesToSymbol.put(name, (OCFunctionSymbol)symbol);
                return true;
            }
            return this.myNames.add(symbol.getSignature());
        }

        private static String getTypeSignature(OCSymbol symbol) {
            return symbol.getResolvedType().getCanonicalName();
        }
    }
}

