/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Editor;
import com.jetbrains.cidr.lang.editor.completion.CallableInsertUtils;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;

public class MacroInsertHandler
implements InsertHandler<LookupElement> {
    private final OCMacroSymbol mySymbol;

    public MacroInsertHandler(OCMacroSymbol symbol) {
        this.mySymbol = symbol;
    }

    public void handleInsert(InsertionContext context, LookupElement item) {
        if (this.mySymbol.hasParameterList()) {
            boolean hasParams = !this.mySymbol.getParameterNames().isEmpty();
            CallableInsertUtils.addParensIfRequired(context, item, hasParams);
            Editor editor = context.getEditor();
            if (hasParams) {
                AutoPopupController.getInstance(context.getProject()).autoPopupParameterInfo(editor, null);
            }
        }
    }
}

