/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.colors;

import com.intellij.application.options.colors.InspectionColorSettingsPage;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.colors.OCFileHighlighter;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.settings.OCLanguageCodeStyleSettingsProvider;
import gnu.trove.THashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class OCColorsSettingsPage
implements ColorSettingsPage,
InspectionColorSettingsPage,
DisplayPrioritySortable {
    private static final ColorDescriptor[] COLORS = new ColorDescriptor[0];

    @NotNull
    public String getDisplayName() {
        String string = OCLanguage.getInstance().getDisplayName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/colors/OCColorsSettingsPage", "getDisplayName"));
        }
        return string;
    }

    public Icon getIcon() {
        return null;
    }

    public DisplayPriority getPriority() {
        return DisplayPriority.KEY_LANGUAGE_SETTINGS;
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        AttributesDescriptor[] attributesDescriptorArray = OCLanguageCodeStyleSettingsProvider.getAttributeDescriptors();
        if (attributesDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/colors/OCColorsSettingsPage", "getAttributeDescriptors"));
        }
        return attributesDescriptorArray;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        if (COLORS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/colors/OCColorsSettingsPage", "getColorDescriptors"));
        }
        return COLORS;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        OCFileHighlighter oCFileHighlighter = new OCFileHighlighter(OCLanguageKind.OBJ_CPP, false);
        if (oCFileHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/colors/OCColorsSettingsPage", "getHighlighter"));
        }
        return oCFileHighlighter;
    }

    @NotNull
    public String getDemoText() {
        String string = OCLanguageCodeStyleSettingsProvider.getCodeSample("Colors");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/colors/OCColorsSettingsPage", "getDemoText"));
        }
        return string;
    }

    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        THashMap answer = new THashMap();
        answer.put("kw", OCHighlightingKeys.SELFSUPERTHIS);
        answer.put("evar", OCHighlightingKeys.EXTERN_VARIABLE);
        answer.put("gvar", OCHighlightingKeys.GLOBAL_VARIABLE);
        answer.put("lvar", OCHighlightingKeys.LOCAL_VARIABLE);
        answer.put("par", OCHighlightingKeys.PARAMETER);
        answer.put("fun", OCHighlightingKeys.FUNCTION);
        answer.put("op", OCHighlightingKeys.OVERLOADED_OPERATOR);
        answer.put("prop", OCHighlightingKeys.PROPERTY);
        answer.put("prop_attr", OCHighlightingKeys.PROPERTY_ATTRIBUTE);
        answer.put("sfield", OCHighlightingKeys.STRUCT_FIELD);
        answer.put("sel", OCHighlightingKeys.MESSAGE_ARGUMENT);
        answer.put("ifdef", OCHighlightingKeys.CONDITIONALLY_NOT_COMPILED);
        answer.put("macro", OCHighlightingKeys.MACRONAME);
        answer.put("macro_par", OCHighlightingKeys.MACRO_PARAMETER);
        answer.put("ivar", OCHighlightingKeys.INSTANCE_VARIABLE);
        answer.put("struct", OCHighlightingKeys.STRUCT_LIKE);
        answer.put("cls", OCHighlightingKeys.CLASS_REFERENCE);
        answer.put("prt", OCHighlightingKeys.PROTOCOL_REFERENCE);
        answer.put("enum", OCHighlightingKeys.ENUM_CONST);
        answer.put("label", OCHighlightingKeys.LABEL);
        answer.put("def", OCHighlightingKeys.TYPEDEF);
        answer.put("fmt", OCHighlightingKeys.OC_FORMAT_STRING_TOKEN);
        answer.put("templt", OCHighlightingKeys.TEMPLATE_TYPE);
        answer.put("templv", OCHighlightingKeys.TEMPLATE_VALUE);
        answer.put("ns", OCHighlightingKeys.NAMESPACE_LIKE);
        answer.put("generic", OCHighlightingKeys.GENERIC_PARAMETER);
        return answer;
    }
}

