/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.resolve.references.OCResourceCompletionProvider;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReference;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReferenceContributor;
import com.jetbrains.cidr.lang.resolve.references.OCStringResourceReference;
import com.jetbrains.cidr.lang.settings.OCCodeFoldingSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFoldingBuilder
extends CustomFoldingBuilder {
    private static Set<? extends IElementType> INCLUDE_ELEMENT_TYPES = ContainerUtil.set((Object[])new OCElementType[]{OCElementTypes.IMPORT_DIRECTIVE, OCElementTypes.IMPORT_MODULE_STATEMENT});

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "buildLanguageFoldRegions"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "buildLanguageFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "buildLanguageFoldRegions"));
        }
        if (!DumbService.isDumb((Project)root.getProject())) {
            ASTNode node = root.getNode();
            if (node != null) {
                OCFoldingBuilder.appendDescriptors(node, document, descriptors);
            }
        } else {
            OCLog.LOG.error("Folding builder was called in dumb mode!");
        }
    }

    @NotNull
    private static Pair<ASTNode, Integer> nodeStart(@Nullable ASTNode node) {
        Pair pair = Pair.create((Object)node, (Object)1);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "nodeStart"));
        }
        return pair;
    }

    @NotNull
    private static Pair<ASTNode, Integer> nodeEnd(@Nullable ASTNode node) {
        Pair pair = Pair.create((Object)node, (Object)-1);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "nodeEnd"));
        }
        return pair;
    }

    @NotNull
    private static ASTNode appendDescriptors(@NotNull ASTNode node, @NotNull Document document, @NotNull List<FoldingDescriptor> descriptors) {
        ASTNode firstChildNode;
        ASTNode end;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "appendDescriptors"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "appendDescriptors"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "appendDescriptors"));
        }
        IElementType type = node.getElementType();
        if (type == OCElementTypes.METHOD || type == OCElementTypes.FUNCTION_DEFINITION) {
            ASTNode body = node.findChildByType(OCElementTypes.BLOCK_STATEMENTS);
            OCFoldingBuilder.registerRange(document, node, descriptors, OCFoldingBuilder.nodeStart(body), OCFoldingBuilder.nodeEnd(body), FoldingCondition.NOT_EMPTY_SEVERAL_LINES);
        } else if (type == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST) {
            ASTNode template = OCFormatterUtil.getPreviousNonWhitespaceOrCommentSibling(node);
            if (OCElementUtil.getElementType(template) == OCTokenTypes.TEMPLATE_CPP_KEYWORD) {
                OCFoldingBuilder.registerRange(document, node, descriptors, OCFoldingBuilder.nodeStart(template), OCFoldingBuilder.nodeEnd(node), FoldingCondition.LONGER_THAN_5CHARS_OR_NOT_EMPTY_SEVERAL_LINES);
            }
        } else if (OCElementTypes.STRUCTURE_TYPES.contains(type) || type == OCElementTypes.CPP_NAMESPACE) {
            ASTNode start = node.findChildByType((IElementType)OCTokenTypes.LBRACE);
            end = node.findChildByType((IElementType)OCTokenTypes.RBRACE);
            OCFoldingBuilder.registerRange(document, node, descriptors, OCFoldingBuilder.nodeStart(start), OCFoldingBuilder.nodeEnd(end), FoldingCondition.LONGER_THAN_5CHARS_OR_NOT_EMPTY_SEVERAL_LINES);
        } else if (OCElementTypes.CLASSES.contains(type)) {
            if (document.getLineNumber(node.getStartOffset()) != document.getLineNumber(node.getTextRange().getEndOffset())) {
                Pair<ASTNode, Integer> startPair;
                ASTNode start;
                if (type == OCElementTypes.INTERFACE) {
                    for (start = node.findChildByType((IElementType)OCElementTypes.INSTANCE_VARIABLES_LIST); start != null && start.getTreePrev() != null && OCFoldingBuilder.isUnimportantNode(start.getTreePrev()); start = start.getTreePrev()) {
                    }
                    startPair = OCFoldingBuilder.nodeStart(start);
                } else {
                    start = node.findChildByType((IElementType)OCTokenTypes.IDENTIFIER);
                    startPair = OCFoldingBuilder.nodeEnd(start);
                }
                end = OCElementUtil.findObjCKeyword(node, OCTokenTypes.END_KEYWORD);
                if (end != null) {
                    end = end.getTreeParent();
                }
                OCFoldingBuilder.registerRange(document, node, descriptors, startPair, OCFoldingBuilder.nodeStart(end), FoldingCondition.LONGER_THAN_5CHARS_OR_NOT_EMPTY_SEVERAL_LINES);
            }
        } else if (type == OCElementTypes.INSTANCE_VARIABLES_LIST || type == OCElementTypes.TEMPLATE_ARGUMENT_LIST || type == OCTokenTypes.BLOCK_COMMENT || type == OCTokenTypes.RAW_STRING_LITERAL) {
            OCFoldingBuilder.registerRange(document, node, descriptors, OCFoldingBuilder.nodeStart(node), OCFoldingBuilder.nodeEnd(node), FoldingCondition.NOT_EMPTY_SEVERAL_LINES);
        } else if (type == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT) {
            OCFoldingBuilder.registerRange(document, node, descriptors, OCFoldingBuilder.nodeStart(node), OCFoldingBuilder.nodeEnd(node), FoldingCondition.ALWAYS);
        } else if (INCLUDE_ELEMENT_TYPES.contains(type)) {
            firstChildNode = node.getFirstChildNode();
            if (firstChildNode != null) {
                ASTNode aSTNode = OCFoldingBuilder.collapseConsequentNodesOfSpecifiedType(document, node, descriptors, INCLUDE_ELEMENT_TYPES, (Pair<ASTNode, Integer>)Pair.create((Object)firstChildNode, (Object)-2), FoldingCondition.LONGER_THAN_5CHARS_OR_NOT_EMPTY_SEVERAL_LINES);
                if (aSTNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "appendDescriptors"));
                }
                return aSTNode;
            }
        } else if (type == OCElementTypes.SYNTHESIZED_PROPERTIES_LIST) {
            firstChildNode = node.getFirstChildNode();
            if (firstChildNode != null) {
                ASTNode aSTNode = OCFoldingBuilder.collapseConsequentNodesOfSpecifiedType(document, node, descriptors, Collections.singleton(OCElementTypes.SYNTHESIZED_PROPERTIES_LIST), (Pair<ASTNode, Integer>)Pair.create((Object)firstChildNode, (Object)-2), FoldingCondition.LONGER_THAN_5CHARS_OR_NOT_EMPTY_SEVERAL_LINES);
                if (aSTNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "appendDescriptors"));
                }
                return aSTNode;
            }
        } else if (type == OCTokenTypes.EOL_COMMENT) {
            if (node.getTreeParent().getElementType() instanceof IFileElementType) {
                ASTNode aSTNode = OCFoldingBuilder.collapseConsequentNodesOfSpecifiedType(document, node, descriptors, Collections.singleton(OCTokenTypes.EOL_COMMENT), OCFoldingBuilder.nodeStart(node), FoldingCondition.LONGER_THAN_5CHARS_OR_NOT_EMPTY_SEVERAL_LINES);
                if (aSTNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "appendDescriptors"));
                }
                return aSTNode;
            }
        } else if (type == OCTokenTypes.TEMPLATE_START_MARK) {
            if (node.getTreeParent().getTextLength() > 0) {
                descriptors.add(new FoldingDescriptor(node.getTreeParent(), node.getTreeParent().getTextRange(), null, Collections.emptySet(), true));
            }
        } else if ((type == OCElementTypes.MESSAGE_EXPRESSION || type == OCElementTypes.MACRO_CALL) && OCFoldingBuilder.getLocalizedString(node) != null || type == OCElementTypes.NS_ARRAY_LITERAL || type == OCElementTypes.NS_DICTIONARY_LITERAL || type == OCElementTypes.BLOCK_EXPRESSION) {
            OCFoldingBuilder.registerRange(document, node, descriptors, OCFoldingBuilder.nodeStart(node), OCFoldingBuilder.nodeEnd(node), FoldingCondition.LONGER_THAN_5CHARS_OR_NOT_EMPTY_SEVERAL_LINES);
        }
        ASTNode child = node.getFirstChildNode();
        while (child != null) {
            child = OCFoldingBuilder.appendDescriptors(child, document, descriptors).getTreeNext();
        }
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "appendDescriptors"));
        }
        return aSTNode;
    }

    private static boolean isUnimportantNode(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "isUnimportantNode"));
        }
        return OCTokenTypes.COMMENTS.contains(node.getElementType()) || node instanceof PsiWhiteSpace || node.getTextLength() == 0;
    }

    @Nullable
    private static OCLocalizedString getLocalizedString(final @NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "getLocalizedString"));
        }
        final Ref result2 = Ref.create(null);
        OCResourceReferenceContributor.processReferenceProviders(new Processor<OCResourceCompletionProvider>(){

            public boolean process(OCResourceCompletionProvider provider) {
                OCResourceReference ref = provider.getReferenceByCall(node.getPsi(), null);
                if (ref instanceof OCStringResourceReference) {
                    OCStringResourceReference stringRef = (OCStringResourceReference)ref;
                    if (!stringRef.areAllLanguagesLocalized()) {
                        return true;
                    }
                    result2.set((Object)((OCLocalizedString)stringRef.resolve()));
                }
                return true;
            }
        });
        return (OCLocalizedString)result2.get();
    }

    private static void registerRange(@NotNull Document document, @NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors, @NotNull Pair<ASTNode, Integer> start, @NotNull Pair<ASTNode, Integer> end, @NotNull FoldingCondition foldingCondition) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "registerRange"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "registerRange"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "registerRange"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "registerRange"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "registerRange"));
        }
        if (foldingCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldingCondition", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "registerRange"));
        }
        int posStart = OCFoldingBuilder.getOffsetPosition(start);
        int posEnd = OCFoldingBuilder.getOffsetPosition(end);
        int length = posEnd - posStart;
        if (posStart < 0 || posEnd < 0 || length <= 0) {
            return;
        }
        boolean needFolding = false;
        switch (foldingCondition) {
            case LONGER_THAN_5CHARS_OR_NOT_EMPTY_SEVERAL_LINES: {
                needFolding = length > 5;
            }
            case NOT_EMPTY_SEVERAL_LINES: {
                needFolding |= length > 1 && document.getLineNumber(posStart) != document.getLineNumber(posEnd);
                break;
            }
            case ALWAYS: {
                needFolding = true;
            }
        }
        if (needFolding) {
            descriptors.add(new FoldingDescriptor(node, TextRange.create((int)posStart, (int)posEnd)));
        }
    }

    private static int getOffsetPosition(@NotNull Pair<ASTNode, Integer> anchorNode) {
        ASTNode leaf;
        if (anchorNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchorNode", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "getOffsetPosition"));
        }
        ASTNode node = (ASTNode)anchorNode.first;
        if (node == null || (Integer)anchorNode.second == 0) {
            return -1;
        }
        ASTNode aSTNode = leaf = (Integer)anchorNode.second > 0 ? OCFormatterUtil.firstLeaf(node) : OCFormatterUtil.lastLeaf(node);
        if (leaf instanceof OCMacroForeignLeafElement) {
            return -1;
        }
        if (leaf == null) {
            leaf = node;
        }
        TextRange range = leaf.getTextRange();
        return ((Integer)anchorNode.second > 0 ? range.getStartOffset() + 1 : range.getEndOffset() - 1) - (Integer)anchorNode.second;
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "getLanguagePlaceholderText"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "getLanguagePlaceholderText"));
        }
        IElementType tt = node.getElementType();
        if (OCElementTypes.CLASSES.contains(tt) || INCLUDE_ELEMENT_TYPES.contains(tt) || tt == OCElementTypes.SYNTHESIZED_PROPERTIES_LIST) {
            return "...";
        }
        if (tt == OCTokenTypes.BLOCK_COMMENT) {
            return node instanceof PsiDocCommentBase ? "/**...*/" : "/.../";
        }
        if (tt == OCTokenTypes.EOL_COMMENT) {
            return "//...";
        }
        if (tt == OCElementTypes.NS_ARRAY_LITERAL) {
            return "@[...]";
        }
        if (tt == OCElementTypes.NS_DICTIONARY_LITERAL) {
            return "@{...}";
        }
        if (tt == OCTokenTypes.RAW_STRING_LITERAL) {
            return "\"...\"";
        }
        if (tt == OCElementTypes.BLOCK_EXPRESSION) {
            OCTypeElement returnType = ((OCBlockExpression)node.getPsi()).getReturnTypeElement();
            OCParameterList paramList = ((OCBlockExpression)node.getPsi()).getParameterList();
            return "^" + (returnType != null ? returnType.getTextWithMacros() : "") + (paramList != null ? paramList.getTextWithMacros() : "") + "{...}";
        }
        if (tt == OCElementTypes.LITERAL_EXPRESSION) {
            return StringUtil.trimStart((String)StringUtil.trimEnd((String)node.getText(), (String)"#>"), (String)"<#");
        }
        if (tt == OCElementTypes.MESSAGE_EXPRESSION || tt == OCElementTypes.MACRO_CALL) {
            OCLocalizedString pair = OCFoldingBuilder.getLocalizedString(node);
            if (pair != null) {
                return "@\"" + pair.getValue() + "\"";
            }
        } else {
            if (tt == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST) {
                return OCFoldingBuilder.getTemplateParamsText(node);
            }
            if (tt == OCElementTypes.TEMPLATE_ARGUMENT_LIST) {
                return "<~>";
            }
            if (tt == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT) {
                return "...";
            }
        }
        return "{...}";
    }

    @NotNull
    private static String getTemplateParamsText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "getTemplateParamsText"));
        }
        StringBuilder builder = new StringBuilder();
        ASTNode leaf = OCFormatterUtil.firstLeaf(node);
        boolean afterPunctuator = false;
        while (leaf != null) {
            IElementType tt = leaf.getElementType();
            if (!(leaf instanceof OCMacroForeignLeafElement) && !OCFormatterUtil.isInessential(leaf) && tt != OCTokenTypes.TYPENAME_CPP_KEYWORD && tt != OCTokenTypes.CLASS_KEYWORD) {
                boolean punctuator = tt instanceof OCPunctuatorElementType;
                if (!afterPunctuator && !punctuator && builder.length() != 0) {
                    builder.append(' ');
                }
                afterPunctuator = punctuator;
                builder.append(leaf.getText());
            }
            leaf = OCFormatterUtil.nextLeafInOwner(leaf, node);
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "getTemplateParamsText"));
        }
        return string;
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "isRegionCollapsedByDefault"));
        }
        OCCodeFoldingSettings settings = OCCodeFoldingSettings.getInstance();
        IElementType type = node.getElementType();
        if (INCLUDE_ELEMENT_TYPES.contains(type)) {
            return CodeFoldingSettings.getInstance().COLLAPSE_IMPORTS;
        }
        if (type == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT) {
            return settings.isCollapseConditionallyNotCompiled();
        }
        if (type == OCTokenTypes.BLOCK_COMMENT || type == OCTokenTypes.EOL_COMMENT) {
            return settings.isCollapseMultilineComments();
        }
        if (type == OCElementTypes.METHOD || type == OCElementTypes.FUNCTION_DEFINITION) {
            return CodeFoldingSettings.getInstance().COLLAPSE_METHODS;
        }
        if (type == OCElementTypes.INSTANCE_VARIABLES_LIST) {
            return settings.isCollapseIvars();
        }
        if (type == OCElementTypes.SYNTHESIZED_PROPERTIES_LIST) {
            return settings.isCollapseSynthesizes();
        }
        if (type == OCElementTypes.LITERAL_EXPRESSION || type == OCElementTypes.MESSAGE_EXPRESSION || type == OCElementTypes.MACRO_CALL) {
            return settings.isCollapseLocalizedStrings();
        }
        if (type == OCElementTypes.BLOCK_EXPRESSION) {
            return settings.isCollapseBlockExpressions();
        }
        if (type == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST) {
            return settings.isCollapseTemplateParamList();
        }
        return false;
    }

    @NotNull
    private static ASTNode collapseConsequentNodesOfSpecifiedType(@NotNull Document document, @NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors, @NotNull Collection<? extends IElementType> elementTypes, @NotNull Pair<ASTNode, Integer> start, @NotNull FoldingCondition foldingCondition) {
        PsiElement firstElement;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "collapseConsequentNodesOfSpecifiedType"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "collapseConsequentNodesOfSpecifiedType"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "collapseConsequentNodesOfSpecifiedType"));
        }
        if (elementTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementTypes", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "collapseConsequentNodesOfSpecifiedType"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "collapseConsequentNodesOfSpecifiedType"));
        }
        if (foldingCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldingCondition", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "collapseConsequentNodesOfSpecifiedType"));
        }
        PsiElement lastElement = firstElement = node.getPsi();
        PsiElement current = lastElement.getNextSibling();
        boolean hasErrors = false;
        boolean containsCustomRegionMarker = OCFoldingBuilder.isCustomRegionElement((PsiElement)firstElement);
        if (firstElement instanceof OCIncludeDirective && !((OCIncludeDirective)firstElement).isValidDirective()) {
            hasErrors = true;
        }
        while (current != null) {
            while (current != null && current instanceof PsiWhiteSpace) {
                current = current.getNextSibling();
            }
            if (current instanceof OCIncludeDirective && !((OCIncludeDirective)current).isValidDirective()) {
                hasErrors = true;
            }
            if (!elementTypes.contains(OCElementUtil.getElementType(current))) break;
            assert (current != null);
            lastElement = current;
            current = current.getNextSibling();
            containsCustomRegionMarker |= OCFoldingBuilder.isCustomRegionElement((PsiElement)lastElement);
        }
        if (lastElement != firstElement) {
            ASTNode lastElementNode = lastElement.getNode();
            if (!hasErrors && !containsCustomRegionMarker) {
                Pair<ASTNode, Integer> end = OCFoldingBuilder.nodeEnd(lastElementNode);
                OCFoldingBuilder.registerRange(document, node, descriptors, start, end, foldingCondition);
            }
            ASTNode aSTNode = lastElementNode;
            if (aSTNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "collapseConsequentNodesOfSpecifiedType"));
            }
            return aSTNode;
        }
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/OCFoldingBuilder", "collapseConsequentNodesOfSpecifiedType"));
        }
        return aSTNode;
    }

    public boolean isDumbAware() {
        return false;
    }

    static enum FoldingCondition {
        LONGER_THAN_5CHARS_OR_NOT_EMPTY_SEVERAL_LINES,
        NOT_EMPTY_SEVERAL_LINES,
        ALWAYS;

    }
}

