/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCategoryName;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesProvider;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeParameterResolveVisitor;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDocumentationProvider
implements DocumentationProvider {
    public static final String PSI_LINK_PREFIX_METHOD = "method,";
    @Nullable
    final ExternalProvider myExternalProvider;

    public CidrDocumentationProvider() {
        this(null);
    }

    public CidrDocumentationProvider(@Nullable ExternalProvider provider) {
        this.myExternalProvider = provider;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element == null) {
            return null;
        }
        String content = this.quickDocContent(element, originalElement, false);
        return content != null ? CidrDocumentationProvider.wrapDocInHtml(content) : null;
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        String result2;
        if (element == null) {
            return null;
        }
        if (element instanceof PsiFile) {
            return null;
        }
        if (element instanceof OCMethodSelectorPart) {
            element = element.getParent();
        }
        if (element instanceof OCSendMessageExpression && (result2 = CidrDocumentationProvider.methodCandidates((OCSendMessageExpression)element)) != null) {
            return result2;
        }
        String doc = this.generateDocInnerHtml(element, originalElement, false);
        return doc == null ? null : CidrDocumentationProvider.wrapDocInHtml(doc);
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(@Nullable PsiManager psiManager, @Nullable Object object, @Nullable PsiElement element) {
        if (object instanceof OCSymbol) {
            return ((OCSymbol)object).locateDefinition();
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(@Nullable PsiManager psiManager, @Nullable String link, @Nullable PsiElement context) {
        List parts;
        if (link == null || psiManager == null) {
            return null;
        }
        if (link.startsWith(PSI_LINK_PREFIX_METHOD) && (parts = StringUtil.split((String)(link = link.substring(PSI_LINK_PREFIX_METHOD.length())), (String)",")).size() == 3) {
            PsiElement elementAt;
            PsiFile file2;
            String path = (String)parts.get(1);
            String offset = (String)parts.get(2);
            VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(path);
            if (fileByPath != null && fileByPath.isValid() && (file2 = psiManager.findFile(fileByPath)) != null && file2.isValid() && (elementAt = file2.findElementAt(Integer.parseInt(offset))) != null && elementAt.isValid()) {
                return PsiTreeUtil.getParentOfType((PsiElement)elementAt, OCMethod.class, (boolean)false);
            }
        }
        return null;
    }

    @Nullable
    private static String buildLinkForMethod(@NotNull OCMethodSymbol symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "buildLinkForMethod"));
        }
        StringBuilder sb = new StringBuilder("psi_element://").append(PSI_LINK_PREFIX_METHOD);
        sb.append(symbol.getName());
        VirtualFile file2 = symbol.getContainingFile();
        if (file2 != null) {
            sb.append(',').append(file2.getPath()).append(',').append(symbol.getOffset());
            return sb.toString();
        }
        return null;
    }

    @Nullable
    private static String methodCandidates(@NotNull OCSendMessageExpression sme) {
        if (sme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sme", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "methodCandidates"));
        }
        PsiReference reference = sme.getReference();
        if (reference != null && reference instanceof OCPolyVariantReference) {
            List list = ((OCPolyVariantReference)reference).resolveToSymbols();
            StringBuilder builder = new StringBuilder("");
            for (Object o : list) {
                if (!(o instanceof OCMethodSymbol)) continue;
                OCMethodSymbol symbol = (OCMethodSymbol)o;
                OCClassSymbol parent = (OCClassSymbol)symbol.getParent();
                String link = CidrDocumentationProvider.buildLinkForMethod(symbol);
                if (link == null) continue;
                builder.append("<a href=\"").append(link).append("\">").append(symbol.getSignature()).append(" (").append(parent.getPresentableName()).append(")</a><br>");
            }
            return CodeInsightBundle.message((String)"javadoc.candidates", (Object[])new Object[]{sme.getExpectedMethodSignature(), builder.toString()});
        }
        return null;
    }

    @Nullable
    protected String quickDocContent(@NotNull PsiElement element, @Nullable PsiElement originalElement, boolean fullDoc) {
        PsiElement resolved;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "quickDocContent"));
        }
        if (originalElement != null && originalElement.getParent() instanceof OCReferenceElement) {
            originalElement = originalElement.getParent();
        }
        if ((resolved = CidrDocumentationProvider.resolveIfRequired(element)) == null) {
            return null;
        }
        element = resolved;
        if (element instanceof OCMethod) {
            return CidrDocumentationProvider.methodHintDoc((OCMethod)element);
        }
        if (element instanceof OCClassDeclaration) {
            OCFile file2;
            OCInterfaceSymbol anInterface;
            StringBuilder answer = new StringBuilder();
            OCClassDeclaration cd = (OCClassDeclaration)element;
            OCObjectType type = cd.getType();
            if (type != null && (anInterface = type.getInterface()) != null && (file2 = anInterface.getContainingOCFile()) != null) {
                answer.append(CidrDocumentationProvider.declaredInHint(file2));
            }
            return answer.append(CidrDocumentationProvider.classHintDoc(cd)).toString();
        }
        if (element instanceof OCMethodSelectorPart) {
            StringBuilder answer = new StringBuilder("parameter<br>");
            CidrDocumentationProvider.appendType(answer, ((OCMethodSelectorPart)element).getRawType(), ((OCMethodSelectorPart)element).getContainingOCFile(), true);
            answer.append(" <b>");
            answer.append(((OCMethodSelectorPart)element).getName());
            answer.append("</b>");
            return answer.toString();
        }
        if (element instanceof OCTypeParameterDeclaration) {
            return CidrDocumentationProvider.typeParameterHintDoc((OCTypeParameterDeclaration)element);
        }
        if (element instanceof OCCategoryName) {
            OCCategoryName category = (OCCategoryName)element;
            PsiElement parent = category.getParent();
            if (parent instanceof OCClassDeclaration) {
                OCClassDeclaration cd = (OCClassDeclaration)parent;
                return fullDoc ? this.generateDocInnerHtml(cd, originalElement, false) : this.quickDocContent(cd, originalElement, false);
            }
            return null;
        }
        if (element instanceof OCDeclarator) {
            String text;
            OCExpression initializer;
            OCClassDeclaration container;
            PsiElement pp;
            OCFile containingFile;
            PsiReference reference;
            OCDeclarator declarator = (OCDeclarator)element;
            StringBuilder answer = new StringBuilder();
            OCSymbol symbol = null;
            PsiReference psiReference = reference = originalElement == null ? null : originalElement.getReference();
            if (reference instanceof OCReference) {
                symbol = ((OCReference)reference).resolveToSymbol();
            }
            if (symbol == null) {
                symbol = declarator.getSymbol();
            }
            OCFile oCFile = containingFile = symbol == null ? null : symbol.getContainingOCFile();
            if (containingFile != null && symbol.getKind() != OCSymbolKind.LOCAL_VARIABLE) {
                answer.append(CidrDocumentationProvider.declaredInHint(containingFile));
            }
            if ((pp = element.getParent().getParent()) instanceof OCProperty) {
                OCProperty property = (OCProperty)pp;
                String iVarDoc = this.propertyIVarDoc(property);
                if (iVarDoc != null) {
                    return iVarDoc;
                }
                OCClassDeclaration container2 = property.getContainingClass();
                if (container2 != null) {
                    answer.append(CidrDocumentationProvider.classHintDoc(container2)).append("<br>");
                }
                answer.append("@property ");
                OCPropertyAttributesList attrs = property.getPropertyAttributesList();
                if (attrs != null) {
                    String attrsStr = StringUtil.join(attrs.getAttributes(), (Function)new Function<OCPropertyAttribute, String>(){

                        public String fun(OCPropertyAttribute attribute) {
                            return attribute.getText();
                        }
                    }, (String)", ");
                    answer.append("(").append(attrsStr).append(") ");
                }
            } else if (pp instanceof OCInstanceVariablesList && (container = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCClassDeclaration.class})) != null) {
                answer.append(CidrDocumentationProvider.classHintDoc(container)).append("<br>");
            }
            boolean appendInitializer = false;
            if (symbol != null) {
                if (symbol.getKind() == OCSymbolKind.INSTANCE_VARIABLE) {
                    answer.append("ivar ");
                } else if (symbol.getKind() == OCSymbolKind.LOCAL_VARIABLE) {
                    answer.append("local variable<br>");
                    final ReadWriteAccessDetector detector = ReadWriteAccessDetector.findDetector((PsiElement)element);
                    if (detector != null) {
                        final PsiElement context = element;
                        appendInitializer = ReferencesSearch.search((PsiElement)element).forEach((Processor)new Processor<PsiReference>(){

                            public boolean process(PsiReference reference) {
                                return detector.getReferenceAccess(context, reference) == ReadWriteAccessDetector.Access.Read;
                            }
                        });
                    }
                } else if (symbol.getKind() == OCSymbolKind.PARAMETER) {
                    answer.append("parameter<br>");
                } else if (symbol.getKind() == OCSymbolKind.TYPEDEF) {
                    answer.append("typedef ");
                }
            }
            if (symbol instanceof OCFunctionSymbol || symbol instanceof OCDeclaratorSymbol) {
                String typeName = CidrDocumentationProvider.effectiveTypeString(symbol, originalElement);
                answer.append(CidrDocumentationProvider.escapeHTML(typeName));
                answer.append(" <b>");
                answer.append(CidrDocumentationProvider.escapeHTML(symbol.getName())).append("</b>");
                if (symbol instanceof OCFunctionSymbol) {
                    String parametersSignature = ((OCFunctionSymbol)symbol).getParametersSignature();
                    answer.append(CidrDocumentationProvider.escapeHTML(parametersSignature));
                }
            } else {
                CidrDocumentationProvider.appendType(answer, declarator.getRawType(), element.getContainingFile(), false);
                answer.append(" <b>");
                answer.append(declarator.getName());
                answer.append("</b>");
            }
            if (appendInitializer && (initializer = declarator.getInitializer()) != null && (text = initializer.getText()).indexOf(10) == -1 && text.length() < 50) {
                answer.append(" = ").append(CidrDocumentationProvider.escapeHTML(text));
            }
            return answer.toString();
        }
        if (element instanceof OCDefineDirective) {
            PsiFile file3 = element.getContainingFile();
            StringBuilder answer = new StringBuilder();
            answer.append(CidrDocumentationProvider.declaredInHint(file3));
            OCMacroSymbol symbol = (OCMacroSymbol)((OCDefineDirective)element).getSymbol();
            if (symbol == null) {
                return "";
            }
            answer.append("#define <b>").append(CidrDocumentationProvider.escapeHTML(symbol.getName())).append("</b>");
            if (symbol.hasParameterList()) {
                answer.append('(');
                answer.append(StringUtil.join(symbol.getParameterNames(), (Function)new Function<String, String>(){

                    public String fun(String name) {
                        return CidrDocumentationProvider.escapeHTML(name);
                    }
                }, (String)", "));
                answer.append(')');
            }
            answer.append(" ").append(CidrDocumentationProvider.escapeHTML(symbol.getSubstitution()));
            return answer.toString();
        }
        if (element instanceof OCCppUsingStatement) {
            StringBuilder answer = new StringBuilder(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            OCSymbol symbol = ((OCCppUsingStatement)element).getSymbol();
            if (symbol instanceof OCAliasUsingSymbol) {
                answer.append("using <b>");
                answer.append(symbol.getName());
                answer.append("</b> = ");
                answer.append(CidrDocumentationProvider.escapeHTML(CidrDocumentationProvider.effectiveTypeString(symbol, originalElement)));
            }
            return answer.toString();
        }
        if (element instanceof OCStruct) {
            String defaultContent;
            OCTemplateParameterList templateList;
            StringBuilder answer = new StringBuilder(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            OCDeclaration context = (OCDeclaration)PsiTreeUtil.getContextOfType((PsiElement)element, (boolean)false, (Class[])new Class[]{OCDeclaration.class});
            if (context != null && (templateList = context.getTemplateParameterList()) != null) {
                PsiElement copy = templateList.copy();
                final ArrayList comments = new ArrayList();
                copy.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                    public void visitComment(PsiComment comment) {
                        comments.add(comment);
                    }
                });
                for (PsiElement comment : comments) {
                    comment.delete();
                }
                CodeStyleManager styleMgr = CodeStyleManager.getInstance((Project)copy.getProject());
                copy = styleMgr.reformat(copy);
                answer.append(CidrDocumentationProvider.escapeHTML("template" + copy.getText().replaceAll("<\\s+", "<").replaceAll("\\s+>", ">")));
            }
            if ((defaultContent = CidrDocumentationProvider.defaultQuickDocContent(element)) != null) {
                answer.append(" ").append(defaultContent);
            }
            return answer.toString();
        }
        PsiFile file4 = element.getContainingFile();
        String defaultContent = CidrDocumentationProvider.defaultQuickDocContent(element);
        return defaultContent != null ? CidrDocumentationProvider.declaredInHint(file4) + defaultContent : null;
    }

    @Nullable
    private static String defaultQuickDocContent(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "defaultQuickDocContent"));
        }
        OCFindUsagesProvider common = new OCFindUsagesProvider();
        if (common.canFindUsagesFor(element)) {
            return common.getType(element) + "  <b>" + common.getDescriptiveName(element) + "</b>";
        }
        return null;
    }

    @NotNull
    private static String effectiveTypeString(@NotNull OCSymbol symbol, @Nullable PsiElement originalElement) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "effectiveTypeString"));
        }
        PsiFile file2 = originalElement == null ? null : originalElement.getContainingFile();
        String string = symbol.getEffectiveType().accept(new OCTypeParameterResolveVisitor(file2)).getName(originalElement);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "effectiveTypeString"));
        }
        return string;
    }

    @Nullable
    private String propertyIVarDoc(@NotNull OCProperty p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "propertyIVarDoc"));
        }
        PsiElement iVar = CidrDocumentationProvider.getPropertyIVar(p);
        if (iVar != null) {
            return this.generateDocInnerHtml(iVar, null, true);
        }
        return null;
    }

    @Nullable
    private static PsiElement getPropertyIVar(@NotNull OCProperty p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "getPropertyIVar"));
        }
        OCPropertySymbol ps = CidrDocumentationProvider.getPropertySymbol(p);
        OCInstanceVariableSymbol iVar = null;
        if (ps != null) {
            iVar = ps.getAssociatedIvar();
        }
        return iVar == null ? null : (PsiElement)iVar.locateDefinition();
    }

    @Nullable
    private static OCPropertySymbol getPropertySymbol(@NotNull OCProperty p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "getPropertySymbol"));
        }
        OCDeclaration pd = p.getDeclaration();
        if (pd == null) {
            return null;
        }
        List<OCDeclarator> ds = pd.getDeclarators();
        if (ds.size() == 0) {
            return null;
        }
        OCSymbol s = ds.get(0).getSymbol();
        return s instanceof OCPropertySymbol ? (OCPropertySymbol)s : null;
    }

    @NotNull
    protected static String declaredInHint(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "declaredInHint"));
        }
        String string = CidrDocumentationProvider.declaredInHint(file2.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "declaredInHint"));
        }
        return string;
    }

    @NotNull
    public static String declaredInHint(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "declaredInHint"));
        }
        String string = "<b>Declared In:</b> " + fileName + "<br><br>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "declaredInHint"));
        }
        return string;
    }

    @Nullable
    private static PsiElement resolveIfRequired(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "resolveIfRequired"));
        }
        if (element instanceof OCReferenceElement) {
            OCPropertySymbol property;
            OCSymbol syntheticSymbol = ((OCReferenceElement)element).resolveToSymbol();
            if (syntheticSymbol instanceof OCInstanceVariableSymbol) {
                OCPropertySymbol property2 = ((OCInstanceVariableSymbol)syntheticSymbol).getAssociatedProperty();
                if (property2 != null) {
                    return property2.locateDefinition();
                }
            } else if (syntheticSymbol instanceof OCMethodSymbol && (property = ((OCMethodSymbol)syntheticSymbol).getGeneratedFromProperty()) != null) {
                return property.locateDefinition();
            }
        }
        return element;
    }

    @Nullable
    private static String typeParameterHintDoc(@NotNull OCTypeParameterDeclaration type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "typeParameterHintDoc"));
        }
        return type.getText();
    }

    @NotNull
    private static String classHintDoc(@NotNull OCClassDeclaration classDeclaration) {
        if (classDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDeclaration", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "classHintDoc"));
        }
        String string = (classDeclaration instanceof OCProtocol ? "protocol " : "class ") + classDeclaration.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "classHintDoc"));
        }
        return string;
    }

    @NotNull
    private static String methodHintDoc(@NotNull OCMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "methodHintDoc"));
        }
        StringBuilder answer = new StringBuilder();
        OCClassDeclaration container = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)method, (Class[])new Class[]{OCClassDeclaration.class});
        if (container != null) {
            answer.append(CidrDocumentationProvider.classHintDoc(container)).append("<br>");
        }
        answer.append(method.isInstanceMethod() ? (char)'-' : '+').append(" ");
        CidrDocumentationProvider.appendType(answer, method.getRawReturnType(), method.getContainingFile(), true);
        for (OCMethodSelectorPart part : method.getParameters()) {
            String parameterName;
            answer.append("<b>");
            answer.append(part.getSelectorPart());
            answer.append("</b>");
            OCType type = part.getRawType();
            if (type != OCUnknownType.INSTANCE) {
                CidrDocumentationProvider.appendType(answer, type, method.getContainingFile(), true);
            }
            if ((parameterName = part.getParameterName()) != null) {
                answer.append(parameterName);
            }
            answer.append(" ");
        }
        String string = answer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "methodHintDoc"));
        }
        return string;
    }

    private static void appendType(@NotNull StringBuilder answer, @NotNull OCType type, @NotNull PsiFile context, boolean requiresParens) {
        boolean needParens;
        if (answer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "appendType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "appendType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "appendType"));
        }
        String typeText = type.accept(new OCTypeParameterResolveVisitor(context)).getName();
        boolean bl = needParens = requiresParens && !typeText.startsWith("(");
        if (needParens) {
            answer.append("(");
        }
        answer.append(CidrDocumentationProvider.escapeHTML(typeText));
        if (needParens) {
            answer.append(")");
        }
    }

    @Nullable
    public String generateDocInnerHtml(@NotNull PsiElement element, @Nullable PsiElement originalElement, boolean skipQuickDoc) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "generateDocInnerHtml"));
        }
        StringBuilder answer = new StringBuilder();
        if (this.myExternalProvider != null && element instanceof PsiNamedElement) {
            this.myExternalProvider.addExternalDoc(element, originalElement, answer);
        }
        if (element instanceof OCDefineDirective) {
            this.addMacroDoc(originalElement, answer, (OCDefineDirective)element);
        }
        if (answer.length() == 0) {
            this.addCommentDoc(element, answer);
        }
        if (!skipQuickDoc && answer.length() == 0) {
            this.addQuickDoc(element, originalElement, answer);
        }
        if (element instanceof PsiNamedElement) {
            CidrDocumentationProvider.addManDoc(answer, (PsiNamedElement)element);
        }
        return answer.length() == 0 ? null : answer.toString();
    }

    private void addQuickDoc(@NotNull PsiElement element, @Nullable PsiElement originalElement, @NotNull StringBuilder answer) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "addQuickDoc"));
        }
        if (answer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "addQuickDoc"));
        }
        String quickDoc = this.quickDocContent(element, originalElement, true);
        if (quickDoc != null) {
            CidrDocumentationProvider.addBreakIfRequired(answer);
            answer.append("<code>").append(quickDoc).append("</code>");
        }
    }

    private static void addManDoc(@NotNull StringBuilder answer, @NotNull PsiNamedElement namedElement) {
        VirtualFile vFile;
        if (answer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "addManDoc"));
        }
        if (namedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedElement", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "addManDoc"));
        }
        PsiFile psiFile = namedElement.getContainingFile();
        VirtualFile virtualFile = vFile = psiFile != null ? psiFile.getVirtualFile() : null;
        if (vFile == null || !vFile.getPath().contains("/usr/include/")) {
            return;
        }
        String name = namedElement.getName();
        if (name == null) {
            return;
        }
        String man = CidrDocumentationProvider.getManPage(name);
        if (man != null && man.length() > 0) {
            CidrDocumentationProvider.addBreakIfRequired(answer);
            if (answer.length() > 0) {
                answer.append("<br>");
            }
            answer.append(CidrDocumentationProvider.man2html(man));
        }
    }

    protected void addMacroDoc(@Nullable PsiElement originalElement, @NotNull StringBuilder answer, @NotNull OCDefineDirective define) {
        PsiFile file2;
        if (answer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "addMacroDoc"));
        }
        if (define == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "define", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "addMacroDoc"));
        }
        CidrDocumentationProvider.addBreakIfRequired(answer);
        if (answer.length() == 0 && (file2 = define.getContainingFile()) != null) {
            answer.append(CidrDocumentationProvider.declaredInHint(file2));
        }
        answer.append("<b>Definition:</b><br><br> <tt><pre>");
        answer.append(CidrDocumentationProvider.escapeHTML(define.getSymbol()));
        answer.append("</pre></tt><br>");
        OCMacroCall call = (OCMacroCall)PsiTreeUtil.getContextOfType((PsiElement)originalElement, (Class[])new Class[]{OCMacroCall.class});
        if (call != null) {
            answer.append("<b>Replacement</b><br><br> <tt><pre>");
            answer.append(CidrDocumentationProvider.escapeHTML(call.getReplacementText()));
            answer.append("</pre></tt>");
        }
    }

    @NotNull
    protected static String escapeHTML(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "escapeHTML"));
        }
        String string = StringUtil.escapeXml((String)text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "escapeHTML"));
        }
        return string;
    }

    @NotNull
    private static String escapeHTML(@Nullable Object object) {
        String string = StringUtil.escapeXml((String)String.valueOf(object));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "escapeHTML"));
        }
        return string;
    }

    private static void addBreakIfRequired(@NotNull StringBuilder answer) {
        if (answer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "addBreakIfRequired"));
        }
        if (answer.length() > 0) {
            answer.append("<hr/>");
        }
    }

    @Nullable
    private static String getManPage(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "getManPage"));
        }
        GeneralCommandLine cl = new GeneralCommandLine();
        cl.setExePath("man");
        cl.addParameter("3");
        cl.addParameter(name);
        try {
            CapturingProcessHandler handler2 = new CapturingProcessHandler(cl.createProcess(), CharsetToolkit.getDefaultSystemCharset());
            ProcessOutput result2 = handler2.runProcess(1000);
            if (result2.isTimeout()) {
                return null;
            }
            return result2.getStdout().trim();
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @NotNull
    private static String man2html(@NotNull String man) {
        if (man == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "man", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "man2html"));
        }
        StringBuilder a = new StringBuilder();
        boolean wasBold = false;
        boolean wasUnderscored = false;
        for (int i = 0; i < man.length(); ++i) {
            boolean bold;
            char c = man.charAt(i);
            char next = i + 1 < man.length() ? man.charAt(i + 1) : (char)'\u0000';
            boolean underscored = c == '_' && next == '\b';
            boolean bl = bold = c != '_' && next == '\b';
            if (!bold && wasBold) {
                wasBold = false;
                a.append("</b>");
            }
            if (!underscored && wasUnderscored) {
                wasUnderscored = false;
                a.append("</u>");
            }
            if (c == '\n') {
                a.append("<br>\n");
                continue;
            }
            if (!bold && !underscored) {
                CidrDocumentationProvider.appendSymbol(a, c);
                continue;
            }
            if (bold && !wasBold) {
                a.append("<b>");
                wasBold = true;
            }
            if (underscored && !wasUnderscored) {
                a.append("<u>");
                wasUnderscored = true;
            }
            CidrDocumentationProvider.appendSymbol(a, man.charAt(i + 2));
            i += 2;
        }
        String string = a.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "man2html"));
        }
        return string;
    }

    private static void appendSymbol(@NotNull StringBuilder a, char c) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "appendSymbol"));
        }
        switch (c) {
            case ' ': {
                a.append("&nbsp;");
                break;
            }
            case '\t': {
                a.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                break;
            }
            case '<': {
                a.append("&lt;");
                break;
            }
            case '>': {
                a.append("&gt;");
                break;
            }
            case '\"': {
                a.append("&quot;");
                break;
            }
            default: {
                a.append(c);
            }
        }
    }

    @NotNull
    public static String wrapDocInHtml(@NotNull String doc) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "wrapDocInHtml"));
        }
        String string = "<html><head><style type=\"text/css\">p { margin-bottom: 5px; }</style></head><body>" + doc + "</body></html>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "wrapDocInHtml"));
        }
        return string;
    }

    @NotNull
    protected String prepareCommentText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "prepareCommentText"));
        }
        StringBuilder answer = new StringBuilder();
        text = CidrDocumentationProvider.entityTag(text, "@class", "Class", 3);
        text = CidrDocumentationProvider.entityTag(text, "@category", "Category", 3);
        text = CidrDocumentationProvider.entityTag(text, "@protocol", "Protocol", 3);
        text = CidrDocumentationProvider.entityTag(text, "@define", "Macro", 3);
        text = CidrDocumentationProvider.entityTag(text, "@defined", "Macro", 3);
        text = CidrDocumentationProvider.entityTag(text, "@function", "Function", 3);
        text = CidrDocumentationProvider.entityTag(text, "@enum", "Enumeration", 3);
        text = CidrDocumentationProvider.entityTag(text, "@file", "File", 3);
        text = CidrDocumentationProvider.entityTag(text, "@framework", "Framework", 3);
        text = CidrDocumentationProvider.entityTag(text, "@functiongroup", "Function Group", 3);
        text = CidrDocumentationProvider.entityTag(text, "@header", "Header", 3);
        text = CidrDocumentationProvider.entityTag(text, "@method", "Method", 3);
        text = CidrDocumentationProvider.entityTag(text, "@property", "Property", 3);
        text = CidrDocumentationProvider.entityTag(text, "@struct", "Struct", 3);
        text = CidrDocumentationProvider.entityTag(text, "@union", "Union", 3);
        text = CidrDocumentationProvider.entityTag(text, "@typedef", "Typedef", 3);
        text = CidrDocumentationProvider.entityTag(text, "@var", "Variable", 3);
        text = CidrDocumentationProvider.entityTag(text, "@const", "Constant", 0);
        text = CidrDocumentationProvider.entityTag(text, "@constant", "Constant", 0);
        text = CidrDocumentationProvider.entityTag(text, "@param", "Parameter", 0);
        text = CidrDocumentationProvider.entityTag(text, "@field", "Field", 0);
        text = CidrDocumentationProvider.headerTag(text, "@result", "Result", 0);
        text = CidrDocumentationProvider.entityTag(text, "@throws", "Throws", 0);
        text = CidrDocumentationProvider.headerTag(text, "@abstract", "Abstract", 4);
        text = CidrDocumentationProvider.headerTag(text, "@brief", "Brief", 4);
        text = CidrDocumentationProvider.headerTag(text, "@discussion", "Discussion", 4);
        for (String line : StringUtil.splitByLines((String)text)) {
            if ((line = line.trim()).startsWith("*")) {
                line = line.substring(1);
            }
            if ((line = line.trim()).isEmpty() && answer.length() > 0) {
                answer.append("<br>");
                continue;
            }
            answer.append(line).append(' ');
        }
        String string = answer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "prepareCommentText"));
        }
        return string;
    }

    @NotNull
    private static String headerTag(@NotNull String text, @NotNull String tag, @NotNull String headerName, int level) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "headerTag"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "headerTag"));
        }
        if (headerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerName", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "headerTag"));
        }
        String replacement = level > 0 ? "<h" + level + ">" + headerName + "</h" + level + ">" : "<p>" + headerName;
        String string = text.replaceAll("\\s" + tag + "\\s", replacement);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "headerTag"));
        }
        return string;
    }

    @NotNull
    private static String entityTag(@NotNull String text, @NotNull String tag, @NotNull String kind, int level) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "entityTag"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "entityTag"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "entityTag"));
        }
        String replacement = kind + "&nbsp;<code>$1</code>&nbsp;";
        replacement = level > 0 ? "<h" + level + ">" + replacement + "</h" + level + ">" : "<p>" + replacement;
        String string = text.replaceAll("\\s" + tag + "\\s([\\w:\\(\\)\\+\\-:]*)\\s", replacement);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "entityTag"));
        }
        return string;
    }

    public void addCommentDoc(@NotNull PsiElement element, @NotNull StringBuilder answer) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "addCommentDoc"));
        }
        if (answer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "addCommentDoc"));
        }
        PsiComment comment = this.findCommentFor(element);
        if (comment != null) {
            CidrDocumentationProvider.addBreakIfRequired(answer);
        }
        while (comment != null) {
            String text = this.stripCommentBegin(comment.getText());
            answer.insert(0, this.prepareCommentText(CidrDocumentationProvider.escapeHTML(text)) + "<br>");
            comment = this.findPrevCommentFor((PsiElement)comment);
        }
    }

    @NotNull
    protected String stripCommentBegin(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "stripCommentBegin"));
        }
        if (text.startsWith("/*!") || text.startsWith("/**")) {
            text = text.substring(3);
        } else if (text.startsWith("/*") || text.startsWith("//")) {
            text = text.substring(2);
        }
        if (text.endsWith("*/")) {
            text = text.substring(0, text.length() - 2);
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "stripCommentBegin"));
        }
        return string;
    }

    @Nullable
    protected PsiComment findCommentFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "findCommentFor"));
        }
        PsiComment comment = CidrDocumentationProvider.findOCCommentFor(element);
        if (comment == null && element instanceof OCSymbolDeclarator) {
            Object associatedElement;
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            if (symbol != null) {
                symbol = symbol.getAssociatedSymbol();
            }
            if (symbol != null && (associatedElement = symbol.locateDefinition()) != null) {
                comment = CidrDocumentationProvider.findOCCommentFor(associatedElement);
            }
        }
        return comment;
    }

    @Nullable
    protected PsiComment findPrevCommentFor(@NotNull PsiElement element) {
        PsiComment prevComment;
        PsiElement prevCommentPrecedingWS;
        PsiWhiteSpace w;
        PsiElement wPrev;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "findPrevCommentFor"));
        }
        PsiElement prev = element.getPrevSibling();
        if (prev instanceof PsiComment) {
            PsiComment comment = (PsiComment)prev;
            return this.acceptDocComment(comment) ? comment : null;
        }
        if (prev instanceof PsiWhiteSpace && (wPrev = (w = (PsiWhiteSpace)prev).getPrevSibling()) instanceof PsiComment && (prevCommentPrecedingWS = (prevComment = (PsiComment)wPrev).getPrevSibling()) instanceof PsiWhiteSpace && prevCommentPrecedingWS.getText().contains("\n")) {
            return this.acceptDocComment(prevComment) ? prevComment : null;
        }
        return null;
    }

    protected boolean acceptDocComment(@NotNull PsiComment comment) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider", "acceptDocComment"));
        }
        return true;
    }

    @Nullable
    private static PsiComment findOCCommentFor(@Nullable PsiElement elt) {
        PsiElement child;
        if (elt instanceof OCDeclarator) {
            elt = elt.getParent();
        }
        if (elt == null) {
            return null;
        }
        if (elt.getParent() instanceof OCProperty) {
            elt = elt.getParent();
        }
        if (elt.getContainingFile() == null) {
            return null;
        }
        for (PsiElement next = elt.getNextSibling(); next != null; next = next.getNextSibling()) {
            if (next instanceof PsiComment) {
                return (PsiComment)next;
            }
            if (next instanceof PsiWhiteSpace ? next.getText().contains("\n") : next.getNode().getElementType() != OCTokenTypes.SEMICOLON) break;
        }
        if ((child = elt.getFirstChild()) instanceof PsiComment) {
            return (PsiComment)child;
        }
        for (elt = elt.getPrevSibling(); elt != null; elt = elt.getPrevSibling()) {
            PsiElement precedingWS;
            if (elt instanceof PsiComment && ((precedingWS = elt.getPrevSibling()) == null || precedingWS instanceof PsiWhiteSpace && precedingWS.getText().contains("\n"))) {
                return (PsiComment)elt;
            }
            if (elt.getTextLength() <= 0) continue;
            IElementType type = OCElementUtil.getObjCKeywordElementType(elt.getNode());
            if (!(elt instanceof PsiWhiteSpace) && type != OCTokenTypes.OPTIONAL_KEYWORD && type != OCTokenTypes.REQUIRED_KEYWORD) break;
        }
        return null;
    }

    public static interface ExternalProvider {
        public void addExternalDoc(@NotNull PsiElement var1, @Nullable PsiElement var2, @NotNull StringBuilder var3);
    }
}

