/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAlgorithm;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCUnreachableCodeFinder
extends OCDataFlowAlgorithm {
    private boolean myExitNodeReached;
    private boolean myDeadEndReached;
    private MultiMap<OCInstruction.InstructionKind, OCInstruction> myInstructionsByType;

    public OCUnreachableCodeFinder(@NotNull OCControlFlowGraph cfg) {
        if (cfg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cfg", "com/jetbrains/cidr/lang/dfa/OCUnreachableCodeFinder", "<init>"));
        }
        super(cfg);
    }

    @Override
    public void process() {
        this.myDeadEndReached = false;
        this.myInstructionsByType = new MultiMap();
        this.clearProcessedNodes();
        this.traverse(this.myCfg.getStartNode(), null, null, true);
    }

    @Override
    protected void processDeadEnd(@NotNull OCNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/dfa/OCUnreachableCodeFinder", "processDeadEnd"));
        }
        this.myDeadEndReached = true;
    }

    public boolean isDeadEndReached() {
        return this.myDeadEndReached;
    }

    public boolean isExitNodeReached() {
        return this.myExitNodeReached;
    }

    @NotNull
    public List<OCElementsRange> getUnreachableRanges(boolean mergeRanges) {
        ArrayList<OCNode> unprocessedNodes = new ArrayList<OCNode>();
        for (OCNode node : this.myCfg.getNodes()) {
            if (this.isNodeProcessed(node, null) || node.isFake()) continue;
            unprocessedNodes.add(node);
        }
        List<OCElementsRange> list = OCUnreachableCodeFinder.getRanges(unprocessedNodes, mergeRanges);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCUnreachableCodeFinder", "getUnreachableRanges"));
        }
        return list;
    }

    @Override
    protected void nodeProcessed(@NotNull OCNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/dfa/OCUnreachableCodeFinder", "nodeProcessed"));
        }
        if (this.myCfg.getExitNodes().contains(node)) {
            this.myExitNodeReached = true;
        }
        if (node.getInstructions() != null) {
            for (OCInstruction instruction : node.getInstructions()) {
                this.myInstructionsByType.putValue((Object)instruction.getKind(), (Object)instruction);
            }
        }
    }

    @NotNull
    public Collection<OCInstruction> getReachableInstructions(@NotNull OCInstruction.InstructionKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/cidr/lang/dfa/OCUnreachableCodeFinder", "getReachableInstructions"));
        }
        Collection collection = this.myInstructionsByType.get((Object)kind);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCUnreachableCodeFinder", "getReachableInstructions"));
        }
        return collection;
    }

    public void clearInstructions() {
        this.myInstructionsByType.clear();
    }
}

