/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNode {
    private OCControlFlowGraph myGraph;
    private int myIndex;
    private int myId;
    private OCElementsRange myRange;
    private boolean myFake;
    private List<OCNode> myJumpTargets;
    private List<OCNode> myJumpSources;
    private List<OCNode> myFakeJumpTargets;
    private OCNode myNodeAfterReturn;
    private List<OCInstruction> myInstructions;
    private MultiMap<OCInstruction.InstructionKind, OCInstruction> myInstructionsByType;

    OCNode(@NotNull OCControlFlowGraph graph, int index, int id, boolean isFake) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/jetbrains/cidr/lang/dfa/OCNode", "<init>"));
        }
        this.myRange = null;
        this.myGraph = graph;
        this.myIndex = index;
        this.myId = id;
        this.myFake = isFake;
    }

    @NotNull
    public OCControlFlowGraph getGraph() {
        OCControlFlowGraph oCControlFlowGraph = this.myGraph;
        if (oCControlFlowGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCNode", "getGraph"));
        }
        return oCControlFlowGraph;
    }

    public int getIndex() {
        return this.myIndex;
    }

    public int getId() {
        return this.myId;
    }

    public boolean isEmpty() {
        return this == this.myGraph.getLastAddedNode() && this.myRange == null && this.myJumpTargets == null && this.myInstructions == null;
    }

    public boolean isFake() {
        return this.myFake;
    }

    public void addBranch(@NotNull OCNode target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/cidr/lang/dfa/OCNode", "addBranch"));
        }
        this.addBranch(target, false);
    }

    public void addBranch(@NotNull OCNode target, boolean isFake) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/cidr/lang/dfa/OCNode", "addBranch"));
        }
        assert (this.myGraph == target.myGraph);
        if (this.myJumpTargets == null) {
            this.myJumpTargets = new ArrayList<OCNode>(2);
        } else if (this.myJumpTargets.contains(target)) {
            return;
        }
        if (target.myJumpSources == null) {
            target.myJumpSources = new ArrayList<OCNode>(2);
        }
        this.myJumpTargets.add(target);
        target.myJumpSources.add(this);
        if (isFake) {
            if (this.myFakeJumpTargets == null) {
                this.myFakeJumpTargets = new ArrayList<OCNode>(2);
            }
            this.myFakeJumpTargets.add(target);
        }
    }

    public void enlarge(@NotNull PsiElement element, @NotNull PsiElement parent) {
        TextRange range;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/dfa/OCNode", "enlarge"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/cidr/lang/dfa/OCNode", "enlarge"));
        }
        TextRange textRange = range = element instanceof OCMacroForeignLeafElement ? ((OCMacroForeignLeafElement)element).getRealTextRange() : element.getTextRange();
        if (this.myRange == null) {
            this.myRange = new OCElementsRange(element, element){

                @Override
                public TextRange getTextRange() {
                    return new TextRange(this.getStartOffset(), this.getEndOffset());
                }
            };
        } else {
            if (this.myRange.getStartOffset() > range.getStartOffset()) {
                PsiFile file2 = element.getContainingFile();
                OCLog.LOG.error("Offset is out of range: " + element.getTextOffset(), new Attachment[]{new Attachment(file2.getName(), file2.getText())});
            }
            this.myRange.setLastElement(element);
        }
        if (this.myRange.getTextRange().contains(parent.getTextRange())) {
            this.myRange.setContainsCompositeElement(true);
        }
    }

    public void addInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/cidr/lang/dfa/OCNode", "addInstruction"));
        }
        if (this.myInstructions == null) {
            this.myInstructions = new ArrayList<OCInstruction>();
            this.myInstructionsByType = new MultiMap();
        }
        this.myInstructions.add(instruction);
        this.myInstructionsByType.putValue((Object)instruction.getKind(), (Object)instruction);
    }

    @Nullable
    public List<OCInstruction> getInstructions() {
        return this.myInstructions;
    }

    @Nullable
    public List<OCNode> getJumpTargets() {
        return this.myJumpTargets;
    }

    @Nullable
    public List<OCNode> getJumpSources() {
        return this.myJumpSources;
    }

    @Nullable
    public List<OCNode> getFakeJumpTargets() {
        return this.myFakeJumpTargets;
    }

    @Nullable
    public OCElementsRange getRange() {
        return this.myRange;
    }

    public int getEndOffset() {
        return this.myRange != null ? this.myRange.getEndOffset() : -1;
    }

    @Nullable
    public OCNode getNodeAfterReturn() {
        return this.myNodeAfterReturn;
    }

    public void setNodeAfterReturn(@NotNull OCNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/dfa/OCNode", "setNodeAfterReturn"));
        }
        this.myNodeAfterReturn = node;
    }
}

