/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAlgorithm;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

class OCEndlessLoopFinder
extends OCDataFlowAlgorithm {
    private Stack<OCNode> myTopologicalOrder;
    private List<OCNode> myComponent;
    private List<OCNode> myEndlessLoops;
    private List<OCNode> myUnreachedNodes;
    private boolean myForwardMode;

    public OCEndlessLoopFinder(@NotNull OCControlFlowGraph cfg) {
        if (cfg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cfg", "com/jetbrains/cidr/lang/dfa/OCEndlessLoopFinder", "<init>"));
        }
        super(cfg);
        this.myTopologicalOrder = new Stack();
        this.myComponent = new ArrayList<OCNode>();
        this.myEndlessLoops = new ArrayList<OCNode>();
        this.myUnreachedNodes = new ArrayList<OCNode>();
    }

    @Override
    public void process() {
        this.myEndlessLoops.clear();
        this.myTopologicalOrder.clear();
        this.myUnreachedNodes.clear();
        this.clearProcessedNodes();
        this.myForwardMode = true;
        this.traverse(this.myCfg.getStartNode(), null, null, true);
        for (OCNode node : this.myCfg.getNodes()) {
            if (this.isNodeProcessed(node, null)) continue;
            this.myUnreachedNodes.add(node);
        }
        this.myForwardMode = false;
        this.clearProcessedNodes();
        while (!this.myTopologicalOrder.isEmpty()) {
            OCNode node = this.myTopologicalOrder.pop();
            if (this.isNodeProcessed(node, null)) continue;
            this.myComponent.clear();
            this.traverse(node, null, null, false);
            if (!this.isEndlessLoop(this.myComponent)) continue;
            this.myEndlessLoops.addAll(this.myComponent);
        }
    }

    private boolean isEndlessLoop(@NotNull List<OCNode> component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/cidr/lang/dfa/OCEndlessLoopFinder", "isEndlessLoop"));
        }
        boolean wasJump = false;
        for (OCNode node : component) {
            if (this.myUnreachedNodes.contains(node) || node.getJumpTargets() == null) continue;
            wasJump = true;
            for (OCNode target : node.getJumpTargets()) {
                if (this.myUnreachedNodes.contains(target) || this.isNodeProcessed(target, null)) continue;
                return false;
            }
        }
        return wasJump;
    }

    @Override
    protected void nodeProcessed(@NotNull OCNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/dfa/OCEndlessLoopFinder", "nodeProcessed"));
        }
        if (this.myForwardMode) {
            this.myTopologicalOrder.push(node);
        } else {
            this.myComponent.add(node);
        }
    }

    @NotNull
    public List<OCElementsRange> getEndlessLoops() {
        List<OCElementsRange> list = OCEndlessLoopFinder.getRanges(this.myEndlessLoops, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCEndlessLoopFinder", "getEndlessLoops"));
        }
        return list;
    }
}

