/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.dfa.OCControlFlowBuilder;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCEndlessLoopFinder;
import com.jetbrains.cidr.lang.dfa.OCEscapedValuesChecker;
import com.jetbrains.cidr.lang.dfa.OCInfiniteRecursionFinder;
import com.jetbrains.cidr.lang.dfa.OCInputOutputVariablesFinder;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNotInitializedVarChecker;
import com.jetbrains.cidr.lang.dfa.OCNotReleasedVariablesChecker;
import com.jetbrains.cidr.lang.dfa.OCNotUsedValueChecker;
import com.jetbrains.cidr.lang.dfa.OCUnreachableCodeFinder;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExternalReference;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCAddElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeGCCAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationButInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSendMessageToObjectIntentionAction;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCMethodReferencesSearch;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDataFlowAnalyzer
extends OCAnnotator {
    private PsiElement[] myCodeFragments;
    private OCControlFlowGraph myGraph;
    private OCControlFlowBuilder myGraphBuilder;
    private OCUnreachableCodeFinder myUnreachableCodeFinder;
    private OCInfiniteRecursionFinder myInfiniteRecursionFinder;
    private OCEndlessLoopFinder myEndlessLoopFinder;
    private OCDataFlowAnalyzer myParentAnalyzer;
    private List<OCDataFlowAnalyzer> myChildAnalyzers;
    private TextRange mySelection;
    private List<OCSymbol> myInputVariables;
    private List<OCSymbol> myOutputVariables;
    private List<OCSymbol> myWrittenVariables;
    private List<OCSymbol> myEscapedDeclarators;
    private Map<OCSymbol, List<PsiReference>> myVariableUsages;

    public OCDataFlowAnalyzer(@NotNull PsiElement codeFragment, @Nullable OCAnnotator annotator, @Nullable OCDataFlowAnalyzer parentAnalyzer) {
        if (codeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFragment", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "<init>"));
        }
        this(codeFragment, parentAnalyzer != null ? parentAnalyzer.mySelection : null);
        this.myParentAnalyzer = parentAnalyzer;
        if (annotator != null) {
            this.setHolder(annotator.getHolder(), annotator.getAnnotatingElement());
        }
        if (parentAnalyzer != null) {
            parentAnalyzer.myChildAnalyzers.add(this);
        }
    }

    public OCDataFlowAnalyzer(@NotNull PsiElement[] codeFragments, @Nullable TextRange selection) {
        if (codeFragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFragments", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "<init>"));
        }
        this.myChildAnalyzers = new ArrayList<OCDataFlowAnalyzer>();
        this.myCodeFragments = codeFragments;
        this.mySelection = selection;
        this.myInputVariables = new ArrayList<OCSymbol>();
        this.myOutputVariables = new ArrayList<OCSymbol>();
        this.myWrittenVariables = new ArrayList<OCSymbol>();
        this.myEscapedDeclarators = new ArrayList<OCSymbol>();
        this.myVariableUsages = new HashMap<OCSymbol, List<PsiReference>>();
    }

    public OCDataFlowAnalyzer(@NotNull PsiElement codeFragment, @Nullable TextRange selection) {
        if (codeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFragment", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "<init>"));
        }
        this(new PsiElement[]{codeFragment}, selection);
    }

    @NotNull
    public OCControlFlowGraph getGraph() {
        OCControlFlowGraph oCControlFlowGraph = this.myGraph;
        if (oCControlFlowGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "getGraph"));
        }
        return oCControlFlowGraph;
    }

    @Nullable
    public OCControlFlowGraph findGraph(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "findGraph"));
        }
        if (!this.myGraph.getCodeFragment().getTextRange().contains(element.getTextOffset())) {
            return null;
        }
        for (OCDataFlowAnalyzer analyzer : this.myChildAnalyzers) {
            OCControlFlowGraph graph = analyzer.findGraph(element);
            if (graph == null) continue;
            return graph;
        }
        return this.myGraph;
    }

    @NotNull
    public OCUnreachableCodeFinder getUnreachableCodeFinder() {
        OCUnreachableCodeFinder oCUnreachableCodeFinder = this.myUnreachableCodeFinder;
        if (oCUnreachableCodeFinder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "getUnreachableCodeFinder"));
        }
        return oCUnreachableCodeFinder;
    }

    @NotNull
    public List<OCSymbol> getInputVariables() {
        List<OCSymbol> list = this.myInputVariables;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "getInputVariables"));
        }
        return list;
    }

    @NotNull
    public List<OCSymbol> getOutputVariables() {
        List<OCSymbol> list = this.myOutputVariables;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "getOutputVariables"));
        }
        return list;
    }

    @NotNull
    public List<OCSymbol> getWrittenVariables() {
        List<OCSymbol> list = this.myWrittenVariables;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "getWrittenVariables"));
        }
        return list;
    }

    @NotNull
    public List<OCSymbol> getEscapedDeclarators() {
        List<OCSymbol> list = this.myEscapedDeclarators;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "getEscapedDeclarators"));
        }
        return list;
    }

    public void buildControlFlowGraph() {
        this.myGraph = new OCControlFlowGraph(this.myCodeFragments[0], this.myParentAnalyzer != null ? this.myParentAnalyzer.getGraph() : null);
        this.myGraphBuilder = new OCControlFlowBuilder(this, this.myGraph, this.mySelection);
        boolean isFirst = true;
        for (PsiElement codeFragment : this.myCodeFragments) {
            if (isFirst) {
                this.myGraphBuilder.processFirstCodeFragment(codeFragment);
            } else {
                this.myGraphBuilder.processNextCodeFragment(codeFragment);
            }
            isFirst = false;
        }
        this.myUnreachableCodeFinder = new OCUnreachableCodeFinder(this.myGraph);
        this.myInfiniteRecursionFinder = new OCInfiniteRecursionFinder(this.myGraph);
        this.myEndlessLoopFinder = new OCEndlessLoopFinder(this.myGraph);
        this.myUnreachableCodeFinder.process();
        this.myInfiniteRecursionFinder.process();
        this.myEndlessLoopFinder.process();
    }

    public void analyze() {
        Annotation annotation;
        PsiElement firstCodeFragment = this.myCodeFragments[0];
        OCCallable callable = firstCodeFragment instanceof OCCallable ? (OCCallable)firstCodeFragment : null;
        List<PsiElement> callableIdentifiers = null;
        if (callable instanceof OCMethod) {
            callableIdentifiers = ((OCMethod)callable).getSelectors();
        } else if (callable instanceof OCFunctionDefinition) {
            callableIdentifiers = Collections.singletonList(((OCFunctionDefinition)callable).getNameIdentifier());
        }
        if (callable != null && !callable.getReturnType().resolve(callable.getContainingFile()).isVoid() && this.myUnreachableCodeFinder.isDeadEndReached()) {
            OCBlockStatement body = callable.getBody();
            boolean isConstructor = false;
            if (body == null) {
                return;
            }
            OCSymbol oCSymbol = callable.getSymbol();
            if (callable.getContainingOCFile().isCpp() && callable instanceof OCFunctionDefinition && oCSymbol != null && oCSymbol.getKind().isConstructorOrDestructor()) {
                isConstructor = true;
            }
            if (oCSymbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)oCSymbol).isMainFunction()) {
                return;
            }
            if (!isConstructor) {
                String message = "Control reaches end of non-void " + callable.getKind().toStringLowercase();
                annotation = callable instanceof OCBlockExpression ? this.addErrorAnnotation(body.getClosingBrace(), "err_maybe_falloff_nonvoid_block", message) : (OCCompilerHelper.doesEmptyReturnFromNonVoidProduceError(body.getContainingOCFile()) ? this.addErrorAnnotation(body.getClosingBrace(), OCInspections.MissingReturn.class, "warn_falloff_nonvoid_function", message) : this.addWarningAnnotation(body.getClosingBrace(), OCInspections.MissingReturn.class, "warn_falloff_nonvoid_function", message));
                OCType type = callable.getReturnType().resolve(body.getContainingFile());
                this.registerQuickFix(annotation, new OCAddElementIntentionAction("Add return statement", body, OCElementFactory.statementFromText("return " + type.getDefaultValue(callable) + ";", firstCodeFragment)));
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(callable.getSymbol(), (OCType)OCVoidType.instance(), true));
            }
        }
        for (OCElementsRange range : this.myEndlessLoopFinder.getEndlessLoops()) {
            this.addWarningAnnotation((PsiElement)firstCodeFragment.getContainingFile(), range.getTextRange(), OCInspections.EndlessLoop.class, "warn_suggest_noreturn_function", "Endless loop", ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
        if (callableIdentifiers != null && !this.myInfiniteRecursionFinder.isExitOrDeadEndReached()) {
            ArrayList<PsiElement> elements = new ArrayList<PsiElement>(callableIdentifiers);
            elements.addAll(this.myInfiniteRecursionFinder.getRecursiveCalls());
            this.addWarningAnnotations(elements, OCInspections.InfiniteRecursion.class, "CIDR", (Object)((Object)callable.getKind()) + " '" + callable.getName() + "' recurses infinitely");
        }
        boolean arcEnabled = firstCodeFragment != null && !OCCompilerHelper.isArcDisabled(firstCodeFragment.getContainingFile());
        for (OCSymbol oCSymbol : this.myGraph.getLocalSymbols()) {
            if (oCSymbol.isUnnamed()) continue;
            this.analyzeNotUsed(oCSymbol);
            this.analyzeInputOutput(oCSymbol);
            this.analyzeNotInitialized(oCSymbol, arcEnabled);
            if (arcEnabled) continue;
            this.analyzeNotReleased(oCSymbol, new OCNotReleasedVariablesChecker(this.myGraph, oCSymbol), true);
        }
        for (OCSymbol oCSymbol : this.myGraph.getClosureSymbols()) {
            if (oCSymbol.isUnnamed()) continue;
            this.analyzeNotInitialized(oCSymbol, arcEnabled);
            this.analyzeInputOutput(oCSymbol);
        }
        if (!arcEnabled && firstCodeFragment != null) {
            for (Pair pair : OCNotReleasedVariablesChecker.getUnreleasedObjects(firstCodeFragment)) {
                OCCallable method;
                OCSymbol symbol;
                annotation = this.addWarningAnnotation((PsiElement)pair.getFirst(), OCInspections.NotReleasedValue.class, "CIDR", "Retained value may have not been released");
                PsiElement object = (PsiElement)pair.getSecond();
                this.registerQuickFix(annotation, new OCSendMessageToObjectIntentionAction(object, "autorelease"));
                if (!(object.getParent() instanceof OCReturnStatement) || !((symbol = (method = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)object, OCCallable.class)) != null ? method.getSymbol() : null) instanceof OCMethodSymbol)) continue;
                this.registerQuickFix(annotation, new OCChangeGCCAttributeIntentionAction(symbol, "ns_returns_retained", "NS_RETURNS_RETAINED", true));
            }
        }
        this.analyzeEscapedValue();
        for (OCDataFlowAnalyzer oCDataFlowAnalyzer : this.myChildAnalyzers) {
            oCDataFlowAnalyzer.analyze();
            this.myInputVariables.addAll(oCDataFlowAnalyzer.getInputVariables());
            this.myOutputVariables.addAll(oCDataFlowAnalyzer.getOutputVariables());
            this.myEscapedDeclarators.addAll(oCDataFlowAnalyzer.getEscapedDeclarators());
            this.myWrittenVariables.addAll(oCDataFlowAnalyzer.getWrittenVariables());
            for (OCSymbol symbol : oCDataFlowAnalyzer.myVariableUsages.keySet()) {
                if (this.myVariableUsages.containsKey(symbol)) continue;
                this.myVariableUsages.put(symbol, oCDataFlowAnalyzer.myVariableUsages.get(symbol));
            }
        }
        if (this.mySelection != null) {
            Comparator<OCSymbol> comparator2 = new Comparator<OCSymbol>(){

                @Override
                public int compare(OCSymbol s1, OCSymbol s2) {
                    return s1.getOffset() - s2.getOffset();
                }
            };
            Collections.sort(this.myInputVariables, comparator2);
            Collections.sort(this.myOutputVariables, comparator2);
            Collections.sort(this.myWrittenVariables, comparator2);
            Collections.sort(this.myEscapedDeclarators, comparator2);
        }
    }

    private void analyzeNotInitialized(@NotNull OCSymbol symbol, boolean arcEnabled) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "analyzeNotInitialized"));
        }
        if (symbol.getKind() != OCSymbolKind.LOCAL_VARIABLE) {
            return;
        }
        OCType resolvedType = symbol.getResolvedType();
        if (resolvedType instanceof OCStructType) {
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            for (OCStructSymbol struct : ((OCStructType)resolvedType).getStructs()) {
                if (!struct.processConstructors((Processor<? super OCFunctionSymbol>)finder)) break;
                if (!((OCStructType)resolvedType).isEmpty()) continue;
                return;
            }
            if (finder.isFound()) {
                return;
            }
        }
        if (arcEnabled && resolvedType.isPointerToObjectCompatible()) {
            return;
        }
        if (symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isStatic()) {
            return;
        }
        OCNotInitializedVarChecker notInitializedChecker = new OCNotInitializedVarChecker(this.myGraph, symbol);
        notInitializedChecker.process();
        for (PsiElement read : notInitializedChecker.getNotInitializedReads()) {
            if (OCDataFlowAnalyzer.isComplicatedCppInstruction(symbol, read)) continue;
            Annotation annotation = this.addWarningAnnotation(read, symbol, OCInspections.NotInitializedVariable.class, "warn_uninit_var", symbol.getNameWithKindUppercase() + " might not have been initialized");
            OCInstruction declInstruction = this.myGraph.getDeclaratorInstruction(symbol);
            if (declInstruction == null) {
                declInstruction = this.myGraph.getClosureVariableDeclaratorGraph(symbol).getDeclaratorInstruction(symbol);
            }
            this.registerQuickFix(annotation, new OCAddInitializerIntentionAction((OCDeclarator)declInstruction.getRValue(), symbol));
        }
    }

    private static boolean isComplicatedCppInstruction(@NotNull OCSymbol symbol, @NotNull PsiElement read) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "isComplicatedCppInstruction"));
        }
        if (read == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "read", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "isComplicatedCppInstruction"));
        }
        OCFile file2 = symbol.getContainingOCFile();
        if (file2 != null && file2.isCpp()) {
            OCType type = symbol.getResolvedType();
            if (type instanceof OCMagicType || type instanceof OCStructType && ((OCStructType)type).getSymbol().hasMemberFunctions()) {
                return true;
            }
            if (read.getParent() instanceof OCQualifiedExpression) {
                PsiElement parent = read.getParent();
                while (parent instanceof OCQualifiedExpression) {
                    OCQualifiedExpression expr = (OCQualifiedExpression)parent;
                    if (expr.getResolvedType() instanceof OCMagicType) {
                        return true;
                    }
                    parent = PsiTreeUtil.skipParentsOfType((PsiElement)parent, (Class[])new Class[]{OCParenthesizedExpression.class});
                }
            }
        }
        return false;
    }

    private void analyzeNotUsed(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "analyzeNotUsed"));
        }
        if (symbol.getType() instanceof OCCppReferenceType || symbol.getProject().getUserData(OCFile.DFA_UNUSED_CHECKS) == OCFile.UnusedChecksMode.DISABLED) {
            return;
        }
        OCNotUsedValueChecker notUsedChecker = new OCNotUsedValueChecker(this.myGraph, symbol);
        notUsedChecker.process();
        for (PsiElement write : notUsedChecker.getNotUsedWrites()) {
            String text;
            if (OCElementUtil.isPartOfMacroSubstitution(write.getParent()) || write.getParent() instanceof OCDeclarator && (!notUsedChecker.isSymbolUsed() || "0".equals(text = OCElementUtil.getTextWithMacros(write = ((OCDeclarator)write.getParent()).getInitializer())) || OCCodeInsightUtil.isLikeNull(text)) || write == null) continue;
            Annotation annotation = this.addWarningAnnotation(write, symbol, OCInspections.UnusedValue.class, "CIDR", "The value is never used", ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            PsiElement element = write.getContext();
            if (element instanceof OCDeclarator) {
                this.registerQuickFix(annotation, new OCRemoveInitializerIntentionAction((OCDeclarator)element));
                continue;
            }
            this.registerQuickFix(annotation, new OCRemoveDeclarationIntentionAction("statement", element));
            this.registerQuickFix(annotation, new OCRemoveDeclarationButInitializerIntentionAction("statement", element));
        }
        if (!notUsedChecker.isSymbolUsed() && this.enableUnusedCheck(symbol)) {
            String clangID;
            Class inspectionClass;
            String messageSuffix = notUsedChecker.isSymbolAssigned() ? " is only assigned but never accessed" : " is never used";
            PsiElement declaratorElement = this.myGraph.getDeclaratorInstruction(symbol).getRValue();
            if (PsiTreeUtil.getParentOfType((PsiElement)declaratorElement, OCTypeElement.class) != null) {
                return;
            }
            if (declaratorElement instanceof OCDeclarator) {
                declaratorElement = ((OCDeclarator)declaratorElement).getNameIdentifier();
            }
            if (symbol.getKind() == OCSymbolKind.PARAMETER) {
                inspectionClass = OCInspections.UnusedParameter.class;
                clangID = "warn_unused_parameter";
            } else if (symbol.getKind() == OCSymbolKind.LABEL) {
                inspectionClass = OCInspections.UnusedLocalVariable.class;
                clangID = "warn_unused_label";
            } else {
                inspectionClass = OCInspections.UnusedLocalVariable.class;
                clangID = "warn_unused_variable";
            }
            Annotation annotation = this.addWarningAnnotation(declaratorElement, symbol, inspectionClass, clangID, symbol.getNameWithKindUppercase() + messageSuffix, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            this.registerQuickFix(annotation, new OCRemoveDeclarationIntentionAction(symbol));
            this.registerQuickFix(annotation, new OCRemoveDeclarationButInitializerIntentionAction(symbol));
            this.registerQuickFix(annotation, (IntentionAction)new OCChangeGCCAttributeIntentionAction.SuppressFix(symbol, "unused", "__unused", true));
        }
    }

    private boolean enableUnusedCheck(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "enableUnusedCheck"));
        }
        if (symbol.hasAttribute("unused") || symbol.hasAttribute("used")) {
            return false;
        }
        if (symbol.getKind() == OCSymbolKind.PARAMETER) {
            OCSymbol parentSymbol;
            PsiElement firstCodeFragment = this.myCodeFragments[0];
            OCCallable callable = firstCodeFragment instanceof OCCallable ? (OCCallable)firstCodeFragment : null;
            OCSymbol oCSymbol = parentSymbol = callable != null ? callable.getSymbol() : null;
            if (parentSymbol == null || parentSymbol.getKind() == OCSymbolKind.BLOCK || parentSymbol.getKind() == OCSymbolKind.LAMBDA || parentSymbol.hasAttribute("ibaction")) {
                return false;
            }
            if (parentSymbol instanceof OCFunctionSymbol) {
                return !((OCFunctionSymbol)parentSymbol).isMainFunction();
            }
            if (parentSymbol instanceof OCMethodSymbol) {
                OCMethodSymbol method = (OCMethodSymbol)parentSymbol;
                if (((OCClassSymbol)method.getParent()).getKind() != OCSymbolKind.IMPLEMENTATION) {
                    return false;
                }
                OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> searchParameters = OCMemberInheritorsSearch.getParameters(method);
                searchParameters.setAncestors(true);
                if (OCMemberInheritorsSearch.search(searchParameters).findFirst() != null) {
                    return false;
                }
                OCMethodSymbol associatedSymbol = method.getAssociatedSymbol();
                if (associatedSymbol != null) {
                    method = associatedSymbol;
                }
                GlobalSearchScope scope = OCSearchScope.getProjectSourcesScope(symbol.getProject());
                Object methodDefinition = method.locateDefinition();
                if (methodDefinition == null) {
                    return false;
                }
                ReferencesSearch.SearchParameters parameters = new ReferencesSearch.SearchParameters(methodDefinition, (SearchScope)scope, false);
                return new OCMethodReferencesSearch().execute(parameters, new Processor<PsiReference>(){

                    public boolean process(PsiReference psiReference) {
                        return !(psiReference.getElement() instanceof OCSelectorExpression) && !(psiReference instanceof OCExternalReference);
                    }
                });
            }
            return false;
        }
        return symbol.getKind() != OCSymbolKind.CATCH_EXCEPTION_VARIABLE;
    }

    public void analyzeNotReleased(@NotNull OCSymbol symbol, @NotNull OCNotReleasedVariablesChecker checker, boolean processReturns) {
        OCCallable callable;
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "analyzeNotReleased"));
        }
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "analyzeNotReleased"));
        }
        if (processReturns) {
            checker.setStartFromReturns(true);
        }
        if (!symbol.getResolvedType().isPointerToObjectCompatible() || symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isStatic()) {
            return;
        }
        checker.process();
        HashSet<PsiElement> notReleasedElements = new HashSet<PsiElement>();
        for (PsiElement element : checker.getNotReleasedElements()) {
            notReleasedElements.add(element);
            Annotation annotation = this.addWarningAnnotation(element, symbol, OCInspections.NotReleasedValue.class, "CIDR", "Retained value may have not been released");
            this.registerQuickFix(annotation, new OCReleaseVariablesIntentionAction(symbol, element));
            this.registerQuickFix(annotation, new OCSendMessageToObjectIntentionAction(element, "autorelease"));
        }
        if (processReturns && this.myCodeFragments[0] instanceof OCCallable && !OCElementUtil.isRetainMethod(callable = (OCCallable)this.myCodeFragments[0])) {
            checker.setStartFromReturns(false);
            checker.process();
            for (PsiElement element : checker.getNotReleasedElements()) {
                if (notReleasedElements.contains(element)) continue;
                Annotation annotation = this.addWarningAnnotation(element, symbol, OCInspections.NotReleasedValue.class, "CIDR", "Retained value may have not been released");
                this.registerQuickFix(annotation, new OCReleaseVariablesIntentionAction(symbol, element));
                this.registerQuickFix(annotation, new OCSendMessageToObjectIntentionAction(element, "autorelease"));
                this.registerQuickFix(annotation, new OCChangeGCCAttributeIntentionAction(callable.getSymbol(), "ns_returns_retained", "NS_RETURNS_RETAINED", true));
            }
        }
    }

    private void analyzeEscapedValue() {
        OCEscapedValuesChecker checker = new OCEscapedValuesChecker(this.myGraph);
        checker.process();
        for (PsiElement element : checker.getEscapedVariables()) {
            this.addWarningAnnotation(element, OCInspections.LocalValueEscapesScope.class, "warn_ret_stack_addr", "Local value may escape the method/function");
        }
        for (PsiElement element : checker.getEscapedObjects()) {
            String message = (element instanceof OCBlockExpression ? "Block" : "Value") + " escapes the local scope";
            Annotation annotation = this.addWarningAnnotation(element, OCInspections.LocalValueEscapesScope.class, "warn_ret_local_temp_addr", message);
            if (!(element instanceof OCBlockExpression)) continue;
            this.registerQuickFix(annotation, new OCSendMessageToObjectIntentionAction(element, "copy"));
        }
    }

    private void analyzeInputOutput(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "analyzeInputOutput"));
        }
        if (this.mySelection == null) {
            return;
        }
        OCInputOutputVariablesFinder finder = new OCInputOutputVariablesFinder(this.myGraph, symbol, this.mySelection);
        finder.process();
        boolean needUsages = false;
        if (finder.isInputVariable()) {
            this.myInputVariables.add(symbol);
            needUsages = true;
        }
        if (finder.isOutputVariable()) {
            this.myOutputVariables.add(symbol);
            needUsages = true;
        }
        if (finder.isWrittenVariable()) {
            this.myWrittenVariables.add(symbol);
            needUsages = true;
        }
        if (finder.isEscapedDeclarator()) {
            this.myEscapedDeclarators.add(symbol);
            needUsages = true;
        }
        if (needUsages) {
            this.myVariableUsages.put(symbol, finder.getVariableUsages());
        }
    }

    public List<PsiReference> getVariableUsages(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "getVariableUsages"));
        }
        return this.myVariableUsages.get(symbol);
    }

    public boolean hasCrossSelectionJumps() {
        return this.myGraphBuilder.hasCrossSelectionJumps();
    }

    public boolean hasDanglingJumps() {
        return this.myGraphBuilder.hasDanglingJumps();
    }

    @Nullable
    private Annotation addWarningAnnotation(@Nullable PsiElement element, @NotNull OCSymbol symbol, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "addWarningAnnotation"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "addWarningAnnotation"));
        }
        OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(element);
        if (macroRange != null && !macroRange.mapsToArguments()) {
            OCMacroCall macroCall = macroRange.getMacroCall();
            if (symbol.getOffset() == 0 || macroCall != null && symbol.getOffset() == macroCall.getTextRange().getEndOffset()) {
                return null;
            }
        }
        return this.addWarningAnnotation(element, inspectionClass, clangID, message, highlightType);
    }

    @Nullable
    private Annotation addWarningAnnotation(@Nullable PsiElement element, @NotNull OCSymbol symbol, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "addWarningAnnotation"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer", "addWarningAnnotation"));
        }
        return this.addWarningAnnotation(element, symbol, inspectionClass, clangID, message, null);
    }
}

