/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCControlFlowGraph {
    private PsiElement myCodeFragment;
    private List<OCNode> myNodes;
    private OCNode myStartNode;
    private Set<OCNode> myExitNodes;
    private OCControlFlowGraph myParentGraph;
    private int myForbidSplitNodesDepth;
    private int myNextNodeId;
    private Map<OCSymbol, MultiMap<OCInstruction.InstructionKind, OCInstruction>> myInstructions;
    private Map<PsiElement, OCInstruction> myReadInstructions;
    private Set<OCInstruction> myAllInstructions;
    private Map<OCSymbol, OCInstruction> myDeclarators;
    private Map<OCSymbol, OCControlFlowGraph> myClosureVariables;

    public OCControlFlowGraph(@NotNull PsiElement codeFragment, @Nullable OCControlFlowGraph parentGraph) {
        if (codeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFragment", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "<init>"));
        }
        this.myNodes = new ArrayList<OCNode>();
        this.myExitNodes = new HashSet<OCNode>();
        this.myInstructions = new HashMap<OCSymbol, MultiMap<OCInstruction.InstructionKind, OCInstruction>>();
        this.myReadInstructions = new HashMap<PsiElement, OCInstruction>();
        this.myAllInstructions = new HashSet<OCInstruction>();
        this.myDeclarators = new HashMap<OCSymbol, OCInstruction>();
        this.myClosureVariables = new HashMap<OCSymbol, OCControlFlowGraph>();
        this.myCodeFragment = codeFragment;
        this.myParentGraph = parentGraph;
    }

    @NotNull
    public List<OCNode> getNodes() {
        List<OCNode> list = this.myNodes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "getNodes"));
        }
        return list;
    }

    public int getNumOfNodes() {
        return this.myNodes.size();
    }

    public int getNextNodeId() {
        return this.myNextNodeId++;
    }

    @NotNull
    public OCNode addNode() {
        OCNode oCNode = this.addNode(false);
        if (oCNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "addNode"));
        }
        return oCNode;
    }

    @NotNull
    public OCNode addNode(boolean isFake) {
        if (this.isSplitNodesAllowed() || isFake) {
            OCNode node = new OCNode(this, this.myNodes.size(), this.myNextNodeId++, isFake);
            this.myNodes.add(node);
            OCNode oCNode = node;
            if (oCNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "addNode"));
            }
            return oCNode;
        }
        OCNode oCNode = this.getLastAddedNode();
        if (oCNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "addNode"));
        }
        return oCNode;
    }

    public void forbidSplittingNodes() {
        ++this.myForbidSplitNodesDepth;
    }

    public void allowSplittingNodes() {
        --this.myForbidSplitNodesDepth;
    }

    public boolean isSplitNodesAllowed() {
        return this.myForbidSplitNodesDepth == 0;
    }

    public void removeNode(@NotNull OCNode node, boolean isFake) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "removeNode"));
        }
        if (this.isSplitNodesAllowed() || isFake) {
            assert (this.getLastAddedNode() == node && (node.isEmpty() || node.isFake()));
            this.myNodes.remove(this.getNumOfNodes() - 1);
        }
    }

    public void setStartNode(@NotNull OCNode startNode) {
        if (startNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startNode", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "setStartNode"));
        }
        this.myStartNode = startNode;
    }

    @NotNull
    public OCNode getStartNode() {
        OCNode oCNode = this.myStartNode;
        if (oCNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "getStartNode"));
        }
        return oCNode;
    }

    public void addExitNode(@NotNull OCNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "addExitNode"));
        }
        this.myExitNodes.add(node);
    }

    @NotNull
    public Set<OCNode> getExitNodes() {
        Set<OCNode> set = this.myExitNodes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "getExitNodes"));
        }
        return set;
    }

    @Nullable
    public OCNode getPreviousNonEmptyNode(@NotNull OCNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "getPreviousNonEmptyNode"));
        }
        for (int index = node.getIndex() - 1; index >= 0; --index) {
            if (this.myNodes.get(index).getRange() == null) continue;
            return this.myNodes.get(index);
        }
        return null;
    }

    @NotNull
    public OCNode getLastAddedNode() {
        OCNode oCNode = this.myNodes.get(this.getNumOfNodes() - 1);
        if (oCNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "getLastAddedNode"));
        }
        return oCNode;
    }

    @Nullable
    public OCInstruction addInstruction(@NotNull OCInstruction.InstructionKind kind, @Nullable PsiElement rValue, @Nullable OCSymbol symbol) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "addInstruction"));
        }
        return this.addInstruction(this.getLastAddedNode(), kind, null, rValue, symbol);
    }

    @Nullable
    public OCInstruction addInstruction(@NotNull OCInstruction.InstructionKind kind, @Nullable PsiElement lValue, @Nullable PsiElement rValue, @Nullable OCSymbol symbol) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "addInstruction"));
        }
        return this.addInstruction(this.getLastAddedNode(), kind, lValue, rValue, symbol);
    }

    @Nullable
    public OCInstruction addInstruction(@NotNull OCNode node, OCInstruction.InstructionKind kind, @Nullable PsiElement lValue, @Nullable PsiElement rValue, @Nullable OCSymbol symbol) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "addInstruction"));
        }
        if (symbol == null) {
            return null;
        }
        OCInstruction instruction = new OCInstruction(kind, node, lValue, rValue, symbol);
        if (kind == OCInstruction.InstructionKind.WRITE) {
            OCInstruction read = this.myReadInstructions.get(OCParenthesesUtils.diveIntoParenthesesAndCasts(rValue));
            if (read != null && read.getKind() == OCInstruction.InstructionKind.READ) {
                read.setAssociatedInstruction(instruction);
                instruction.setAssociatedInstruction(read);
            }
        } else if (kind == OCInstruction.InstructionKind.READ) {
            this.myReadInstructions.put(OCParenthesesUtils.diveIntoParenthesesAndCasts(rValue), instruction);
        }
        if (kind == OCInstruction.InstructionKind.DECLARATOR) {
            this.myDeclarators.put(symbol, instruction);
        } else if (!this.myDeclarators.containsKey(symbol)) {
            OCControlFlowGraph parent = this.myParentGraph;
            while (parent != null && !parent.myDeclarators.containsKey(symbol)) {
                parent = parent.myParentGraph;
            }
            if (parent != null) {
                this.myClosureVariables.put(symbol, parent);
            }
        }
        MultiMap multiMap = this.myInstructions.get(symbol);
        if (multiMap == null) {
            multiMap = new MultiMap();
            this.myInstructions.put(symbol, (MultiMap<OCInstruction.InstructionKind, OCInstruction>)multiMap);
        }
        multiMap.putValue((Object)kind, (Object)instruction);
        this.myAllInstructions.add(instruction);
        node.addInstruction(instruction);
        return instruction;
    }

    public void addInstructions(@NotNull OCNode node, @NotNull OCInstruction.InstructionKind kind, @NotNull Collection<OCInstruction> instructions) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "addInstructions"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "addInstructions"));
        }
        if (instructions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instructions", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "addInstructions"));
        }
        for (OCInstruction instruction : instructions) {
            OCInstruction newInstruction = this.addInstruction(node, kind, instruction.getLValue(), instruction.getRValue(), instruction.getSymbol());
            if (newInstruction == null) continue;
            OCInstruction associatedInstruction = instruction.getAssociatedInstruction();
            newInstruction.setAssociatedInstruction(associatedInstruction != null ? associatedInstruction : instruction);
        }
    }

    public MultiMap<OCInstruction.InstructionKind, OCInstruction> getInstructions(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "getInstructions"));
        }
        return this.myInstructions.get(symbol);
    }

    public Set<OCInstruction> getAllInstructions() {
        return this.myAllInstructions;
    }

    public OCInstruction getDeclaratorInstruction(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "getDeclaratorInstruction"));
        }
        return this.myDeclarators.get(symbol);
    }

    public Set<OCSymbol> getLocalSymbols() {
        return this.myDeclarators.keySet();
    }

    public Set<OCSymbol> getClosureSymbols() {
        return this.myClosureVariables.keySet();
    }

    public OCControlFlowGraph getClosureVariableDeclaratorGraph(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "getClosureVariableDeclaratorGraph"));
        }
        return this.myClosureVariables.get(symbol);
    }

    @NotNull
    public PsiElement getCodeFragment() {
        PsiElement psiElement = this.myCodeFragment;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "getCodeFragment"));
        }
        return psiElement;
    }

    @Nullable
    public OCControlFlowGraph getParentGraph() {
        return this.myParentGraph;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append("<CFG>\n");
        String fileText = this.myCodeFragment.getContainingFile().getText();
        for (OCNode node : this.myNodes) {
            String nodeName = "node";
            if (node == this.myStartNode) {
                nodeName = "start-node";
            } else if (this.myExitNodes.contains(node)) {
                nodeName = "exit-node";
            }
            result2.append("  <").append(nodeName).append(" id=\"").append(node.getIndex()).append("\">\n");
            OCElementsRange range = node.getRange();
            if (range != null) {
                TextRange textRange = range.getTextRange();
                result2.append(fileText.substring(textRange.getStartOffset(), textRange.getEndOffset()).trim()).append("\n");
            }
            if (node.getJumpTargets() != null) {
                for (OCNode target : node.getJumpTargets()) {
                    result2.append("    <target node-id=\"").append(target.getIndex()).append("\"/>\n");
                }
            }
            result2.append("  </").append(nodeName).append(">\n");
        }
        result2.append("</CFG>\n");
        return result2.toString();
    }

    public boolean hasInstructionsInParentGraph(@NotNull OCSymbol symbol, OCInstruction.InstructionKind ... kinds) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph", "hasInstructionsInParentGraph"));
        }
        OCControlFlowGraph parentCfg = this.getClosureVariableDeclaratorGraph(symbol);
        if (parentCfg == null) {
            return false;
        }
        MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = parentCfg.getInstructions(symbol);
        if (instructions == null) {
            return false;
        }
        for (OCInstruction.InstructionKind kind : kinds) {
            for (OCInstruction instruction : instructions.get((Object)kind)) {
                OCInstruction associatedInstruction = instruction.getAssociatedInstruction();
                if (associatedInstruction != null && associatedInstruction.getNode().getGraph() == this) continue;
                return true;
            }
        }
        return false;
    }
}

