/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAnalyzer;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.dfa.OCUnreachableCodeFinder;
import com.jetbrains.cidr.lang.intentions.OCCreateMissingSwitchCasesIntentionAction;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCBreakStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCContinueStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFinallySection;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCGotoStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCThrowExpression;
import com.jetbrains.cidr.lang.psi.OCTryStatement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import com.jetbrains.cidr.lang.psi.impl.OCAsmStatementImpl;
import com.jetbrains.cidr.lang.psi.impl.OCAsmStatementPartImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCControlFlowBuilder
extends OCVisitor {
    private OCDataFlowAnalyzer myAnalyzer;
    protected OCControlFlowGraph myGraph;
    private TextRange mySelection;
    private boolean myHasCrossSelectionJumps;
    private boolean myHasTopLevelCaseStatements;
    private List<OCNode> myBreakNodes;
    private List<OCNode> myContinueNodes;
    private Stack<List<OCNode>> myTryThrows;
    private Stack<SwitchInfo> mySwitchStack;
    private Stack<List<PsiElement>> myValuesStack;
    private Map<String, OCNode> myLabeledNodes;
    private MostlySingularMultiMap<String, OCNode> myGotoNodes;
    private int myShortCircuitDepth;
    private static final TokenSet closingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.SEMICOLON, OCTokenTypes.RBRACE}), OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET, OCTokenTypes.DIRECTIVES});

    public OCControlFlowBuilder(@Nullable OCDataFlowAnalyzer analyzer, @NotNull OCControlFlowGraph graph, @Nullable TextRange selection) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "<init>"));
        }
        this.myAnalyzer = analyzer;
        this.mySelection = selection;
        this.init(graph);
    }

    protected OCControlFlowBuilder() {
    }

    protected void init(@NotNull OCControlFlowGraph graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "init"));
        }
        this.myGraph = graph;
        this.myGotoNodes = new MostlySingularMultiMap();
        this.myLabeledNodes = new HashMap<String, OCNode>();
        this.mySwitchStack = new Stack();
        this.myValuesStack = new Stack();
        this.myTryThrows = new Stack();
        this.myContinueNodes = new ArrayList<OCNode>();
        this.myBreakNodes = new ArrayList<OCNode>();
    }

    public void visitElement(@Nullable PsiElement element) {
        if (element != null) {
            this.getKidIterator(element).acceptAll();
        }
    }

    private KidIterator getKidIterator(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "getKidIterator"));
        }
        ASTNode node = element.getNode();
        final ASTNode firstChild = node != null ? node.getFirstChildNode() : null;
        return new KidIterator(){
            private ASTNode child;
            private boolean initialized;

            @Override
            public void skipLeaves() {
                if (!this.initialized) {
                    this.initialized = true;
                    this.child = firstChild;
                }
                while (!(this.child == null || this.child.getFirstChildNode() != null && this.child.getElementType() != OCElementTypes.OBJC_KEYWORD && OCElementUtil.isElementSignificant(this.child.getPsi()))) {
                    PsiElement psiElement = this.child.getPsi();
                    if (psiElement != null && OCControlFlowBuilder.this.doEnlargeNodes()) {
                        OCNode node = OCControlFlowBuilder.this.myGraph.getLastAddedNode();
                        if (node.isEmpty() && closingTokens.contains(this.child.getElementType())) {
                            OCNode previousNode = OCControlFlowBuilder.this.myGraph.getPreviousNonEmptyNode(node);
                            while (previousNode != null && node.getEndOffset() < previousNode.getEndOffset() && previousNode.getEndOffset() <= psiElement.getTextOffset()) {
                                node = previousNode;
                                previousNode = OCControlFlowBuilder.this.myGraph.getPreviousNonEmptyNode(node);
                            }
                        }
                        node.enlarge(psiElement, psiElement.getParent());
                    }
                    this.child = this.child.getTreeNext();
                }
            }

            @Override
            public void accept(@Nullable PsiElement kid) {
                if (kid == null) {
                    return;
                }
                this.skipLeaves();
                if (this.child != null && kid == this.child.getPsi()) {
                    kid.accept((PsiElementVisitor)OCControlFlowBuilder.this);
                    this.child = this.child.getTreeNext();
                }
            }

            @Override
            public void skip(@Nullable PsiElement kid) {
                if (kid == null) {
                    return;
                }
                this.skipLeaves();
                if (this.child != null && kid == this.child.getPsi()) {
                    this.child = this.child.getTreeNext();
                }
            }

            @Override
            public void acceptAll() {
                this.skipLeaves();
                while (this.child != null) {
                    ProgressManager.checkCanceled();
                    PsiElement element = this.child.getPsi();
                    if (element != null) {
                        element.accept((PsiElementVisitor)OCControlFlowBuilder.this);
                    }
                    this.child = this.child.getTreeNext();
                    this.skipLeaves();
                }
            }

            @Override
            public void finish() {
                this.skipLeaves();
            }
        };
    }

    protected boolean doEnlargeNodes() {
        return true;
    }

    public void processFirstCodeFragment(@NotNull PsiElement codeFragment) {
        if (codeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFragment", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "processFirstCodeFragment"));
        }
        this.myTryThrows.push(new ArrayList());
        this.myValuesStack.push(new ArrayList());
        this.addStartNode(this.myGraph.addNode());
        this.processNextCodeFragment(codeFragment);
    }

    public void processNextCodeFragment(@NotNull PsiElement codeFragment) {
        if (codeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFragment", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "processNextCodeFragment"));
        }
        if (codeFragment instanceof OCCallable) {
            this.visitElement(codeFragment);
        } else {
            codeFragment.accept((PsiElementVisitor)this);
        }
    }

    protected void addStartNode(@NotNull OCNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "addStartNode"));
        }
        this.myGraph.setStartNode(node);
    }

    @Nullable
    protected NodeState addBranch(@NotNull OCNode fromNode, @NotNull OCNode toNode, @Nullable List<PsiElement> modifiedValues, @Nullable NodeState oldFromState) {
        if (fromNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromNode", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "addBranch"));
        }
        if (toNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toNode", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "addBranch"));
        }
        if (this.myGraph.isSplitNodesAllowed()) {
            fromNode.addBranch(toNode);
        }
        return null;
    }

    @Nullable
    protected NodeState addBranch(@NotNull OCNode fromNode, @NotNull OCNode toNode, @Nullable List<PsiElement> modifiedValues) {
        if (fromNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromNode", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "addBranch"));
        }
        if (toNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toNode", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "addBranch"));
        }
        return this.addBranch(fromNode, toNode, modifiedValues, null);
    }

    @Nullable
    protected NodeState addUnstructuralBranch(@NotNull OCNode fromNode, @NotNull OCNode toNode) {
        if (fromNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromNode", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "addUnstructuralBranch"));
        }
        if (toNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toNode", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "addUnstructuralBranch"));
        }
        return this.addBranch(fromNode, toNode, null);
    }

    @Nullable
    protected NodeState addBranch(@NotNull OCNode fromNode, @NotNull OCNode toNode) {
        if (fromNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromNode", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "addBranch"));
        }
        if (toNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toNode", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "addBranch"));
        }
        return this.addBranch(fromNode, toNode, null);
    }

    protected OCNode acceptCondition(@Nullable OCElement condition, @NotNull KidIterator itr, boolean isLoop) {
        if (itr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itr", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "acceptCondition"));
        }
        itr.accept(condition);
        itr.skipLeaves();
        return this.myGraph.getLastAddedNode();
    }

    @Nullable
    protected NodeState addConditionalBranch(@NotNull OCElement condition, boolean branch, @NotNull OCNode fromNode, @NotNull OCNode toNode, @Nullable List<PsiElement> modifiedValues, @Nullable NodeState oldFromState) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "addConditionalBranch"));
        }
        if (fromNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromNode", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "addConditionalBranch"));
        }
        if (toNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toNode", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "addConditionalBranch"));
        }
        if (this.myGraph.isSplitNodesAllowed()) {
            fromNode.addBranch(toNode);
        }
        return null;
    }

    @Nullable
    protected NodeState addConditionalBranch(@NotNull OCElement condition, boolean branch, @NotNull OCNode fromNode, @NotNull OCNode toNode) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "addConditionalBranch"));
        }
        if (fromNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromNode", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "addConditionalBranch"));
        }
        if (toNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toNode", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "addConditionalBranch"));
        }
        return this.addConditionalBranch(condition, branch, fromNode, toNode, null, null);
    }

    @Override
    public void visitIfStatement(OCIfStatement stmt) {
        this.visitIfLike(stmt, stmt.getCondition(), stmt.getThenBranch(), stmt.getElseBranch());
    }

    @Override
    public void visitConditionalExpression(OCConditionalExpression expression) {
        this.visitIfLike(expression, expression.getCondition(), expression.getPositiveExpression(true), expression.getNegativeExpression());
    }

    private void visitIfLike(@NotNull PsiElement element, @Nullable OCElement condition, @Nullable PsiElement thenBranch, @Nullable PsiElement elseBranch) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "visitIfLike"));
        }
        this.myValuesStack.push(new ArrayList());
        KidIterator itr = this.getKidIterator(element);
        OCNode conditionNode = this.acceptCondition(condition, itr, false);
        Number conditionValue = OCControlFlowBuilder.getValueOfCondition(condition);
        boolean needThenBranch = conditionValue == null || OCExpressionEvaluator.singAsInC(conditionValue) != 0;
        boolean needElseBranch = conditionValue == null || OCExpressionEvaluator.singAsInC(conditionValue) == 0;
        OCNode thenStartNode = this.myGraph.addNode();
        if (needThenBranch && condition != null) {
            this.addConditionalBranch(condition, true, conditionNode, thenStartNode);
        }
        itr.accept(thenBranch);
        OCNode thenFinishNode = this.myGraph.getLastAddedNode();
        OCNode elseStartNode = this.myGraph.addNode();
        if (needElseBranch && condition != null) {
            this.addConditionalBranch(condition, false, conditionNode, elseStartNode);
        }
        itr.accept(elseBranch);
        OCNode elseFinishNode = this.myGraph.getLastAddedNode();
        List<PsiElement> writes = this.myValuesStack.pop();
        if (conditionNode != this.myGraph.getLastAddedNode()) {
            OCNode exitNode = this.myGraph.addNode();
            this.addBranch(thenFinishNode, exitNode, writes);
            this.addBranch(elseFinishNode, exitNode, writes);
        }
        itr.finish();
    }

    @Nullable
    private static Number getValueOfCondition(@Nullable OCElement condition) {
        OCExpression conditionalExpression = null;
        if (condition instanceof OCExpression) {
            conditionalExpression = (OCExpression)condition;
        } else if (condition instanceof OCDeclarationOrExpression) {
            OCDeclarationOrExpression declarationOrExpression = (OCDeclarationOrExpression)condition;
            OCExpression expression = declarationOrExpression.getExpression();
            if (expression != null) {
                conditionalExpression = expression;
            } else {
                OCDeclaration declaration = declarationOrExpression.getDeclaration();
                if (declaration != null && declaration.getDeclarators().size() != 0) {
                    List<OCDeclarator> declarators = declaration.getDeclarators();
                    conditionalExpression = declarators.get(0).getInitializer();
                }
            }
        }
        return OCExpressionEvaluator.evaluate(conditionalExpression);
    }

    @NotNull
    private int[] saveLoopState() {
        int[] nArray = new int[]{this.myBreakNodes.size(), this.myContinueNodes.size()};
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "saveLoopState"));
        }
        return nArray;
    }

    private boolean isSelected(@NotNull OCNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "isSelected"));
        }
        OCElementsRange range = node.getRange();
        return this.mySelection != null && range != null && this.mySelection.contains(range.getTextRange());
    }

    public boolean hasCrossSelectionJumps() {
        return this.myHasCrossSelectionJumps;
    }

    public boolean hasDanglingJumps() {
        return !this.myBreakNodes.isEmpty() || !this.myContinueNodes.isEmpty() || this.myHasTopLevelCaseStatements;
    }

    private void patchLoopJumps(@NotNull int[] savedState, @Nullable OCNode continueToNode, @Nullable OCNode breakToNode, @Nullable List<PsiElement> writes) {
        int i;
        if (savedState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "savedState", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "patchLoopJumps"));
        }
        if (breakToNode != null) {
            for (i = this.myBreakNodes.size() - 1; i >= savedState[0]; --i) {
                this.addBranch(this.myBreakNodes.get(i), breakToNode, writes);
                this.myBreakNodes.remove(i);
            }
        }
        if (continueToNode != null) {
            for (i = this.myContinueNodes.size() - 1; i >= savedState[1]; --i) {
                this.addBranch(this.myContinueNodes.get(i), continueToNode, null);
                this.myContinueNodes.remove(i);
            }
        }
    }

    @Override
    public void visitWhileStatement(OCWhileStatement stmt) {
        this.visitForWhile(stmt, null, stmt.getCondition(), null, stmt.getBody());
    }

    @Override
    public void visitForStatement(OCForStatement stmt) {
        this.visitForWhile(stmt, stmt.getInitializer(), stmt.getCondition(), stmt.getIncrement(), stmt.getBody());
    }

    @Override
    public void visitForeachStatement(OCForeachStatement statement) {
        OCElement condition = statement.getVariableDeclaration();
        if (condition == null) {
            condition = statement.getVariableExpression();
        }
        this.visitForWhile(statement, condition, statement.getCollectionExpression(), null, statement.getBody());
    }

    private void visitForWhile(@NotNull OCElement element, @Nullable OCElement initializer, @Nullable OCElement condition, @Nullable OCStatement increment, @Nullable OCStatement body) {
        OCNode conditionStartNode;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "visitForWhile"));
        }
        KidIterator itr = this.getKidIterator(element);
        itr.accept(initializer);
        OCNode enterNode = this.myGraph.getLastAddedNode();
        OCNode continueNode = conditionStartNode = this.myGraph.addNode();
        NodeState condState1 = this.addBranch(enterNode, conditionStartNode);
        this.myValuesStack.push(new ArrayList());
        OCNode conditionEndNode = this.acceptCondition(condition, itr, true);
        boolean foreach = element instanceof OCForeachStatement;
        Number conditionValue = foreach ? (Number)null : (Number)OCControlFlowBuilder.getValueOfCondition(condition);
        boolean conditionNotFalse = conditionValue == null || OCExpressionEvaluator.singAsInC(conditionValue) != 0;
        boolean conditionNotTrue = conditionValue == null || OCExpressionEvaluator.singAsInC(conditionValue) == 0;
        OCNode bodyStartNode = this.myGraph.addNode();
        if (conditionNotFalse) {
            if (foreach || condition == null) {
                this.addBranch(conditionStartNode, bodyStartNode);
            } else {
                this.addConditionalBranch(condition, true, conditionEndNode, bodyStartNode);
            }
        }
        int[] state = this.saveLoopState();
        itr.skip(increment);
        itr.accept(body);
        OCNode bodyEndNode = this.myGraph.getLastAddedNode();
        if (increment != null) {
            OCNode incrementNode = this.myGraph.addNode();
            this.addBranch(bodyEndNode, incrementNode);
            increment.accept(this);
            bodyEndNode = this.myGraph.getLastAddedNode();
            continueNode = incrementNode;
        }
        List<PsiElement> writes = this.myValuesStack.pop();
        OCNode exitNode = this.myGraph.addNode();
        this.patchLoopJumps(state, continueNode, exitNode, writes);
        NodeState condState2 = this.addBranch(bodyEndNode, conditionStartNode, writes);
        if (conditionNotFalse) {
            if (!Comparing.equal((Object)condState1, (Object)condState2) && condition != null) {
                this.addConditionalBranch(condition, true, conditionEndNode, bodyStartNode, null, condState1);
            } else {
                this.addBranch(conditionEndNode, bodyStartNode, null, condState1);
            }
        }
        if (conditionNotTrue) {
            if (foreach) {
                this.addBranch(conditionStartNode, exitNode);
            } else if (condition != null) {
                this.addConditionalBranch(condition, false, conditionEndNode, exitNode);
            }
        }
        itr.finish();
    }

    @Override
    public void visitDoWhileStatement(OCDoWhileStatement stmt) {
        boolean conditionNotTrue;
        KidIterator itr = this.getKidIterator(stmt);
        OCNode lastNode = this.myGraph.getLastAddedNode();
        OCNode loopStartNode = this.myGraph.addNode();
        this.addBranch(lastNode, loopStartNode);
        int[] state = this.saveLoopState();
        this.myValuesStack.push(new ArrayList());
        itr.accept(stmt.getBody());
        OCExpression condition = stmt.getCondition();
        OCNode conditionNode = this.acceptCondition(condition, itr, false);
        Number conditionValue = OCExpressionEvaluator.evaluate(condition);
        boolean conditionNotFalse = conditionValue == null || OCExpressionEvaluator.singAsInC(conditionValue) != 0;
        boolean bl = conditionNotTrue = conditionValue == null || OCExpressionEvaluator.singAsInC(conditionValue) == 0;
        if (loopStartNode.isEmpty()) {
            this.myGraph.removeNode(loopStartNode, false);
            return;
        }
        List<PsiElement> writes = this.myValuesStack.pop();
        OCNode loopEndNode = this.myGraph.getLastAddedNode();
        OCNode exitNode = this.myGraph.addNode();
        if (condition != null) {
            if (conditionNotFalse) {
                this.addConditionalBranch(condition, true, loopEndNode, loopStartNode, Collections.<PsiElement>emptyList(), null);
            }
            if (conditionNotTrue) {
                this.addConditionalBranch(condition, false, loopEndNode, exitNode);
            }
        }
        this.patchLoopJumps(state, conditionNode, exitNode, writes);
        itr.finish();
    }

    @Override
    public void visitBreakStatement(OCBreakStatement stmt) {
        this.visitElement(stmt);
        OCNode breakNode = this.myGraph.getLastAddedNode();
        this.myBreakNodes.add(breakNode);
        this.myGraph.addNode();
    }

    @Override
    public void visitContinueStatement(OCContinueStatement stmt) {
        this.visitElement(stmt);
        OCNode continueNode = this.myGraph.getLastAddedNode();
        this.myContinueNodes.add(continueNode);
        this.myGraph.addNode();
    }

    @Override
    public void visitLabeledStatement(OCLabeledStatement stmt) {
        OCNode labeledNode;
        OCNode lastNode = this.myGraph.getLastAddedNode();
        if (!lastNode.isEmpty()) {
            labeledNode = this.myGraph.addNode();
            this.addBranch(lastNode, labeledNode);
        } else {
            labeledNode = lastNode;
        }
        this.visitElement(stmt);
        this.myLabeledNodes.put(stmt.getLabel(), labeledNode);
        for (OCNode gotoNode : this.myGotoNodes.get((Object)stmt.getLabel())) {
            this.addUnstructuralBranch(gotoNode, labeledNode);
            if (!(this.isSelected(gotoNode) ^ this.isSelected(labeledNode))) continue;
            this.myHasCrossSelectionJumps = true;
        }
        OCSymbol symbol = stmt.getLocalSymbol();
        if (symbol != null) {
            this.myGraph.addInstruction(OCInstruction.InstructionKind.DECLARATOR, stmt.getLabelElement(), symbol);
        }
    }

    @Override
    public void visitGotoStatement(OCGotoStatement stmt) {
        this.visitElement(stmt);
        OCNode gotoNode = this.myGraph.getLastAddedNode();
        this.myGraph.addNode();
        OCReferenceElement label = stmt.getLabel();
        if (label == null) {
            return;
        }
        this.myGotoNodes.add((Object)label.getCanonicalText(), (Object)gotoNode);
        OCNode labeledNode = this.myLabeledNodes.get(label.getCanonicalText());
        this.myGraph.addInstruction(OCInstruction.InstructionKind.READ, stmt.getNavigationElement(), label.resolveToSymbol());
        if (labeledNode != null) {
            this.addUnstructuralBranch(gotoNode, labeledNode);
            if (this.isSelected(gotoNode) ^ this.isSelected(labeledNode)) {
                this.myHasCrossSelectionJumps = true;
            }
        }
    }

    protected void addCaseStatement(@NotNull OCCaseStatement stmt, @NotNull OCNode caseNode, @NotNull SwitchInfo info) {
        if (stmt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stmt", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "addCaseStatement"));
        }
        if (caseNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caseNode", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "addCaseStatement"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "addCaseStatement"));
        }
        this.addBranch(info.getNode(), caseNode);
        info.addCaseExpression(stmt.getExpression());
    }

    @Override
    public void visitCaseStatement(OCCaseStatement stmt) {
        SwitchInfo info;
        OCNode caseNode;
        OCNode lastNode = this.myGraph.getLastAddedNode();
        if (!lastNode.isEmpty()) {
            caseNode = this.myGraph.addNode();
            this.addBranch(lastNode, caseNode);
        } else {
            caseNode = lastNode;
        }
        SwitchInfo switchInfo = info = this.mySwitchStack.isEmpty() ? null : this.mySwitchStack.peek();
        if (info != null) {
            this.addCaseStatement(stmt, caseNode, info);
            if (stmt.isDefault()) {
                info.setHasDefault(true);
            }
        } else {
            this.myHasTopLevelCaseStatements = true;
        }
        this.visitElement(stmt);
    }

    @Override
    public void visitSwitchStatement(OCSwitchStatement stmt) {
        OCType type;
        KidIterator itr = this.getKidIterator(stmt);
        OCDeclarationOrExpression expression = stmt.getExpression();
        itr.accept(expression);
        itr.skipLeaves();
        this.myValuesStack.push(new ArrayList());
        OCNode switchNode = this.myGraph.getLastAddedNode();
        this.mySwitchStack.push(new SwitchInfo(expression, switchNode));
        int[] state = this.saveLoopState();
        this.myGraph.addNode();
        OCBlockStatement body = stmt.getBody();
        itr.accept(body);
        OCNode lastNode = this.myGraph.getLastAddedNode();
        OCNode exitNode = this.myGraph.addNode();
        List<PsiElement> writes = this.myValuesStack.pop();
        this.addBranch(lastNode, exitNode, writes);
        boolean allCasesCovered = this.mySwitchStack.pop().hasDefault();
        OCType oCType = type = expression != null ? expression.getResolvedType().getTerminalType() : null;
        if (type instanceof OCStructType && ((OCStructType)type).isEnumClass()) {
            ArrayList<Pair<Integer, Integer>> ranges = new ArrayList<Pair<Integer, Integer>>();
            ArrayList<OCCaseStatement> caseStmts = new ArrayList<OCCaseStatement>();
            if (body != null) {
                OCCreateMissingSwitchCasesIntentionAction.findCaseStatements(body, ranges, caseStmts);
                allCasesCovered |= OCCreateMissingSwitchCasesIntentionAction.getMissingCases(stmt, ranges, (Ref<Boolean>)new Ref()).isEmpty();
            }
        }
        if (!allCasesCovered) {
            this.addBranch(switchNode, exitNode, writes);
        }
        this.patchLoopJumps(state, null, exitNode, writes);
        itr.finish();
    }

    @Override
    public void visitReturnStatement(OCReturnStatement stmt) {
        this.visitElement(stmt);
        OCNode returnNode = this.myGraph.getLastAddedNode();
        this.myGraph.addExitNode(returnNode);
        this.myGraph.addNode();
        returnNode.setNodeAfterReturn(this.myGraph.getLastAddedNode());
    }

    @Override
    public void visitThrowExpression(OCThrowExpression expression) {
        this.visitElement(expression);
        this.processThrow();
    }

    private void processThrow() {
        OCNode throwNode = this.myGraph.getLastAddedNode();
        this.myGraph.addExitNode(throwNode);
        this.myGraph.addNode();
        this.myTryThrows.peek().add(throwNode);
    }

    @Override
    public void visitTryStatement(OCTryStatement stmt) {
        KidIterator itr = this.getKidIterator(stmt);
        OCNode lastNode = this.myGraph.getLastAddedNode();
        OCNode bodyStartNode = this.myGraph.addNode();
        this.addBranch(lastNode, bodyStartNode);
        this.myTryThrows.push(new ArrayList());
        itr.accept(stmt.getBody());
        bodyStartNode.enlarge(stmt, stmt);
        OCNode bodyEndNode = this.myGraph.getLastAddedNode();
        OCNode exitNode = this.myGraph.addNode();
        this.addBranch(bodyEndNode, exitNode);
        List<OCNode> throwNodes = this.myTryThrows.pop();
        ArrayList<OCElement> sections = new ArrayList<OCElement>();
        sections.addAll(stmt.getCatchSections());
        OCFinallySection finallySection = stmt.getFinallySection();
        boolean hasNonExitCatch = false;
        if (finallySection != null) {
            sections.add(finallySection);
        }
        for (PsiElement psiElement : sections) {
            OCDataFlowAnalyzer analyzer = new OCDataFlowAnalyzer(psiElement, this.myAnalyzer, this.myAnalyzer);
            analyzer.buildControlFlowGraph();
            OCUnreachableCodeFinder finder = analyzer.getUnreachableCodeFinder();
            this.myGraph.addInstructions(lastNode, OCInstruction.InstructionKind.READ_IN_BLOCK, finder.getReachableInstructions(OCInstruction.InstructionKind.READ));
            this.myGraph.addInstructions(lastNode, OCInstruction.InstructionKind.READ_IN_BLOCK, finder.getReachableInstructions(OCInstruction.InstructionKind.READ_IN_BLOCK));
            this.myGraph.addInstructions(lastNode, OCInstruction.InstructionKind.READ_IN_BLOCK, finder.getReachableInstructions(OCInstruction.InstructionKind.REFERENCE));
            this.myGraph.addInstructions(exitNode, OCInstruction.InstructionKind.WRITE_IN_BLOCK, finder.getReachableInstructions(OCInstruction.InstructionKind.WRITE));
            this.myGraph.addInstructions(exitNode, OCInstruction.InstructionKind.WRITE_IN_BLOCK, finder.getReachableInstructions(OCInstruction.InstructionKind.WRITE_IN_BLOCK));
            this.myGraph.addInstructions(exitNode, OCInstruction.InstructionKind.WRITE_IN_BLOCK, finder.getReachableInstructions(OCInstruction.InstructionKind.REFERENCE));
            if (psiElement == finallySection) {
                if (finder.isDeadEndReached()) continue;
                this.myGraph.addExitNode(exitNode);
                this.myGraph.addNode();
                continue;
            }
            if (!finder.isDeadEndReached()) continue;
            hasNonExitCatch = true;
        }
        if (hasNonExitCatch) {
            lastNode.addBranch(exitNode, true);
            for (OCNode oCNode : throwNodes) {
                this.addBranch(oCNode, exitNode);
            }
        }
        itr.finish();
    }

    @Override
    public void visitBlockExpression(OCBlockExpression blockExpression) {
        this.visitBlockOrLambdaExpression(blockExpression);
    }

    @Override
    public void visitLambdaExpression(OCLambdaExpression lambdaExpression) {
        this.visitBlockOrLambdaExpression(lambdaExpression);
    }

    private void visitBlockOrLambdaExpression(@NotNull OCCallable callable) {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "visitBlockOrLambdaExpression"));
        }
        this.myGraph.getLastAddedNode().enlarge(callable, callable);
        OCDataFlowAnalyzer analyzer = new OCDataFlowAnalyzer(callable, this.myAnalyzer, this.myAnalyzer);
        analyzer.buildControlFlowGraph();
        OCUnreachableCodeFinder finder = analyzer.getUnreachableCodeFinder();
        OCNode lastNode = this.myGraph.getLastAddedNode();
        this.myGraph.addInstructions(lastNode, OCInstruction.InstructionKind.READ_IN_BLOCK, finder.getReachableInstructions(OCInstruction.InstructionKind.READ));
        this.myGraph.addInstructions(lastNode, OCInstruction.InstructionKind.READ_IN_BLOCK, finder.getReachableInstructions(OCInstruction.InstructionKind.READ_IN_BLOCK));
        this.myGraph.addInstructions(lastNode, OCInstruction.InstructionKind.WRITE_IN_BLOCK, finder.getReachableInstructions(OCInstruction.InstructionKind.WRITE));
        this.myGraph.addInstructions(lastNode, OCInstruction.InstructionKind.WRITE_IN_BLOCK, finder.getReachableInstructions(OCInstruction.InstructionKind.WRITE_IN_BLOCK));
        this.myGraph.addInstructions(lastNode, OCInstruction.InstructionKind.REFERENCE, finder.getReachableInstructions(OCInstruction.InstructionKind.REFERENCE));
        for (OCInstruction instruction : finder.getReachableInstructions(OCInstruction.InstructionKind.WRITE)) {
            this.processReferenceFromBlock(instruction.getSymbol());
        }
        for (OCInstruction instruction : finder.getReachableInstructions(OCInstruction.InstructionKind.WRITE_IN_BLOCK)) {
            this.processReferenceFromBlock(instruction.getSymbol());
        }
        for (OCInstruction instruction : finder.getReachableInstructions(OCInstruction.InstructionKind.REFERENCE)) {
            this.processReferenceFromBlock(instruction.getSymbol());
        }
        finder.clearInstructions();
    }

    @Override
    public void visitDeclarator(OCDeclarator declarator) {
        OCSymbol symbol = declarator.getLocalSymbol();
        if (symbol != null && symbol.getKind().isLocal()) {
            this.myGraph.addInstruction(OCInstruction.InstructionKind.DECLARATOR, declarator, symbol);
        }
        this.visitElement(declarator);
        OCType type = declarator.getResolvedType();
        if (symbol != null && symbol.getKind().isLocal()) {
            if (declarator.getInitializer() != null && symbol.getKind() != OCSymbolKind.PARAMETER) {
                this.processAssignment(symbol, declarator.getNameIdentifier(), declarator.getInitializer(), false);
            } else if (!declarator.getInitializers().isEmpty() && symbol.getKind() != OCSymbolKind.PARAMETER || !declarator.getArrayLengths().isEmpty()) {
                this.processAssignment(symbol, declarator.getNameIdentifier(), null, true);
            } else {
                PsiElement parent = declarator.getParent().getParent();
                if (parent instanceof OCForeachStatement || parent instanceof OCDeclarationStatement && parent.getParent() instanceof OCForeachStatement) {
                    this.processAssignment(symbol, declarator.getNameIdentifier(), null, true);
                } else {
                    this.processNonInitializedDeclarator(symbol, declarator.getNameIdentifier());
                }
            }
        }
    }

    @Override
    public void visitMethodSelectorPart(OCMethodSelectorPart part) {
        this.visitElement(part);
        OCSymbol symbol = part.getLocalSymbol();
        if (symbol != null && symbol.getKind().isLocal()) {
            this.myGraph.addInstruction(OCInstruction.InstructionKind.DECLARATOR, part.getParameter(), symbol);
        }
        if (symbol != null) {
            this.processNonInitializedDeclarator(symbol, part.getNameIdentifier());
        }
    }

    @Override
    public void visitAsmStatement(OCAsmStatementImpl statement) {
        this.visitElement(statement);
    }

    @Override
    public void visitAsmStatementPart(OCAsmStatementPartImpl part) {
        OCExpression expression = part.getExpression();
        if (part.isOutputParametersPart()) {
            if (expression != null) {
                this.processAssignment(expression, null, part, false);
            }
        } else {
            this.visitElement(part);
        }
    }

    @Override
    public void visitAssignmentExpression(OCAssignmentExpression expression) {
        this.visitElement(expression);
        OCExpression receiver = expression.getReceiverExpression();
        OCExpression source = expression.getSourceExpression();
        this.processAssignment(receiver, source, (OCElement)expression, expression.getOperationSign() != OCTokenTypes.EQ);
    }

    private void processAssignment(@Nullable OCExpression receiver, @Nullable OCExpression source, @NotNull OCElement context, boolean complexAssignment) {
        OCSymbol symbol;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "processAssignment"));
        }
        ProgressManager.checkCanceled();
        boolean wasQualifier = false;
        boolean wasIndex = false;
        while (true) {
            if (receiver instanceof OCQualifiedExpression) {
                receiver = ((OCQualifiedExpression)receiver).getQualifier();
                wasQualifier = true;
                continue;
            }
            if (receiver instanceof OCArraySelectionExpression) {
                receiver = ((OCArraySelectionExpression)receiver).getArrayExpression();
                wasIndex = true;
                continue;
            }
            if (receiver instanceof OCParenthesizedExpression) {
                receiver = ((OCParenthesizedExpression)receiver).getOperand();
                continue;
            }
            if (!(receiver instanceof OCCastExpression)) break;
            receiver = ((OCCastExpression)receiver).getOperand();
        }
        if (receiver instanceof OCReferenceExpression && this.isSymbolInScope(symbol = ((OCReferenceExpression)receiver).resolveToSymbol())) {
            if (!wasQualifier && !wasIndex) {
                this.processAssignment(symbol, receiver, source, complexAssignment, this.myShortCircuitDepth != 0);
            } else if (symbol.getType().resolve(context.getContainingFile()) instanceof OCStructType) {
                this.myGraph.addInstruction(OCInstruction.InstructionKind.WRITE, receiver, source, symbol);
            }
        }
    }

    protected void processNonInitializedDeclarator(@NotNull OCSymbol symbol, @Nullable PsiElement lValue) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "processNonInitializedDeclarator"));
        }
    }

    protected void processDereference(@NotNull OCReferenceExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "processDereference"));
        }
    }

    protected void processReference(@NotNull PsiElement element, @NotNull OCSymbol symbol) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "processReference"));
        }
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "processReference"));
        }
        this.myGraph.addInstruction(OCInstruction.InstructionKind.REFERENCE, element, symbol);
    }

    protected void processReferenceFromBlock(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "processReferenceFromBlock"));
        }
    }

    protected void processAssignment(@NotNull OCSymbol symbol, @Nullable PsiElement lValue, @Nullable OCExpression rValue, boolean complexAssignment) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "processAssignment"));
        }
        this.processAssignment(symbol, lValue, rValue, complexAssignment, false);
    }

    protected void processAssignment(@NotNull OCSymbol symbol, @Nullable PsiElement lValue, @Nullable OCExpression rValue, boolean complexAssignment, boolean shortCircuitEvaluation) {
        OCInstruction write;
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder", "processAssignment"));
        }
        if (!shortCircuitEvaluation) {
            this.myGraph.addInstruction(OCInstruction.InstructionKind.KILL, lValue, null, symbol);
        }
        if ((write = this.myGraph.addInstruction(OCInstruction.InstructionKind.WRITE, lValue, rValue, symbol)) != null) {
            this.addModifiedValue(write.getRValue());
        }
    }

    protected void addModifiedValue(@Nullable PsiElement value) {
        if (value != null) {
            for (List list : this.myValuesStack) {
                list.add(value);
            }
        }
    }

    @Override
    public void visitBinaryExpression(OCBinaryExpression expression) {
        OCElementType sign = expression.getOperationSign();
        if (sign == OCTokenTypes.ANDAND || sign == OCTokenTypes.OROR) {
            KidIterator itr = this.getKidIterator(expression);
            itr.accept(expression.getLeft());
            Number leftValue = OCControlFlowBuilder.getValueOfCondition(expression.getLeft());
            if (leftValue == null) {
                ++this.myShortCircuitDepth;
                itr.accept(expression.getRight());
                --this.myShortCircuitDepth;
            } else if (OCExpressionEvaluator.singAsInC(leftValue) == 0 == (sign == OCTokenTypes.OROR)) {
                itr.accept(expression.getRight());
            }
            itr.finish();
        } else {
            this.visitElement(expression);
        }
    }

    @Override
    public void visitCallExpression(OCCallExpression expression) {
        this.visitElement(expression);
        OCExpression caller = expression.getFunctionReferenceExpression();
        if (!(caller instanceof OCReferenceExpression)) {
            return;
        }
        OCSymbol symbol = ((OCReferenceExpression)caller).resolveToSymbol();
        if (symbol != null && symbol.hasAttribute("noreturn")) {
            OCNode returnNode = this.myGraph.getLastAddedNode();
            this.myGraph.addExitNode(returnNode);
            this.myGraph.addNode();
        }
    }

    @Override
    public void visitSendMessageExpression(OCSendMessageExpression expression) {
        this.visitElement(expression);
        OCExpression receiver = expression.getReceiverExpression();
        String selector = expression.getMessageSelector();
        if (selector.startsWith("raise") && receiver != null && receiver.getResolvedType().getName().equals("NSException")) {
            this.processThrow();
        }
    }

    @Override
    public void visitReferenceExpression(OCReferenceExpression expression) {
        PsiElement parent;
        OCInstruction instruction;
        OCExpression element;
        this.visitElement(expression);
        OCSymbol symbol = expression.resolveToSymbol();
        if (!this.isSymbolInScope(symbol)) {
            return;
        }
        boolean wasQualifierOrIndex = false;
        if (element == null) {
            return;
        }
        if (symbol.getType().resolve(expression.getContainingFile()) instanceof OCStructType) {
            for (element = OCParenthesesUtils.topmostParenthesized(expression); element.getParent() instanceof OCQualifiedExpression || element.getParent() instanceof OCArraySelectionExpression && ((OCArraySelectionExpression)element.getParent()).getArrayExpression() == element; element = element.getParent()) {
                wasQualifierOrIndex = true;
            }
        }
        if (wasQualifierOrIndex && (instruction = this.myGraph.addInstruction(OCInstruction.InstructionKind.READ, expression, symbol)) != null && element instanceof OCExpression && !(OCParenthesesUtils.topmostParenthesized(element).getParent() instanceof OCCallExpression)) {
            instruction.setTransparentRead(true);
        }
        if ((parent = element.getContext()) == null) {
            return;
        }
        MyParentVisitor visitor = new MyParentVisitor(element, symbol);
        parent.accept((PsiElementVisitor)visitor);
        if (!wasQualifierOrIndex && !visitor.isFound()) {
            this.myGraph.addInstruction(OCInstruction.InstructionKind.READ, expression, symbol);
        }
        if (visitor.isDereference()) {
            this.processDereference(expression);
        }
    }

    @Contract(value="null -> false")
    protected boolean isSymbolInScope(@Nullable OCSymbol symbol) {
        return symbol != null && symbol.getKind().isLocal();
    }

    @Override
    public void visitBlockStatement(OCBlockStatement stmt) {
        PsiElement parent = stmt.getParent();
        if (!(parent instanceof OCFunctionDefinition) || parent == this.myGraph.getCodeFragment()) {
            this.visitElement(stmt);
        }
    }

    private class MyParentVisitor
    extends OCVisitor {
        private PsiElement myElement;
        private OCSymbol mySymbol;
        private boolean myFound;
        private boolean myDereference;

        private MyParentVisitor(@NotNull PsiElement element, OCSymbol symbol) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder$MyParentVisitor", "<init>"));
            }
            if (symbol == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder$MyParentVisitor", "<init>"));
            }
            this.myElement = element;
            this.mySymbol = symbol;
        }

        public boolean isFound() {
            return this.myFound;
        }

        private boolean isDereference() {
            return this.myDereference;
        }

        @Override
        public void visitAssignmentExpression(OCAssignmentExpression expression) {
            if (!this.processOperator(expression) && this.myElement == expression.getReceiverExpression()) {
                if (expression.getOperationSign() != OCTokenTypes.EQ) {
                    OCControlFlowBuilder.this.myGraph.addInstruction(OCInstruction.InstructionKind.READ, this.myElement, this.mySymbol);
                }
                this.myFound = true;
            }
        }

        private void processFunctionCall(OCFunctionSymbol operator, OCFunctionType functionType, List<OCExpression> arguments) {
            ProgressManager.checkCanceled();
            if (operator instanceof OCResolveOverloadsUtil.OCFunctionGroupSymbol) {
                for (OCFunctionSymbol symbol : ((OCResolveOverloadsUtil.OCFunctionGroupSymbol)operator).getOverloads()) {
                    this.processFunctionCall(symbol, functionType, arguments);
                }
                return;
            }
            List<? extends OCType> parameterTypes = functionType.getParameterTypes();
            int index = arguments.indexOf((OCExpression)this.myElement);
            if (operator != null && operator.isCppMemberOperator(new OCResolveContext(this.myElement))) {
                --index;
            }
            if (index >= 0 && index < parameterTypes.size() && parameterTypes.get(index) instanceof OCCppReferenceType && !((OCCppReferenceType)parameterTypes.get(index)).isReferenceToConst()) {
                OCControlFlowBuilder.this.processReference(this.myElement, this.mySymbol);
                this.myFound = true;
            }
        }

        private boolean processOperator(OCExpression expression) {
            boolean isOperator = false;
            PsiReference reference = expression.getReference();
            if (reference instanceof OCOperatorReference) {
                for (OCSymbol operator : ((OCOperatorReference)reference).resolveToSymbols()) {
                    if (!(operator instanceof OCFunctionSymbol)) continue;
                    isOperator = true;
                    this.processFunctionCall((OCFunctionSymbol)operator, (OCFunctionType)operator.getType().resolve(expression.getContainingFile()), ((OCOperatorReference)reference).getArgumentExpressions());
                }
            }
            return isOperator;
        }

        @Override
        public void visitCallExpression(OCCallExpression expression) {
            this.processOperator(expression);
        }

        @Override
        public void visitArgumentList(OCArgumentList argList) {
            OCType functionType;
            if (!(argList.getParent() instanceof OCCallExpression)) {
                return;
            }
            OCCallExpression callExpression = (OCCallExpression)argList.getParent();
            if (!this.processOperator(callExpression) && (functionType = callExpression.getFunctionReferenceExpression().getResolvedType().getTerminalType()) instanceof OCFunctionType) {
                this.processFunctionCall(null, (OCFunctionType)functionType, argList.getArguments());
            }
        }

        @Override
        public void visitMessageArgument(OCMessageArgument argument) {
            OCSendMessageExpression call = (OCSendMessageExpression)argument.getParent();
            int index = call.getArguments().indexOf(argument);
            OCSendMessageExpression.ProbableResponders responders = call.getProbableResponders();
            for (OCMethodSymbol method : responders.getAllResponders()) {
                OCDeclaratorSymbol parameter;
                if (method.getSelectors().size() <= index || (parameter = method.getSelectors().get(index).getParameter()) == null || !parameter.isPassByReference() && (!(parameter.getType() instanceof OCCppReferenceType) || ((OCCppReferenceType)parameter.getType()).isReferenceToConst())) continue;
                OCExpression expression = argument.getArgumentExpression();
                if (expression != null) {
                    OCControlFlowBuilder.this.processReference(expression, this.mySymbol);
                }
                this.myFound = true;
                return;
            }
        }

        @Override
        public void visitForeachStatement(OCForeachStatement statement) {
            OCElement expression = statement.getVariableExpression();
            if (expression instanceof OCExpressionStatement) {
                expression = ((OCExpressionStatement)expression).getExpression();
            }
            if (this.myElement == expression) {
                OCControlFlowBuilder.this.processAssignment(this.mySymbol, this.myElement, null, true);
                this.myFound = true;
            }
        }

        @Override
        public void visitDeclarationStatement(OCDeclarationStatement stmt) {
            if (stmt.getParent() instanceof OCForeachStatement) {
                this.visitForeachStatement((OCForeachStatement)stmt.getParent());
            } else {
                this.myFound = true;
            }
        }

        @Override
        public void visitExpressionStatement(OCExpressionStatement stmt) {
            if (stmt.getParent() instanceof OCForeachStatement) {
                this.visitForeachStatement((OCForeachStatement)stmt.getParent());
            } else {
                this.myFound = true;
            }
        }

        @Override
        public void visitPostfixExpression(OCPostfixExpression expression) {
            if (!(this.processOperator(expression) || expression.getOperationSign() != OCTokenTypes.PLUSPLUS && expression.getOperationSign() != OCTokenTypes.MINUSMINUS)) {
                OCControlFlowBuilder.this.myGraph.addInstruction(OCInstruction.InstructionKind.READ, this.myElement, this.mySymbol);
                OCControlFlowBuilder.this.processAssignment(this.mySymbol, (PsiElement)expression.getOperand(), expression.getOperand(), true);
                this.myFound = true;
            }
        }

        @Override
        public void visitPrefixExpression(OCPrefixExpression expression) {
            if (!(this.processOperator(expression) || expression.getOperationSign() != OCTokenTypes.PLUSPLUS && expression.getOperationSign() != OCTokenTypes.MINUSMINUS)) {
                OCControlFlowBuilder.this.myGraph.addInstruction(OCInstruction.InstructionKind.READ, this.myElement, this.mySymbol);
                OCControlFlowBuilder.this.processAssignment(this.mySymbol, (PsiElement)expression.getOperand(), expression.getOperand(), true);
                PsiElement parent = OCParenthesesUtils.topmostParenthesized(expression).getParent();
                if (parent != null) {
                    parent.accept((PsiElementVisitor)this);
                }
            }
        }

        @Override
        public void visitBinaryExpression(OCBinaryExpression expression) {
            this.processOperator(expression);
        }

        @Override
        public void visitUnaryExpression(OCUnaryExpression expression) {
            if (this.processOperator(expression)) {
                return;
            }
            OCElementType sign = expression.getOperationSign();
            if (sign == OCTokenTypes.AND || sign == OCTokenTypes.__IMAG__KEYWORD || sign == OCTokenTypes.__REAL__KEYWORD) {
                OCControlFlowBuilder.this.processReference(expression, this.mySymbol);
                this.myFound = true;
            } else if (sign == OCTokenTypes.MUL) {
                if (OCParenthesesUtils.topmostParenthesized(expression).getParent() instanceof OCSizeofExpression) {
                    this.myFound = true;
                } else {
                    this.myDereference = true;
                }
            }
        }

        @Override
        public void visitQualifiedExpression(OCQualifiedExpression expression) {
            if (!(this.processOperator(expression) || expression.getQualifier() != this.myElement || expression.getQualifyingTokenKind() == OCTokenTypes.DOT && expression.getQualifier().getResolvedType().isPointerToObject())) {
                this.myDereference = true;
            }
        }

        @Override
        public void visitArraySelectionExpression(OCArraySelectionExpression expression) {
            if (!this.processOperator(expression) && expression.getArrayExpression() == this.myElement && !expression.getArrayExpression().getResolvedType().isPointerToObject()) {
                this.myDereference = true;
            }
        }

        @Override
        public void visitSizeofExpression(OCSizeofExpression expression) {
            this.myFound = true;
        }
    }

    protected static class SwitchInfo {
        OCNode myNode;
        OCExpression myExpression;
        List<OCExpression> myCaseExpressions;
        boolean myHasDefault;

        public SwitchInfo(@Nullable OCDeclarationOrExpression expression, @NotNull OCNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder$SwitchInfo", "<init>"));
            }
            this.myCaseExpressions = new ArrayList<OCExpression>();
            this.myExpression = expression != null ? expression.getExpression() : null;
            this.myNode = node;
        }

        @NotNull
        public OCNode getNode() {
            OCNode oCNode = this.myNode;
            if (oCNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder$SwitchInfo", "getNode"));
            }
            return oCNode;
        }

        @Nullable
        public OCExpression getExpression() {
            return this.myExpression;
        }

        public boolean hasDefault() {
            return this.myHasDefault;
        }

        public void setHasDefault(boolean hasDefault) {
            this.myHasDefault = hasDefault;
        }

        public void addCaseExpression(@Nullable OCExpression expr) {
            if (expr != null) {
                this.myCaseExpressions.add(expr);
            }
        }

        public List<OCExpression> getCaseExpressions() {
            return this.myCaseExpressions;
        }
    }

    protected static interface NodeState {
    }

    protected static interface KidIterator {
        public void skipLeaves();

        public void accept(@Nullable PsiElement var1);

        public void skip(@Nullable PsiElement var1);

        public void acceptAll();

        public void finish();
    }
}

