/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorHelper;
import com.jetbrains.cidr.lang.editor.colors.OCFileHighlighter;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.intentions.OCDeclareMethodInInterfaceIntentionAction;
import com.jetbrains.cidr.lang.intentions.OCDeclareMethodInPrivateCategoryIntentionAction;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceAlias;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCCppQualifiedPointer;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCGenericParameter;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCQualifiedDesignator;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.psi.impl.OCDefineDirectiveImpl;
import com.jetbrains.cidr.lang.psi.impl.OCDirectiveImpl;
import com.jetbrains.cidr.lang.psi.impl.OCMacroParameterImpl;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceElementImpl;
import com.jetbrains.cidr.lang.quickfixes.OCChangeMethodSignatureIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCreateNewDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCHighPriorityCreateNewDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCMigrateToARCIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCMoveDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCPredeclareSymbolIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCProvideStringLocalizationsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRenameReferenceIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.OCSelectorAdHocResolver;
import com.jetbrains.cidr.lang.resolve.references.OCCompositeResourceReference;
import com.jetbrains.cidr.lang.resolve.references.OCFileResourceReference;
import com.jetbrains.cidr.lang.resolve.references.OCStringResourceReference;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCResolveAnnotator
extends OCAnnotator {
    @Nullable
    private Annotation checkReferences(@NotNull PsiElement psiElement, @Nullable String cannotResolveMessage, @Nullable OCSymbolGroupContext groupContext, @Nullable String newName, @Nullable Class<? extends OCInspection> inspectionClass) {
        PsiReference[] refs;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/cidr/lang/daemon/OCResolveAnnotator", "checkReferences"));
        }
        if (cannotResolveMessage == null) {
            cannotResolveMessage = groupContext != null ? groupContext.getCannotResolveMessagePrefix() : "Can't resolve";
        }
        for (PsiReference reference : refs = psiElement.getReferences()) {
            OCSymbol symbol = null;
            Annotation annotation = null;
            if (reference instanceof OCPolyVariantReference) {
                List symbols = ((OCPolyVariantReference)reference).resolveToSymbols();
                if (symbols.size() == 0) {
                    if (!reference.isSoft()) {
                        annotation = this.highlightUnresolvedReference(cannotResolveMessage, reference, inspectionClass);
                    }
                } else {
                    symbol = (OCSymbol)symbols.get(0);
                }
            } else if (reference instanceof OCReference) {
                symbol = ((OCReference)reference).resolveToSymbol();
                if (symbol == null) {
                    PsiElement context = psiElement.getContext();
                    if (psiElement instanceof OCQualifiedExpression) {
                        OCExpression qualifier = ((OCQualifiedExpression)psiElement).getQualifier();
                        if (qualifier.getResolvedType() instanceof OCMagicType) {
                            this.highlight(reference, OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.TEMPLATE_VALUE_PARAMETER));
                            continue;
                        }
                    } else if (psiElement instanceof OCReferenceElement) {
                        OCReferenceElement referenceElement = (OCReferenceElement)psiElement;
                        boolean soft = false;
                        OCCppNamespaceQualifier namespaceQualifier = referenceElement.getNamespaceQualifier();
                        if (namespaceQualifier != null) {
                            for (OCSymbol candidate : namespaceQualifier.resolveToSymbols(false)) {
                                if (!(candidate instanceof OCTypeParameterSymbol)) continue;
                                soft = true;
                                break;
                            }
                            if (soft) {
                                this.highlight(reference, OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.TEMPLATE_VALUE_PARAMETER));
                                continue;
                            }
                        }
                    }
                    if (!(context instanceof OCStructLike) && !reference.isSoft() && PsiTreeUtil.getContextOfType((PsiElement)psiElement, (Class[])new Class[]{OCDirectiveImpl.class}) == null) {
                        annotation = this.highlightUnresolvedReference(cannotResolveMessage, reference, inspectionClass);
                    }
                }
            } else if (reference.resolve() == null) {
                if (reference instanceof PsiPolyVariantReference && ((PsiPolyVariantReference)reference).multiResolve(false).length > 0) continue;
                if (!reference.isSoft()) {
                    annotation = this.highlightUnresolvedReference(cannotResolveMessage, reference, inspectionClass);
                }
            }
            if (annotation != null) {
                if (groupContext != null) {
                    for (OCSymbolContext context : groupContext.getSymbolContexts()) {
                        String name = newName != null ? newName : reference.getCanonicalText();
                        this.registerCreateNewDefinitionFix(psiElement, annotation, context, name);
                        this.registerQuickFix(annotation, new OCRenameReferenceIntentionAction(psiElement));
                    }
                }
                return annotation;
            }
            if (symbol == null) continue;
            if (symbol instanceof OCResolveOverloadsUtil.OCFunctionGroupSymbol) {
                symbol = (OCSymbol)ContainerUtil.getFirstItem(((OCResolveOverloadsUtil.OCFunctionGroupSymbol)symbol).getOverloads());
            }
            if (symbol instanceof OCThisSelfSuperSymbol) {
                this.highlight(reference, OCHighlightingKeys.SELFSUPERTHIS);
                return null;
            }
            OCSymbolKind kind = symbol.getKind();
            if (kind == OCSymbolKind.MACRO) {
                if (psiElement.getTextLength() > 0) {
                    this.highlight(psiElement, OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.MACRO));
                }
            } else if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppOperator()) {
                this.highlight(reference, OCHighlightingKeys.OVERLOADED_OPERATOR);
            } else {
                this.highlight(reference, OCResolveAnnotator.getTextAttributesKeyByKind(kind));
            }
            if (symbol.isForbiddenByARC(psiElement)) {
                annotation = this.addErrorAnnotation(psiElement, OCInspections.ARCIssues.class, "CIDR", "Explicit usage of '" + symbol.getName() + "' is forbidden in ARC");
                if (psiElement instanceof OCReferenceElement) {
                    this.registerQuickFix(annotation, new OCMigrateToARCIntentionAction((OCReferenceElement)psiElement));
                }
                this.registerQuickFix(annotation, new OCMigrateToARCIntentionAction((OCFile)psiElement.getContainingFile()));
                break;
            }
            if (symbol.isUnavailable()) {
                this.addErrorAnnotation(psiElement, OCInspections.DeprecatedAPI.class, "CIDR", symbol.getUnavailableMessage());
            } else if (symbol.isDeprecated()) {
                this.addWarningAnnotation(psiElement, OCInspections.DeprecatedAPI.class, "warn_deprecated", symbol.getDeprecatedMessage(), ProblemHighlightType.LIKE_DEPRECATED);
            }
            String unavailableMessage = OCResolveUtil.checkAvailability(symbol, psiElement);
            if (unavailableMessage == null) continue;
            this.addWarningAnnotation(psiElement, OCInspections.UnavailableInDeploymentTarget.class, "CIDR", unavailableMessage, ProblemHighlightType.LIKE_DEPRECATED);
            break;
        }
        return null;
    }

    private void registerCreateNewDefinitionFix(PsiElement psiElement, Annotation annotation, OCSymbolContext context, String name) {
        if (context.getSymbolKind() == OCSymbolKind.METHOD && psiElement instanceof OCQualifiedExpression) {
            boolean isSetter = new OCReadWriteAccessDetector().getExpressionAccess(psiElement) == ReadWriteAccessDetector.Access.Write;
            OCObjectTypeContext receiverContext = ((OCQualifiedExpression)psiElement).getQualifier().getTypeContext();
            OCType expectedType = context.getExpectedType();
            if (receiverContext == null || expectedType == null) {
                return;
            }
            expectedType = expectedType.resolve(psiElement.getContainingFile());
            OCType returnType = isSetter ? OCVoidType.instance() : expectedType;
            String methodName = isSetter ? OCNameSuggester.getObjCSetterFromGetter(name) : name;
            String staticToken = receiverContext.getStaticMode() == OCObjectTypeContext.StaticMode.STATIC ? "+" : "-";
            StringBuilder signature = new StringBuilder();
            signature.append(staticToken).append('(').append(returnType.getName(psiElement)).append(')').append(methodName);
            if (isSetter) {
                signature.append('(').append(expectedType.getName(psiElement)).append(')').append(name);
            }
            this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(psiElement, context.getParent(), staticToken + methodName, signature.toString(), returnType, receiverContext.getType()));
        } else if (OCHighPriorityCreateNewDefinitionIntentionAction.isHighPrioritySymbolKind(context.getSymbolKind())) {
            this.registerQuickFix(annotation, new OCHighPriorityCreateNewDefinitionIntentionAction(context, psiElement, name));
        } else {
            this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(context, psiElement, name));
        }
    }

    @Nullable
    private Annotation highlightUnresolvedReference(String cannotResolveMessage, PsiReference reference, @Nullable Class<? extends OCInspection> inspectionClass) {
        TextRange refRange = reference.getRangeInElement();
        TextRange range = TextRange.from((int)(reference.getElement().getTextOffset() + refRange.getStartOffset()), (int)refRange.getLength());
        if (inspectionClass != null) {
            return this.addWarningAnnotation(reference.getElement(), range, inspectionClass, "CIDR", cannotResolveMessage + " '" + reference.getCanonicalText() + "'", ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
        return this.addErrorAnnotation(reference.getElement(), range, OCInspections.CannotResolve.class, "CIDR", cannotResolveMessage + " '" + reference.getCanonicalText() + "'", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
    }

    @Override
    public void visitClassDeclaration(OCClassDeclaration dcl) {
        PsiElement id = dcl.getNameIdentifier();
        if (id != null) {
            this.highlight(id.getTextRange(), dcl instanceof OCProtocol ? OCHighlightingKeys.PROTOCOL_REFERENCE : OCHighlightingKeys.CLASS_REFERENCE);
        }
    }

    @Nullable
    public Annotation checkNamespaceQualifierOwnerElement(OCCppNamespaceQualifier element) {
        Annotation annotation;
        OCCppNamespaceQualifier qualifier = element.getNamespaceQualifier();
        if (qualifier != null && (annotation = this.checkNamespaceQualifierOwnerElement(qualifier)) != null) {
            return annotation;
        }
        return this.checkReferences(element, "Can't resolve container", null, null, null);
    }

    @Override
    public void visitCppQualifiedPointer(OCCppQualifiedPointer pointer) {
        this.checkNamespaceQualifierOwnerElement(pointer.getNamespaceQualifier());
        super.visitCppQualifiedPointer(pointer);
    }

    @Override
    public void visitReferenceElement(OCReferenceElement referenceElement) {
        OCCppNamespaceQualifier qualifier = referenceElement.getNamespaceQualifier();
        Annotation annotation = null;
        if (qualifier != null) {
            annotation = this.checkNamespaceQualifierOwnerElement(qualifier);
        }
        if (annotation == null && (annotation = this.checkReferences(referenceElement, null, referenceElement.getSymbolContext(), null, null)) != null && referenceElement.resolveToSymbolIgnoringSymbolContext() != null) {
            annotation.setHighlightType(ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
        if (annotation != null) {
            Object fix = new OCImportSymbolFix(referenceElement);
            if (!fix.isAvailable(referenceElement.getProject(), null, referenceElement.getContainingFile())) {
                fix = new OCPredeclareSymbolIntentionAction(referenceElement);
            }
            this.registerQuickFix(annotation, (IntentionAction)fix);
        }
    }

    @Override
    public void visitQualifiedDesignator(OCQualifiedDesignator designator) {
        if (designator.getName() != null) {
            this.checkReferences(designator, null, OCSymbolGroupContext.STRUCT_FIELD_CONTEXT, null, null);
        }
    }

    @Override
    public void visitQualifiedExpression(OCQualifiedExpression expression) {
        this.checkReferences(expression.getQualifyingElement(), "Can't resolve operator", null, null, null);
        Annotation annotation = this.checkReferences(expression, null, expression.getSymbolContext(), null, null);
        if (annotation != null) {
            OCObjectTypeContext typeContext = expression.getQualifier().getTypeContext();
            if (typeContext == null) {
                return;
            }
            OCClassSymbol symbol = typeContext.getType().getClassSymbol();
            if (symbol != null && symbol.isPredeclaration() && (symbol = symbol.getDefinitionSymbol()) != null) {
                this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(expression.getSelectorElement(), symbol));
            }
            for (OCProtocolSymbol protocol : typeContext.getType().getAllProtocols()) {
                if (!protocol.isPredeclaration() || (symbol = protocol.getDefinitionSymbol()) == null) continue;
                this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(expression.getSelectorElement(), symbol));
            }
        }
    }

    @Override
    public void visitImportDirective(OCIncludeDirective directive) {
        if (directive.getText().isEmpty()) {
            return;
        }
        VirtualFile containingFile = directive.getContainingFile().getVirtualFile();
        if (containingFile == null) {
            return;
        }
        Annotation annotation = this.checkReferences(directive, "Cannot find", null, null, null);
        PsiReference[] references = directive.getReferences();
        if (annotation != null && references.length == 1) {
            String fileNameToImport = references[0].getCanonicalText();
            for (OCAutoImportHelper each : (OCAutoImportHelper[])Extensions.getExtensions(OCAutoImportHelper.EP_NAME)) {
                for (IntentionAction eachAction : each.getAddHeaderSearchPathFixes(directive.getProject(), containingFile, fileNameToImport)) {
                    this.registerQuickFix(annotation, eachAction);
                }
            }
        }
    }

    @Override
    public void visitSelectorExpression(OCSelectorExpression stmt) {
        OCSymbolContext context;
        String message;
        Annotation annotation;
        OCObjectType type;
        OCClassDeclaration classDeclaration = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)stmt, OCClassDeclaration.class);
        OCClassSymbol parent = classDeclaration != null ? classDeclaration.getSymbol() : null;
        OCObjectTypeContext targetContext = OCSelectorAdHocResolver.getActionTargetContext(stmt);
        OCObjectType oCObjectType = type = targetContext != null ? targetContext.getType() : null;
        if (!(type == null || parent != null && parent.getName().equals(type.getClassSymbol().getName()))) {
            parent = type.getClassSymbol();
        }
        if ((annotation = this.checkReferences(stmt, message = type != null ? "Type '" + type.getName(stmt) + "' doesn't have the method" : "Cannot find the method", new OCSymbolGroupContext(context = new OCSymbolContext(null, OCSymbolKind.METHOD, parent)), null, OCInspections.UnresolvedMessage.class)) != null) {
            ArrayList<String> selectors = new ArrayList<String>();
            ArrayList<OCExpression> expressions = new ArrayList<OCExpression>();
            ArrayList<OCType> argumentTypes = new ArrayList<OCType>();
            String selector = stmt.getSelector();
            int pos = selector.indexOf(58);
            if (pos != -1) {
                int prevPos = 0;
                while (pos != -1) {
                    selectors.add(selector.substring(prevPos, pos + 1));
                    expressions.add(null);
                    argumentTypes.add(null);
                    prevPos = pos + 1;
                    pos = selector.indexOf(58, prevPos);
                }
            } else {
                selectors.add(selector);
                expressions.add(null);
            }
            OCMethodSymbol similarResponder = OCObjectTypeContext.findSimilarResponder(type, selectors, argumentTypes, stmt.getContainingFile());
            if (similarResponder != null) {
                for (int i = 0; i < argumentTypes.size(); ++i) {
                    argumentTypes.set(i, OCIdType.pointerToID(stmt.getProject()));
                }
            }
            this.registerQuickFix(annotation, new OCChangeMethodSignatureIntentionAction(similarResponder, argumentTypes, selectors, expressions));
            this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(stmt, context.getParent(), "-" + selector, stmt.getExpectedMethodSignature(), stmt.getExpectedReturnType(), type));
        }
    }

    @Override
    public void visitLiteralExpression(final OCLiteralExpression expression) {
        OCClassSymbol receiverClass = null;
        String referencedName = null;
        String message = null;
        Class inspectionClass = null;
        OCProvideStringLocalizationsIntentionAction quickFix = null;
        OCFileHighlighter fhl = null;
        Lexer lexer = null;
        String text = null;
        for (ASTNode child = expression.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!OCTokenTypes.RAW_STRING_LITERALS.contains(OCElementUtil.getElementType(child))) continue;
            if (fhl == null) {
                fhl = new OCFileHighlighter(OCLanguageKind.CPP, false);
                lexer = fhl.getHighlightingLexer();
                text = expression.getContainingFile().getText();
            }
            TextRange range = child.getTextRange();
            lexer.start(text, range.getStartOffset(), range.getEndOffset());
            while (lexer.getTokenType() != null) {
                TextRange tr = new TextRange(lexer.getTokenStart(), lexer.getTokenEnd());
                TextAttributesKey[] ta = fhl.getTokenHighlights(lexer.getTokenType());
                if (ta.length > 0) {
                    this.highlight(tr, ta[0]);
                }
                lexer.advance();
            }
        }
        for (ASTNode ref : expression.getReferences()) {
            while (ref instanceof OCCompositeResourceReference) {
                ref = ((OCCompositeResourceReference)ref).getRepresentative();
            }
            boolean processed = false;
            for (OCAnnotatorHelper each : OCAnnotator.getAnnotatorHelpers()) {
                Ref referencedNameRef;
                Ref inspectionClassRef = Ref.create();
                Ref receiverClassRef = Ref.create();
                Ref messageRef = Ref.create();
                if (!each.processReference((PsiReference)ref, (Ref<Class<? extends OCInspection>>)inspectionClassRef, (Ref<String>)messageRef, (Ref<OCClassSymbol>)receiverClassRef, (Ref<String>)(referencedNameRef = Ref.create()))) continue;
                inspectionClass = (Class)inspectionClassRef.get();
                message = (String)messageRef.get();
                receiverClass = (OCClassSymbol)receiverClassRef.get();
                referencedName = (String)referencedNameRef.get();
                processed = true;
                break;
            }
            if (processed) continue;
            if (ref instanceof OCFileResourceReference) {
                inspectionClass = OCInspections.ResourceNotFoundInspection.class;
                message = "Can't find the resource";
                continue;
            }
            if (!(ref instanceof OCStringResourceReference)) continue;
            inspectionClass = OCInspections.StringLocalizationInspection.class;
            String tableFileName = ((OCStringResourceReference)ref).getTableFileName();
            List<String> notLocalizedLanguages = ((OCStringResourceReference)ref).getNotLocalizedLanguages();
            if (!notLocalizedLanguages.isEmpty()) {
                String messagePrefix = StringUtil.join(notLocalizedLanguages, (String)", ") + (notLocalizedLanguages.size() > 1 ? " localizations don't" : " localization doesn't") + " contain the value for";
                Annotation annotation = this.highlightUnresolvedReference(messagePrefix, (PsiReference)ref, OCInspections.StringLocalizationInspection.class);
                this.registerQuickFix(annotation, new OCProvideStringLocalizationsIntentionAction((OCStringResourceReference)ref));
                return;
            }
            if (tableFileName == null) continue;
            message = tableFileName + " doesn't contain the value for";
            quickFix = new OCProvideStringLocalizationsIntentionAction((OCStringResourceReference)ref);
        }
        OCSymbolContext context = receiverClass != null ? new OCSymbolContext(new OCExpectedTypeUtil.Expectable(){

            @Override
            public OCType getExpectedType() {
                return OCIdType.pointerToID(expression.getProject());
            }
        }, OCSymbolKind.PROPERTY, receiverClass) : null;
        Annotation annotation = this.checkReferences(expression, message, context != null ? new OCSymbolGroupContext(context) : null, referencedName, inspectionClass);
        if (annotation != null && quickFix != null) {
            this.registerQuickFix(annotation, quickFix);
        }
    }

    public void visitComment(PsiComment comment) {
        IElementType tt;
        ASTNode node = comment.getNode();
        if (node != null && (tt = node.getElementType()) == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT && this.myHolder != null) {
            this.myHolder.createInfoAnnotation((PsiElement)comment, null).setTextAttributes(OCHighlightingKeys.CONDITIONALLY_NOT_COMPILED);
        }
    }

    @Override
    public void visitDirective(OCDirective directive) {
        IElementType directiveType = directive.getHeaderToken().getNode().getElementType();
        if (directiveType == OCTokenTypes.UNKNOWN_DIRECTIVE) {
            Annotation annotation = this.addErrorAnnotation(directive, "CIDR", "Unknown preprocessor directive '" + directive.getHeaderToken().getText() + "'");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)directive, "Remove directive"));
        }
    }

    @Override
    public void visitStructLike(OCStructLike struct) {
        OCStructSymbol symbol = (OCStructSymbol)struct.getSymbol();
        if (symbol != null) {
            this.highlight(struct.getNameIdentifier(), OCResolveAnnotator.getTextAttributesKeyByKind(symbol.getKind()));
        }
    }

    @Override
    public void visitDefineDirective(OCDefineDirectiveImpl directive) {
        this.highlight(directive.getNameIdentifier(), OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.MACRO));
    }

    @Override
    public void visitMacroParameter(OCMacroParameterImpl parameter) {
        this.highlight(parameter, OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.MACRO_PARAMETER));
    }

    @Override
    public void visitDeclarator(OCDeclarator declarator) {
        PsiElement nameIdentifier = declarator.getNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        PsiElement parent = PsiTreeUtil.getContextOfType((PsiElement)declarator, (Class[])new Class[]{OCInstanceVariablesList.class, OCEnum.class, OCProperty.class});
        if (parent != null) {
            if (parent instanceof OCInstanceVariablesList) {
                this.highlight(nameIdentifier, OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.INSTANCE_VARIABLE));
            } else if (parent instanceof OCEnum) {
                this.highlight(nameIdentifier, OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.ENUM_CONST));
            } else if (parent instanceof OCProperty) {
                this.highlight(nameIdentifier, OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.PROPERTY));
            }
        } else {
            OCSymbol symbol = declarator.getSymbol();
            OCCppNamespaceQualifier qualifier = declarator.getNamespaceQualifier();
            if (symbol != null) {
                this.highlight(nameIdentifier, OCResolveAnnotator.getTextAttributesKeyByKind(symbol.getKind()));
            }
            if (qualifier != null) {
                Annotation namespaceAnnotation = this.checkNamespaceQualifierOwnerElement(qualifier);
                if (namespaceAnnotation != null) {
                    OCSymbolReference symbolRef = OCSymbolReference.getLocalReference(OCSymbolReferenceResolver.getQualifiedName(declarator), (PsiElement)declarator);
                    OCResolveContext context = new OCResolveContext(declarator.getContainingOCFile());
                    context.setProcessNonImported(true);
                    List<OCSymbol> symbols = context.resolveToSymbols(symbolRef, true, false);
                    for (OCSymbol s : symbols) {
                        OCImportSymbolFix fix = new OCImportSymbolFix(declarator, s);
                        if (!fix.isAvailable(qualifier.getProject(), null, qualifier.getContainingOCFile())) continue;
                        this.registerQuickFix(namespaceAnnotation, (IntentionAction)fix);
                        break;
                    }
                } else if (symbol instanceof OCSymbolWithQualifiedName) {
                    OCFile file2 = declarator.getContainingOCFile();
                    OCTypeElement typeElement = ((OCDeclaration)declarator.getParent()).getTypeElement();
                    boolean isOldAccessDeclaration = symbol instanceof OCDeclaratorSymbol && typeElement != null && typeElement.isEmpty();
                    OCSymbol predeclarationInParent = qualifier.getPredeclarationInParent((OCSymbolWithQualifiedName)symbol, !isOldAccessDeclaration);
                    if (predeclarationInParent == null && symbol.processSameSymbols(new Processor<OCSymbol>(){

                        public boolean process(OCSymbol symbol) {
                            return !(symbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol).isFriendFunction();
                        }
                    })) {
                        OCSymbol parentSymbol = OCReferenceElementImpl.getAppropriateToAppendSymbol(qualifier, new OCResolveContext(qualifier));
                        if (parentSymbol != null) {
                            String message = symbol.getNameWithKindUppercase() + " was not declared in " + parentSymbol.getNameWithKindLowercase();
                            Annotation annotation = this.addErrorAnnotation(declarator.getNameIdentifier(), OCInspections.CannotResolve.class, "err_member_decl_does_not_match", message, ProblemHighlightType.GENERIC_ERROR);
                            OCSymbolKind kind = ((OCSymbolWithQualifiedName)symbol).getResolvedKind();
                            boolean staticMember = kind == OCSymbolKind.STRUCT_FIELD;
                            OCCreateNewDefinitionIntentionAction fix = new OCCreateNewDefinitionIntentionAction(kind, declarator, null, parentSymbol, declarator.getName(), symbol.getResolvedType(), staticMember);
                            fix.setSilentMode(true);
                            this.registerQuickFix(annotation, fix);
                        }
                    } else if (predeclarationInParent instanceof OCSymbolWithParent) {
                        OCFileSymbols.markSymbolAsUsed(file2, ((OCSymbolWithParent)predeclarationInParent).getParent(), declarator);
                    }
                }
            }
        }
    }

    @Override
    public void visitTypeParameterDeclaration(OCTypeParameterDeclaration declaration) {
        this.highlight(declaration.getNameIdentifier(), OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.TEMPLATE_TYPE_PARAMETER));
        super.visitTypeParameterDeclaration(declaration);
    }

    @Override
    public void visitNamespace(OCCppNamespace declaration) {
        this.highlight(declaration.getNameIdentifier(), OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.NAMESPACE));
        super.visitNamespace(declaration);
    }

    @Override
    public void visitNamespaceAlias(OCCppNamespaceAlias declaration) {
        this.highlight(declaration.getNameIdentifier(), OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.NAMESPACE_ALIAS));
        super.visitNamespaceAlias(declaration);
    }

    @Override
    public void visitUsingStatement(OCCppUsingStatement usingStatement) {
        this.highlight(usingStatement.getNameIdentifier(), OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.USING_SYMBOL_ALIAS));
        super.visitUsingStatement(usingStatement);
    }

    @Override
    public void visitMethodSelectorPart(OCMethodSelectorPart part) {
        this.highlight(part.getSelectorIdentifier(), OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.METHOD));
        this.highlight(part.getParameter(), OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.PARAMETER));
        super.visitMethodSelectorPart(part);
    }

    @Override
    public void visitArgumentSelector(OCArgumentSelector selector) {
        if (selector.getTextRange().getLength() > 0 && this.myHolder != null) {
            Annotation annotation = this.myHolder.createInfoAnnotation((PsiElement)selector, null);
            annotation.setTextAttributes(OCHighlightingKeys.MESSAGE_ARGUMENT);
        }
    }

    @Override
    public void visitPropertyAttribute(OCPropertyAttribute attribute) {
        this.highlight(attribute, OCHighlightingKeys.PROPERTY_ATTRIBUTE);
    }

    @Override
    public void visitExpression(OCExpression expression) {
        this.checkReferences(expression, "Can't resolve operator", null, null, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void visitSendMessageExpression(OCSendMessageExpression expression) {
        void var6_14;
        ArrayList<Object> quickFixes;
        ProblemHighlightType highlightType;
        boolean isError;
        boolean isInfo;
        String clangID;
        String message;
        block22: {
            OCExpression argument;
            Iterator<OCMessageArgument> iterator;
            ArrayList<OCType> argumentTypes;
            ArrayList<OCExpression> expressions;
            ArrayList<String> selectors;
            OCType returnExpectedType;
            OCObjectType receiverType;
            String selector;
            block20: {
                OCMethodSymbol firstResponder;
                block25: {
                    block24: {
                        block23: {
                            block21: {
                                if (expression.getArguments().size() == 0) {
                                    return;
                                }
                                OCSendMessageExpression.ProbableResponders responders = expression.getProbableResponders();
                                selector = expression.getMessageSelector();
                                receiverType = responders.getReceiverType();
                                OCClassSymbol clazz = receiverType != null ? receiverType.getClassSymbol() : null;
                                Object var6_6 = null;
                                message = null;
                                clangID = null;
                                isInfo = false;
                                isError = false;
                                highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                                quickFixes = new ArrayList<Object>();
                                if (responders.getAllResponders().isEmpty()) {
                                    if (receiverType != null) {
                                        OCExpression receiver;
                                        message = "Cannot resolve method '" + selector + "'" + (clazz != null ? " for " + clazz.getNameWithKindLowercase() : "");
                                        Class<OCInspections.UnresolvedMessage> clazz2 = OCInspections.UnresolvedMessage.class;
                                        clangID = "CIDR";
                                        isError = true;
                                        returnExpectedType = OCExpectedTypeUtil.getExpectedType(expression, true);
                                        if (returnExpectedType == OCUnknownType.INSTANCE) {
                                            returnExpectedType = OCVoidType.instance();
                                        }
                                        if ((receiver = expression.getReceiverExpression()) instanceof OCReferenceExpression && ((OCReferenceExpression)receiver).getSelfSuperToken() != null) {
                                            OCClassDeclaration classDeclaration = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)expression, OCClassDeclaration.class);
                                            OCClassSymbol oCClassSymbol = classDeclaration != null ? classDeclaration.getSymbol() : null;
                                        } else {
                                            OCInterfaceSymbol oCInterfaceSymbol = receiverType.getInterface();
                                        }
                                        String signature = expression.getExpectedMethodSignature();
                                        if (signature != null) {
                                            void var15_28;
                                            quickFixes.add(new OCCreateNewDefinitionIntentionAction(expression, (OCSymbol)var15_28, signature.charAt(0) + expression.getMessageSelector(), signature, returnExpectedType.resolve(expression.getContainingFile()), receiverType));
                                        }
                                        selectors = new ArrayList<String>();
                                        expressions = new ArrayList<OCExpression>();
                                        argumentTypes = new ArrayList<OCType>();
                                        iterator = expression.getArguments().iterator();
                                        break block20;
                                    } else {
                                        OCExpression receiverExpression = expression.getReceiverExpression();
                                        OCType type = receiverExpression != null ? receiverExpression.getResolvedType() : null;
                                        if (type == null) return;
                                        if (type.getTerminalType().isUnknown()) return;
                                        message = "Can't send messages to expressions of type '" + type.getName(receiverExpression) + "'";
                                        if (!type.isPointerCompatible(receiverExpression)) {
                                            this.addErrorAnnotation(receiverExpression, "err_bad_receiver_type", message);
                                            return;
                                        }
                                        if (OCCompilerHelper.isArcEnabled(receiverExpression.getContainingFile())) {
                                            this.addErrorAnnotation(receiverExpression, "err_bad_receiver_type", message);
                                            return;
                                        }
                                        this.addWarningAnnotation(receiverExpression, OCInspections.IncompatiblePointers.class, "warn_bad_receiver_type", message);
                                        return;
                                    }
                                }
                                List<OCMethodSymbol> filteredResponders = responders.getFilteredByStaticnessResponders();
                                OCMethodSymbol oCMethodSymbol = firstResponder = filteredResponders.isEmpty() ? null : filteredResponders.get(0);
                                if (OCResolveAnnotator.haveSingleRoot(filteredResponders)) break block21;
                                message = "Message '" + selector + "' can be resolved to several methods";
                                Class<OCInspections.SeveralTargetsMessage> clazz3 = OCInspections.SeveralTargetsMessage.class;
                                clangID = "CIDR";
                                isInfo = true;
                                break block22;
                            }
                            if (firstResponder == null || !firstResponder.isForbiddenByARC(expression)) break block23;
                            Annotation annotation = this.addErrorAnnotation(expression, OCInspections.ARCIssues.class, "CIDR", "Explicit usage of '" + selector + "' is forbidden in ARC");
                            this.registerQuickFix(annotation, new OCMigrateToARCIntentionAction(expression));
                            this.registerQuickFix(annotation, new OCMigrateToARCIntentionAction(expression.getContainingOCFile()));
                            break block22;
                        }
                        if (firstResponder == null || !firstResponder.isUnavailable()) break block24;
                        message = firstResponder.getUnavailableMessage();
                        Class<OCInspections.DeprecatedAPI> clazz = OCInspections.DeprecatedAPI.class;
                        clangID = "CIDR";
                        isError = true;
                        break block22;
                    }
                    if (firstResponder == null || !firstResponder.isDeprecated()) break block25;
                    message = firstResponder.getDeprecatedMessage();
                    Class<OCInspections.DeprecatedAPI> clazz = OCInspections.DeprecatedAPI.class;
                    clangID = "warn_deprecated";
                    highlightType = ProblemHighlightType.LIKE_DEPRECATED;
                    break block22;
                }
                if (firstResponder != null) {
                    void var6_12;
                    message = OCResolveUtil.checkAvailability(firstResponder, expression);
                    if (message != null) {
                        Class<OCInspections.UnavailableInDeploymentTarget> clazz = OCInspections.UnavailableInDeploymentTarget.class;
                        clangID = "CIDR";
                        highlightType = ProblemHighlightType.LIKE_DEPRECATED;
                    }
                    if (var6_12 == null && !OCResolveUtil.isEarlierInCode((OCSymbol)firstResponder, expression)) {
                        OCClassSymbol curClass;
                        OCClassDeclaration oCClassDeclaration = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)expression, OCClassDeclaration.class);
                        OCClassSymbol oCClassSymbol = curClass = oCClassDeclaration != null ? oCClassDeclaration.getSymbol() : null;
                        if (!Comparing.equal((Object)curClass, firstResponder.getParent())) {
                            message = "Method '" + selector + "' is declared in another category/implementation later in the scope";
                        } else if (!OCCompilerHelper.supportsLaterMethodDeclaration()) {
                            message = "Method '" + selector + "' is declared later in the scope";
                            quickFixes.add(new OCMoveDefinitionIntentionAction(OCSymbolKind.METHOD, expression, null, firstResponder, " above"));
                            quickFixes.add(new OCDeclareMethodInPrivateCategoryIntentionAction(){

                                @Override
                                protected OCClassSymbol getParent(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
                                    if (project == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/daemon/OCResolveAnnotator$3", "getParent"));
                                    }
                                    if (file2 == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/daemon/OCResolveAnnotator$3", "getParent"));
                                    }
                                    return (OCClassSymbol)firstResponder.getParent();
                                }

                                @Override
                                public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
                                    if (project == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/daemon/OCResolveAnnotator$3", "isAvailable"));
                                    }
                                    return OCSearchScope.isInProjectSources(firstResponder);
                                }

                                @Override
                                protected OCMethodSymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file2) {
                                    if (project == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/daemon/OCResolveAnnotator$3", "locateCandidate"));
                                    }
                                    return firstResponder;
                                }
                            });
                        }
                        Class<OCInspections.MethodIsLaterInTheScope> clazz = OCInspections.MethodIsLaterInTheScope.class;
                        quickFixes.add(new OCDeclareMethodInInterfaceIntentionAction(){

                            @Override
                            protected OCClassSymbol getParent(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
                                if (project == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/daemon/OCResolveAnnotator$4", "getParent"));
                                }
                                if (file2 == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/daemon/OCResolveAnnotator$4", "getParent"));
                                }
                                return (OCClassSymbol)firstResponder.getParent();
                            }

                            @Override
                            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
                                if (project == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/daemon/OCResolveAnnotator$4", "isAvailable"));
                                }
                                return OCSearchScope.isInProjectSources(firstResponder);
                            }

                            @Override
                            protected OCMethodSymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file2) {
                                if (project == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/daemon/OCResolveAnnotator$4", "locateCandidate"));
                                }
                                return firstResponder;
                            }
                        });
                    }
                }
                break block22;
            }
            while (iterator.hasNext()) {
                OCMessageArgument argument2 = iterator.next();
                selectors.add(argument2.getArgumentSelector().getSelectorName());
                OCExpression argumentExpression = argument2.getArgumentExpression();
                expressions.add(argumentExpression);
                argumentTypes.add(argumentExpression != null ? OCExpectedTypeUtil.getExpressionType(argumentExpression, true) : null);
            }
            OCMethodSymbol similarResponder = OCObjectTypeContext.findSimilarResponder(receiverType, selectors, argumentTypes, expression.getContainingFile());
            quickFixes.add(new OCChangeMethodSignatureIntentionAction(similarResponder, argumentTypes, selectors, expressions));
            OCObjectTypeContext receiverContext = expression.getReceiverContext();
            if (OCNameSuggester.isObjCGetter(selector) && (receiverContext == null || receiverContext.getStaticMode() != OCObjectTypeContext.StaticMode.STATIC)) {
                OCType propertyType = returnExpectedType.isVoid() ? OCIdType.pointerToID(expression.getProject()) : returnExpectedType;
                quickFixes.add(new OCCreateNewDefinitionIntentionAction(OCSymbolKind.PROPERTY, expression, receiverType.getInterface(), selector, propertyType));
            }
            if (OCNameSuggester.isObjCSetter(selector) && OCElementUtil.startsWithWord(selector, "set") && expression.getArguments().size() == 1 && (argument = expression.getArguments().get(0).getArgumentExpression()) != null) {
                String name = OCNameSuggester.getObjCGetterFromSetter(selector);
                quickFixes.add(new OCCreateNewDefinitionIntentionAction(OCSymbolKind.PROPERTY, expression, receiverType.getInterface(), name, argument.getResolvedType()));
            }
        }
        if (message == null) return;
        Annotation annotation = isError ? this.addErrorAnnotation(expression, (Class<? extends OCInspection>)var6_14, clangID, message) : this.addWarningAnnotation(expression, (Class<? extends OCInspection>)var6_14, clangID, message, isInfo ? ProblemHighlightType.WEAK_WARNING : highlightType);
        Iterator iterator = quickFixes.iterator();
        while (iterator.hasNext()) {
            IntentionAction intentionAction = (IntentionAction)iterator.next();
            this.registerQuickFix(annotation, intentionAction);
        }
    }

    @Override
    public void visitGenericParameter(OCGenericParameter parameter) {
        this.highlight(parameter.getNameIdentifier(), OCHighlightingKeys.GENERIC_PARAMETER);
    }

    private static boolean haveSingleRoot(List<OCMethodSymbol> methods) {
        if (methods.size() <= 1) {
            return true;
        }
        final HashSet<OCMethodSymbol> set = new HashSet<OCMethodSymbol>();
        set.addAll(methods);
        OCMemberInheritorsSearch.SearchParameters<OCMemberSymbol> parameters = OCMemberInheritorsSearch.getParameters((OCMemberSymbol)methods.get(0));
        parameters.setInheritors(true);
        parameters.setAncestors(true);
        parameters.setIncludeSelfImplementation(true);
        OCMemberInheritorsSearch.search(parameters).forEach((Processor)new Processor<OCMethodSymbol>(){

            public boolean process(OCMethodSymbol method) {
                set.remove(method);
                return true;
            }
        });
        return set.isEmpty();
    }

    @Nullable
    private static TextAttributesKey getTextAttributesKeyByKind(@NotNull OCSymbolKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/cidr/lang/daemon/OCResolveAnnotator", "getTextAttributesKeyByKind"));
        }
        switch (kind) {
            case LOCAL_VARIABLE: {
                return OCHighlightingKeys.LOCAL_VARIABLE;
            }
            case PARAMETER: {
                return OCHighlightingKeys.PARAMETER;
            }
            case INTERFACE: 
            case IMPLEMENTATION: 
            case COMPATIBILITY_ALIAS: {
                return OCHighlightingKeys.CLASS_REFERENCE;
            }
            case PROTOCOL: {
                return OCHighlightingKeys.PROTOCOL_REFERENCE;
            }
            case INSTANCE_VARIABLE: {
                return OCHighlightingKeys.INSTANCE_VARIABLE;
            }
            case PROPERTY: {
                return OCHighlightingKeys.PROPERTY;
            }
            case METHOD: {
                return OCHighlightingKeys.MESSAGE_ARGUMENT;
            }
            case CATCH_EXCEPTION_VARIABLE: {
                break;
            }
            case TYPEDEF: 
            case USING_SYMBOL_ALIAS: {
                return OCHighlightingKeys.TYPEDEF;
            }
            case FUNCTION_PREDECLARATION: 
            case FUNCTION_DECLARATION: 
            case CPP_CONSTRUCTOR_PREDECLARATION: 
            case CPP_CONSTRUCTOR_DECLARATION: {
                return OCHighlightingKeys.FUNCTION;
            }
            case TEMPLATE_TYPE_PARAMETER: {
                return OCHighlightingKeys.TEMPLATE_TYPE;
            }
            case TEMPLATE_VALUE_PARAMETER: {
                return OCHighlightingKeys.TEMPLATE_VALUE;
            }
            case NAMESPACE: 
            case NAMESPACE_ALIAS: {
                return OCHighlightingKeys.NAMESPACE_LIKE;
            }
            case MACRO: 
            case UNDEF_MACRO: {
                return OCHighlightingKeys.MACRONAME;
            }
            case MACRO_PARAMETER: {
                return OCHighlightingKeys.MACRO_PARAMETER;
            }
            case STRUCT: 
            case UNION: 
            case ENUM: {
                return OCHighlightingKeys.STRUCT_LIKE;
            }
            case ENUM_CONST: {
                return OCHighlightingKeys.ENUM_CONST;
            }
            case STRUCT_FIELD: {
                return OCHighlightingKeys.STRUCT_FIELD;
            }
            case GLOBAL_VARIABLE: 
            case GLOBAL_VARIABLE_PREDECLARATION: {
                return OCHighlightingKeys.GLOBAL_VARIABLE;
            }
            case BUILTIN_SYMBOL: {
                break;
            }
            case SYNTHESIZE: {
                return OCHighlightingKeys.PROPERTY;
            }
            case BLOCK: {
                break;
            }
            case LABEL: {
                return OCHighlightingKeys.LABEL;
            }
            case GENERIC_PARAMETER: {
                return OCHighlightingKeys.GENERIC_PARAMETER;
            }
        }
        return null;
    }
}

