/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.psi.PsiReference;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OCLValueVisitor
extends OCVisitor {
    private OCSymbol mySymbol;
    private int numOfDereferences;
    private boolean wasUnresolvedSymbol;
    private boolean processCalls;

    public OCLValueVisitor() {
    }

    public OCLValueVisitor(boolean processCalls) {
        this.processCalls = processCalls;
    }

    @Override
    public void visitQualifiedExpression(OCQualifiedExpression expression) {
        CommonProcessors.FindFirstProcessor collector = new CommonProcessors.FindFirstProcessor();
        expression.processTargets(expression.getName(), (Processor<OCSymbol>)collector, false, null, true, false, null);
        this.mySymbol = (OCSymbol)collector.getFoundValue();
        if (this.mySymbol == null) {
            this.wasUnresolvedSymbol = true;
        }
    }

    @Override
    public void visitReferenceExpression(OCReferenceExpression expression) {
        OCElementTypes.SelfSuperToken token = expression.getSelfSuperToken();
        if (token != null) {
            this.wasUnresolvedSymbol = token == OCElementTypes.SelfSuperToken.SELF;
            return;
        }
        this.mySymbol = expression.resolveToSymbol();
        if (this.mySymbol == null) {
            this.wasUnresolvedSymbol = true;
        }
    }

    @Override
    public void visitCallExpression(OCCallExpression expression) {
        if (this.processCalls) {
            expression.getFunctionReferenceExpression().accept(this);
        } else if (expression.getResolvedType() instanceof OCCppReferenceType) {
            this.wasUnresolvedSymbol = true;
        }
    }

    @Override
    public void visitBinaryExpression(OCBinaryExpression expression) {
        PsiReference reference = expression.getReference();
        if (reference != null && reference.resolve() != null) {
            return;
        }
        OCElementType sign = expression.getOperationSign();
        if ((sign == OCTokenTypes.DOT_MUL || sign == OCTokenTypes.DEREF_MUL) && OCLValueVisitor.isLvalue(expression.getLeft())) {
            this.wasUnresolvedSymbol = true;
        }
    }

    @Override
    public void visitAssignmentExpression(OCAssignmentExpression expression) {
        if (expression.getOperationSign() == OCTokenTypes.EQ) {
            expression.getReceiverExpression().accept(this);
        }
    }

    @Override
    public void visitSendMessageExpression(OCSendMessageExpression expression) {
        if (this.processCalls) {
            List<OCMethodSymbol> symbols = expression.getProbableResponders().getFilteredByStaticnessResponders();
            if (symbols.size() == 1) {
                this.mySymbol = symbols.get(0);
            }
        } else if (expression.getResolvedType() instanceof OCCppReferenceType) {
            this.wasUnresolvedSymbol = true;
        }
    }

    @Override
    public void visitParenthesizedExpression(OCParenthesizedExpression expression) {
        OCExpression operand = expression.getOperand();
        if (operand != null) {
            operand.accept(this);
        }
    }

    @Override
    public void visitCastExpression(OCCastExpression expression) {
        OCExpression operand = expression.getOperand();
        if (operand != null) {
            operand.accept(this);
        }
    }

    @Override
    public void visitUnaryExpression(OCUnaryExpression expression) {
        OCElementType sign = expression.getOperationSign();
        OCExpression operand = expression.getOperand();
        if (sign == OCTokenTypes.MUL) {
            ++this.numOfDereferences;
            if (operand != null) {
                operand.accept(this);
            }
        } else if ((sign == OCTokenTypes.__IMAG__KEYWORD || sign == OCTokenTypes.__REAL__KEYWORD) && operand != null) {
            operand.accept(this);
        }
    }

    @Override
    public void visitArraySelectionExpression(OCArraySelectionExpression expression) {
        ++this.numOfDereferences;
        expression.getArrayExpression().accept(this);
    }

    @Nullable
    public static OCSymbol getSymbol(OCExpression expr) {
        OCLValueVisitor visitor = new OCLValueVisitor();
        if (expr != null) {
            expr.accept(visitor);
        }
        return visitor.getSymbol();
    }

    public static boolean isConst(OCExpression expression) {
        if ((expression = OCParenthesesUtils.diveIntoParenthesesAndCasts(expression)) == null) {
            return false;
        }
        if (expression instanceof OCConditionalExpression && expression.getContainingOCFile().isCpp()) {
            return OCLValueVisitor.isConst(((OCConditionalExpression)expression).getPositiveExpression(true)) && OCLValueVisitor.isConst(((OCConditionalExpression)expression).getNegativeExpression());
        }
        OCLValueVisitor visitor = new OCLValueVisitor();
        expression.accept(visitor);
        OCSymbol symbol = visitor.getSymbol();
        return visitor.getNumOfDereferences() == 0 && symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isConst();
    }

    public static boolean isLvalue(@Nullable OCExpression expr) {
        if ((expr = OCParenthesesUtils.diveIntoParenthesesAndCasts(expr)) instanceof OCConditionalExpression && expr.getContainingOCFile().isCpp()) {
            return OCLValueVisitor.isLvalue(((OCConditionalExpression)expr).getPositiveExpression(true)) && OCLValueVisitor.isLvalue(((OCConditionalExpression)expr).getNegativeExpression());
        }
        OCLValueVisitor visitor = new OCLValueVisitor();
        if (expr != null) {
            expr.accept(visitor);
        }
        OCSymbol symbol = visitor.getSymbol();
        if (visitor.wasUnresolvedSymbol() || visitor.getNumOfDereferences() > 0 || symbol != null && symbol.getKind() != OCSymbolKind.TYPEDEF) {
            return true;
        }
        if (expr != null) {
            OCType type = expr.getResolvedType();
            return type instanceof OCCppReferenceType || type instanceof OCMagicType;
        }
        return false;
    }

    public static boolean isLvalue(@Nullable OCExpressionSymbol expr) {
        return false;
    }

    public static boolean isLvalue(@Nullable Object expr) {
        if (expr instanceof OCExpression) {
            return OCLValueVisitor.isLvalue((OCExpression)expr);
        }
        if (expr instanceof OCExpressionSymbol) {
            return OCLValueVisitor.isLvalue((OCExpressionSymbol)expr);
        }
        return false;
    }

    public OCSymbol getSymbol() {
        return this.mySymbol;
    }

    public int getNumOfDereferences() {
        return this.numOfDereferences;
    }

    public boolean wasUnresolvedSymbol() {
        return this.wasUnresolvedSymbol;
    }
}

