/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCConstantExpressionVisitor;
import com.jetbrains.cidr.lang.daemon.OCCppChecker;
import com.jetbrains.cidr.lang.daemon.OCDeclaratorChecker;
import com.jetbrains.cidr.lang.daemon.OCImplementationChecker;
import com.jetbrains.cidr.lang.daemon.OCLValueVisitor;
import com.jetbrains.cidr.lang.daemon.OCOperatorsChecker;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAnalyzer;
import com.jetbrains.cidr.lang.inspections.OCGlobalUnusedInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCAttributesList;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBoxedExpression;
import com.jetbrains.cidr.lang.psi.OCBreakStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCatchSection;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclaration;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCContinueStatement;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCNSArrayLiteral;
import com.jetbrains.cidr.lang.psi.OCNSDictionaryLiteral;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCProtocolExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedDesignator;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCSynchronizedStatement;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCThrowExpression;
import com.jetbrains.cidr.lang.psi.OCTryStatement;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.OCUnion;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import com.jetbrains.cidr.lang.psi.impl.OCDefineDirectiveImpl;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCAddRawStringSuffix;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCreateNewDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCImportsOptimizer;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OCErrorAnnotator
extends OCAnnotator {
    public OCErrorAnnotator() {
        this.myOperatorsChecker = new OCOperatorsChecker();
        this.myDeclaratorChecker = new OCDeclaratorChecker();
        this.myCppChecker = new OCCppChecker();
        this.myImplementationChecker = new OCImplementationChecker();
        this.myOperatorsChecker.copyCheckers(this);
        this.myDeclaratorChecker.copyCheckers(this);
        this.myCppChecker.copyCheckers(this);
        this.myImplementationChecker.copyCheckers(this);
    }

    @Override
    public void setHolder(@Nullable AnnotationHolder holder, @Nullable PsiElement annotatingElement) {
        super.setHolder(holder, annotatingElement);
        this.myOperatorsChecker.setHolder(holder, annotatingElement);
        this.myDeclaratorChecker.setHolder(holder, annotatingElement);
        this.myCppChecker.setHolder(holder, annotatingElement);
        this.myImplementationChecker.setHolder(holder, annotatingElement);
    }

    public void visitElement(PsiElement element) {
        OCClassSymbol symbol;
        super.visitElement(element);
        PsiElement parent = element.getParent();
        if (parent instanceof OCStruct && element == ((OCStruct)parent).getNameIdentifier() && ((OCFile)element.getContainingFile()).isCpp()) {
            this.myCppChecker.checkClass((OCStruct)parent);
        }
        if (!(parent instanceof OCClassDeclaration) || element != ((OCClassDeclaration)parent).getNameIdentifier()) {
            return;
        }
        if (parent instanceof OCInterface) {
            if (this.myDeclaratorChecker.checkDuplicates((OCInterface)parent)) {
                this.myImplementationChecker.checkInterfaceDeclaration((OCInterface)parent);
            }
        } else if (parent instanceof OCImplementation) {
            if (this.myDeclaratorChecker.checkDuplicates((OCImplementation)parent)) {
                this.myImplementationChecker.checkInterfaceImplementation((OCImplementation)parent);
            }
        } else if (parent instanceof OCProtocol) {
            if (this.myDeclaratorChecker.checkDuplicates((OCProtocol)parent)) {
                this.myImplementationChecker.checkProtocolDeclaration((OCProtocol)parent);
            }
        } else if (parent instanceof OCClassPredeclaration && (symbol = ((OCClassPredeclaration)parent).getSymbol()) != null) {
            OCClassSymbol definitionSymbol = symbol.getDefinitionSymbol();
            if (definitionSymbol != null) {
                OCGlobalUnusedInspection.markSymbolAsUsed(definitionSymbol, null);
            } else if (OCCodeInsightUtil.isValid((PsiElement)element.getContainingFile())) {
                Annotation annotation = this.addWarningAnnotation(((OCClassPredeclaration)parent).getNameIdentifier(), OCInspections.NoClassDefinition.class, "warn_undef_protocolref", "Can't find " + symbol.getNameWithKindLowercase() + " in the project and external files");
                this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(OCSymbolKind.INTERFACE, element, null, symbol.getName(), null));
                this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(OCSymbolKind.PROTOCOL, element, null, symbol.getName(), null));
                this.registerQuickFix(annotation, new OCRemoveDeclarationIntentionAction(symbol));
            }
        }
    }

    @Override
    public void visitReferenceExpression(OCReferenceExpression expr) {
        PsiElement parent;
        super.visitReferenceExpression(expr);
        PsiElement nonParethesizedParent = parent = expr.getParent();
        while (nonParethesizedParent instanceof OCParenthesizedExpression) {
            nonParethesizedParent = nonParethesizedParent.getParent();
        }
        boolean nonExprPossible = parent instanceof OCSendMessageExpression && ((OCSendMessageExpression)parent).getReceiverExpression() == expr || parent instanceof OCQualifiedExpression && ((OCQualifiedExpression)parent).getQualifier() == expr || nonParethesizedParent instanceof OCSizeofExpression || parent instanceof OCCallExpression && expr.getContainingOCFile().isCpp() || parent instanceof OCTemplateArgumentList;
        OCElementTypes.SelfSuperToken token = expr.getSelfSuperToken();
        if (token != null) {
            OCMethod method;
            if (new OCReadWriteAccessDetector().getExpressionAccess(expr) == ReadWriteAccessDetector.Access.Write && (method = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)expr, OCMethod.class)) != null && !method.getSelector().startsWith("init")) {
                this.addErrorAnnotation(expr, OCInspections.NotAssignable.class, "err_typecheck_arc_assign_self", "Assignment to self is allowed only in init methods");
                return;
            }
            if (token == OCElementTypes.SelfSuperToken.SELF) {
                return;
            }
            OCClassDeclaration clazz = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)expr, (Class[])new Class[]{OCClassDeclaration.class});
            if (clazz == null) {
                return;
            }
            OCObjectType type = clazz.getType();
            if (type != null && type.getSuperType() == null) {
                this.addErrorAnnotation(expr, "CIDR", "Class '" + type.getName(expr) + "' doesn't have a superclass");
            }
            return;
        }
        OCSymbol symbol = expr.resolveToSymbol();
        if (symbol != null) {
            List<OCSymbol> symbols;
            if (symbol.getKind() == OCSymbolKind.SYMBOL_USING_SYMBOL && (symbols = ((OCUsingSymbol)symbol).getSymbolReference().resolveToSymbols(expr.getContainingOCFile())).size() != 0) {
                symbol = symbols.get(0);
            }
            if (!nonExprPossible && !symbol.getKind().isExpression() && symbol.getKind() != OCSymbolKind.MACRO) {
                this.addErrorAnnotation(expr, "CIDR", "Expression expected");
            }
        }
    }

    @Override
    public void visitReferenceElement(OCReferenceElement referenceElement) {
        super.visitReferenceElement(referenceElement);
        this.myDeclaratorChecker.checkReferenceElement(referenceElement);
    }

    @Override
    public void visitLabeledStatement(OCLabeledStatement stmt) {
        super.visitLabeledStatement(stmt);
        this.myDeclaratorChecker.checkDuplicates(stmt);
    }

    private void checkCaseType(OCExpression caseExpr, OCType switchType) {
        if (caseExpr == null) {
            return;
        }
        OCType caseType = caseExpr.getResolvedType();
        if (switchType instanceof OCCppReferenceType) {
            switchType = ((OCCppReferenceType)switchType).getRefType();
        }
        if (caseType.isUnknown()) {
            return;
        }
        if (!(caseType.isIntegerCompatible(caseExpr) || caseType instanceof OCStructType && ((OCStructType)caseType).isEnumClass())) {
            String message = "Integer expression is required in 'case' statement instead of '" + caseType.getName(caseExpr) + "'";
            Annotation annotation = this.addErrorAnnotation(caseExpr, OCInspections.IntegerTypeRequired.class, "err_expr_not_ice", message);
            this.registerQuickFix(annotation, OCChangeTypeIntentionAction.getAction(caseExpr, OCIntType.CHAR));
            return;
        }
        if (!new OCConstantExpressionVisitor().isConstant(caseExpr)) {
            this.addErrorAnnotation(caseExpr, OCInspections.IntegerTypeRequired.class, "err_expr_not_ice", "Constant expression is required");
            return;
        }
        String message = "Case expression type '" + caseType.getName(caseExpr) + "' is incompatible with switch expression type '" + switchType.getName(caseExpr) + "': ";
        this.checkAssignment(caseExpr, caseExpr, switchType, caseType, message);
    }

    @Override
    public void visitCaseStatement(OCCaseStatement stmt) {
        super.visitCaseStatement(stmt);
        OCSwitchStatement switchStmt = (OCSwitchStatement)PsiTreeUtil.getContextOfType((PsiElement)stmt, (Class[])new Class[]{OCSwitchStatement.class});
        if (switchStmt == null) {
            this.addErrorAnnotation(stmt, OCInspections.ConstructionIsNotAllowed.class, "err_case_not_in_switch", "Case label is outside of a switch");
            return;
        }
        OCDeclarationOrExpression switchExpr = switchStmt.getExpression();
        if (switchExpr == null) {
            return;
        }
        OCType switchType = switchExpr.getResolvedType();
        if (stmt.isRange()) {
            this.checkCaseType(stmt.getRangeFirst(), switchType);
            this.checkCaseType(stmt.getRangeSecond(), switchType);
        } else {
            this.checkCaseType(stmt.getExpression(), switchType);
        }
    }

    private void checkConditionalStatement(@Nullable OCElement condition, @Nullable OCType conditionType, String elementName, OCStatement ... statementBlocks) {
        OCDeclarationOrExpression declOrExpr;
        OCDeclaration declaration;
        for (OCStatement statement : statementBlocks) {
            if (!(statement instanceof OCDeclarationStatement) || !OCCodeInsightUtil.isInPlainOldC(statement)) continue;
            Annotation annotation = this.addErrorAnnotation(statement, "CIDR", "Declaration is not allowed here");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)statement, "Remove statement"));
        }
        if (condition instanceof OCDeclarationOrExpression && (declaration = (declOrExpr = (OCDeclarationOrExpression)condition).getDeclaration()) != null && declOrExpr.getExpression() == null) {
            if (!condition.getContainingOCFile().isCpp()) {
                this.addErrorAnnotation(condition, OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Declaration is not allowed here");
            } else if (declaration.getDeclarators().isEmpty()) {
                this.addErrorAnnotation(condition, "err_expected_unqualified_id", "Declaration or expression is expected");
            } else if (declaration.getDeclarators().size() > 1) {
                this.addErrorAnnotation(condition, "CIDR", "Only one declarator is allowed here");
            } else {
                OCDeclarator declarator = declaration.getDeclarators().get(0);
                if (declarator.getInitializer() == null) {
                    Annotation annotation = this.addErrorAnnotation(condition, OCInspections.InitializerIssues.class, "err_expected_init_in_condition", "Initializer is expected");
                    this.registerQuickFix(annotation, new OCAddInitializerIntentionAction(declarator, declarator.getSymbol()));
                }
            }
        }
        if (conditionType == null || conditionType.isUnknown()) {
            return;
        }
        if (!conditionType.isScalarOrConvertibleToScalar(condition)) {
            String message = "Type '" + conditionType.getName(condition) + "' used in '" + elementName + "' condition is not scalar";
            this.addErrorAnnotation(condition, OCInspections.ScalarTypeRequired.class, "err_typecheck_statement_requires_scalar", message);
        }
    }

    @Override
    public void visitIfStatement(OCIfStatement stmt) {
        super.visitIfStatement(stmt);
        OCDeclarationOrExpression condition = stmt.getCondition();
        if (condition != null) {
            this.checkConditionalStatement(condition, condition.getResolvedType(), "if", stmt.getThenBranch(), stmt.getElseBranch());
        }
    }

    @Override
    public void visitWhileStatement(OCWhileStatement stmt) {
        super.visitWhileStatement(stmt);
        OCDeclarationOrExpression condition = stmt.getCondition();
        if (condition != null) {
            this.checkConditionalStatement(condition, condition.getResolvedType(), "while", stmt.getBody());
        }
    }

    @Override
    public void visitDoWhileStatement(OCDoWhileStatement stmt) {
        super.visitDoWhileStatement(stmt);
        OCExpression condition = stmt.getCondition();
        if (condition != null) {
            OCType conditionType = condition.getResolvedType();
            this.checkConditionalStatement(condition, conditionType, "do-while", stmt.getBody());
        }
    }

    @Override
    public void visitForStatement(OCForStatement stmt) {
        super.visitForStatement(stmt);
        OCDeclarationOrExpression condition = stmt.getCondition();
        this.checkConditionalStatement(condition, condition != null ? condition.getResolvedType() : null, "for", stmt.getBody());
    }

    @Override
    public void visitForeachStatement(OCForeachStatement statement) {
        super.visitForeachStatement(statement);
        this.myOperatorsChecker.checkForeach(statement);
        this.checkConditionalStatement(null, null, "foreach", statement.getBody());
    }

    @Override
    public void visitReturnStatement(OCReturnStatement stmt) {
        super.visitReturnStatement(stmt);
        this.myOperatorsChecker.checkReturnStatement(stmt);
    }

    @Override
    public void visitBreakStatement(OCBreakStatement stmt) {
        super.visitBreakStatement(stmt);
        if (PsiTreeUtil.getContextOfType((PsiElement)stmt, (Class[])new Class[]{OCLoopStatement.class, OCSwitchStatement.class}) == null) {
            this.addErrorAnnotation(stmt, OCInspections.ConstructionIsNotAllowed.class, "err_break_not_in_loop_or_switch", "'break' statement is outside of a loop or switch");
        }
    }

    @Override
    public void visitContinueStatement(OCContinueStatement stmt) {
        super.visitContinueStatement(stmt);
        if (PsiTreeUtil.getContextOfType((PsiElement)stmt, (Class[])new Class[]{OCLoopStatement.class}) == null) {
            this.addErrorAnnotation(stmt, OCInspections.ConstructionIsNotAllowed.class, "err_continue_not_in_loop", "'continue' statement is outside of a loop");
        }
    }

    @Override
    public void visitSwitchStatement(OCSwitchStatement stmt) {
        super.visitSwitchStatement(stmt);
        this.myOperatorsChecker.checkSwitchStatement(stmt);
    }

    private void checkExceptionExpression(OCExpression expression) {
        if (expression == null) {
            return;
        }
        OCType type = expression.getResolvedType();
        if (!(type.isUnknown() || type.isPointerToObject() || type.isClassType())) {
            this.addErrorAnnotation(expression, OCInspections.PointerTypeRequired.class, "error_objc_throw_expects_object", "Expression type '" + type.getName(expression) + "' is not a pointer to object");
        }
    }

    @Override
    public void visitSynchronizedStatement(OCSynchronizedStatement stmt) {
        super.visitSynchronizedStatement(stmt);
        this.checkExceptionExpression(stmt.getLockExpression());
    }

    @Override
    public void visitThrowExpression(OCThrowExpression expression) {
        super.visitThrowExpression(expression);
        if (expression.isCppStatement()) {
            return;
        }
        this.checkExceptionExpression(expression.getExceptionExpression());
        if (expression.getExceptionExpression() == null && PsiTreeUtil.getParentOfType((PsiElement)expression, OCCatchSection.class, (boolean)true, (Class[])new Class[]{OCCallable.class}) == null) {
            this.addErrorAnnotation(expression, "error_rethrow_used_outside_catch", "@throw (rethrow) is used outside of a @catch block");
        }
    }

    @Override
    public void visitTryStatement(OCTryStatement stmt) {
        if (stmt.getCatchSections().isEmpty() && stmt.getFinallySection() == null) {
            this.addErrorAnnotation(stmt, "err_missing_catch_finally", stmt.getContainingOCFile().isCpp() ? "Missing catch or finally" : "Missing @catch or @finally");
        }
    }

    @Override
    public void visitCatchSection(OCCatchSection catchSection) {
        super.visitCatchSection(catchSection);
        OCParameterList paramList = catchSection.getParameters();
        if (paramList == null) {
            return;
        }
        if (paramList.getParameterDeclarations().size() != 1) {
            Annotation annotation = this.addErrorAnnotation(paramList, "CIDR", "Only one variable declaration is allowed");
            for (int i = paramList.getParameterDeclarations().size() - 1; i >= 1; --i) {
                this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)paramList.getParameterDeclarations().get(i), "Remove extra declarators"));
            }
            return;
        }
        OCDeclarator declarator = paramList.getParameterDeclarations().get(0).getDeclarator();
        if (declarator == null || catchSection.isCppStatement()) {
            return;
        }
        OCType type = declarator.getResolvedType();
        if (!(type.isUnknown() || type.isPointerToObject() || type.isClassType())) {
            this.addErrorAnnotation(declarator.getNameIdentifier(), OCInspections.PointerTypeRequired.class, "err_catch_param_not_objc_type", "Variable type ('" + type.getName(catchSection) + "') is not a pointer to object");
        }
    }

    @Override
    public void visitProperty(OCProperty property) {
        super.visitProperty(property);
        if (PsiTreeUtil.getContextOfType((PsiElement)property, (Class[])new Class[]{OCInterface.class, OCProtocol.class}) == null) {
            Annotation annotation = this.addErrorAnnotation(property, OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Property is declared outside of an interface/protocol");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)property, "Remove property"));
        }
    }

    @Override
    public void visitDeclarator(OCDeclarator declarator) {
        super.visitDeclarator(declarator);
        this.myDeclaratorChecker.checkDeclarator(declarator.getType(), declarator, declarator, declarator.getSymbol());
    }

    @Override
    public void visitDefineDirective(OCDefineDirectiveImpl directive) {
        this.myDeclaratorChecker.checkDuplicates(directive.getName(), directive, Collections.singletonList(directive));
    }

    @Override
    public void visitStructLike(OCStructLike struct) {
        super.visitStructLike(struct);
        if (struct.getContainingOCFile().isCpp()) {
            PsiElement context = struct.getContext();
            if (context == null || PsiTreeUtil.getChildOfType((PsiElement)context.getContext(), OCTemplateParameterList.class) == null) {
                this.myDeclaratorChecker.checkDuplicates(struct);
            }
        } else {
            List<PsiElement> navigationElements = Collections.singletonList(struct.getNameIdentifier());
            String structName = OCSymbolKind.STRUCT.getNameLowercase() + " " + struct.getName();
            String enumName = OCSymbolKind.ENUM.getNameLowercase() + " " + struct.getName();
            String unionName = OCSymbolKind.UNION.getNameLowercase() + " " + struct.getName();
            boolean bl = this.myDeclaratorChecker.checkDuplicates(structName, struct.getSymbol(), struct, navigationElements) && this.myDeclaratorChecker.checkDuplicates(enumName, struct.getSymbol(), struct, navigationElements) && this.myDeclaratorChecker.checkDuplicates(unionName, struct.getSymbol(), struct, navigationElements);
        }
    }

    @Override
    public void visitDeclaration(OCDeclaration declaration) {
        OCDeclarator declarator;
        OCSymbol symbol;
        super.visitDeclaration(declaration);
        PsiElement parent = declaration.getParent();
        if (!(!(parent instanceof OCInterface) && !(parent instanceof OCProtocol) || declaration.getDeclarators().isEmpty() || declaration.isTypedef() || declaration instanceof OCFunctionDeclaration || (symbol = (declarator = declaration.getDeclarators().get(0)).getSymbol()) instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isExtern())) {
            Annotation annotation = this.addErrorAnnotation(declaration, OCInspections.ConstructionIsNotAllowed.class, "err_objc_var_decl_inclass", "Can't declare variables inside @interface or @protocol");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)declaration, "Remove declaration"));
            return;
        }
        OCTypeElement typeElement = declaration.getTypeElement();
        if (declaration.getDeclarators().isEmpty()) {
            OCType type;
            OCType oCType = type = typeElement != null ? typeElement.getType().resolve(declaration.getContainingFile()) : null;
            if (type == null || !(type instanceof OCStructType) && !type.isUnknown()) {
                Annotation annotation = this.addWarningAnnotation(declaration, OCInspections.UnusedExpressionResult.class, "ext_no_declarators", "Useless type name in empty declaration");
                this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)declaration, "Remove statement"));
            }
        } else if ((typeElement == null || typeElement.isEmpty()) && (parent instanceof OCProperty || parent instanceof OCInstanceVariablesList || parent instanceof OCStruct || parent instanceof OCUnion || !OCCodeInsightUtil.isInPlainOldC(parent) && (parent instanceof OCFile || parent instanceof OCCppNamespace))) {
            OCFunctionSymbol functionSymbol;
            if (declaration instanceof OCFunctionDeclaration && (symbol = (OCSymbolWithQualifiedName)((OCFunctionDeclaration)declaration).getSymbol()) instanceof OCFunctionSymbol && ((functionSymbol = (OCFunctionSymbol)symbol).isCppConstructor() || functionSymbol.isCppDestructor() || functionSymbol.isCppConversionOperator())) {
                return;
            }
            OCElement annotationRange = null;
            if (!declaration.getDeclarators().isEmpty()) {
                OCDeclarator declarator2 = declaration.getDeclarators().get(0);
                if (declarator2.getNamespaceQualifier() == null) {
                    annotationRange = declarator2.getNameIdentifier() != null ? declarator2.getNameIdentifier() : declarator2;
                }
            } else {
                annotationRange = declaration;
            }
            this.addErrorAnnotation(annotationRange, "CIDR", "Explicit type is required here");
        }
    }

    @Override
    public void visitMethod(OCMethod method) {
        super.visitMethod(method);
        this.myImplementationChecker.checkMethod(method);
    }

    @Override
    public void visitExpressionStatement(OCExpressionStatement stmt) {
        PsiReference reference;
        super.visitExpressionStatement(stmt);
        OCExpression expr = stmt.getExpression();
        if ((expr instanceof OCUnaryExpression || expr instanceof OCBinaryExpression || expr instanceof OCArraySelectionExpression) && (!((reference = expr.getReference()) instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0 && !((OCOperatorReference)reference).hasMagicOperands())) {
            Annotation annotation = this.addWarningAnnotation(expr, OCInspections.UnusedExpressionResult.class, "warn_unused_expr", "Expression result is unused");
            if (!OCCodeInsightUtil.hasSideEffects(expr)) {
                this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)stmt, "Remove statement"));
            }
        }
    }

    @Override
    public void visitMethodSelectorPart(OCMethodSelectorPart part) {
        super.visitMethodSelectorPart(part);
        this.myDeclaratorChecker.checkDeclarator(part.getType(), part, null, part.getLocalSymbol());
    }

    @Override
    public void visitAssignmentExpression(OCAssignmentExpression expression) {
        super.visitAssignmentExpression(expression);
        PsiReference reference = expression.getReference();
        if (!(reference instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0) {
            this.myOperatorsChecker.checkBinaryOperatorApplicable(expression.getReceiverExpression(), expression.getSourceExpression(), expression.getOperationSign(), expression);
        } else {
            this.checkOperatorVisibility(expression, (OCOperatorReference)reference);
        }
    }

    @Override
    public void visitBinaryExpression(OCBinaryExpression expression) {
        super.visitBinaryExpression(expression);
        PsiReference reference = expression.getReference();
        if (!(reference instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0) {
            this.myOperatorsChecker.checkBinaryOperatorApplicable(expression.getLeft(), expression.getRight(), expression.getOperationSign(), expression);
        } else {
            this.checkOperatorVisibility(expression, (OCOperatorReference)reference);
        }
    }

    @Override
    public void visitUnaryExpression(OCUnaryExpression expression) {
        super.visitUnaryExpression(expression);
        PsiReference reference = expression.getReference();
        if (!(reference instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0) {
            this.myOperatorsChecker.checkUnaryOperatorApplicable(expression.getOperand(), expression.getOperationSign(), expression);
        } else {
            this.checkOperatorVisibility(expression, (OCOperatorReference)reference);
        }
    }

    @Override
    public void visitPrefixExpression(OCPrefixExpression expression) {
        super.visitPrefixExpression(expression);
        PsiReference reference = expression.getReference();
        if (!(reference instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0) {
            this.myOperatorsChecker.checkUnaryOperatorApplicable(expression.getOperand(), expression.getOperationSign(), expression);
        } else {
            this.checkOperatorVisibility(expression, (OCOperatorReference)reference);
        }
    }

    @Override
    public void visitPostfixExpression(OCPostfixExpression expression) {
        super.visitPostfixExpression(expression);
        PsiReference reference = expression.getReference();
        if (!(reference instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0) {
            this.myOperatorsChecker.checkUnaryOperatorApplicable(expression.getOperand(), expression.getOperationSign(), expression);
        } else {
            this.checkOperatorVisibility(expression, (OCOperatorReference)reference);
        }
    }

    private void checkOperatorVisibility(OCExpression expression, OCOperatorReference reference) {
        OCSymbol operator = reference.resolveToSymbols().get(0);
        this.myOperatorsChecker.checkFieldVisibility(operator, expression, null);
    }

    @Override
    public void visitLiteralExpression(OCLiteralExpression expression) {
        String typeName;
        OCType type;
        super.visitLiteralExpression(expression);
        ASTNode child = expression.getNode().getFirstChildNode();
        if (!OCCompilerHelper.supportsObjectLiterals(expression.getContainingOCFile()) && (type = expression.getResolvedType()) instanceof OCPointerType && ("NSNumber".equals(typeName = ((OCPointerType)type).getRefType().getName()) || "NSArray".equals(typeName) || "NSDictionary".equals(typeName)) && this.myHolder != null) {
            this.myHolder.createErrorAnnotation((PsiElement)expression, typeName + " literals are not supported by the compiler");
        }
        while (child != null) {
            type = child.getElementType();
            if (type == OCTokenTypes.STRING_LITERAL) {
                String text = child.getText();
                if (text.startsWith("\"") && (text.length() == 1 || !text.endsWith("\"")) && this.myHolder != null) {
                    this.myHolder.createErrorAnnotation(child, "Unterminated string literal").setAfterEndOfLine(true);
                }
            } else if (type == OCTokenTypes.WRONG_RAW_STRING_LITERAL) {
                Annotation annotation = this.myHolder.createErrorAnnotation(child, "Invalid suffix on raw string");
                annotation.setNeedsUpdateOnTyping(true);
                this.registerQuickFix(annotation, new OCAddRawStringSuffix(child.getPsi()));
            } else if (type == OCTokenTypes.WRONG_INTEGER_LITERAL) {
                this.addErrorAnnotation(child.getPsi(), "err_invalid_suffix_integer_constant", "Invalid suffix on integer constant");
            } else if (type == OCTokenTypes.WRONG_FLOAT_LITERAL) {
                this.addErrorAnnotation(child.getPsi(), "err_invalid_suffix_float_constant", "Invalid suffix on floating constant");
            }
            child = child.getTreeNext();
        }
    }

    @Override
    public void visitArrayLiteral(OCNSArrayLiteral literal) {
        super.visitArrayLiteral(literal);
        for (OCExpression expression : literal.getElements()) {
            this.checkAssignment(expression, expression, OCIdType.pointerToID(literal.getProject()), expression.getResolvedType(), "");
        }
    }

    @Override
    public void visitDictionaryLiteral(OCNSDictionaryLiteral literal) {
        super.visitDictionaryLiteral(literal);
        for (OCExpression expression : literal.getElements()) {
            this.checkAssignment(expression, expression, OCIdType.pointerToID(literal.getProject()), expression.getResolvedType(), "");
        }
    }

    @Override
    public void visitCastExpression(OCCastExpression expression) {
        super.visitCastExpression(expression);
        this.myOperatorsChecker.checkCastExperssion(expression);
    }

    @Override
    public void visitArraySelectionExpression(OCArraySelectionExpression expression) {
        super.visitArraySelectionExpression(expression);
        OCExpression arrayExpr = expression.getArrayExpression();
        OCExpression indexExpr = expression.getIndexExpression();
        if (indexExpr == null) {
            return;
        }
        OCType arrayType = arrayExpr.getResolvedType();
        OCType indexType = indexExpr.getResolvedType();
        PsiReference reference = expression.getReference();
        if (!(reference instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0) {
            if (arrayType instanceof OCCppReferenceType) {
                arrayType = ((OCCppReferenceType)arrayType).getRefType();
            }
            if (arrayType.isPointerToObject() && OCCompilerHelper.supportsSubscripting(expression.getContainingOCFile())) {
                ReadWriteAccessDetector.Access accessType = new OCReadWriteAccessDetector().getExpressionAccess(expression);
                String accessorName = expression.getArraySubscriptAccessorName(indexType, accessType);
                if (accessorName != null) {
                    OCSymbol symbol;
                    String message = "Type '" + arrayType.getName(expression) + "' doesn't respond to '-" + accessorName + "'";
                    Annotation annotation = this.addErrorAnnotation(expression.getArrayExpression(), OCInspections.UnresolvedMessage.class, "err_objc_subscript_method_not_found", message);
                    OCObjectType receiverType = (OCObjectType)arrayType.getTerminalType();
                    OCClassSymbol parentClass = receiverType.getClassSymbol();
                    String signature = expression.getArraySubscriptMethodSignature(indexType, accessType);
                    OCVoidType returnType = accessType == ReadWriteAccessDetector.Access.Read ? OCIdType.pointerToID(expression.getProject()) : OCVoidType.instance();
                    this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(expression, parentClass, "-" + accessorName, signature, returnType, receiverType));
                    if (arrayType.getName().equals("NSArray *") && accessorName.equals("setObject:atIndexedSubscript:")) {
                        OCSymbol symbol2 = OCLValueVisitor.getSymbol(arrayExpr);
                        if (symbol2 != null && symbol2.getResolvedType().equals((Object)arrayType, arrayExpr)) {
                            OCPointerType newType = OCPointerType.to(OCReferenceType.resolvedFromText("NSMutableArray", arrayExpr.getContainingFile()));
                            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol2, newType));
                        }
                    } else if (arrayType.getName().equals("NSDictionary *") && accessorName.equals("setObject:forKeyedSubscript:") && (symbol = OCLValueVisitor.getSymbol(arrayExpr)) != null && symbol.getResolvedType().equals((Object)arrayType, arrayExpr)) {
                        OCPointerType newType = OCPointerType.to(OCReferenceType.resolvedFromText("NSMutableDictionary", arrayExpr.getContainingFile()));
                        this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol, newType));
                    }
                } else {
                    this.addErrorAnnotation(indexExpr, OCInspections.ArrayIssues.class, "err_objc_subscript_index_type", "Index expression must be an integer or an object pointer");
                }
            } else if (!arrayType.isSubclassOfMagic(expression)) {
                if (!arrayType.isUnknown() && !(arrayType instanceof OCPointerType)) {
                    this.addErrorAnnotation(expression.getArrayExpression(), OCInspections.ArrayIssues.class, "err_typecheck_subscript_value", "Subscripted value is not an array");
                    ((OCOperatorReference)reference).resolveToSymbols();
                } else if (!indexType.isUnknown() && !indexType.isIntegerCompatible(expression)) {
                    Annotation annotation = this.addErrorAnnotation(expression.getIndexExpression(), OCInspections.ArrayIssues.class, "err_objc_subscript_index_type", "Array index is not integer");
                    this.registerQuickFix(annotation, OCChangeTypeIntentionAction.getAction(expression.getIndexExpression(), OCIntType.CHAR));
                }
            }
        } else {
            OCSymbol operator = ((OCOperatorReference)reference).resolveToSymbols().get(0);
            this.myOperatorsChecker.checkFieldVisibility(operator, expression, null);
            if (operator instanceof OCMethodSymbol) {
                List<OCMethodSymbol.SelectorPartSymbol> selectors = ((OCMethodSymbol)operator).getSelectors();
                OCType indexRequiredType = selectors.get(selectors.size() - 1).getParameter().getType().resolve(expression.getContainingFile());
                this.checkAssignment(indexExpr, indexExpr, indexRequiredType, indexType, "Index type mismatch: ");
                OCExpression parentExpr = OCParenthesesUtils.topmostParenthesized(expression);
                if (parentExpr.getParent() instanceof OCAssignmentExpression && ((OCAssignmentExpression)parentExpr.getParent()).getReceiverExpression() == parentExpr) {
                    OCExpression sourceExpr = ((OCAssignmentExpression)parentExpr.getParent()).getSourceExpression();
                    OCType sourceRequiredType = selectors.get(0).getParameter().getType().resolve(expression.getContainingFile());
                    if (sourceExpr != null) {
                        this.checkAssignment(sourceExpr, sourceExpr, sourceRequiredType, sourceExpr.getResolvedType(), "");
                    }
                }
            }
        }
    }

    @Override
    public void visitCallExpression(OCCallExpression expression) {
        super.visitCallExpression(expression);
        this.myOperatorsChecker.checkCallExpression(expression);
    }

    @Override
    public void visitMacroCall(OCMacroCall macroCall) {
        super.visitMacroCall(macroCall);
        this.myOperatorsChecker.checkMacroCall(macroCall);
    }

    @Override
    public void visitSendMessageExpression(OCSendMessageExpression expression) {
        super.visitSendMessageExpression(expression);
        this.myOperatorsChecker.checkSendMessageExpression(expression);
    }

    @Override
    public void visitSelectorExpression(OCSelectorExpression expression) {
        super.visitSelectorExpression(expression);
        for (OCMethodSymbol method : expression.getReference().resolveToSymbols()) {
            OCFileSymbols.markSymbolAsUsed(expression.getContainingOCFile(), method, expression);
        }
    }

    @Override
    public void visitConditionalExpression(OCConditionalExpression expression) {
        OCType commonType;
        OCType rType;
        super.visitConditionalExpression(expression);
        OCType type = expression.getCondition().getResolvedType();
        if (!type.isUnknown() && !type.isScalarOrConvertibleToScalar(expression)) {
            this.addErrorAnnotation(expression.getCondition(), OCInspections.ScalarTypeRequired.class, OCClangMessageFinder.getInstance().getConditionShouldBeScalar(), "Type '" + type.getName(expression) + "' used in '?:' operator condition is not scalar");
        }
        OCExpression lExpr = expression.getPositiveExpression(true);
        OCExpression rExpr = expression.getNegativeExpression();
        if (lExpr == null || rExpr == null) {
            return;
        }
        OCType lType = lExpr.getResolvedType();
        if (lType instanceof OCCppReferenceType) {
            lType = ((OCCppReferenceType)lType).getRefType();
        }
        if ((rType = rExpr.getResolvedType()) instanceof OCCppReferenceType) {
            rType = ((OCCppReferenceType)rType).getRefType();
        }
        if ((commonType = expression.getResolvedType()) instanceof OCCppReferenceType) {
            commonType = ((OCCppReferenceType)commonType).getRefType();
        }
        String lTypeName = lType.getName(expression);
        String rTypeName = rType.getName(expression);
        String message = "Types '" + lTypeName + "' and '" + rTypeName + "' are not compatible";
        if (this.checkAssignment(lExpr, lExpr, commonType, lType, message) == null) {
            this.checkAssignment(rExpr, rExpr, commonType, rType, message);
        }
    }

    @Override
    public void visitQualifiedExpression(OCQualifiedExpression expression) {
        super.visitQualifiedExpression(expression);
        this.myOperatorsChecker.checkQualifiedExpression(expression);
    }

    @Override
    public void visitPropertyAttributesList(OCPropertyAttributesList attributes) {
        super.visitPropertyAttributesList(attributes);
        HashSet<OCPropertySymbol.PropertyAttribute> processedAttrs = new HashSet<OCPropertySymbol.PropertyAttribute>();
        for (OCPropertyAttribute attributeNode : attributes.getAttributes()) {
            String name = attributeNode.getName();
            if (name == null) continue;
            Annotation annotation = null;
            OCPropertySymbol.PropertyAttribute attribute = OCPropertySymbolImpl.parseAttribute(name);
            if (!OCCompilerHelper.supportsNullability(attributes.getContainingFile()) && attribute != null && attribute.getGroup() == 5) {
                attribute = null;
            }
            if (attribute != null) {
                List<OCDeclarator> declarators;
                OCProperty property;
                OCDeclaration declaration;
                for (OCPropertySymbol.PropertyAttribute processedAttr : processedAttrs) {
                    if (processedAttr == attribute) {
                        annotation = this.addWarningAnnotation(attributeNode.getNameIdentifier(), OCInspections.DuplicateAttribute.class, "CIDR", "Attribute '" + name + "' was already declared");
                        continue;
                    }
                    if (processedAttr.getGroup() != attribute.getGroup()) continue;
                    annotation = this.addErrorAnnotation(attributeNode.getNameIdentifier(), "err_objc_property_attr_mutually_exclusive", "Attributes '" + StringUtil.toLowerCase((String)processedAttr.name()) + "' and '" + name + "' are mutually exclusive");
                }
                if (OCPropertySymbol.PROPERTY_ATTRIBUTES_WITH_VALUE.contains((Object)attribute) && attributeNode.getValue() == null) {
                    this.addErrorAnnotation(attributeNode.getNameIdentifier(), "CIDR", "Attribute '" + name + "' requires a value");
                } else if (!OCPropertySymbol.PROPERTY_ATTRIBUTES_WITH_VALUE.contains((Object)attribute) && attributeNode.getValue() != null) {
                    this.addErrorAnnotation(attributeNode.getNameIdentifier(), "CIDR", "Attribute '" + name + "' mustn't have a value");
                } else if (OCPropertySymbol.PROPERTY_ATTRIBUTES_FOR_OBJECT.contains((Object)attribute) && attributeNode.getParent().getParent() instanceof OCProperty && (declaration = (property = (OCProperty)attributeNode.getParent().getParent()).getDeclaration()) != null && !(declarators = declaration.getDeclarators()).isEmpty()) {
                    OCDeclarator declarator = declarators.get(0);
                    OCType type = declarator.getResolvedType();
                    OCSymbol symbol = declarator.getSymbol();
                    if (!(declarators.size() <= 0 || type.isPointerToObjectCompatible() || symbol != null && symbol.hasAttribute("NSObject"))) {
                        String message = "Attribute '" + name + "' requires the property of object type instead of '" + type.getName(attributes) + "'";
                        this.addErrorAnnotation(attributeNode.getNameIdentifier(), "err_objc_property_requires_object", message);
                    }
                }
                processedAttrs.add(attribute);
            } else {
                annotation = this.addErrorAnnotation(attributeNode.getNameIdentifier(), "err_objc_expected_property_attr", "Unknown attribute '" + name + "'");
            }
            if (attributeNode.getColon() != null) {
                if ("getter".equals(name)) {
                    this.addErrorAnnotation(attributeNode.getColon(), "CIDR", "Colon is only allowed for 'setter' attribute");
                }
            } else if ("setter".equals(name)) {
                this.addErrorAnnotation(attributeNode.getValueElement(), "CIDR", "Colon is required for 'setter' attribute");
            }
            if (annotation == null) continue;
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)attributeNode, "Remove attribute"));
        }
    }

    @Override
    public void visitAttributeList(OCAttributesList list) {
        super.visitAttributeList(list);
        if (list.isMicrosoftAttributes() && !OCCompilerHelper.supportsMicrosoftAttributes(list.getContainingOCFile())) {
            this.addErrorAnnotation(list, "CIDR", "Microsoft attributes are not supported by the compiler");
        }
    }

    @Override
    public void visitTypeElement(OCTypeElement typeElement) {
        super.visitTypeElement(typeElement);
        for (ASTNode child : typeElement.getNode().getChildren(null)) {
            if (child.getElementType() != OCTokenTypes.UNDERLYING_TYPE_KEYWORD || OCCompilerHelper.supportsUnderlyingType(typeElement.getContainingFile())) continue;
            this.addErrorAnnotation(child.getPsi(), "CIDR", "__underlying_type is not supported by the compiler");
        }
    }

    @Override
    public void visitQualifiedDesignator(OCQualifiedDesignator designator) {
        if (designator.getArrayStartIndexer() != null) {
            OCType parent = designator.getParentType();
            if (parent instanceof OCArrayType) {
                OCExpression arrayStopIndexer;
                OCArrayType arrayParent = (OCArrayType)parent;
                int length = arrayParent.getLength();
                Number index = OCExpressionEvaluator.evaluate(designator.getArrayStartIndexer());
                if (index != null && (index.intValue() < 0 || arrayParent.hasLength() && index.intValue() >= length)) {
                    this.addErrorAnnotation(designator, OCInspections.ArrayIssues.class, "CIDR", "Array index in initializer exceeds array bounds");
                }
                if ((arrayStopIndexer = designator.getArrayStopIndexer()) != null) {
                    Number stopIndex = OCExpressionEvaluator.evaluate(arrayStopIndexer);
                    if (stopIndex != null && (stopIndex.intValue() < 0 || arrayParent.hasLength() && stopIndex.intValue() >= length)) {
                        this.addErrorAnnotation(designator, OCInspections.ArrayIssues.class, "CIDR", "Array index in initializer exceeds array bounds");
                    } else if (index != null && stopIndex != null && index.intValue() > stopIndex.intValue()) {
                        this.addErrorAnnotation(designator, OCInspections.ArrayIssues.class, "err_array_designator_empty_range", "Empty index range in initializer");
                    }
                }
            } else {
                this.addErrorAnnotation(designator, OCInspections.ArrayIssues.class, "err_designator_for_scalar_init", "Subscripted value is not an array");
            }
        }
    }

    @Override
    public void visitSynthesizeProperty(OCSynthesizeProperty property) {
        super.visitSynthesizeProperty(property);
        this.myImplementationChecker.checkSynthesize(property);
    }

    @Override
    public void visitProtocolExpression(OCProtocolExpression expression) {
        OCType type;
        super.visitProtocolExpression(expression);
        OCTypeElement typeElement = expression.getTypeElement();
        if (typeElement != null && !((type = typeElement.getType().resolve(expression.getContainingFile())) instanceof OCObjectType) && !type.isUnknown()) {
            this.addErrorAnnotation(typeElement, "CIDR", "'" + type.getName(expression) + "' isn't a protocol");
        }
    }

    @Override
    public void visitOCFile(OCFile file2) {
        super.visitOCFile(file2);
        if (file2.isHeader()) {
            return;
        }
        OCFileGlobalSymbols symbols = OCFileGlobalSymbolsCache.getInstance(file2.getProject()).forFile(file2);
        this.processUndefinedClasses(file2, symbols.getUndefinedClasses(), OCSymbolKind.INTERFACE);
        this.processUndefinedClasses(file2, symbols.getUndefinedProtocols(), OCSymbolKind.PROTOCOL);
        List<OCIncludeDirective> imports = OCImportsOptimizer.doGetImports(file2, false, true);
        for (OCIncludeDirective directive : imports) {
            Annotation annotation = this.addWarningAnnotation(directive, OCInspections.UnusedImportStatement.class, "CIDR", "Unused import statement", ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)directive, "Remove useless import"));
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction(imports, "Optimize imports", "Optimize imports"));
        }
    }

    private void processUndefinedClasses(OCFile file2, Map<String, Pair<OCSymbol, VirtualFile>> undefinedClasses, OCSymbolKind symbolKind) {
        for (String className : undefinedClasses.keySet()) {
            OCClassSymbol definition;
            String message;
            Pair<OCSymbol, VirtualFile> pair = undefinedClasses.get(className);
            OCIncludeDirective directive = file2.findIncludeDirective((VirtualFile)pair.getSecond());
            OCSymbol symbol = (OCSymbol)pair.getFirst();
            if (directive == null || OCWorkspaceManager.getWorkspace(file2.getProject()).isInSDK(symbol.getContainingFile())) continue;
            Annotation annotation = null;
            if (symbolKind == OCSymbolKind.INTERFACE) {
                message = "Cannot find class '" + className + "', superclass of " + symbol.getNameWithKindLowercase();
                annotation = this.addErrorAnnotation(directive, OCInspections.CannotResolve.class, "CIDR", message);
            } else if (symbolKind == OCSymbolKind.PROTOCOL) {
                message = "Cannot find protocol '" + className + "', conformed by " + symbol.getNameWithKindLowercase();
                annotation = this.addWarningAnnotation(directive, OCInspections.NotVisibleClass.class, "CIDR", message);
            }
            if ((definition = (OCClassSymbol)OCSymbolImpl.findSymbolDefinition(className, symbolKind, file2.getProject(), file2.getVirtualFile())) == null || annotation == null) continue;
            this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(directive, definition));
        }
    }

    @Override
    public void visitCallable(OCCallable callable) {
        super.visitCallable(callable);
        if (!(callable instanceof OCBlockExpression) && !(callable instanceof OCLambdaExpression) || PsiTreeUtil.getContextOfType((PsiElement)callable, (Class[])new Class[]{OCCallable.class}) == null) {
            OCDataFlowAnalyzer analyzer = new OCDataFlowAnalyzer(callable, this, null);
            analyzer.buildControlFlowGraph();
            analyzer.analyze();
        }
    }

    @Override
    public void visitDirective(OCDirective directive) {
        IElementType type;
        PsiElement token = directive.getHeaderToken();
        IElementType header = token.getNode().getElementType();
        PsiElement nextSibling = token.getNextSibling();
        if (nextSibling != null && (type = nextSibling.getNode().getElementType()) == OCTokenTypes.DIRECTIVE_CONTENT) {
            String message = nextSibling.getText().trim();
            TextRange range = OCElementUtil.getTrimmedRange(nextSibling);
            if (header == OCTokenTypes.ERROR_DIRECTIVE) {
                this.addErrorAnnotation(nextSibling, range, null, "CIDR", message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            } else if (header == OCTokenTypes.WARNING_DIRECTIVE) {
                this.addWarningAnnotation(nextSibling, range, null, "CIDR", message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
        }
    }

    @Override
    public void visitCppNewExpression(OCCppNewExpression expression) {
        super.visitCppNewExpression(expression);
        OCFile file2 = expression.getContainingOCFile();
        OCType type = expression.getConstructingType().resolve(file2);
        if (type instanceof OCArrayType) {
            type = ((OCArrayType)type).getRefType();
        }
        if (type instanceof OCStructType) {
            for (OCStructSymbol structSymbol : ((OCStructType)type).getStructs()) {
                OCFileSymbols.markSymbolAsUsed(file2, structSymbol, expression);
            }
            if (((OCStructType)type).isAbstract(new OCResolveContext(file2))) {
                String message = "Instantiating the abstract " + ((OCStructType)type).getStructs().get(0).getNameWithKindLowercase();
                this.addErrorAnnotation(expression, "err_allocation_of_abstract_type", message);
            }
            OCReferenceElement refElement = expression.getReferenceElement();
            this.myCppChecker.checkConstructorCall(expression, expression.getInitializers(), refElement != null ? refElement.resolveToSymbol() : null, true);
        }
    }

    @Override
    public void visitConstructorFieldInitializer(OCConstructorFieldInitializer initializer) {
        super.visitConstructorFieldInitializer(initializer);
        OCReferenceElement refElement = initializer.getReferenceElement();
        OCSymbol symbol = refElement != null ? refElement.resolveToSymbol() : null;
        List<OCExpression> initializers = initializer.getInitializers();
        if (symbol instanceof OCDeclaratorSymbol) {
            OCType type = symbol.getType().resolve(initializer.getContainingFile());
            this.myCppChecker.checkTypeInitialization(initializer, refElement, initializers, initializer.getInitializerTypes(new OCResolveContext(initializer)), symbol, type, false, initializer);
        } else {
            this.myCppChecker.checkConstructorCall(initializer, initializers, symbol, true);
        }
    }

    @Override
    public void visitCompoundInitializer(OCCompoundInitializer initializer) {
        super.visitCompoundInitializer(initializer);
        if (initializer.getParent() instanceof OCCompoundInitializer) {
            return;
        }
        OCType type = initializer.inferType();
        if (type != null) {
            type = type.resolve(initializer.getContainingFile());
        }
        new OCAnnotator.MyArgumentsChecker(){

            @Override
            protected void checkConstructor(OCCompoundInitializer compInitializer, OCSymbol constructor) {
                PsiElement parent = OCParenthesesUtils.topmostParenthesized(compInitializer).getParent();
                if (!(parent instanceof OCDeclarator || parent instanceof OCArgumentList || parent instanceof OCCompoundInitializer || parent instanceof OCConstructorFieldInitializer || parent instanceof OCTypeElement && parent.getParent() instanceof OCCppNewExpression)) {
                    OCErrorAnnotator.this.myCppChecker.checkConstructorCall(compInitializer, Collections.singletonList(compInitializer), constructor, true);
                }
            }
        }.checkCompoundInitializer(initializer, type, true, true);
    }

    @Override
    public void visitNamespaceQualifier(OCCppNamespaceQualifier qualifier) {
        super.visitNamespaceQualifier(qualifier);
        if (qualifier.getParent() instanceof OCReferenceElement) {
            for (OCSymbol symbol : qualifier.resolveToSymbols(false)) {
                this.myOperatorsChecker.checkFieldVisibility(symbol, qualifier, null);
                OCFileSymbols.markSymbolAsUsed(qualifier.getContainingOCFile(), symbol, qualifier);
            }
        }
    }

    @Override
    public void visitBoxedExpression(OCBoxedExpression expression) {
        if (!OCCompilerHelper.supportsObjectLiterals(expression.getContainingOCFile())) {
            this.addErrorAnnotation(expression, "CIDR", "Expression literals are not supported by the compiler");
        } else {
            OCType type;
            OCExpression operand = expression.getOperand();
            if (!(operand == null || (type = operand.getResolvedType()).isNumberCompatible(expression) || type.isPointerToChar() || type instanceof OCMagicType)) {
                this.addErrorAnnotation(operand, "err_objc_illegal_boxed_expression_type", "Type '" + type.getName(operand) + "' is illegal for a boxed expression");
            }
        }
        super.visitBoxedExpression(expression);
    }
}

