/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.intentions.OCAddParametersToConstructorIntentionAction;
import com.jetbrains.cidr.lang.intentions.OCImplementCppFunctionInplaceIntentionAction;
import com.jetbrains.cidr.lang.intentions.OCImplementCppFunctionIntentionAction;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCCppBaseClause;
import com.jetbrains.cidr.lang.psi.OCCppBaseClauseList;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCAddFieldInitializerFix;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCAddSuperConstructorCallsFix;
import com.jetbrains.cidr.lang.quickfixes.OCAddTypeModifierIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCreateNewDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCGenerateConstructorFix;
import com.jetbrains.cidr.lang.quickfixes.OCMakeFunctionVirtualFix;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveTypeModifierIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSafeDeleteIntentionAction;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCppChecker
extends OCAnnotator {
    public void checkCppFunction(OCFunctionDeclaration function, final OCFunctionSymbol symbol) {
        OCSymbolWithQualifiedName parent;
        OCExpression initializer = function.getDeclarator().getInitializer();
        if (initializer != null) {
            this.checkPureVirtual(symbol, initializer);
        } else if (symbol.isPredeclaration() && OCSearchScope.isInProjectSources(symbol) && !symbol.isDefault() && !symbol.isDelete() && (parent = symbol.getParent()) != null && parent.getKind() == OCSymbolKind.STRUCT && !OCCppChecker.isImplemented(symbol)) {
            Annotation annotation = this.addWarningAnnotation(function, OCInspections.NotImplementedFunctions.class, "CIDR", symbol.getNameWithKindUppercase() + " is not implemented");
            this.registerQuickFix(annotation, new OCImplementCppFunctionInplaceIntentionAction(symbol));
            this.registerQuickFix(annotation, new OCImplementCppFunctionIntentionAction(){

                @Override
                @NotNull
                public String getText() {
                    String string = "Implement " + symbol.getNameWithKindLowercase();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/daemon/OCCppChecker$1", "getText"));
                    }
                    return string;
                }

                @Override
                @Nullable
                protected OCFunctionSymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file2) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/daemon/OCCppChecker$1", "locateCandidate"));
                    }
                    return symbol;
                }

                @Override
                protected boolean allowClassMembers() {
                    return true;
                }
            });
            this.registerQuickFix(annotation, new OCMakeFunctionVirtualFix(symbol, true));
        }
        final Ref nonVirtualRef = new Ref();
        CommonProcessors.FindFirstProcessor<OCFunctionSymbol> virtualFinder = new CommonProcessors.FindFirstProcessor<OCFunctionSymbol>(){

            public boolean process(OCFunctionSymbol symbol) {
                if (symbol.isVirtual()) {
                    return super.process((Object)symbol);
                }
                nonVirtualRef.set((Object)symbol);
                return true;
            }
        };
        new OCFunctionAncestorsQuery(symbol, true, false).forEach((Processor)virtualFinder);
        OCFunctionSymbol virtualFunction = (OCFunctionSymbol)virtualFinder.getFoundValue();
        OCFunctionSymbol nonVirtualFunction = (OCFunctionSymbol)nonVirtualRef.get();
        if (virtualFunction != null) {
            this.checkFunctionReturnTypes(function, symbol, virtualFunction, true, "derived function", "virtual " + symbol.getNameWithKindLowercase(), "base function", "err_different_return_type_for_overriding_virtual_function");
        } else if (symbol.getParent() != null && nonVirtualFunction != null && nonVirtualFunction.getVisibility() != OCVisibility.PRIVATE) {
            String message = symbol.getNameWithKindUppercase() + " hides a non-virtual function from " + nonVirtualFunction.getParent().getNameWithKindLowercase();
            Annotation annotation = this.addWarningAnnotation(function, OCInspections.HidingNonVirtualFunction.class, "CIDR", message);
            this.registerQuickFix(annotation, new OCAddTypeModifierIntentionAction(nonVirtualFunction, OCTokenTypes.VIRTUAL_CPP_KEYWORD, nonVirtualFunction.getParent().getName() + "::" + nonVirtualFunction.getName(), false));
        }
        if (symbol.isCppConstructor() && symbol.isDefinition() && function instanceof OCFunctionDefinition) {
            this.checkConstructorDefinition(function, symbol);
        }
        this.checkFunctionReturnTypes(function, symbol);
        this.checkOverrideControls(function, symbol);
    }

    private static boolean isImplemented(OCFunctionSymbol symbol) {
        return !symbol.processSameSymbols(new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                return symbol.isPredeclaration() && (!(symbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol).isDefault() && !((OCFunctionSymbol)symbol).isDelete());
            }
        });
    }

    private void checkFunctionReturnTypes(OCFunctionDeclaration function, OCFunctionSymbol symbol) {
        OCSymbol associatedFunction;
        OCCppNamespaceQualifier qualifier = function.getDeclarator().getNamespaceQualifier();
        if (qualifier != null && symbol.isDefinition()) {
            associatedFunction = qualifier.getPredeclarationInParent(symbol, true);
        } else {
            associatedFunction = symbol.getAssociatedSymbol();
            if (associatedFunction instanceof OCFunctionSymbol && associatedFunction.isDefinition()) {
                Object element = associatedFunction.locateDefinition();
                OCCppNamespaceQualifier oCCppNamespaceQualifier = qualifier = element instanceof OCDeclarator ? ((OCDeclarator)element).getNamespaceQualifier() : null;
                if (qualifier != null) {
                    OCSymbol newSymbol = qualifier.getPredeclarationInParent((OCSymbolWithQualifiedName)associatedFunction, true);
                    OCFunctionSymbol oCFunctionSymbol = symbol = newSymbol instanceof OCFunctionSymbol ? (OCFunctionSymbol)newSymbol : null;
                }
            }
        }
        if (symbol != null && associatedFunction instanceof OCFunctionSymbol) {
            if (symbol.isDefinition() && !associatedFunction.isDefinition()) {
                this.checkFunctionReturnTypes(function, symbol, (OCFunctionSymbol)associatedFunction, false, "function definition", symbol.getNameWithKindLowercase() + " definition", "function declaration", "err_member_def_does_not_match_ret_type");
            } else if (!symbol.isDefinition() && associatedFunction.isDefinition()) {
                this.checkFunctionReturnTypes(function, symbol, (OCFunctionSymbol)associatedFunction, false, "function declaration", symbol.getNameWithKindLowercase() + " declaration", "function definition", "err_member_def_does_not_match_ret_type");
            }
        }
    }

    private void checkOverrideControls(final OCFunctionDeclaration function, final OCFunctionSymbol symbol) {
        OCSymbolWithQualifiedName owner = symbol.getResolvedOwner();
        if (owner == null || !(owner.getType() instanceof OCMagicType)) {
            final Ref isOverridden = Ref.create((Object)false);
            new OCFunctionAncestorsQuery(symbol, true, false).forEach((Processor)new Processor<OCFunctionSymbol>(){

                public boolean process(final OCFunctionSymbol baseFunction) {
                    if (!baseFunction.isVirtual()) {
                        return true;
                    }
                    isOverridden.set((Object)true);
                    if (baseFunction.isFinal()) {
                        String message = symbol.getNameWithKindUppercase() + " overrides a final function from " + baseFunction.getParent().getNameWithKindLowercase();
                        Annotation annotation = OCCppChecker.this.addErrorAnnotation(function, "err_final_function_overridden", message);
                        OCCppChecker.this.registerQuickFix(annotation, new OCRemoveTypeModifierIntentionAction(baseFunction, OCTokenTypes.FINAL_CPP_KEYWORD){

                            @Override
                            protected String getSubject(OCSymbol symbol) {
                                return baseFunction.getNameWithParent();
                            }
                        });
                        OCCppChecker.this.registerQuickFix(annotation, new OCSafeDeleteIntentionAction((PsiElement)function, symbol.getNameWithKindLowercase()));
                        return false;
                    }
                    return true;
                }
            });
            int overrideCount = 0;
            List<PsiElement> vs = function.getVirtualSpecifiers();
            for (PsiElement spec : vs) {
                IElementType type = OCElementUtil.getElementType(spec);
                Annotation highlighting = this.highlightKeyword(spec);
                if (type != OCTokenTypes.OVERRIDE_CPP_KEYWORD || overrideCount++ != 0 || ((Boolean)isOverridden.get()).booleanValue()) continue;
                Annotation error = this.addErrorAnnotation(spec, "err_function_marked_override_not_overriding", "Function doesn't override any base member functions");
                this.registerQuickFix(error, new OCRemoveTypeModifierIntentionAction(symbol, OCTokenTypes.OVERRIDE_CPP_KEYWORD));
                if (highlighting == null || error == null) continue;
                EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
                TextAttributes ha = scheme.getAttributes(highlighting.getTextAttributes());
                TextAttributes ea = scheme.getAttributes(error.getTextAttributes());
                error.setEnforcedTextAttributes(TextAttributes.merge((TextAttributes)ha, (TextAttributes)ea));
            }
        }
    }

    private void checkPureVirtual(OCFunctionSymbol symbol, OCExpression initializer) {
        Annotation annotation;
        if (!symbol.isVirtual()) {
            annotation = this.addErrorAnnotation(initializer, OCInspections.ConstructionIsNotAllowed.class, "err_non_virtual_pure", "Only virtual function can have pure specifier");
            this.registerQuickFix(annotation, new OCMakeFunctionVirtualFix(symbol, false));
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)initializer, "Remove pure specifier"));
        }
        if (!(initializer instanceof OCLiteralExpression) || !"0".equals(((OCLiteralExpression)initializer).getUnescapedLiteralText())) {
            annotation = this.addErrorAnnotation(initializer, OCInspections.ConstructionIsNotAllowed.class, "err_member_function_initialization", "Invalid pure specifier");
            OCExpression zero = OCElementFactory.expressionFromText("0", initializer, false);
            this.registerQuickFix(annotation, new OCChangeElementIntentionAction((PsiElement)initializer, (PsiElement)zero, "Change pure specifier to '= 0'"));
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)initializer, "Remove pure specifier"));
        }
    }

    private void checkFunctionReturnTypes(OCFunctionDeclaration element, OCFunctionSymbol derivedFunction, OCFunctionSymbol baseFunction, boolean allowCovariance, String derivedSubject, String derivedLongSubject, String baseSubject, String clangID) {
        PsiFile file2 = element.getContainingFile();
        OCType baseType = baseFunction.getType().getReturnType().resolve(baseFunction.getContainingOCFile());
        OCType derivedType = derivedFunction.getType().getReturnType().resolve(derivedFunction.getContainingOCFile());
        String baseTypeName = baseType.getName(element);
        String overriddenTypeName = derivedType.getName(element);
        OCTypeElement annotationElement = element.getTypeElement();
        annotationElement = annotationElement != null ? annotationElement : element;
        Annotation annotation = null;
        if (allowCovariance && (baseType.isPointer() || baseType instanceof OCCppReferenceType) && (derivedType.isPointer() || derivedType instanceof OCCppReferenceType)) {
            String message = "Return type of " + derivedLongSubject + " (" + overriddenTypeName + ") isn't derived from the return type of " + baseSubject + " (" + baseTypeName + ")";
            if (!baseType.getTerminalType().isSuperType(derivedType.getTerminalType(), annotationElement)) {
                annotation = this.addErrorAnnotation(annotationElement, OCInspections.DerivedFunctionsReturnTypeMismatch.class, "err_covariant_return_not_derived", message);
            }
        } else if (!new OCTypeEqualityAfterResolvingVisitor(derivedType, true, true, false, false, true, new OCResolveContext((PsiElement)file2)).equal(baseType)) {
            String message = "Return type of " + derivedLongSubject + " (" + overriddenTypeName + ") differs from the return type of " + baseSubject + " (" + baseTypeName + ")";
            annotation = this.addErrorAnnotation(annotationElement, OCInspections.DerivedFunctionsReturnTypeMismatch.class, clangID, message);
        }
        if (annotation != null) {
            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)derivedFunction, baseType, true, derivedSubject));
            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)baseFunction, derivedType, true, baseSubject));
        }
    }

    private static String getMissingDefaultCtorsMessage(Collection<OCStructSymbol> classesMissingDefaultCtors) {
        boolean mutual = classesMissingDefaultCtors.size() > 1;
        return "Base " + (mutual ? StringUtil.pluralize((String)"class") : "class") + " " + StringUtil.join(classesMissingDefaultCtors, (Function)new Function<OCStructSymbol, String>(){

            public String fun(OCStructSymbol symbol) {
                return "'" + symbol.getName() + "'";
            }
        }, (String)", ") + (mutual ? " don't" : " doesn't") + " have a default constructor";
    }

    private static List<OCStructSymbol> getBaseClasses(OCStructSymbol symbol, PsiFile file2) {
        final ArrayList<OCStructSymbol> baseClasses = new ArrayList<OCStructSymbol>();
        symbol.processBaseClasses(new OCResolveContext((PsiElement)file2), new OCStructSymbol.BaseClassProcessor(){

            @Override
            public boolean process(OCSymbol symbol, OCVisibility visibility) {
                if (symbol instanceof OCStructSymbol) {
                    baseClasses.add((OCStructSymbol)symbol);
                }
                return true;
            }
        });
        return baseClasses;
    }

    public void checkClass(OCStruct parent) {
        ASTNode[] kws;
        for (ASTNode kw : kws = parent.getNode().getChildren(OCTokenTypes.CPP_CLASS_VIRTUAL_SPECIFIERS)) {
            this.highlightKeyword(kw.getPsi());
        }
        OCStructSymbol symbol = (OCStructSymbol)parent.getSymbol();
        if (symbol == null || symbol.isPredeclaration()) {
            return;
        }
        OCCppBaseClauseList baseClausesList = parent.getBaseClausesList();
        if (baseClausesList != null) {
            for (OCCppBaseClause baseClause : baseClausesList.getBaseClauses()) {
                OCReferenceElement refElement = baseClause.getReferenceElement();
                OCSymbol baseClass = refElement != null ? refElement.resolveToSymbol() : null;
                if (!(baseClass instanceof OCStructSymbol) || !((OCStructSymbol)baseClass).isFinal()) continue;
                Annotation annotation = this.addErrorAnnotation(baseClause, "err_class_marked_final_used_as_base", baseClass.getNameWithKindUppercase() + " is marked as final");
                this.registerQuickFix(annotation, new OCRemoveTypeModifierIntentionAction((OCSymbolWithQualifiedName)baseClass, OCTokenTypes.FINAL_CPP_KEYWORD));
                this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)baseClause, "Remove '" + baseClass.getName() + "' from the base classes list"));
            }
        }
        if (!symbol.processConstructors((Processor<? super OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor(), true, new OCResolveContext(parent))) {
            return;
        }
        List classesMissingDefaultCtors = ContainerUtil.filter(OCCppChecker.getBaseClasses(symbol, parent.getContainingFile()), (Condition)new Condition<OCStructSymbol>(){

            public boolean value(OCStructSymbol struct) {
                return !struct.hasDefaultConstructor();
            }
        });
        if (!classesMissingDefaultCtors.isEmpty()) {
            String message = OCCppChecker.getMissingDefaultCtorsMessage(classesMissingDefaultCtors);
            Annotation annotation = this.addErrorAnnotation(parent.getHeaderRange(), OCInspections.NoDefaultBaseConstructor.class, "err_missing_default_ctor", message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            this.registerQuickFix(annotation, new OCGenerateConstructorFix(symbol, true));
            for (OCStructSymbol baseClass : classesMissingDefaultCtors) {
                this.registerQuickFix(annotation, new OCGenerateConstructorFix(baseClass, false));
            }
        }
    }

    private void checkConstructorDefinition(final OCFunctionDeclaration function, final OCFunctionSymbol symbol) {
        final OCSymbolWithQualifiedName parent = symbol.getResolvedOwner();
        if (parent instanceof OCStructSymbol) {
            List classesMissingCtors;
            LinkedHashSet<OCStructSymbol> baseClasses = new LinkedHashSet<OCStructSymbol>(OCCppChecker.getBaseClasses((OCStructSymbol)parent, function.getContainingFile()));
            CommonProcessors.CollectProcessor<OCDeclaratorSymbol> collector = new CommonProcessors.CollectProcessor<OCDeclaratorSymbol>(){

                protected boolean accept(OCDeclaratorSymbol field) {
                    if (field.getKind() == OCSymbolKind.STRUCT_FIELD && !field.isStatic() && !(field.getResolvedType() instanceof OCArrayType)) {
                        OCType type = field.getResolvedType();
                        return type instanceof OCStructType || type instanceof OCCppReferenceType || field.isConst();
                    }
                    return false;
                }
            };
            ((OCStructSymbol)parent).processFields((Processor<OCDeclaratorSymbol>)collector);
            HashSet fields = new HashSet(collector.getResults());
            OCConstructorInitializationList list = ((OCFunctionDefinition)function).getConstructorInitializationList();
            if (list != null) {
                for (OCConstructorFieldInitializer initializer : list.getInitializers()) {
                    OCReferenceElement referenceElement = initializer.getReferenceElement();
                    if (referenceElement == null) continue;
                    OCQualifiedName qname = OCSymbolReferenceResolver.getQualifiedName(referenceElement);
                    OCSymbolReference reference = OCSymbolReference.getLocalReference(qname, (PsiElement)referenceElement);
                    for (OCSymbol initializerSymbol : reference.resolveToSymbols(true, false, referenceElement.getContainingFile())) {
                        if (initializerSymbol instanceof OCStructSymbol) {
                            baseClasses.remove(initializerSymbol);
                            continue;
                        }
                        if (initializerSymbol instanceof OCFunctionSymbol) {
                            OCSymbolWithQualifiedName owner = ((OCFunctionSymbol)initializerSymbol).getResolvedOwner();
                            if (parent.equals(owner)) {
                                return;
                            }
                            if (owner == null) continue;
                            baseClasses.remove(owner);
                            continue;
                        }
                        if (!(initializerSymbol instanceof OCDeclaratorSymbol) || !fields.contains(initializerSymbol)) continue;
                        fields.remove(initializerSymbol);
                    }
                }
            }
            if (!(classesMissingCtors = ContainerUtil.filter(baseClasses, (Condition)new Condition<OCStructSymbol>(){

                public boolean value(OCStructSymbol struct) {
                    return !struct.hasDefaultConstructor();
                }
            })).isEmpty()) {
                String message = OCCppChecker.getMissingDefaultCtorsMessage(classesMissingCtors);
                Annotation annotation = this.addErrorAnnotation(function, OCInspections.NoDefaultBaseConstructor.class, "err_missing_default_ctor", message);
                this.registerQuickFix(annotation, new OCAddSuperConstructorCallsFix(symbol, classesMissingCtors));
                for (OCStructSymbol baseClass : classesMissingCtors) {
                    this.registerQuickFix(annotation, new OCGenerateConstructorFix(baseClass, false));
                }
            } else {
                for (OCStructSymbol baseClass : baseClasses) {
                    this.myOperatorsChecker.checkFieldVisibility(baseClass.getDefaultConstructor(), function, null);
                }
            }
            for (final OCDeclaratorSymbol field : fields) {
                OCType type = field.getResolvedType();
                OCDeclarator declarator = (OCDeclarator)field.locateDefinition();
                if (declarator != null && declarator.getInitializer() != null) continue;
                if (type instanceof OCStructType) {
                    OCStructSymbol structSymbol = ((OCStructType)type).getSymbol();
                    OCFunctionSymbol constructor = structSymbol.getDefaultConstructor();
                    if (constructor != null) {
                        this.myOperatorsChecker.checkFieldVisibility(constructor, function, null);
                        continue;
                    }
                    if (structSymbol.hasDefaultConstructor()) continue;
                }
                Annotation annotation = this.addErrorAnnotation(function, OCInspections.FieldMustBeInitialized.class, "err_uninitialized_member_in_ctor", field.getNameWithKindUppercase() + " must be initialized");
                this.registerQuickFix(annotation, new OCAddParametersToConstructorIntentionAction(){

                    @Override
                    @Nullable
                    protected OCDeclaratorSymbol getField(Editor editor, PsiFile file2) {
                        return field;
                    }

                    @Override
                    @NotNull
                    public String getText() {
                        String string = "Add " + field.getNameWithKindLowercase() + " as a parameter to constructor";
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/daemon/OCCppChecker$10", "getText"));
                        }
                        return string;
                    }

                    @Override
                    protected boolean enableChooseDialog(Collection<OCFunctionSymbol> candidates) {
                        return false;
                    }

                    @Override
                    @Nullable
                    protected OCCppActionContext<OCStructSymbol, OCFunctionSymbol> evaluateActionContext(Project project, @Nullable Editor editor, PsiFile file2) {
                        return new OCCppActionContext<OCStructSymbol, OCFunctionSymbol>((OCStructSymbol)parent, (PsiElement)function){

                            @Override
                            @NotNull
                            public Collection<OCFunctionSymbol> getMemberCandidates() {
                                List<OCFunctionSymbol> list = Collections.singletonList(symbol);
                                if (list == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/daemon/OCCppChecker$10$1", "getMemberCandidates"));
                                }
                                return list;
                            }
                        };
                    }
                });
                if (type instanceof OCCppReferenceType) {
                    this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(field, ((OCCppReferenceType)type).getRefType()));
                } else {
                    if (!(type instanceof OCStructType)) {
                        this.registerQuickFix(annotation, new OCAddFieldInitializerFix((OCFunctionDefinition)function, field));
                    }
                    if (OCCompilerHelper.supportsInClassInitialization(function.getContainingFile())) {
                        this.registerQuickFix(annotation, new OCAddInitializerIntentionAction(declarator, field));
                    }
                }
                if (field.isConst()) {
                    this.registerQuickFix(annotation, new OCRemoveTypeModifierIntentionAction(field, OCTokenTypes.CONST_KEYWORD));
                }
                if (!(type instanceof OCStructType)) continue;
                this.registerQuickFix(annotation, new OCGenerateConstructorFix(((OCStructType)type).getSymbol(), false));
            }
        }
    }

    public void checkTypeInitialization(@NotNull OCElement element, @Nullable PsiElement callElement, List<OCExpression> argumentExprs, @NotNull List<OCType> argumentTypes, @Nullable OCSymbol symbol, OCType type, boolean isCast, PsiElement expression) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/daemon/OCCppChecker", "checkTypeInitialization"));
        }
        if (argumentTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypes", "com/jetbrains/cidr/lang/daemon/OCCppChecker", "checkTypeInitialization"));
        }
        if (type instanceof OCStructType) {
            OCSymbol constructor = ((OCStructType)type).findConstructor(argumentTypes, argumentExprs, element.getContainingOCFile(), true);
            this.checkConstructorCall(element, argumentExprs, constructor, true);
        } else if (!(argumentExprs.size() <= 1 || type instanceof OCMagicType || type instanceof OCCppReferenceType && ((OCCppReferenceType)type).getRefType() instanceof OCMagicType)) {
            this.addErrorAnnotation(argumentExprs.get(1), "err_excess_initializers", "Only one initializer is permitted");
        } else if (argumentExprs.size() == 1) {
            OCExpression argument = argumentExprs.get(0);
            OCType initializerType = argument.getResolvedType();
            if (isCast) {
                this.myOperatorsChecker.checkTypeCast(type, initializerType, callElement, argument, expression);
            } else {
                this.checkAssignment(argument, (PsiElement)element, type, initializerType, symbol, initializerType);
            }
        }
    }

    public boolean checkConstructorCall(@NotNull OCElement element, @NotNull List<OCExpression> arguments, @Nullable OCSymbol symbol, boolean checkVisibility) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/daemon/OCCppChecker", "checkConstructorCall"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/jetbrains/cidr/lang/daemon/OCCppChecker", "checkConstructorCall"));
        }
        boolean result2 = true;
        if (symbol instanceof OCFunctionSymbol) {
            Boolean res;
            boolean isCopyConstructor = false;
            if (((OCFunctionSymbol)symbol).isCppConstructor() && arguments.size() == 1) {
                OCSymbolWithQualifiedName parent = ((OCFunctionSymbol)symbol).getParent();
                OCExpression argument = arguments.get(0);
                OCType argumentType = argument.getResolvedType();
                if (parent instanceof OCStructSymbol && !(argument instanceof OCCompoundInitializer) && parent.getType().isCompatible(argumentType, element, false)) {
                    isCopyConstructor = true;
                    List<OCDeclaratorSymbol> parameterSymbols = ((OCFunctionSymbol)symbol).getParameterSymbols();
                    if (parameterSymbols.size() != 1 || !parameterSymbols.get(0).getResolvedType().isCompatible(argumentType, element, false)) {
                        return true;
                    }
                }
            }
            if (!isCopyConstructor && (res = this.checkDeclaratorReference(element, arguments)) != null) {
                return res;
            }
            OCFunctionType funcType = (OCFunctionType)symbol.getType().resolve(element.getContainingOCFile());
            result2 = this.myOperatorsChecker.checkFunctionArguments(element, funcType, arguments, symbol);
        } else if (symbol instanceof OCStructSymbol && symbol.getKind() == OCSymbolKind.STRUCT) {
            if (arguments.size() == 1 && arguments.get(0) instanceof OCCompoundInitializer) {
                if (OCCodeInsightUtil.isInitializerListType(symbol.getType(), element.getContainingOCFile())) {
                    Boolean res = this.checkDeclaratorReference(element, arguments);
                    return res == null || res != false;
                }
                if (element instanceof OCDeclarator && ((OCStructSymbol)symbol).isPOD(false)) {
                    return true;
                }
                arguments = ((OCCompoundInitializer)arguments.get(0)).getInitializerExpressions();
            }
            if (arguments.size() == 1 && symbol.getType().isCompatible(arguments.get(0).getResolvedType(), element, element instanceof OCCallExpression)) {
                return true;
            }
            if (arguments.isEmpty() && ((OCStructSymbol)symbol).hasDefaultConstructor()) {
                return true;
            }
            List argumentTypes = ContainerUtil.map(arguments, (Function)new Function<OCExpression, OCType>(){

                public OCType fun(OCExpression expression) {
                    return OCExpectedTypeUtil.getExpressionType(expression, true);
                }
            });
            OCFunctionType type = new OCFunctionType(OCVoidType.instance(), argumentTypes);
            Annotation annotation = this.addErrorAnnotation(element, OCInspections.CannotResolve.class, "CIDR", OCCppChecker.getCantResolveCtorMessage(symbol, type, element));
            this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION, element, symbol, symbol.getName(), type));
            return false;
        }
        if (checkVisibility) {
            result2 &= this.myOperatorsChecker.checkFieldVisibility(symbol, element, null);
        }
        return result2;
    }

    @Nullable
    private Boolean checkDeclaratorReference(OCElement element, List<OCExpression> arguments) {
        if (element instanceof OCDeclarator && ((OCDeclarator)element).getResolvedType() instanceof OCCppReferenceType) {
            if (arguments.isEmpty() || ((OCDeclarator)element).getArgumentList() == null && ((OCDeclarator)element).getInitializerList() == null) {
                return true;
            }
            Annotation annotation = this.addErrorAnnotation(element, OCInspections.InitializerIssues.class, "err_lvalue_reference_bind_to_unrelated", "Can't use constructors for initialization of references");
            OCType type = ((OCDeclarator)element).getResolvedType();
            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(((OCDeclarator)element).getSymbol(), ((OCCppReferenceType)type).getRefType()));
            return false;
        }
        return null;
    }

    public static String getCantResolveCtorMessage(OCSymbol symbol, OCFunctionType type, PsiElement context) {
        return symbol.getKindUppercase() + " '" + symbol.getType().getBestNameInContext(context) + "' doesn't have a constructor '" + OCTypeNameVisitor.getFunctionSignature(context, type, symbol.getName()) + "'";
    }

    @Nullable
    public Annotation highlightKeyword(@NotNull PsiElement psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/jetbrains/cidr/lang/daemon/OCCppChecker", "highlightKeyword"));
        }
        return this.highlight(psi, OCHighlightingKeys.OC_KEYWORD);
    }
}

