/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializerMember;
import com.jetbrains.cidr.lang.psi.OCDesignatedInitializer;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveExtraInitializersIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCArrayToPointerChanger;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCArgumentsChecker {
    public void checkCompoundInitializer(OCCompoundInitializer compInitializer, OCType type, boolean goRecursive, boolean allowImplicitConversions) {
        Object argExprs;
        List<OCType> types;
        OCSymbol constructor;
        List<OCCompoundInitializerMember> initializers = compInitializer.getInitializers();
        OCFile file2 = compInitializer.getContainingOCFile();
        OCType originalType = type;
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        if (OCCodeInsightUtil.isInitializerListType(type, file2)) {
            this.checkInitializersInList(compInitializer, (OCStructType)type);
            return;
        }
        if (type instanceof OCStructType && type.isCppStructType() && ((constructor = ((OCStructType)type).findConstructor(types = Collections.singletonList(compInitializer.getType()), (List<OCExpression>)(argExprs = Collections.singletonList(compInitializer)), file2, allowImplicitConversions)) instanceof OCFunctionSymbol || !((OCStructType)type).isPOD(false))) {
            this.checkConstructor(compInitializer, constructor);
            return;
        }
        while (type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.UNION) {
            OCDeclaratorSymbol field = null;
            for (OCSymbol symbol : ((OCStructType)type).getSymbol().getMembersList()) {
                if (!(symbol instanceof OCDeclaratorSymbol)) continue;
                field = (OCDeclaratorSymbol)symbol;
                break;
            }
            if (field != null) {
                originalType = type = field.getType().resolve(compInitializer.getContainingFile());
                if (compInitializer.getInitializerExpressions().size() != 1) continue;
                OCExpression childExpression = compInitializer.getInitializerExpressions().get(0);
                if (childExpression instanceof OCCompoundInitializer) {
                    compInitializer = (OCCompoundInitializer)childExpression;
                    continue;
                }
                if (!originalType.isCompatible(childExpression.getResolvedType(), childExpression)) continue;
                return;
            }
            if (initializers.size() > 0) {
                this.addErrorAnnotation(compInitializer, OCInspections.InitializerIssues.class, "err_excess_initializers", "Excess elements in scalar initializer", new IntentionAction[0]);
            }
            return;
        }
        if (type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.STRUCT || type instanceof OCArrayType) {
            int curInitializerIndex = 0;
            boolean excessInitializers = false;
            HashMap<PsiElement, Pair<OCType, OCSymbol>> childTypes = new HashMap<PsiElement, Pair<OCType, OCSymbol>>();
            childTypes.put(compInitializer, new Pair((Object)type, null));
            compInitializer.inferChildTypes(childTypes, new HashSet<OCSymbol>());
            for (OCCompoundInitializerMember member : initializers) {
                if (member instanceof OCExpression) {
                    OCType childType;
                    Pair<OCType, OCSymbol> pair = childTypes.get(member);
                    OCType oCType = childType = pair != null ? (OCType)pair.first : null;
                    if (childType != null) {
                        childType = childType.resolve(file2);
                        OCType rType = ((OCExpression)member).getResolvedType();
                        OCExpression innerMember = OCParenthesesUtils.diveIntoParentheses((OCExpression)member);
                        if (type.isCString() && childType instanceof OCArrayType && innerMember instanceof OCLiteralExpression && rType.isCString()) {
                            this.checkCharArrayInit(childType, (OCLiteralExpression)innerMember);
                        }
                        if (member instanceof OCCompoundInitializer && goRecursive) {
                            this.checkCompoundInitializer((OCCompoundInitializer)member, childType, true, true);
                        } else {
                            this.checkAssignment((OCExpression)member, member, childType, rType, (OCSymbol)pair.second, rType, true, false, "Incompatible types in initializer: ");
                        }
                    } else if (!excessInitializers) {
                        excessInitializers = true;
                        OCRemoveExtraInitializersIntentionAction fix = new OCRemoveExtraInitializersIntentionAction(initializers, curInitializerIndex);
                        if (file2.isCpp()) {
                            this.addErrorAnnotation(member, OCInspections.IncompatibleInitializers.class, "err_excess_initializers", "Excess elements in initializer", fix);
                        } else {
                            this.addWarningAnnotation(member, OCInspections.IncompatibleInitializers.class, "ext_excess_initializers", "Excess elements in initializer", null, fix);
                        }
                    }
                } else if (member instanceof OCDesignatedInitializer) {
                    OCExpression initializer;
                    OCDesignatedInitializer fieldInitializer = (OCDesignatedInitializer)member;
                    OCSymbol symbol = fieldInitializer.getDesignation().resolveToSymbol();
                    if (symbol != null && (initializer = fieldInitializer.getInitializer()) != null) {
                        OCType rType = initializer.getResolvedType().getGuessedType();
                        this.checkAssignment(initializer, member, symbol.getResolvedType(), rType, symbol, rType, true, false, "");
                    }
                } else {
                    this.addErrorAnnotation(member, OCInspections.InitializerIssues.class, "err_typecheck_convert_incompatible", "Invalid initializer for struct field", new IntentionAction[0]);
                }
                ++curInitializerIndex;
            }
        } else if (originalType != null && originalType.isScalar()) {
            if (initializers.size() == 0) {
                if (!file2.isCpp()) {
                    this.addErrorAnnotation(compInitializer, OCInspections.InitializerIssues.class, "err_empty_scalar_initializer", "Empty initializer for scalar type", new IntentionAction[0]);
                }
            } else if (initializers.size() > 1) {
                this.addErrorAnnotation(compInitializer, OCInspections.InitializerIssues.class, "err_excess_initializers", "Excess elements in scalar initializer", new IntentionAction[0]);
            } else {
                OCCompoundInitializerMember initializer = initializers.get(0);
                if (initializer instanceof OCExpression) {
                    this.checkAssignment((OCExpression)initializer, initializer, originalType, ((OCExpression)initializer).getResolvedType(), "Incompatible types in initializer: ");
                    if (compInitializer.getParent() instanceof OCCompoundInitializer) {
                        for (ASTNode child : compInitializer.getNode().getChildren(null)) {
                            if (child.getElementType() != OCTokenTypes.LBRACE && child.getElementType() != OCTokenTypes.RBRACE) continue;
                            this.addWarningAnnotation(child.getPsi(), null, "warn_braces_around_scalar_init", "Redundant braces", ProblemHighlightType.LIKE_UNUSED_SYMBOL);
                        }
                    }
                } else {
                    this.addErrorAnnotation(compInitializer, OCInspections.InitializerIssues.class, "ext_many_braces_around_scalar_init", "Invalid initializer for scalar type", new IntentionAction[0]);
                }
            }
        }
    }

    protected void checkInitializersInList(OCCompoundInitializer compInitializer, OCStructType type) {
        OCStructSymbol paramTypeSymbol = type.getSymbol();
        if (paramTypeSymbol.getTemplateParameters().size() == 1) {
            OCTypeParameterSymbol parameterSymbol = paramTypeSymbol.getTemplateParameters().get(0);
            OCTypeArgument paramSubstitution = paramTypeSymbol.getSubstitution().getSubstitutionFor(parameterSymbol);
            if (paramSubstitution instanceof OCType) {
                for (OCExpression argument : compInitializer.getInitializerExpressions()) {
                    this.checkAssignment(argument, argument, (OCType)paramSubstitution, argument.getResolvedType().getGuessedType(), "");
                }
            }
        }
    }

    public boolean checkFunctionArguments(OCElement element, OCFunctionType funcType, List<OCExpression> arguments, OCSymbol functionSymbol) {
        boolean variableArgs;
        int requiredArgumentsCnt;
        List<? extends OCType> paramTypes = funcType.getParameterTypes();
        boolean allowImplicitConversions = true;
        if (functionSymbol != null && functionSymbol.getKind().isConstructorOrDestructor() && arguments.size() == 1 && arguments.get(0) instanceof OCCompoundInitializer) {
            OCCompoundInitializer initializer = (OCCompoundInitializer)arguments.get(0);
            List<OCExpression> expressions = initializer.getInitializerExpressions();
            if (paramTypes.size() > 0 && OCCodeInsightUtil.isInitializerListType(paramTypes.get(0), element.getContainingOCFile())) {
                this.checkInitializersInList(initializer, (OCStructType)paramTypes.get(0));
                return true;
            }
            if (paramTypes.size() != 1 || expressions.size() == 1 && paramTypes.get(0).resolve(initializer.getContainingFile()).isCompatible(expressions.get(0).getResolvedType(), (PsiElement)initializer, false)) {
                arguments = expressions;
            } else {
                allowImplicitConversions = false;
            }
        }
        LinkedList<Annotation> annotations = new LinkedList<Annotation>();
        List argumentTypes = ContainerUtil.map(arguments, (Function)new Function<OCExpression, OCType>(){

            public OCType fun(OCExpression expression) {
                return expression.getResolvedType();
            }
        });
        int maxArgumentsCnt = requiredArgumentsCnt = paramTypes.size();
        boolean bl = variableArgs = funcType.isVararg() || functionSymbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)functionSymbol).isVararg();
        if (functionSymbol instanceof OCFunctionSymbol) {
            requiredArgumentsCnt = ((OCFunctionSymbol)functionSymbol).getNonInitializedParametersCount();
            maxArgumentsCnt = paramTypes.size();
        } else if (variableArgs) {
            --requiredArgumentsCnt;
        }
        if (arguments.size() < requiredArgumentsCnt) {
            annotations.add(this.addErrorAnnotation(element, OCInspections.FunctionParameterCountMismatch.class, "err_typecheck_call_too_few_args", "Too few arguments, expected " + (variableArgs ? "at least " : "") + requiredArgumentsCnt, new IntentionAction[0]));
        } else if (!variableArgs && arguments.size() > maxArgumentsCnt) {
            if (OCCodeInsightUtil.isInPlainOldC(element) && funcType.getParameterTypes(true).isEmpty()) {
                annotations.add(this.addWarningAnnotation(element, OCInspections.KRUnspecifiedParameters.class, "CIDR", "Too many arguments, expected " + requiredArgumentsCnt));
            } else {
                annotations.add(this.addErrorAnnotation(element, OCInspections.FunctionParameterCountMismatch.class, "err_typecheck_call_too_many_args", "Too many arguments, expected " + requiredArgumentsCnt, new IntentionAction[0]));
            }
        }
        if (annotations.size() == 0) {
            OCFunctionSymbol symbol;
            List<OCDeclaratorSymbol> paramSymbols = null;
            if (functionSymbol instanceof OCFunctionSymbol && (symbol = (OCFunctionSymbol)functionSymbol).getParameterSymbols().size() == arguments.size()) {
                paramSymbols = symbol.getParameterSymbols();
            }
            for (int i = 0; i < Math.min(arguments.size(), paramTypes.size()); ++i) {
                OCExpression argument = arguments.get(i);
                OCType argumentType = ((OCType)argumentTypes.get(i)).getGuessedType();
                OCType paramType = paramTypes.get(i).resolve(element.getContainingFile());
                if (paramType instanceof OCEllipsisType || argumentType instanceof OCEllipsisType) {
                    if (!argumentType.isVoid()) break;
                    this.addErrorAnnotation(argument, null, "err_call_incomplete_argument", "Invalid use of void expression", new IntentionAction[0]);
                    return false;
                }
                OCType requiredType = argumentType.accept(OCArrayToPointerChanger.INSTANCE);
                requiredType.attachAliasName(argumentType.getAliasName());
                this.checkAssignment(argument, argument, paramType, argumentType, paramSymbols != null ? paramSymbols.get(i) : null, requiredType, allowImplicitConversions, false, "Parameter type mismatch: ");
            }
        }
        this.addFunctionCallQuickFixes(element, funcType, arguments, functionSymbol, argumentTypes, annotations);
        return annotations.isEmpty();
    }

    protected void addFunctionCallQuickFixes(OCElement element, OCFunctionType funcType, List<OCExpression> arguments, OCSymbol functionSymbol, List<OCType> argumentTypes, List<Annotation> annotations) {
    }

    protected abstract void checkAssignment(OCExpression var1, PsiElement var2, OCType var3, OCType var4, OCSymbol var5, OCType var6, boolean var7, boolean var8, String var9);

    protected abstract void checkAssignment(OCExpression var1, PsiElement var2, OCType var3, OCType var4, String var5);

    @Nullable
    public Annotation addWarningAnnotation(@Nullable PsiElement element, @Nullable Class<? extends OCInspection> aClass, @Nullable String inspectionID, @NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/cidr/lang/daemon/OCArgumentsChecker", "addWarningAnnotation"));
        }
        return this.addWarningAnnotation(element, aClass, inspectionID, message, null, new IntentionAction[0]);
    }

    @Nullable
    public Annotation addWarningAnnotation(@Nullable PsiElement element, @Nullable Class<? extends OCInspection> aClass, @Nullable String inspectionID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/cidr/lang/daemon/OCArgumentsChecker", "addWarningAnnotation"));
        }
        return this.addWarningAnnotation(element, aClass, inspectionID, message, highlightType, new IntentionAction[0]);
    }

    @Nullable
    protected abstract Annotation addWarningAnnotation(@Nullable PsiElement var1, @Nullable Class<? extends OCInspection> var2, @Nullable String var3, @NotNull String var4, @Nullable ProblemHighlightType var5, IntentionAction ... var6);

    @Nullable
    protected abstract Annotation addErrorAnnotation(@Nullable PsiElement var1, @Nullable Class<? extends OCInspection> var2, @Nullable String var3, @NotNull String var4, IntentionAction ... var5);

    protected abstract void checkConstructor(OCCompoundInitializer var1, OCSymbol var2);

    public void checkCharArrayInit(@NotNull OCType type, @NotNull OCLiteralExpression literal) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/daemon/OCArgumentsChecker", "checkCharArrayInit"));
        }
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/jetbrains/cidr/lang/daemon/OCArgumentsChecker", "checkCharArrayInit"));
        }
        if (type instanceof OCArrayType) {
            OCArrayType arrayType = (OCArrayType)type;
            int length = arrayType.getLength();
            OCType literalType = literal.getType();
            if (literalType instanceof OCArrayType) {
                OCArrayType literalArray = (OCArrayType)literalType;
                if (arrayType.hasLength() && length < literalArray.getLength()) {
                    this.addWarningAnnotation(literal, OCInspections.IncompatibleInitializers.class, "ext_initializer_string_for_char_array_too_long", length == literalArray.getLength() - 1 ? "Initializer string is too long, null-terminator doesn't fit" : "Initializer string is too long for array of chars");
                }
            }
        }
    }
}

