/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.autoImport;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.FrameworksSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedHeadersRoot;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDefaultAutoImportHelper
implements OCAutoImportHelper {
    @Override
    public boolean supports(@NotNull OCResolveRootAndConfiguration rootAndConfiguration) {
        if (rootAndConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootAndConfiguration", "com/jetbrains/cidr/lang/autoImport/OCDefaultAutoImportHelper", "supports"));
        }
        return true;
    }

    @Override
    public boolean processPathSpecificationToInclude(@NotNull Project project, @Nullable VirtualFile targetFile, final @NotNull VirtualFile fileToImport, @NotNull OCResolveRootAndConfiguration rootAndConfiguration, @NotNull Processor<OCAutoImportHelper.ImportSpecification> processor2) {
        String relativePath;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/autoImport/OCDefaultAutoImportHelper", "processPathSpecificationToInclude"));
        }
        if (fileToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToImport", "com/jetbrains/cidr/lang/autoImport/OCDefaultAutoImportHelper", "processPathSpecificationToInclude"));
        }
        if (rootAndConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootAndConfiguration", "com/jetbrains/cidr/lang/autoImport/OCDefaultAutoImportHelper", "processPathSpecificationToInclude"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/autoImport/OCDefaultAutoImportHelper", "processPathSpecificationToInclude"));
        }
        String name = fileToImport.getName();
        String path = fileToImport.getPath();
        if (targetFile != null && targetFile.getParent().equals(fileToImport.getParent()) && !processor2.process((Object)new OCAutoImportHelper.ImportSpecification(name, OCAutoImportHelper.ImportSpecification.Kind.PROJECT_HEADER))) {
            return false;
        }
        boolean isUnderSearchPaths = false;
        for (PsiFileSystemItem psiFileSystemItem : rootAndConfiguration.getLibraryHeadersRoots().getRoots()) {
            VirtualFile rootBase = psiFileSystemItem.getVirtualFile();
            if (!VfsUtilCore.isAncestor((VirtualFile)rootBase, (VirtualFile)fileToImport, (boolean)true)) continue;
            isUnderSearchPaths = true;
            if (psiFileSystemItem instanceof IncludedHeadersRoot) {
                OCAutoImportHelper.ImportSpecification spec;
                IncludedHeadersRoot includedRoot = (IncludedHeadersRoot)psiFileSystemItem;
                if (includedRoot.isRecursive()) {
                    path = name;
                } else {
                    String relativePath2 = VfsUtilCore.getRelativePath((VirtualFile)fileToImport, (VirtualFile)rootBase);
                    if (relativePath2 == null) {
                        OCLog.LOG.error("Cannot calculate relative path: \n\tbase: " + rootBase + "\n\tchild: " + fileToImport);
                    } else {
                        path = relativePath2;
                    }
                }
                if (processor2.process((Object)(spec = includedRoot.isUserHeaders() ? new OCAutoImportHelper.ImportSpecification(path, OCAutoImportHelper.ImportSpecification.Kind.USER_HEADER_SEARCH_PATH) : new OCAutoImportHelper.ImportSpecification(path, OCAutoImportHelper.ImportSpecification.Kind.SYSTEM_HEADER_SEARCH_PATH)))) continue;
                return false;
            }
            if (!(psiFileSystemItem instanceof FrameworksSearchRoot)) continue;
            FrameworksSearchRoot frameworksRoot = (FrameworksSearchRoot)psiFileSystemItem;
            final Ref found = new Ref();
            frameworksRoot.processChildren(new PsiElementProcessor<PsiFileSystemItem>(){

                public boolean execute(@NotNull PsiFileSystemItem element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/autoImport/OCDefaultAutoImportHelper$1", "execute"));
                    }
                    if (!(element instanceof AppleFramework)) {
                        return true;
                    }
                    if (((AppleFramework)element).containsHeader(fileToImport)) {
                        found.set((Object)((AppleFramework)element));
                        return false;
                    }
                    return true;
                }
            });
            AppleFramework framework = (AppleFramework)((Object)found.get());
            if (framework == null) continue;
            VirtualFile frameworkHeader = framework.getMainFile();
            if (frameworkHeader == null) {
                frameworkHeader = fileToImport;
            }
            if (processor2.process((Object)new OCAutoImportHelper.ImportSpecification(framework.getName() + "/" + frameworkHeader.getName(), OCAutoImportHelper.ImportSpecification.Kind.SYSTEM_HEADER_SEARCH_PATH))) continue;
            return false;
        }
        return isUnderSearchPaths || targetFile == null || (relativePath = FileUtil.getRelativePath((String)targetFile.getParent().getPath(), (String)path, (char)'/')) == null || processor2.process((Object)new OCAutoImportHelper.ImportSpecification(relativePath, OCAutoImportHelper.ImportSpecification.Kind.USER_HEADER_SEARCH_PATH));
    }

    @Override
    public void addHeaderSearchPath(@NotNull Project project, @Nullable VirtualFile targetFile, @NotNull VirtualFile fileToImport) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/autoImport/OCDefaultAutoImportHelper", "addHeaderSearchPath"));
        }
        if (fileToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToImport", "com/jetbrains/cidr/lang/autoImport/OCDefaultAutoImportHelper", "addHeaderSearchPath"));
        }
    }

    @Override
    @NotNull
    public Iterable<IntentionAction> getAddHeaderSearchPathFixes(@NotNull Project project, @NotNull VirtualFile targetFile, @NotNull String fileNameToImport) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/autoImport/OCDefaultAutoImportHelper", "getAddHeaderSearchPathFixes"));
        }
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "com/jetbrains/cidr/lang/autoImport/OCDefaultAutoImportHelper", "getAddHeaderSearchPathFixes"));
        }
        if (fileNameToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNameToImport", "com/jetbrains/cidr/lang/autoImport/OCDefaultAutoImportHelper", "getAddHeaderSearchPathFixes"));
        }
        List<IntentionAction> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/autoImport/OCDefaultAutoImportHelper", "getAddHeaderSearchPathFixes"));
        }
        return list;
    }
}

