/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiFile;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileWithSelectedExtensionAction;
import com.jetbrains.cidr.lang.actions.newFile.OCNewHeaderFileAction;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import icons.CidrLangIcons;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewSourceFileAction
extends OCNewFileWithSelectedExtensionAction<OCNewFileWithSelectedExtensionAction.CreateFileDialog> {
    public OCNewSourceFileAction() {
        super((FileType)OCFileType.INSTANCE, OCBundle.message("create.cpp.source.title", new Object[0]), OCBundle.message("create.cpp.source.title", new Object[0]), CidrLangIcons.FileType_cpp);
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        OCCodeStyleSettings.FileExtensionPair extensionPair = ((OCNewFileWithSelectedExtensionAction.CreateFileDialog)this.myDialogPeer).myFileExtensionPair;
        String sourceName = selectedName + "." + extensionPair.mySourceExt;
        OCNewFileActionBase.NewFileNames newFileNames = new OCNewFileActionBase.NewFileNames(sourceName, this.shouldAddHeader() ? selectedName + '.' + extensionPair.myHeaderExt : null);
        if (newFileNames == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/actions/newFile/OCNewSourceFileAction", "getNewFileNames"));
        }
        return newFileNames;
    }

    private boolean shouldAddHeader() {
        return ((MyCreateFileDialog)this.myDialogPeer).myShouldAddHeader;
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName, PsiFile sampleFile) {
        String headerExt = null;
        String sourceExt = null;
        String selectedExt = FileUtilRt.getExtension((String)selectedName);
        if (selectedExt.length() > 0) {
            if (OCFileTypeHelpers.isHeaderFile(selectedName)) {
                headerExt = selectedExt;
            } else if (OCFileTypeHelpers.isSourceFile(selectedName)) {
                sourceExt = selectedExt;
            }
        }
        String nameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)selectedName);
        Couple<String> extensions = this.determineExtensions((OCFile)sampleFile, sourceExt, headerExt);
        OCNewFileActionBase.NewFileNames newFileNames = new OCNewFileActionBase.NewFileNames(nameWithoutExtension + '.' + (String)extensions.first, nameWithoutExtension + '.' + (String)extensions.second);
        if (newFileNames == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/actions/newFile/OCNewSourceFileAction", "getNewFileNames"));
        }
        return newFileNames;
    }

    @Override
    protected void setAdditionalProperties(Properties properties, String fileName, @Nullable PsiFile sampleFile, Project project) {
        String headerName;
        if (this.myDialogPeer != null) {
            headerName = this.getNewFileNames(this.mySelectedName).getHeaderName();
        } else {
            assert (sampleFile != null);
            headerName = this.getNewFileNames(this.mySelectedName, sampleFile).getHeaderName();
        }
        if (headerName != null) {
            properties.setProperty("HEADER_FILENAME", headerName);
        }
    }

    @Override
    protected boolean isValidName(String selectedName) {
        String sourceName = selectedName + "." + ((OCNewFileWithSelectedExtensionAction.CreateFileDialog)this.myDialogPeer).myFileExtensionPair.mySourceExt;
        return super.isValidName(sourceName) && OCFileImpl.isSourceCodeFile(sourceName);
    }

    @Override
    protected String getFileTemplate(String fileName) {
        if (OCFileImpl.isHeaderFile(fileName)) {
            return OCNewHeaderFileAction.headerTemplate();
        }
        return "C Source File.c";
    }

    @Override
    protected OCNewFileWithSelectedExtensionAction.CreateFileDialog createDialog(String defaultName) {
        return new MyCreateFileDialog(defaultName);
    }

    private class MyCreateFileDialog
    extends OCNewFileWithSelectedExtensionAction.CreateFileDialog {
        private boolean myShouldAddHeader;

        public MyCreateFileDialog(String defaultName) {
            super(defaultName);
        }

        @Override
        public void fillGenericControls(FormBuilder formBuilder) {
            super.fillGenericControls(formBuilder);
            NonFocusableCheckBox headerCheckBox = new NonFocusableCheckBox(OCBundle.message("create.checkbox.source.associated.header", new Object[0]));
            DialogUtil.registerMnemonic((AbstractButton)headerCheckBox, (char)'&');
            headerCheckBox.addItemListener(new ItemListener((JCheckBox)headerCheckBox){
                final /* synthetic */ JCheckBox val$headerCheckBox;
                {
                    this.val$headerCheckBox = jCheckBox;
                }

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MyCreateFileDialog.this.myShouldAddHeader = this.val$headerCheckBox.isSelected();
                    if (MyCreateFileDialog.this.myKindCombo != null) {
                        MyCreateFileDialog.this.reloadExtensions();
                    }
                    MyCreateFileDialog.this.validateOkAction();
                }
            });
            OCNewSourceFileAction.this.addAuxAction(new Runnable(){

                @Override
                public void run() {
                    UsageTrigger.trigger("cidr.newFile.source");
                    if (MyCreateFileDialog.this.myShouldAddHeader) {
                        UsageTrigger.trigger("cidr.newFile.source.withHeader");
                    }
                }
            });
            formBuilder.addComponent((JComponent)headerCheckBox);
        }

        @Override
        @NotNull
        protected String getPresentableName(@NotNull OCCodeStyleSettings.FileExtensionPair pair) {
            if (pair == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair", "com/jetbrains/cidr/lang/actions/newFile/OCNewSourceFileAction$MyCreateFileDialog", "getPresentableName"));
            }
            String string = this.myShouldAddHeader ? super.getPresentableName(pair) : "." + pair.mySourceExt;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/actions/newFile/OCNewSourceFileAction$MyCreateFileDialog", "getPresentableName"));
            }
            return string;
        }
    }
}

