/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.actions.newFile.OCNewClassAction;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.ui.OCTypeReferenceEditor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import icons.CidrLangIcons;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewCategoryAction
extends OCNewClassAction<CreateCategoryDialog> {
    private static final String CATEGORY_TEMPLATE_NAME = "Objective-C Category File.m";

    public OCNewCategoryAction() {
        super(OCBundle.message("create.category.title", new Object[0]), OCBundle.message("create.category.description", new Object[0]), CidrLangIcons.CodeAssistantClassExtension);
    }

    @Override
    @NotNull
    protected String getDefaultName() {
        String string = this.getDefaultClassPrefix();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/actions/newFile/OCNewCategoryAction", "getDefaultName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        selectedName = ((CreateCategoryDialog)this.myDialogPeer).myClassField.getText() + "+" + selectedName;
        OCNewFileActionBase.NewFileNames newFileNames = new OCNewFileActionBase.NewFileNames(selectedName + ((CreateCategoryDialog)this.myDialogPeer).getImplementationExtension(), ((CreateCategoryDialog)this.myDialogPeer).myCreateInterfaceCB.isSelected() ? selectedName + ".h" : null);
        if (newFileNames == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/actions/newFile/OCNewCategoryAction", "getNewFileNames"));
        }
        return newFileNames;
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName, PsiFile sampleFile) {
        OCFile implFile = ((OCFile)sampleFile).isHeader() ? ((OCFile)sampleFile).getAssociatedFile() : (OCFile)sampleFile;
        String extension = implFile != null && implFile.getName().endsWith(".mm") ? ".mm" : ".m";
        OCClassSymbol baseClass = this.getBaseClass();
        OCLog.LOG.assertTrue(baseClass != null);
        String categoryName = baseClass.getName() + "+" + selectedName;
        OCNewFileActionBase.NewFileNames newFileNames = new OCNewFileActionBase.NewFileNames(categoryName + extension, categoryName + ".h");
        if (newFileNames == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/actions/newFile/OCNewCategoryAction", "getNewFileNames"));
        }
        return newFileNames;
    }

    @Override
    protected void setAdditionalProperties(Properties properties, String fileName, PsiFile sampleFile, final Project project) {
        OCClassSymbol mainClassSymbol;
        String mainClassName;
        if (this.myDialogPeer != null) {
            mainClassName = ((CreateCategoryDialog)this.myDialogPeer).myClassField.getText();
            mainClassSymbol = (OCClassSymbol)((CreateCategoryDialog)this.myDialogPeer).myClassField.getClassDeclaration(project);
        } else {
            mainClassSymbol = this.getBaseClass();
            String string = mainClassName = mainClassSymbol != null ? mainClassSymbol.getName() : null;
        }
        if (mainClassSymbol != null && fileName.endsWith(".h")) {
            this.addAuxAction(new Runnable(){

                @Override
                public void run() {
                    OCInterfaceSymbol symbol = mainClassSymbol.getMainInterface();
                    for (PsiFile file2 : OCNewCategoryAction.this.getCreatedElements()) {
                        OCClassSymbol mainClass;
                        if (!(file2 instanceof OCFile) || !((OCFile)file2).isHeader()) continue;
                        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
                        if (document != null) {
                            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                        }
                        new OCImportSymbolFix((mainClass = (OCClassSymbol)((OCFile)file2).getSameNamedClass()) != null ? (OCClassDeclarationBase)mainClass.locateDefinition() : null, symbol, true).fixFirstItem(project, file2);
                    }
                }
            });
        }
        properties.setProperty("NAME", mainClassName + "(" + this.mySelectedName + ")");
        if (this.myDialogPeer == null) {
            properties.setProperty("HEADER_FILENAME", this.getNewFileNames(this.mySelectedName, sampleFile).getHeaderName());
        } else if (((CreateCategoryDialog)this.myDialogPeer).myCreateInterfaceCB.isSelected()) {
            properties.setProperty("HEADER_FILENAME", this.getNewFileNames(this.mySelectedName).getHeaderName());
        } else {
            properties.setProperty("HEADER_FILENAME", mainClassName + ".h");
        }
    }

    @Override
    protected String getFileTemplate(String fileName) {
        if (fileName.endsWith(".m") || fileName.endsWith(".mm")) {
            return "Objective-C Class.m";
        }
        if (fileName.endsWith(".h")) {
            return CATEGORY_TEMPLATE_NAME;
        }
        assert (false);
        return null;
    }

    @Nullable
    protected OCClassSymbol getBaseClass() {
        OCClassSymbol classSymbol = this.mySelectedFile instanceof OCFile ? OCCodeInsightUtil.getClassInFile((OCFile)this.mySelectedFile) : null;
        return classSymbol != null && classSymbol.getCategoryName() != null ? classSymbol.getMainInterface() : classSymbol;
    }

    @Override
    protected CreateCategoryDialog createDialog(String defaultName) {
        return new CreateCategoryDialog(defaultName);
    }

    protected class CreateCategoryDialog
    extends OCNewClassAction.CreateClassDialog {
        private JCheckBox myCreateInterfaceCB;
        private OCTypeReferenceEditor myClassField;

        public CreateCategoryDialog(String defaultName) {
            super(OCNewCategoryAction.this, OCBundle.message("create.category.dialog.title", new Object[0]), OCBundle.message("create.field.name.category", new Object[0]), defaultName);
        }

        @Override
        public void fillGenericControls(FormBuilder formBuilder) {
            this.myCreateInterfaceCB = new JCheckBox(OCBundle.message("create.checkbox.category.interface", new Object[0]));
            DialogUtil.registerMnemonic((AbstractButton)this.myCreateInterfaceCB, (char)'&');
            OCClassSymbol classSymbol = OCNewCategoryAction.this.getBaseClass();
            this.myClassField = OCTypeReferenceEditor.create(classSymbol, new Condition<OCSymbol>(){

                public boolean value(OCSymbol symbol) {
                    return symbol instanceof OCInterfaceSymbol && ((OCInterfaceSymbol)symbol).getCategoryName() == null;
                }
            }, (PsiElement)OCNewCategoryAction.this.mySelectedFile, false, OCNewCategoryAction.this.myProject);
            formBuilder.addLabeledComponent(OCBundle.message("create.field.class", new Object[0]), (JComponent)((Object)this.myClassField));
            super.fillGenericControls(formBuilder);
            formBuilder.addLabeledComponent("", (JComponent)this.myCreateInterfaceCB, 0);
            this.myClassField.addDocumentListener(new DocumentListener(){

                public void beforeDocumentChange(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    CreateCategoryDialog.this.validateOkAction();
                }
            });
            this.myCreateInterfaceCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CreateCategoryDialog.this.validateOkAction();
                }
            });
            final OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)OCNewCategoryAction.this.myProject).getCustomSettings(OCCodeStyleSettings.class);
            this.myCreateInterfaceCB.setSelected(settings == null || settings.CREATE_INTERFACE_FOR_CATEGORIES);
            OCNewCategoryAction.this.addAuxAction(new Runnable(){

                @Override
                public void run() {
                    if (settings != null) {
                        settings.CREATE_INTERFACE_FOR_CATEGORIES = CreateCategoryDialog.this.myCreateInterfaceCB.isSelected();
                    }
                }
            });
        }

        @Override
        protected boolean areControlsConsistent() {
            OCSymbol classDeclaration = this.myClassField.getClassDeclaration(OCNewCategoryAction.this.myProject);
            if (!(classDeclaration instanceof OCInterfaceSymbol) && !(classDeclaration instanceof OCImplementationSymbol)) {
                String title = OCBundle.message("create.category.no.class.dialog.title", new Object[0]);
                String message = OCBundle.message("create.category.no.class.dialog", this.myClassField.getText());
                if (Messages.showYesNoDialog((String)message, (String)title, (Icon)Messages.getWarningIcon()) != 0) {
                    return false;
                }
            }
            return super.areControlsConsistent();
        }

        @Override
        @Nullable
        protected String collectOkActionErrors() {
            if (StringUtil.isEmpty((String)this.myClassField.getText()) || StringUtil.isEmpty((String)this.myLocationField.getText())) {
                return "";
            }
            return super.collectOkActionErrors();
        }
    }
}

