/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OCQualifiedNameProvider
implements QualifiedNameProvider {
    @Override
    public PsiElement adjustElementToCopy(PsiElement element) {
        return null;
    }

    @Override
    public String getQualifiedName(PsiElement element) {
        if (element instanceof OCSymbolDeclarator) {
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            if (symbol instanceof OCSymbolWithParent) {
                return ((OCSymbolWithParent)symbol).getNameWithParent();
            }
            if (symbol != null) {
                return symbol.getName();
            }
        }
        return null;
    }

    @Override
    public PsiElement qualifiedNameToElement(String fqn, Project project) {
        OCSymbol clazz;
        Pattern pattern = Pattern.compile(".\\[([^ ]*) ([^ ]*)\\]");
        Matcher matcher = pattern.matcher(fqn);
        if (!matcher.matches()) {
            pattern = Pattern.compile("([^.]*).([^.]*)]");
            matcher = pattern.matcher(fqn);
        }
        if (matcher.matches() && (clazz = OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(project, matcher.group(1), null, null)) instanceof OCClassSymbol) {
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            ((OCClassSymbol)clazz).processMembersInAllCategories(matcher.group(2), OCMemberSymbol.class, finder, false);
            return finder.isFound() ? (PsiElement)((OCMemberSymbol)finder.getFoundValue()).locateDefinition() : null;
        }
        OCSymbol symbol = OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(project, fqn, null, null);
        return symbol != null ? (PsiElement)symbol.locateDefinition() : null;
    }

    @Override
    public void insertQualifiedName(String fqn, PsiElement element, Editor editor, Project project) {
        String string = fqn;
        if (element instanceof OCSymbolDeclarator) {
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            if (symbol instanceof OCMethodSymbol) {
                string = "@selector(" + symbol.getName() + ")";
            } else if (symbol instanceof OCPropertySymbol) {
                string = ((OCPropertySymbol)symbol).getParent() + "." + symbol.getName();
            } else if (symbol instanceof OCInstanceVariableSymbol) {
                string = ((OCInstanceVariableSymbol)symbol).getParent() + "->" + symbol.getName();
            }
        }
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)string);
    }
}

