/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public abstract class OCInternator<T> {
    private final ConcurrentMap<T, T> myCache = ContainerUtil.createConcurrentWeakKeyWeakValueMap();

    @NotNull
    public T intern(@NotNull T value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/lang/OCInternator", "intern"));
        }
        Object internedValue = this.myCache.get(value);
        if (internedValue != null) {
            Object v = internedValue;
            if (v == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/OCInternator", "intern"));
            }
            return (T)v;
        }
        T valueToIntern = this.valueToStore(value);
        Object object = ConcurrencyUtil.cacheOrGet(this.myCache, valueToIntern, valueToIntern);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/OCInternator", "intern"));
        }
        return (T)object;
    }

    @NotNull
    protected abstract T valueToStore(@NotNull T var1);
}

