/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SpecificNameItemProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.lang.CustomHeaderProvider;
import com.jetbrains.cidr.lang.OCIncludeHelper;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeaderRoots;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCIncludeHelpers {
    public static OCIncludeHelper[] getIncludeHelpers() {
        return (OCIncludeHelper[])Extensions.getExtensions(OCIncludeHelper.EP_NAME);
    }

    public static ShowInCompletion showInCompletion(@Nullable PsiFileSystemItem item) {
        if (item == null) {
            return ShowInCompletion.DEFAULT;
        }
        ShowInCompletion result2 = ShowInCompletion.DEFAULT;
        for (OCIncludeHelper each : OCIncludeHelpers.getIncludeHelpers()) {
            ShowInCompletion eachResult = each.showInCompletion(item);
            if (eachResult == ShowInCompletion.DEFAULT) continue;
            if (eachResult == ShowInCompletion.SHOW) {
                return ShowInCompletion.SHOW;
            }
            result2 = eachResult;
        }
        return result2;
    }

    @Nullable
    public static VirtualFile resolveIncludedFile(@Nullable OCResolveRootAndConfiguration rootAndConfiguration, @Nullable VirtualFile context, @NotNull OCIncludeSymbol.IncludePath include, @NotNull Project project) {
        if (include == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "include", "com/jetbrains/cidr/lang/OCIncludeHelpers", "resolveIncludedFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/OCIncludeHelpers", "resolveIncludedFile"));
        }
        Ref result2 = new Ref();
        OCIncludeHelpers.resolveNextIncludedFile(rootAndConfiguration, context, null, include, project, (Ref<VirtualFile>)result2);
        return (VirtualFile)result2.get();
    }

    public static void resolveNextIncludedFile(@Nullable OCResolveRootAndConfiguration rootAndConfiguration, @Nullable VirtualFile context, @Nullable VirtualFile after, @NotNull OCIncludeSymbol.IncludePath include, @NotNull Project project, final @NotNull Ref<VirtualFile> result2) {
        VirtualFile file2;
        List<PsiFileSystemItem> firstSegmentElements;
        PsiFileSystemItem item;
        if (include == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "include", "com/jetbrains/cidr/lang/OCIncludeHelpers", "resolveNextIncludedFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/OCIncludeHelpers", "resolveNextIncludedFile"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/OCIncludeHelpers", "resolveNextIncludedFile"));
        }
        if (project.isDisposed()) {
            return;
        }
        if (context == null || !context.isValid()) {
            return;
        }
        final String[] pathElements = include.getPath().split("/");
        if (pathElements.length == 0) {
            return;
        }
        final String first = pathElements[0];
        if (first.isEmpty()) {
            VirtualFile file3 = LocalFileSystem.getInstance().findFileByPath(include.getPath());
            result2.set(file3 == null || file3.isDirectory() ? null : file3);
            return;
        }
        boolean searchInCurrent = after == null && !include.isAngleBrackets() && !FileUtil.namesEqual((String)context.getName(), (String)include.getPath());
        final Ref afterRef = new Ref((Object)after);
        if (searchInCurrent && (item = FileReferenceHelper.getPsiFileSystemItem(PsiManager.getInstance((Project)project), context)) != null && item.getParent() != null && OCIncludeHelpers.findHeader(firstSegmentElements = OCIncludeHelpers.findChild(item.getParent(), first), pathElements, (Ref<VirtualFile>)afterRef, result2)) {
            return;
        }
        if (rootAndConfiguration != null) {
            Collection<PsiFileSystemItem> projectHeaders;
            if (!include.isAngleBrackets() && OCIncludeHelpers.findHeader(projectHeaders = HeaderRootsSegmentCache.getFirstSegmentsInProjectHeader(rootAndConfiguration, first), pathElements, (Ref<VirtualFile>)afterRef, result2)) {
                return;
            }
            Collection<PsiFileSystemItem> libHeaders = HeaderRootsSegmentCache.getFirstSegmentsInLibraryRoots(rootAndConfiguration, first);
            if (OCIncludeHelpers.findHeader(libHeaders, pathElements, (Ref<VirtualFile>)afterRef, result2)) {
                return;
            }
        }
        if (!OCIncludeHelpers.processContainingFramework(project, context, new Processor<PsiFileSystemItem>(){

            public boolean process(PsiFileSystemItem framework) {
                if (framework.getName().equals(first) && OCIncludeHelpers.findHeader(Collections.singletonList(framework), pathElements, (Ref<VirtualFile>)afterRef, (Ref<VirtualFile>)result2)) {
                    return false;
                }
                return !OCIncludeHelpers.findHeader(OCIncludeHelpers.findChild(framework, first), pathElements, (Ref<VirtualFile>)afterRef, (Ref<VirtualFile>)result2);
            }
        })) {
            return;
        }
        if (rootAndConfiguration != null && (file2 = OCIncludeHelpers.getFileFromExtension(include.getPath(), rootAndConfiguration.getConfiguration())) != null) {
            result2.set((Object)file2);
        }
    }

    @Nullable
    public static VirtualFile getFileFromExtension(@NotNull String headerName, @Nullable OCResolveConfiguration configuration) {
        if (headerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerName", "com/jetbrains/cidr/lang/OCIncludeHelpers", "getFileFromExtension"));
        }
        for (CustomHeaderProvider provider : (CustomHeaderProvider[])CustomHeaderProvider.EP_NAME.getExtensions()) {
            VirtualFile header = provider.getCustomHeaderFile(headerName, configuration);
            if (header == null) continue;
            return header;
        }
        return null;
    }

    @Nullable
    public static String provideSerializationPathForExtensionFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/OCIncludeHelpers", "provideSerializationPathForExtensionFile"));
        }
        for (CustomHeaderProvider provider : (CustomHeaderProvider[])CustomHeaderProvider.EP_NAME.getExtensions()) {
            String path = provider.provideSerializationPath(file2);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    @Nullable
    public static VirtualFile getCustomHeader(String serializationPath, Project project, VirtualFile file2) {
        for (CustomHeaderProvider provider : (CustomHeaderProvider[])CustomHeaderProvider.EP_NAME.getExtensions()) {
            VirtualFile headerFile = provider.getCustomHeaderFile(serializationPath, project, file2);
            if (headerFile == null) continue;
            return headerFile;
        }
        return null;
    }

    private static boolean findHeader(@NotNull Collection<PsiFileSystemItem> firstSegmentElements, @NotNull String[] pathElements, @NotNull Ref<VirtualFile> afterRef, @NotNull Ref<VirtualFile> result2) {
        if (firstSegmentElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstSegmentElements", "com/jetbrains/cidr/lang/OCIncludeHelpers", "findHeader"));
        }
        if (pathElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathElements", "com/jetbrains/cidr/lang/OCIncludeHelpers", "findHeader"));
        }
        if (afterRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterRef", "com/jetbrains/cidr/lang/OCIncludeHelpers", "findHeader"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/OCIncludeHelpers", "findHeader"));
        }
        for (PsiFileSystemItem segment : firstSegmentElements) {
            PsiFile candidate = null;
            if (pathElements.length != 1) {
                candidate = OCIncludeHelpers.find(segment, pathElements, 1);
            } else if (segment instanceof PsiFile) {
                candidate = (PsiFile)segment;
            }
            if (candidate == null) continue;
            VirtualFile file2 = candidate.getVirtualFile();
            VirtualFile after = (VirtualFile)afterRef.get();
            if (after == null) {
                result2.set((Object)file2);
                return true;
            }
            if (!Comparing.equal((Object)file2, (Object)after)) continue;
            afterRef.set(null);
        }
        return false;
    }

    public static boolean processContainingFramework(@NotNull Project project, @Nullable VirtualFile forFile, @NotNull Processor<PsiFileSystemItem> processor2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/OCIncludeHelpers", "processContainingFramework"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/OCIncludeHelpers", "processContainingFramework"));
        }
        if (forFile == null) {
            return true;
        }
        for (OCIncludeHelper each : OCIncludeHelpers.getIncludeHelpers()) {
            if (each.processContainingFramework(project, forFile, processor2)) continue;
            return false;
        }
        return true;
    }

    public static boolean processImportSpecifications(@NotNull Project project, @NotNull OCResolveRootAndConfiguration rootAndConfiguration, @Nullable VirtualFile targetFile, @NotNull VirtualFile fileToImport, @NotNull Processor<OCAutoImportHelper.ImportSpecification> processor2) {
        OCAutoImportHelper[] extensions;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/OCIncludeHelpers", "processImportSpecifications"));
        }
        if (rootAndConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootAndConfiguration", "com/jetbrains/cidr/lang/OCIncludeHelpers", "processImportSpecifications"));
        }
        if (fileToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToImport", "com/jetbrains/cidr/lang/OCIncludeHelpers", "processImportSpecifications"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/OCIncludeHelpers", "processImportSpecifications"));
        }
        for (OCAutoImportHelper each : extensions = (OCAutoImportHelper[])Extensions.getExtensions(OCAutoImportHelper.EP_NAME)) {
            if (!each.supports(rootAndConfiguration) || each.processPathSpecificationToInclude(project, targetFile, fileToImport, rootAndConfiguration, processor2)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static PsiFile find(PsiFileSystemItem root, String[] pathElements, int cur) {
        if (root == null) {
            return null;
        }
        String name = pathElements[cur];
        for (PsiFileSystemItem item : OCIncludeHelpers.findChild(root, name)) {
            if (cur == pathElements.length - 1) {
                if (!(item instanceof PsiFile)) continue;
                return (PsiFile)item;
            }
            PsiFile element = OCIncludeHelpers.find(item, pathElements, cur + 1);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    @NotNull
    private static List<PsiFileSystemItem> findChild(PsiFileSystemItem parent, String childName) {
        PsiFile found;
        if (parent == null || !parent.isValid()) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/OCIncludeHelpers", "findChild"));
            }
            return list;
        }
        if ("..".equals(childName)) {
            VirtualFile vFile = parent.getVirtualFile();
            for (OCIncludeHelper each : OCIncludeHelpers.getIncludeHelpers()) {
                VirtualFile headersRoot = each.findHeadersRoot(parent);
                if (headersRoot == null) continue;
                vFile = headersRoot;
                break;
            }
            if (vFile == null) {
                List<PsiFileSystemItem> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/OCIncludeHelpers", "findChild"));
                }
                return list;
            }
            VirtualFile vParent = vFile.getParent();
            if (vParent == null) {
                List<PsiFileSystemItem> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/OCIncludeHelpers", "findChild"));
                }
                return list;
            }
            PsiDirectory directory = parent.getManager().findDirectory(vParent);
            List<Object> list = directory != null ? Collections.singletonList(directory) : Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/OCIncludeHelpers", "findChild"));
            }
            return list;
        }
        if (".".equals(childName)) {
            List<PsiFileSystemItem> list = Collections.singletonList(parent);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/OCIncludeHelpers", "findChild"));
            }
            return list;
        }
        if (parent instanceof PsiDirectory && (found = ((PsiDirectory)parent).findFile(childName)) != null) {
            List<PsiFile> list = Collections.singletonList(found);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/OCIncludeHelpers", "findChild"));
            }
            return list;
        }
        final SmartList result2 = new SmartList();
        parent.processChildren((PsiElementProcessor)new SpecificNameItemProcessor(childName){

            public boolean execute(@NotNull PsiFileSystemItem element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/OCIncludeHelpers$2", "execute"));
                }
                result2.add((Object)element);
                return true;
            }
        });
        SmartList smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/OCIncludeHelpers", "findChild"));
        }
        return smartList;
    }

    private static class FirstSegmentCache {
        @NotNull
        private final List<HeadersSearchRoot> myRoots;
        private final boolean mySupportsRelative;
        private Map<String, List<PsiFileSystemItem>> myCache;

        private FirstSegmentCache(@NotNull List<HeadersSearchRoot> roots, boolean relative) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/jetbrains/cidr/lang/OCIncludeHelpers$FirstSegmentCache", "<init>"));
            }
            this.mySupportsRelative = relative;
            this.myRoots = roots;
        }

        private void prepareCache() {
            if (this.myCache != null) {
                return;
            }
            this.myCache = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
            for (PsiFileSystemItem psiFileSystemItem : this.myRoots) {
                if (!psiFileSystemItem.isValid()) continue;
                psiFileSystemItem.processChildren((PsiElementProcessor)new PsiElementProcessor<PsiFileSystemItem>(){

                    public boolean execute(@NotNull PsiFileSystemItem element) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/OCIncludeHelpers$FirstSegmentCache$1", "execute"));
                        }
                        String segment = element.getName();
                        ArrayList<PsiFileSystemItem> items = (ArrayList<PsiFileSystemItem>)FirstSegmentCache.this.myCache.get(segment);
                        if (items == null) {
                            items = new ArrayList<PsiFileSystemItem>();
                            FirstSegmentCache.this.myCache.put(segment, items);
                        }
                        items.add(element);
                        return true;
                    }
                });
            }
        }

        private synchronized Collection<PsiFileSystemItem> getFiles(@NotNull String segment) {
            if (segment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segment", "com/jetbrains/cidr/lang/OCIncludeHelpers$FirstSegmentCache", "getFiles"));
            }
            this.prepareCache();
            List<Object> items = this.myCache.get(segment);
            if (items == null) {
                if (this.mySupportsRelative) {
                    items = new ArrayList<PsiFileSystemItem>();
                    for (PsiFileSystemItem psiFileSystemItem : this.myRoots) {
                        if (!psiFileSystemItem.isValid()) continue;
                        items.addAll(OCIncludeHelpers.findChild(psiFileSystemItem, segment));
                    }
                    this.myCache.put(segment, items);
                } else {
                    items = Collections.emptyList();
                }
            }
            return items;
        }
    }

    private static class HeaderRootsSegmentCache {
        private static final NotNullLazyKey<CachedValue<HeaderRootsSegmentCache>, Project> RESOLVE_INCLUDE_IN_PROJECT_HEADERS_CACHE = HeaderRootsSegmentCache.createCacheKey("RESOLVE_INCLUDE_IN_PROJECT_HEADERS_CACHE", false);
        private static final NotNullLazyKey<CachedValue<HeaderRootsSegmentCache>, Project> RESOLVE_INCLUDE_CACHE = HeaderRootsSegmentCache.createCacheKey("RESOLVE_INCLUDE_CACHE", true);
        @NotNull
        private final HashMap<HeaderRoots, FirstSegmentCache> myCache = new HashMap();
        private final boolean mySupportsRelative;

        private HeaderRootsSegmentCache(boolean supportsRelative) {
            this.mySupportsRelative = supportsRelative;
        }

        @NotNull
        static Collection<PsiFileSystemItem> getFirstSegmentsInLibraryRoots(OCResolveRootAndConfiguration headerResolveCtx, String first) {
            Project project = headerResolveCtx.getProject();
            if (project == null) {
                List<PsiFileSystemItem> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/OCIncludeHelpers$HeaderRootsSegmentCache", "getFirstSegmentsInLibraryRoots"));
                }
                return list;
            }
            HeaderRootsSegmentCache headerRootsCache = (HeaderRootsSegmentCache)((CachedValue)RESOLVE_INCLUDE_CACHE.getValue((UserDataHolder)project)).getValue();
            HeaderRoots roots = headerResolveCtx.getLibraryHeadersRoots();
            FirstSegmentCache fsc = headerRootsCache.getFirstSegmentCache(roots);
            Collection collection = fsc.getFiles(first);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/OCIncludeHelpers$HeaderRootsSegmentCache", "getFirstSegmentsInLibraryRoots"));
            }
            return collection;
        }

        @NotNull
        static Collection<PsiFileSystemItem> getFirstSegmentsInProjectHeader(@NotNull OCResolveRootAndConfiguration headerResolveCtx, @NotNull String firstSegment) {
            if (headerResolveCtx == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerResolveCtx", "com/jetbrains/cidr/lang/OCIncludeHelpers$HeaderRootsSegmentCache", "getFirstSegmentsInProjectHeader"));
            }
            if (firstSegment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstSegment", "com/jetbrains/cidr/lang/OCIncludeHelpers$HeaderRootsSegmentCache", "getFirstSegmentsInProjectHeader"));
            }
            Project project = headerResolveCtx.getProject();
            if (project == null) {
                List<PsiFileSystemItem> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/OCIncludeHelpers$HeaderRootsSegmentCache", "getFirstSegmentsInProjectHeader"));
                }
                return list;
            }
            HeaderRootsSegmentCache headerRootsCache = (HeaderRootsSegmentCache)((CachedValue)RESOLVE_INCLUDE_IN_PROJECT_HEADERS_CACHE.getValue((UserDataHolder)project)).getValue();
            HeaderRoots roots = headerResolveCtx.getProjectHeadersRoots();
            FirstSegmentCache fsc = headerRootsCache.getFirstSegmentCache(roots);
            Collection collection = fsc.getFiles(firstSegment);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/OCIncludeHelpers$HeaderRootsSegmentCache", "getFirstSegmentsInProjectHeader"));
            }
            return collection;
        }

        private synchronized FirstSegmentCache getFirstSegmentCache(@NotNull HeaderRoots roots) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/jetbrains/cidr/lang/OCIncludeHelpers$HeaderRootsSegmentCache", "getFirstSegmentCache"));
            }
            FirstSegmentCache cache = this.myCache.get(roots);
            if (cache == null) {
                cache = new FirstSegmentCache(roots.getRoots(), this.mySupportsRelative);
                this.myCache.put(roots, cache);
            }
            return cache;
        }

        private static NotNullLazyKey<CachedValue<HeaderRootsSegmentCache>, Project> createCacheKey(@NotNull String name, final boolean supportsRelative) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/OCIncludeHelpers$HeaderRootsSegmentCache", "createCacheKey"));
            }
            return NotNullLazyKey.create((String)name, (NotNullFunction)new NotNullFunction<Project, CachedValue<HeaderRootsSegmentCache>>(){

                @NotNull
                public CachedValue<HeaderRootsSegmentCache> fun(final Project project) {
                    CachedValue cachedValue = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new CachedValueProvider<HeaderRootsSegmentCache>(){

                        @Nullable
                        public CachedValueProvider.Result<HeaderRootsSegmentCache> compute() {
                            OCWorkspaceModificationTrackers tracker = OCWorkspaceManager.getWorkspace(project).getModificationTrackers();
                            return new CachedValueProvider.Result((Object)new HeaderRootsSegmentCache(supportsRelative), new Object[]{tracker.getProjectsListTracker(), tracker.getProjectFilesListTracker(), tracker.getSourceFilesListTracker(), tracker.getBuildConfigurationChangesTracker()});
                        }
                    }, false);
                    if (cachedValue == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/OCIncludeHelpers$HeaderRootsSegmentCache$1", "fun"));
                    }
                    return cachedValue;
                }
            });
        }
    }

    public static enum ShowInCompletion {
        SHOW,
        DON_NOT_SHOW,
        DEFAULT;

    }
}

