/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.generate.handlers;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.testing.CidrTestUtil;
import com.jetbrains.cidr.generate.handlers.OCCppGenerateTestHandler;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGoogleGenerateTestHandler
extends OCCppGenerateTestHandler {
    public OCGoogleGenerateTestHandler(String actionTitle, String templateName) {
        super(actionTitle, templateName);
    }

    @Override
    public boolean isValidFor(Editor editor, PsiFile file2) {
        return super.isValidFor(editor, file2) && FileSymbolTablesCache.areSymbolsLoaded(file2.getProject()) && CidrTestUtil.fileIncludesGoogleTest(file2);
    }

    @Override
    @Nullable
    protected OCCppActionContext<OCStructSymbol, OCFunctionSymbol> evaluateActionContext(Project project, @Nullable Editor editor, PsiFile file2) {
        return this.evaluateActionContext((OCStructSymbol)null, (PsiElement)file2);
    }

    @Override
    protected void onTemplateFinished(@NotNull PsiFile file2, @NotNull RangeMarker rangeMarker) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/generate/handlers/OCGoogleGenerateTestHandler", "onTemplateFinished"));
        }
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/jetbrains/cidr/generate/handlers/OCGoogleGenerateTestHandler", "onTemplateFinished"));
        }
        PsiElement at = OCGoogleGenerateTestHandler.getFirstInsertedElement(file2, rangeMarker);
        if (!(at instanceof OCMacroCall)) {
            at = PsiTreeUtil.getNextSiblingOfType((PsiElement)at, OCMacroCall.class);
        }
        if (at instanceof OCMacroCall) {
            OCReferenceElement referenceElement = ((OCMacroCall)at).getMacroReferenceElement();
            List<OCMacroCallArgument> arguments = ((OCMacroCall)at).getArguments();
            if (referenceElement != null && referenceElement.getName().equals("TEST") && arguments.size() == 2) {
                String suiteName = CidrTestUtil.extractArgumentValue(arguments.get(0));
                String testName = CidrTestUtil.extractArgumentValue(arguments.get(1));
                if (OCGoogleGenerateTestHandler.migrateToParameterized(referenceElement, suiteName)) {
                    return;
                }
                if (OCGoogleGenerateTestHandler.migrateToTyped(referenceElement, suiteName)) {
                    return;
                }
                if (OCGoogleGenerateTestHandler.migrateToTypeParameterized(referenceElement, suiteName, testName)) {
                    return;
                }
                OCGoogleGenerateTestHandler.migrateToFixture(referenceElement, suiteName);
            }
        }
    }

    private static boolean migrateToFixture(OCReferenceElement referenceElement, String suiteName) {
        return OCGoogleGenerateTestHandler.correctMacroNameIfNeeded(suiteName, referenceElement, "TEST_F", new Condition<OCSymbol>(){

            public boolean value(OCSymbol symbol) {
                return symbol instanceof OCStructSymbol && CidrTestUtil.isGoogleTestClass((OCStructSymbol)symbol);
            }
        }, null);
    }

    private static boolean migrateToTypeParameterized(OCReferenceElement referenceElement, String suiteName, final String testName) {
        Consumer<OCSymbol> consumer = new Consumer<OCSymbol>(){

            public void consume(OCSymbol symbol) {
                OCReferenceElement macroReferenceElement;
                OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getParentOfType(symbol.locateDefinition(), OCDeclaration.class);
                OCMacroCall macroCall = (OCMacroCall)PsiTreeUtil.getPrevSiblingOfType((PsiElement)declaration, OCMacroCall.class);
                if (macroCall != null && (macroReferenceElement = macroCall.getMacroReferenceElement()) != null && macroReferenceElement.getName().equals("REGISTER_TYPED_TEST_CASE_P")) {
                    List<OCMacroCallArgument> arguments = macroCall.getArguments();
                    OCMacroCallArgument lastArgument = arguments.get(arguments.size() - 1);
                    PsiElement newElement = OCElementFactory.create(OCTokenTypes.COMMA, macroCall);
                    PsiElement added = OCChangeUtil.addAfter(macroCall, newElement, lastArgument);
                    OCChangeUtil.addAfter(macroCall, OCElementFactory.expressionFromText(testName, macroCall), added);
                }
            }
        };
        return OCGoogleGenerateTestHandler.correctMacroNameIfNeeded("gtest_registered_test_names_" + suiteName + "_", referenceElement, "TYPED_TEST_P", null, consumer);
    }

    private static boolean migrateToTyped(OCReferenceElement referenceElement, String suiteName) {
        return OCGoogleGenerateTestHandler.correctMacroNameIfNeeded("gtest_type_params_" + suiteName + "_", referenceElement, "TYPED_TEST", null, null);
    }

    private static boolean migrateToParameterized(OCReferenceElement referenceElement, String suiteName) {
        return OCGoogleGenerateTestHandler.correctMacroNameIfNeeded(suiteName, referenceElement, "TEST_P", new Condition<OCSymbol>(){

            public boolean value(OCSymbol symbol) {
                return symbol instanceof OCStructSymbol && CidrTestUtil.isGoogleTestClassWithAncestor((OCStructSymbol)symbol, "TestWithParam");
            }
        }, null);
    }

    private static boolean correctMacroNameIfNeeded(@NotNull String suiteName, @NotNull OCReferenceElement referenceElement, @NotNull String correctMacroName, final @Nullable Condition<OCSymbol> condition, final @Nullable Consumer<OCSymbol> onCorrection) {
        if (suiteName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteName", "com/jetbrains/cidr/generate/handlers/OCGoogleGenerateTestHandler", "correctMacroNameIfNeeded"));
        }
        if (referenceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceElement", "com/jetbrains/cidr/generate/handlers/OCGoogleGenerateTestHandler", "correctMacroNameIfNeeded"));
        }
        if (correctMacroName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "correctMacroName", "com/jetbrains/cidr/generate/handlers/OCGoogleGenerateTestHandler", "correctMacroNameIfNeeded"));
        }
        final OCFile file2 = referenceElement.getContainingOCFile();
        CommonProcessors.FindFirstProcessor<OCSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return file2.equals(symbol.getContainingOCFile()) && (condition == null || condition.value((Object)symbol));
            }
        };
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(referenceElement.getProject(), (Processor<OCSymbol>)processor2, suiteName);
        if (processor2.isFound()) {
            new WriteAction((CommonProcessors.FindFirstProcessor)processor2, referenceElement, correctMacroName, file2){
                final /* synthetic */ CommonProcessors.FindFirstProcessor val$processor;
                final /* synthetic */ OCReferenceElement val$referenceElement;
                final /* synthetic */ String val$correctMacroName;
                final /* synthetic */ OCFile val$file;
                {
                    this.val$processor = findFirstProcessor;
                    this.val$referenceElement = oCReferenceElement;
                    this.val$correctMacroName = string;
                    this.val$file = oCFile;
                }

                protected void run(@NotNull Result result2) throws Throwable {
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/generate/handlers/OCGoogleGenerateTestHandler$5", "run"));
                    }
                    if (onCorrection != null) {
                        onCorrection.consume(this.val$processor.getFoundValue());
                    }
                    this.val$referenceElement.setName(this.val$correctMacroName);
                    FileSymbolTablesCache.getInstance(this.val$file.getProject()).scheduleReparseFile(this.val$file);
                }
            }.execute();
        }
        return processor2.isFound();
    }

    @Nullable
    private static PsiElement getFirstInsertedElement(@NotNull PsiFile file2, @NotNull RangeMarker rangeMarker) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/generate/handlers/OCGoogleGenerateTestHandler", "getFirstInsertedElement"));
        }
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/jetbrains/cidr/generate/handlers/OCGoogleGenerateTestHandler", "getFirstInsertedElement"));
        }
        PsiElement at = file2.findElementAt(rangeMarker.getStartOffset());
        while (at instanceof PsiWhiteSpace) {
            at = at.getNextSibling();
        }
        at = PsiTreeUtil.getContextOfType((PsiElement)at, (boolean)false, (Class[])new Class[]{OCMacroCall.class, OCDeclaration.class});
        return at;
    }

    @Override
    protected int getInsertPosition(PsiElement element, int caretOffset, PsiElement at, List<OCFunctionSymbol> members, OCCppActionContext<OCStructSymbol, OCFunctionSymbol> actionContext) {
        boolean insertAfter = false;
        Condition<PsiElement> condition = new Condition<PsiElement>(){

            public boolean value(PsiElement element) {
                return element.getParent() instanceof OCFile || element.getParent() instanceof OCCppNamespace;
            }
        };
        if (condition.value((Object)at)) {
            return at.getTextRange().getEndOffset();
        }
        OCStruct struct = (OCStruct)PsiTreeUtil.getNonStrictParentOfType((PsiElement)at, (Class[])new Class[]{OCStruct.class});
        if (struct != null) {
            insertAfter = CidrTestUtil.isGoogleTestFixture((OCStructSymbol)struct.getSymbol(), false);
        }
        at = PsiTreeUtil.findFirstParent((PsiElement)at, (boolean)true, (Condition)condition);
        at = insertAfter ? PsiTreeUtil.getNextSiblingOfType((PsiElement)at, PsiWhiteSpace.class) : PsiTreeUtil.getPrevSiblingOfType((PsiElement)at, PsiWhiteSpace.class);
        if (at != null) {
            return at.getTextRange().getEndOffset();
        }
        return -1;
    }
}

