/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.generate.handlers;

import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.testing.CidrTestUtil;
import com.jetbrains.cidr.generate.handlers.OCCppGenerateTestHandler;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGoogleGenerateFixtureMethodsHandler
extends OCCppGenerateTestHandler {
    public OCGoogleGenerateFixtureMethodsHandler(String actionTitle, String templateName) {
        super(actionTitle, templateName);
    }

    @Override
    public boolean isValidFor(Editor editor, PsiFile file2) {
        return FileSymbolTablesCache.areSymbolsLoaded(file2.getProject()) && super.isValidFor(editor, file2);
    }

    @Override
    @Nullable
    protected OCStructSymbol getParent(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/generate/handlers/OCGoogleGenerateFixtureMethodsHandler", "getParent"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/generate/handlers/OCGoogleGenerateFixtureMethodsHandler", "getParent"));
        }
        OCStructSymbol symbol = (OCStructSymbol)super.getParent(project, editor, file2);
        if (symbol != null || editor == null) {
            return symbol;
        }
        PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
        if (at != null) {
            Couple<String> suite;
            List<OCMacroCallArgument> arguments;
            OCMacroCall macroCall;
            OCSymbolWithQualifiedName symbolWithQualifiedName;
            OCFunctionSymbol functionSymbol;
            OCFunctionDefinition parent = (OCFunctionDefinition)PsiTreeUtil.getContextOfType((PsiElement)at, (Class[])new Class[]{OCFunctionDefinition.class});
            if (parent != null && (functionSymbol = parent.getSymbol()) != null && (symbolWithQualifiedName = functionSymbol.getResolvedOwner()) instanceof OCStructSymbol) {
                symbol = (OCStructSymbol)symbolWithQualifiedName;
            }
            if (symbol == null && (macroCall = CidrTestUtil.findGoogleTestMacros(at)) != null && (arguments = macroCall.getArguments()).size() >= 2) {
                String suiteName = CidrTestUtil.extractArgumentValue(arguments.get(0));
                String testName = CidrTestUtil.extractArgumentValue(arguments.get(1));
                symbol = CidrTestUtil.findGoogleTestSymbol(at.getProject(), suiteName, testName);
            }
            if (symbol == null && (suite = CidrTestUtil.extractFullSuiteNameFromMacro(at)) != null) {
                CommonProcessors.FindProcessor<OCSymbol> processor2 = new CommonProcessors.FindProcessor<OCSymbol>(){

                    protected boolean accept(OCSymbol symbol) {
                        return symbol instanceof OCStructSymbol;
                    }
                };
                OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project, (Processor<OCSymbol>)processor2, (String)suite.first);
                if (processor2.isFound()) {
                    symbol = (OCStructSymbol)processor2.getFoundValue();
                }
            }
        }
        return symbol != null ? CidrTestUtil.findGoogleTestFixture(symbol, true) : null;
    }

    @Override
    @Nullable
    protected OCCppActionContext<OCStructSymbol, OCFunctionSymbol> evaluateActionContext(final OCStructSymbol parent, PsiElement element) {
        return new OCCppActionContext<OCStructSymbol, OCFunctionSymbol>(parent, element){

            @Override
            @NotNull
            public Collection<OCFunctionSymbol> getMemberCandidates() {
                List<OCFunctionSymbol> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/generate/handlers/OCGoogleGenerateFixtureMethodsHandler$2", "getMemberCandidates"));
                }
                return list;
            }

            @Override
            public boolean isValid() {
                return CidrTestUtil.isGoogleTestFixture(parent, true);
            }
        };
    }

    @Override
    protected int getInsertPosition(PsiElement element, int caretOffset, PsiElement at, List<OCFunctionSymbol> members, OCCppActionContext<OCStructSymbol, OCFunctionSymbol> actionContext) {
        OCElement parentDefinition = (OCElement)((OCStructSymbol)actionContext.getParent()).locateDefinition();
        if (parentDefinition != null && parentDefinition.getContainingFile().equals(element.getContainingFile()) && !parentDefinition.getTextRange().contains(caretOffset)) {
            element = parentDefinition;
        }
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(element))) {
            element = element.getNextSibling();
        }
        PsiElement parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCStruct.class, OCFunctionDefinition.class});
        if (parent == null) {
            return -1;
        }
        if (parent instanceof OCStruct) {
            return ((OCStruct)parent).getFunctionsStartOffset();
        }
        return parent.getTextRange().getStartOffset();
    }

    @Override
    @NotNull
    protected String getTemplateText(@NotNull FileTemplateDescriptor templateDesc, Project project) {
        if (templateDesc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateDesc", "com/jetbrains/cidr/generate/handlers/OCGoogleGenerateFixtureMethodsHandler", "getTemplateText"));
        }
        String string = "protected:" + super.getTemplateText(templateDesc, project);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/generate/handlers/OCGoogleGenerateFixtureMethodsHandler", "getTemplateText"));
        }
        return string;
    }
}

