/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.SMStacktraceParser;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.jetbrains.cidr.execution.testing.CidrTestUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCAbstractTestConsoleProperties
extends SMTRunnerConsoleProperties
implements SMCustomMessagesParsing,
SMStacktraceParser {
    private final ExecutionTarget myTarget;

    protected OCAbstractTestConsoleProperties(@NotNull RunConfiguration config, @NotNull String testFrameworkName, @NotNull Executor executor, @NotNull ExecutionTarget target) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/cidr/execution/testing/OCAbstractTestConsoleProperties", "<init>"));
        }
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/jetbrains/cidr/execution/testing/OCAbstractTestConsoleProperties", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/cidr/execution/testing/OCAbstractTestConsoleProperties", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/cidr/execution/testing/OCAbstractTestConsoleProperties", "<init>"));
        }
        super(config, testFrameworkName, executor);
        this.myTarget = target;
    }

    @Override
    @NotNull
    public ExecutionTarget getExecutionTarget() {
        ExecutionTarget executionTarget = this.myTarget;
        if (executionTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/OCAbstractTestConsoleProperties", "getExecutionTarget"));
        }
        return executionTarget;
    }

    @NotNull
    protected abstract Pattern getAssertionPattern();

    @Override
    @Nullable
    public Navigatable getErrorNavigatable(@NotNull Project project, @NotNull String stacktrace) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/execution/testing/OCAbstractTestConsoleProperties", "getErrorNavigatable"));
        }
        if (stacktrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stacktrace", "com/jetbrains/cidr/execution/testing/OCAbstractTestConsoleProperties", "getErrorNavigatable"));
        }
        Matcher m = this.getAssertionPattern().matcher(stacktrace);
        if (m.find()) {
            int line;
            String path = m.group(1);
            String lineString = m.group(2);
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(CidrTestUtil.normalizePath(path));
            if (file2 == null) {
                return null;
            }
            try {
                line = Integer.valueOf(lineString) - 1;
            }
            catch (NumberFormatException e) {
                return null;
            }
            return this.findSuitableNavigatableForLine(project, file2, line);
        }
        return null;
    }
}

