/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestUtil {
    private static final Pattern namePattern = Pattern.compile("\\w+_\\w+_Test");
    private static final Set<String> GOOGLE_TEST_MACRO_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"GTEST_TEST_", "TEST_P", "TYPED_TEST", "TYPED_TEST_P"});

    @Nullable
    public static OCStructSymbol findGoogleTestSymbol(Project project, final @NotNull String suiteName, final @NotNull String testName) {
        boolean found;
        if (suiteName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteName", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "findGoogleTestSymbol"));
        }
        if (testName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "findGoogleTestSymbol"));
        }
        final Ref result2 = new Ref();
        boolean bl = found = !OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project, new Processor<OCSymbol>(){

            public boolean process(OCSymbol ocSymbol) {
                if (ocSymbol instanceof OCStructSymbol && CidrTestUtil.googleTestNameMatches((OCStructSymbol)ocSymbol, suiteName, testName)) {
                    result2.set((Object)((OCStructSymbol)ocSymbol));
                    return false;
                }
                return true;
            }
        }, suiteName + "_" + testName + "_Test");
        if (!found) {
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project, new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    OCSymbol res;
                    Iterator symbols;
                    MostlySingularMultiMap<String, OCSymbol> members;
                    if (symbol instanceof OCNamespaceSymbol && (members = ((OCNamespaceSymbol)symbol).getMembers()) != null && (symbols = members.get((Object)testName).iterator()).hasNext() && (res = (OCSymbol)symbols.next()) instanceof OCStructSymbol) {
                        result2.set((Object)((OCStructSymbol)res));
                    }
                    return true;
                }
            }, "gtest_case_" + suiteName + "_");
        }
        return (OCStructSymbol)result2.get();
    }

    @NotNull
    public static Collection<OCStructSymbol> findGoogleTestSymbols(Project project) {
        Collection<OCStructSymbol> collection = CidrTestUtil.findGoogleTestSymbolsForSuite(project, null, false, true);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "findGoogleTestSymbols"));
        }
        return collection;
    }

    @NotNull
    public static Collection<OCStructSymbol> findGoogleTestSymbolsForSuiteRandomly(Project project, @Nullable String suiteName, boolean onlyFirst) {
        Collection<OCStructSymbol> collection = CidrTestUtil.findGoogleTestSymbolsForSuite(project, suiteName, onlyFirst, false);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "findGoogleTestSymbolsForSuiteRandomly"));
        }
        return collection;
    }

    @NotNull
    public static Collection<OCStructSymbol> findGoogleTestSymbolsForSuiteSorted(Project project, @Nullable String suiteName) {
        Collection<OCStructSymbol> collection = CidrTestUtil.findGoogleTestSymbolsForSuite(project, suiteName, false, true);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "findGoogleTestSymbolsForSuiteSorted"));
        }
        return collection;
    }

    @NotNull
    private static Collection<OCStructSymbol> findGoogleTestSymbolsForSuite(Project project, final @Nullable String suiteName, final boolean onlyFirst, boolean sorted) {
        final Pattern suiteNamePattern = suiteName == null ? namePattern : CidrTestUtil.getSimpleTestPattern(suiteName);
        final ArrayList<OCStructSymbol> result2 = new ArrayList<OCStructSymbol>();
        CommonProcessors.CollectProcessor<OCSymbol> allNamespaceCollector = new CommonProcessors.CollectProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCNamespaceSymbol && (suiteName == null || symbol.getName().contains(suiteName));
            }
        };
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project, (Processor<OCSymbol>)allNamespaceCollector, null);
        Processor<OCSymbol> processor2 = new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                OCStructSymbol foundSymbol = null;
                if (symbol instanceof OCStructSymbol) {
                    boolean ok;
                    OCStructSymbol s = (OCStructSymbol)symbol;
                    boolean bl = ok = suiteNamePattern.matcher(s.getName()).matches() && (suiteName == null || CidrTestUtil.googleTestNameMatches(s, suiteName)) && CidrTestUtil.isGoogleTestClass(s) && !CidrTestUtil.isTypeParameterizedTest(s);
                    if (ok) {
                        foundSymbol = s;
                    }
                } else {
                    boolean ok;
                    boolean bl = suiteName == null ? symbol.getName().startsWith("gtest_case_") && symbol.getName().endsWith("_") : (ok = symbol.getName().equals("gtest_case_" + suiteName + "_"));
                    if (ok) {
                        CommonProcessors.FindFirstProcessor<OCSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

                            protected boolean accept(OCSymbol symbol) {
                                return symbol instanceof OCStructSymbol && CidrTestUtil.isGoogleTestClass((OCStructSymbol)symbol);
                            }
                        };
                        ((OCNamespaceSymbol)symbol).processMembers((String)null, (Processor<OCSymbol>)processor2);
                        if (processor2.isFound()) {
                            foundSymbol = (OCStructSymbol)processor2.getFoundValue();
                        }
                    }
                }
                if (foundSymbol != null) {
                    result2.add(foundSymbol);
                    return !onlyFirst;
                }
                return true;
            }
        };
        ContainerUtil.process((Iterable)allNamespaceCollector.getResults(), (Processor)processor2);
        if (!onlyFirst && sorted) {
            ContainerUtil.sort(result2, (Comparator)new Comparator<OCStructSymbol>(){

                @Override
                public int compare(OCStructSymbol s1, OCStructSymbol s2) {
                    int res = s1.getName().compareTo(s2.getName());
                    if (res != 0) {
                        return res;
                    }
                    res = s1.getOffset() - s2.getOffset();
                    if (res != 0) {
                        return res;
                    }
                    return s1.getContainingFile() == null || s2.getContainingFile() == null ? 0 : FileUtil.comparePaths((String)s1.getContainingFile().getPath(), (String)s2.getContainingFile().getPath());
                }
            });
        }
        ArrayList<OCStructSymbol> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "findGoogleTestSymbolsForSuite"));
        }
        return arrayList;
    }

    public static Pattern getSimpleTestPattern(String suiteName) {
        return Pattern.compile(Pattern.quote(suiteName) + "_\\w+_Test");
    }

    private static boolean isTypeParameterizedTest(OCStructSymbol symbol) {
        return !CidrTestUtil.extractTypeParameterizedArguments(symbol).isEmpty();
    }

    @Contract(value="null, _ -> false")
    public static boolean isGoogleTestFixture(@Nullable OCStructSymbol symbol, boolean recursively) {
        return symbol != null && CidrTestUtil.findGoogleTestFixture(symbol, recursively) != null;
    }

    @Nullable
    public static OCStructSymbol findGoogleTestFixture(@NotNull OCStructSymbol symbol, boolean recursively) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "findGoogleTestFixture"));
        }
        if (CidrTestUtil.isGoogleTestClass(symbol) && CidrTestUtil.extractGoogleTestName(symbol) == null) {
            return symbol;
        }
        if (!recursively) {
            return null;
        }
        final Ref found = Ref.create();
        OCResolveContext context = new OCResolveContext(symbol.getContainingOCFile());
        symbol.processBaseClasses(context, new OCStructSymbol.BaseClassProcessor(){

            @Override
            public boolean process(OCSymbol symbol, OCVisibility visibility) {
                boolean ok;
                boolean bl = ok = symbol instanceof OCStructSymbol && CidrTestUtil.isGoogleTestFixture((OCStructSymbol)symbol, true);
                if (ok) {
                    found.set((Object)((OCStructSymbol)symbol));
                }
                return !ok;
            }
        });
        return (OCStructSymbol)found.get();
    }

    public static boolean isGoogleTestClass(@NotNull OCStructSymbol symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "isGoogleTestClass"));
        }
        return symbol.getKind() == OCSymbolKind.STRUCT && CidrTestUtil.isGoogleTestClassWithAncestor(symbol, "Test");
    }

    public static boolean isGoogleTestClassWithAncestor(@NotNull OCStructSymbol symbol, final @NotNull String ancestorName) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "isGoogleTestClassWithAncestor"));
        }
        if (ancestorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestorName", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "isGoogleTestClassWithAncestor"));
        }
        final String canonicalName = "::testing::" + ancestorName;
        return !symbol.processAllBaseClasses(new OCStructSymbol.BaseClassProcessor(){

            @Override
            public boolean process(OCSymbol symbol, OCVisibility visibility) {
                OCType type = symbol.getType();
                return !ancestorName.equals(symbol.getName()) || !canonicalName.equals(type.getCanonicalName());
            }
        });
    }

    @NotNull
    public static String normalizePath(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "normalizePath"));
        }
        if (ApplicationManagerEx.getApplicationEx().isUnitTestMode() && FileUtil.isAbsolute((String)fileName)) {
            try {
                fileName = new File(fileName).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String string = fileName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "normalizePath"));
        }
        return string;
    }

    @Nullable
    public static Couple<String> extractGoogleTestName(@Nullable OCStructSymbol symbol) {
        List<Object> arguments = Collections.emptyList();
        if (symbol != null) {
            OCDeclarator varDeclarator;
            OCDeclaration declaration;
            String name = symbol.getName();
            if (name.endsWith("_Test") && (declaration = (OCDeclaration)PsiTreeUtil.getParentOfType(symbol.locateDefinition(), OCDeclaration.class)) != null && (varDeclarator = (OCDeclarator)PsiTreeUtil.getChildOfType((PsiElement)(declaration = (OCDeclaration)PsiTreeUtil.getNextSiblingOfType((PsiElement)declaration, OCDeclaration.class)), OCDeclarator.class)) != null) {
                if ("test_info_".equals(varDeclarator.getName())) {
                    arguments = CidrTestUtil.extractMethodArguments(varDeclarator);
                } else {
                    List<OCExpression> result2;
                    String varName = "gtest_" + name.substring(0, name.length() - "_Test".length()) + "_registered_";
                    if (varName.equals(varDeclarator.getName()) && (result2 = CidrTestUtil.extractMethodArguments(varDeclarator)).size() >= 3) {
                        arguments = result2.subList(1, 3);
                    }
                }
            }
            if (arguments.isEmpty()) {
                arguments = CidrTestUtil.extractMethodArguments(symbol.getMembers(), "AddToRegistry");
            }
            if (arguments.isEmpty()) {
                arguments = CidrTestUtil.extractTypeParameterizedArguments(symbol);
            }
        }
        if (arguments.size() >= 2) {
            String className = StringUtil.stripQuotesAroundValue((String)CidrTestUtil.extractArgumentValue((PsiElement)arguments.get(0)));
            String methodName = StringUtil.stripQuotesAroundValue((String)CidrTestUtil.extractArgumentValue((PsiElement)arguments.get(1)));
            return Couple.of((Object)className, (Object)methodName);
        }
        return null;
    }

    private static List<OCExpression> extractTypeParameterizedArguments(OCStructSymbol symbol) {
        List<OCExpression> arguments = Collections.emptyList();
        if (symbol.getParent() instanceof OCNamespaceSymbol && (arguments = CidrTestUtil.extractMethodArguments(((OCNamespaceSymbol)symbol.getParent()).getMembers(), "gtest_" + symbol.getName() + "_defined_")).size() >= 4) {
            arguments = arguments.subList(2, 4);
        }
        return arguments;
    }

    public static boolean googleTestNameMatches(@NotNull OCStructSymbol symbol, @NotNull String suiteName) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "googleTestNameMatches"));
        }
        if (suiteName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteName", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "googleTestNameMatches"));
        }
        return CidrTestUtil.googleTestNameMatches(symbol, suiteName, null);
    }

    public static boolean googleTestNameMatches(@NotNull OCStructSymbol symbol, @NotNull String suiteName, @Nullable String testName) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "googleTestNameMatches"));
        }
        if (suiteName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteName", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "googleTestNameMatches"));
        }
        Couple<String> name = CidrTestUtil.extractGoogleTestName(symbol);
        return name != null && suiteName.equals(name.first) && (testName == null || testName.equals(name.second));
    }

    @Nullable
    public static OCMacroCall findGoogleTestMacros(@Nullable PsiElement element) {
        return CidrTestUtil.findMacros(element, GOOGLE_TEST_MACRO_NAMES);
    }

    @Nullable
    private static OCMacroCall findMacros(@Nullable PsiElement element, @NotNull Set<String> macroNames) {
        if (macroNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macroNames", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "findMacros"));
        }
        element = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCMacroCall.class});
        while (element instanceof OCMacroCall) {
            String referenceName;
            OCReferenceElement referenceElement = ((OCMacroCall)element).getMacroReferenceElement();
            String string = referenceName = referenceElement == null ? null : referenceElement.getName();
            if (macroNames.contains(referenceName)) {
                return (OCMacroCall)element;
            }
            element = element.getNextSibling();
        }
        return null;
    }

    @Nullable
    public static Couple<String> extractFullSuiteNameFromMacro(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "extractFullSuiteNameFromMacro"));
        }
        List<String> result2 = CidrTestUtil.extractMacroArgumentValues(element, ContainerUtil.newHashSet((Object[])new String[]{"INSTANTIATE_TEST_CASE_P", "INSTANTIATE_TYPED_TEST_CASE_P"}), 0, 1);
        if (result2.isEmpty()) {
            result2 = CidrTestUtil.extractMacroArgumentValues(element, ContainerUtil.newHashSet((Object[])new String[]{"TYPED_TEST_CASE", "TYPED_TEST_CASE_P", "REGISTER_TYPED_TEST_CASE_P"}), 0, 0);
            return result2.isEmpty() ? null : Couple.of((Object)result2.get(0), null);
        }
        return Couple.of((Object)result2.get(1), (Object)result2.get(0));
    }

    @NotNull
    private static List<String> extractMacroArgumentValues(@NotNull PsiElement element, Set<String> macroNames, int beginIndex, int endIndex) {
        List<OCMacroCallArgument> arguments;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "extractMacroArgumentValues"));
        }
        ArrayList<String> result2 = new ArrayList<String>();
        OCMacroCall macroCall = CidrTestUtil.findMacros(element, macroNames);
        if (macroCall != null && (arguments = macroCall.getArguments()).size() > endIndex) {
            while (beginIndex <= endIndex) {
                result2.add(CidrTestUtil.extractArgumentValue(arguments.get(beginIndex++)));
            }
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "extractMacroArgumentValues"));
        }
        return arrayList;
    }

    @NotNull
    public static String extractArgumentValue(@Nullable PsiElement element) {
        LeafPsiElement leafPsiElement = (LeafPsiElement)PsiTreeUtil.findChildOfType((PsiElement)element, LeafPsiElement.class);
        String string = leafPsiElement == null ? "" : StringUtil.notNullize((String)leafPsiElement.getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "extractArgumentValue"));
        }
        return string;
    }

    @NotNull
    private static List<OCExpression> extractMethodArguments(@Nullable MostlySingularMultiMap<String, OCSymbol> members, @NotNull String methodName) {
        Iterator symbols;
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "extractMethodArguments"));
        }
        if (members != null && members.containsKey((Object)methodName) && (symbols = members.get((Object)methodName).iterator()).hasNext()) {
            List<OCExpression> list = CidrTestUtil.extractMethodArguments((OCSymbol)symbols.next());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "extractMethodArguments"));
            }
            return list;
        }
        List<OCExpression> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "extractMethodArguments"));
        }
        return list;
    }

    @NotNull
    private static List<OCExpression> extractMethodArguments(@Nullable PsiElement psiElement) {
        PsiElement parent;
        OCCallExpression expression;
        if (psiElement != null && (expression = (OCCallExpression)PsiTreeUtil.findChildOfType((PsiElement)(parent = psiElement.getParent()), OCCallExpression.class)) != null) {
            List<OCExpression> list = expression.getArguments();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "extractMethodArguments"));
            }
            return list;
        }
        List<OCExpression> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "extractMethodArguments"));
        }
        return list;
    }

    @NotNull
    private static List<OCExpression> extractMethodArguments(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "extractMethodArguments"));
        }
        List<OCExpression> list = CidrTestUtil.extractMethodArguments(symbol.locateDefinition());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "extractMethodArguments"));
        }
        return list;
    }

    @Nullable
    public static OCSymbol findGoogleTestInstantiationSymbol(@NotNull Project project, @NotNull String suiteName, @NotNull String instantiationName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "findGoogleTestInstantiationSymbol"));
        }
        if (suiteName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteName", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "findGoogleTestInstantiationSymbol"));
        }
        if (instantiationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instantiationName", "com/jetbrains/cidr/execution/testing/CidrTestUtil", "findGoogleTestInstantiationSymbol"));
        }
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project, (Processor<OCSymbol>)processor2, "gtest_" + instantiationName + suiteName + "_dummy_");
        if (processor2.isFound()) {
            return (OCSymbol)processor2.getFoundValue();
        }
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project, (Processor<OCSymbol>)processor2, "gtest_" + instantiationName + "_" + suiteName);
        return (OCSymbol)processor2.getFoundValue();
    }

    public static boolean fileIncludesGoogleTest(final PsiFile file2) {
        CommonProcessors.CollectProcessor<OCSymbol> processor2 = new CommonProcessors.CollectProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCStructSymbol && "::testing::TestCase".equals(symbol.getType().getCanonicalName((PsiElement)file2));
            }
        };
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(file2.getProject(), (Processor<OCSymbol>)processor2, "TestCase");
        for (OCSymbol testSymbol : processor2.getResults()) {
            Collection<VirtualFile> roots;
            if (testSymbol.getContainingFile() == null || !(roots = OCImportGraph.getAllHeaderRoots(file2.getProject(), testSymbol.getContainingFile())).contains(file2.getVirtualFile())) continue;
            return true;
        }
        return false;
    }
}

