/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.CidrBundle;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestRunConfigurationData
implements JDOMExternalizable,
Cloneable {
    @Nullable
    protected String myTestClass;
    @Nullable
    protected String myTestMethod;
    @Nullable
    protected String myTestPattern;
    @NotNull
    protected Mode myTestMode;
    @NotNull
    protected Project myProject;

    public abstract void checkData() throws RuntimeConfigurationException;

    public CidrTestRunConfigurationData(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/execution/testing/CidrTestRunConfigurationData", "<init>"));
        }
        this.myTestMode = Mode.SUITE_TEST;
        this.myProject = project;
    }

    @Nullable
    public String getTestClass() {
        return this.myTestClass;
    }

    public void setTestClass(@Nullable String testClass) {
        this.myTestClass = StringUtil.nullize((String)testClass, (boolean)true);
    }

    @Nullable
    public String getTestMethod() {
        return this.myTestMethod;
    }

    public void setTestMethod(@Nullable String testMethod) {
        this.myTestMethod = StringUtil.nullize((String)testMethod, (boolean)true);
    }

    @Nullable
    public String getTestPattern() {
        return this.myTestPattern;
    }

    public void setTestPattern(@Nullable String testPattern) {
        this.myTestPattern = testPattern;
    }

    @NotNull
    public Mode getTestMode() {
        Mode mode = this.myTestMode;
        if (mode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestRunConfigurationData", "getTestMode"));
        }
        return mode;
    }

    public void setTestMode(@NotNull Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/jetbrains/cidr/execution/testing/CidrTestRunConfigurationData", "setTestMode"));
        }
        this.myTestMode = mode;
    }

    @NotNull
    public String suggestedName(@Nullable String fallbackName) {
        if (this.myTestClass != null && this.myTestMethod != null) {
            String string = this.formatTestMethod();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestRunConfigurationData", "suggestedName"));
            }
            return string;
        }
        if (this.myTestMode == Mode.PATTERN) {
            if ("Pattern" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestRunConfigurationData", "suggestedName"));
            }
            return "Pattern";
        }
        String scopeName = this.myTestClass != null ? this.myTestClass : fallbackName;
        String string = scopeName == null ? CidrBundle.message("ocunit.defaultName.allTests", new Object[0]) : CidrBundle.message("ocunit.defaultName.allTestsIn", scopeName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestRunConfigurationData", "suggestedName"));
        }
        return string;
    }

    @NotNull
    protected abstract String formatTestMethod();

    @Nullable
    public abstract String getTestingFrameworkName();

    public void readExternal(Element element) throws InvalidDataException {
        this.setTestClass(element.getAttributeValue("TEST_CLASS"));
        this.setTestMethod(element.getAttributeValue("TEST_METHOD"));
        this.setTestPattern(element.getAttributeValue("TEST_PATTERN"));
        String modeValue = element.getAttributeValue("TEST_MODE");
        this.setTestMode(modeValue == null || modeValue.equals("SUITE_TEST") ? Mode.SUITE_TEST : Mode.PATTERN);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        switch (this.myTestMode) {
            case SUITE_TEST: {
                if (this.myTestClass == null) break;
                element.setAttribute("TEST_CLASS", this.myTestClass);
                if (this.myTestMethod == null) break;
                element.setAttribute("TEST_METHOD", this.myTestMethod);
                break;
            }
            case PATTERN: {
                if (this.myTestPattern == null) break;
                element.setAttribute("TEST_PATTERN", this.myTestPattern);
            }
        }
        element.setAttribute("TEST_MODE", this.myTestMode.name());
    }

    public CidrTestRunConfigurationData clone() {
        try {
            CidrTestRunConfigurationData result2 = (CidrTestRunConfigurationData)super.clone();
            result2.myTestClass = this.myTestClass;
            result2.myTestMethod = this.myTestMethod;
            result2.myTestPattern = this.myTestPattern;
            result2.myTestMode = this.myTestMode;
            result2.myProject = this.myProject;
            return result2;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Mode {
        SUITE_TEST,
        PATTERN;

    }
}

