/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestEventProcessor {
    @NotNull
    private String myLocationProtocol;

    public CidrTestEventProcessor(@NotNull String locationProtocol) {
        if (locationProtocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locationProtocol", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "<init>"));
        }
        this.myLocationProtocol = locationProtocol;
    }

    @NotNull
    public List<ServiceMessageBuilder> suiteStarted(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "suiteStarted"));
        }
        List<ServiceMessageBuilder> list = this.suiteStarted(name, name);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "suiteStarted"));
        }
        return list;
    }

    @NotNull
    public List<ServiceMessageBuilder> suiteStarted(@NotNull String name, @NotNull String location) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "suiteStarted"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "suiteStarted"));
        }
        List<ServiceMessageBuilder> list = this.doSuiteStarted(name, location);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "suiteStarted"));
        }
        return list;
    }

    @NotNull
    protected List<ServiceMessageBuilder> doSuiteStarted(@NotNull String name, @NotNull String location) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "doSuiteStarted"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "doSuiteStarted"));
        }
        List<ServiceMessageBuilder> list = Collections.singletonList(this.setLocation(ServiceMessageBuilder.testSuiteStarted(name), location));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "doSuiteStarted"));
        }
        return list;
    }

    @NotNull
    protected List<ServiceMessageBuilder> suiteFinished(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "suiteFinished"));
        }
        List<ServiceMessageBuilder> list = Collections.singletonList(ServiceMessageBuilder.testSuiteFinished(name));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "suiteFinished"));
        }
        return list;
    }

    @NotNull
    public List<ServiceMessageBuilder> testStarted(@NotNull String suiteAndMethodName, @NotNull String testName) {
        if (suiteAndMethodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteAndMethodName", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "testStarted"));
        }
        if (testName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "testStarted"));
        }
        List<ServiceMessageBuilder> list = this.doTestStarted(testName, suiteAndMethodName);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "testStarted"));
        }
        return list;
    }

    @NotNull
    protected List<ServiceMessageBuilder> doTestStarted(@NotNull String testName, @NotNull String location) {
        if (testName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "doTestStarted"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "doTestStarted"));
        }
        List<ServiceMessageBuilder> list = Collections.singletonList(this.setLocation(ServiceMessageBuilder.testStarted(testName), location));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "doTestStarted"));
        }
        return list;
    }

    @NotNull
    public List<ServiceMessageBuilder> testFinished(@NotNull String testName, @NotNull String duration, boolean success) {
        if (testName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "testFinished"));
        }
        if (duration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "duration", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "testFinished"));
        }
        List<ServiceMessageBuilder> list = this.doTestFinished(testName, duration, success, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "testFinished"));
        }
        return list;
    }

    @NotNull
    protected List<ServiceMessageBuilder> doTestFinished(@NotNull String testName, @NotNull String duration, boolean success, boolean ignored) {
        if (testName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "doTestFinished"));
        }
        if (duration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "duration", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "doTestFinished"));
        }
        ServiceMessageBuilder statusMessage = null;
        if (!success) {
            statusMessage = ServiceMessageBuilder.testFailed(testName);
        } else if (ignored) {
            statusMessage = ServiceMessageBuilder.testIgnored(testName);
        }
        ServiceMessageBuilder finishMessage = ServiceMessageBuilder.testFinished(testName).addAttribute("duration", duration);
        if (statusMessage == null) {
            List<ServiceMessageBuilder> list = Collections.singletonList(finishMessage);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "doTestFinished"));
            }
            return list;
        }
        statusMessage.addAttribute("message", "");
        List<ServiceMessageBuilder> list = Arrays.asList(statusMessage, finishMessage);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "doTestFinished"));
        }
        return list;
    }

    @NotNull
    protected List<ServiceMessageBuilder> testErrOut(@NotNull String testName, @NotNull String output) {
        if (testName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "testErrOut"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "testErrOut"));
        }
        List<ServiceMessageBuilder> list = Collections.singletonList(ServiceMessageBuilder.testStdErr(testName).addAttribute("out", output));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "testErrOut"));
        }
        return list;
    }

    @NotNull
    private ServiceMessageBuilder setLocation(ServiceMessageBuilder builder, String location) {
        ServiceMessageBuilder serviceMessageBuilder = builder.addAttribute("locationHint", this.myLocationProtocol + "://" + location);
        if (serviceMessageBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "setLocation"));
        }
        return serviceMessageBuilder;
    }

    @Nullable
    public Matcher hideOutputMatcher(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor", "hideOutputMatcher"));
        }
        return null;
    }
}

