/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.testing.CidrTestEventProcessor;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrOutputToGeneralTestEventsConverter
extends OutputToGeneralTestEventsConverter {
    @Nullable
    protected String myPotentiallyFinishedSuite;
    @Nullable
    protected String myRunningTest;
    @Nullable
    protected CidrTestEventProcessor myEventProcessor;
    protected StringBuilder myAssertionOutput;
    private static final Pattern PROCESS_FINISHED_PATTERN = Pattern.compile("Process finished with exit code (\\d+)\n");
    private static final String KILLED_EXIT_CODE = "137";
    private boolean myTestFrameworkAttached;

    public CidrOutputToGeneralTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/jetbrains/cidr/execution/testing/CidrOutputToGeneralTestEventsConverter", "<init>"));
        }
        if (consoleProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleProperties", "com/jetbrains/cidr/execution/testing/CidrOutputToGeneralTestEventsConverter", "<init>"));
        }
        super(testFrameworkName, consoleProperties);
        this.myPotentiallyFinishedSuite = null;
        this.myAssertionOutput = new StringBuilder();
    }

    protected void doProcessMessages(@NotNull Key outputType, @NotNull ServiceMessageVisitor visitor, @NotNull List<ServiceMessageBuilder> messages) throws ParseException {
        if (outputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputType", "com/jetbrains/cidr/execution/testing/CidrOutputToGeneralTestEventsConverter", "doProcessMessages"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/execution/testing/CidrOutputToGeneralTestEventsConverter", "doProcessMessages"));
        }
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/jetbrains/cidr/execution/testing/CidrOutputToGeneralTestEventsConverter", "doProcessMessages"));
        }
        for (ServiceMessageBuilder each : messages) {
            super.processServiceMessages(each.toString(), outputType, visitor);
        }
    }

    protected void logOutput(String text, Key outputType) {
        String prefix = ">";
        if (outputType == ProcessOutputTypes.SYSTEM) {
            prefix = "~";
        }
        if (outputType == ProcessOutputTypes.STDERR) {
            prefix = "!";
        }
        CidrTestLog.LOG.debug(prefix + StringUtil.trimEnd((String)text, (String)"\n"));
    }

    protected void reopenSuiteIfAppropriate(Key outputType, ServiceMessageVisitor visitor, @Nullable String name, @Nullable String location) throws ParseException {
        boolean open2;
        boolean bl = open2 = name != null && !name.equals(this.myPotentiallyFinishedSuite);
        if (this.myPotentiallyFinishedSuite != null && (open2 || name == null)) {
            this.suiteFinished(outputType, visitor, this.myPotentiallyFinishedSuite);
        }
        if (open2) {
            this.suiteStarted(outputType, visitor, name, location);
        }
        this.myPotentiallyFinishedSuite = null;
    }

    protected abstract void suiteStarted(Key var1, ServiceMessageVisitor var2, String var3, String var4) throws ParseException;

    protected abstract void suiteFinished(Key var1, ServiceMessageVisitor var2, String var3) throws ParseException;

    protected Boolean processAssertion(Key outputType, ServiceMessageVisitor visitor, String text, Pattern pattern) throws ParseException {
        if (this.myRunningTest != null && this.myEventProcessor != null) {
            Matcher m = pattern.matcher(text);
            if (m.find()) {
                if (this.myAssertionOutput.length() > 0) {
                    this.doProcessMessages(outputType, visitor, this.myEventProcessor.testErrOut(this.myRunningTest, this.myAssertionOutput.toString()));
                    this.myAssertionOutput.setLength(0);
                }
                this.myAssertionOutput.append(m.group(0));
                return this.shouldNotPrint(m);
            }
            if (this.myAssertionOutput.length() > 0) {
                this.myAssertionOutput.append(text);
                return true;
            }
        }
        return null;
    }

    protected boolean shouldNotPrint(Matcher m) {
        return m.start() == 0;
    }

    protected void checkForTermination(String text, Key outputType, ServiceMessageVisitor visitor) throws ParseException {
        Matcher m = PROCESS_FINISHED_PATTERN.matcher(text);
        if (m.matches() && this.myRunningTest != null) {
            boolean killed = KILLED_EXIT_CODE.equals(m.group(1));
            this.processCollectedAssertionOutput(outputType, visitor, this.myRunningTest, true);
            if (!killed) {
                CidrTestLog.LOG.assertTrue(this.myEventProcessor != null, (Object)"Event processor was not initialized");
                this.doProcessMessages(outputType, visitor, this.myEventProcessor.testFinished(this.myRunningTest, "0", false));
            }
        }
    }

    protected abstract void processCollectedAssertionOutput(Key var1, ServiceMessageVisitor var2, @NotNull String var3, boolean var4) throws ParseException;

    protected void attachTestFramework(Key outputType, ServiceMessageVisitor visitor) throws ParseException {
        if (!this.myTestFrameworkAttached) {
            this.doProcessMessages(outputType, visitor, Arrays.asList(new ServiceMessageBuilder("enteredTheMatrix")));
            this.myTestFrameworkAttached = true;
        }
    }
}

