/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestUtil;
import com.jetbrains.cidr.execution.testing.OCGoogleTestLocationProvider;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestRerunFailedTestsAction
extends CidrRerunFailedTestsAction {
    public CidrGoogleTestRerunFailedTestsAction(@NotNull ComponentContainer componentContainer) {
        if (componentContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentContainer", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRerunFailedTestsAction", "<init>"));
        }
        super(componentContainer);
    }

    @Override
    @NotNull
    protected Filter getFilter(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRerunFailedTestsAction", "getFilter"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRerunFailedTestsAction", "getFilter"));
        }
        Filter filter = super.getFilter(project, searchScope).and(new Filter(){

            public boolean shouldAccept(AbstractTestProxy t) {
                return t.isLeaf();
            }
        });
        if (filter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRerunFailedTestsAction", "getFilter"));
        }
        return filter;
    }

    @Override
    @Nullable
    protected CidrTestScopeElement getElement(@NotNull AbstractTestProxy test, Project project) {
        String scope;
        if (test == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "test", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRerunFailedTestsAction", "getElement"));
        }
        OCGoogleTestLocationProvider.OCGoogleTestLocation location = CidrGoogleTestRerunFailedTestsAction.getLocation(test, project);
        String param = location != null ? location.getParam() : null;
        int depth = CidrGoogleTestRerunFailedTestsAction.getTestDepth(test);
        switch (depth) {
            case 2: {
                scope = String.format("%s.%s", test.getParent().getName(), test.getName());
                break;
            }
            case 3: {
                AbstractTestProxy suite = test.getParent().getParent();
                scope = String.format("%s/%s.%s", suite.getName(), param, test.getName());
                break;
            }
            case 4: {
                if (location == null) {
                    return null;
                }
                PsiElement element = location.getPsiElement();
                if (!(element instanceof OCStruct)) {
                    return null;
                }
                Couple<String> testName = CidrTestUtil.extractGoogleTestName((OCStructSymbol)((OCStruct)element).getSymbol());
                if (testName == null) {
                    return null;
                }
                if (location.isTyped()) {
                    scope = String.format("%s/%s/%s.%s", location.getInstantiation(), testName.first, param, testName.second);
                    break;
                }
                scope = String.format("%s/%s.%s/%s", location.getInstantiation(), testName.first, testName.second, param);
                break;
            }
            default: {
                scope = null;
            }
        }
        CidrTestScopeElement scopeElement = new CidrTestScopeElement(){

            @Override
            public String toString() {
                return scope;
            }
        };
        return scope == null ? null : scopeElement;
    }

    private static OCGoogleTestLocationProvider.OCGoogleTestLocation getLocation(AbstractTestProxy test, Project project) {
        Location location = test.getLocation(project, OCSearchScope.getProjectSourcesScope(project));
        return location instanceof OCGoogleTestLocationProvider.OCGoogleTestLocation ? (OCGoogleTestLocationProvider.OCGoogleTestLocation)location : null;
    }

    private static int getTestDepth(AbstractTestProxy test) {
        int count = 0;
        while (test.getParent() != null) {
            test = test.getParent();
            ++count;
        }
        return count;
    }

    @Override
    @Nullable
    protected CidrCommandLineState createState(@NotNull CidrRunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull Executor executor, @NotNull CidrTestScope failedTests) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRerunFailedTestsAction", "createState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRerunFailedTestsAction", "createState"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRerunFailedTestsAction", "createState"));
        }
        if (failedTests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failedTests", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRerunFailedTestsAction", "createState"));
        }
        return ((CidrTestRunConfiguration)((Object)configuration)).createState(env, executor, failedTests);
    }

    @Override
    protected CidrTestScope createTestScope() {
        return new CidrTestScope(':');
    }
}

