/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectVariablesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NSObjectValueRenderer
extends ValueRenderer {
    public static final Pattern NS_STRING_TYPES_IMPL = Pattern.compile("(const __CFString \\*)|(CFStringRef)");

    @Nullable
    public static NSObjectValueRenderer createIfObject(@NotNull CidrPhysicalValue value, @NotNull LLValue var) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSObjectValueRenderer", "createIfObject"));
        }
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSObjectValueRenderer", "createIfObject"));
        }
        if (var.isValidPointer() && (value.isNSObject() || NS_STRING_TYPES_IMPL.matcher(var.getType()).matches())) {
            return new NSObjectValueRenderer(value);
        }
        return null;
    }

    private NSObjectValueRenderer(@NotNull CidrPhysicalValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSObjectValueRenderer", "<init>"));
        }
        super(value);
    }

    @Override
    @NotNull
    protected String doComputeValue(@NotNull EvaluationContext evaluationContext) throws ExecutionException {
        String string;
        if (evaluationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationContext", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSObjectValueRenderer", "doComputeValue"));
        }
        try {
            LLValue var = this.myValue.getVar();
            string = "\"" + evaluationContext.objectDescription(var) + "\"";
        }
        catch (DBCannotEvaluateException e) {
            CidrDebuggerLog.LOG.debug((Throwable)e);
            String string2 = super.doComputeValue(evaluationContext);
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSObjectValueRenderer", "doComputeValue"));
            }
            return string2;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSObjectValueRenderer", "doComputeValue"));
        }
        return string;
    }

    @Override
    public void computeChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container) throws ExecutionException, DBCannotCollectVariablesException, DBCannotEvaluateException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSObjectValueRenderer", "computeChildren"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSObjectValueRenderer", "computeChildren"));
        }
        if (!this.computeHasChildren(context)) {
            container.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        this.doComputeChildren(context, container, true);
    }
}

