/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDictionaryEntryValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrElementValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import java.util.ArrayList;
import java.util.List;

abstract class ContainerValueRenderer
extends ValueRenderer {
    private int myCurrentIndex = 0;

    public ContainerValueRenderer(CidrPhysicalValue cidrPhysicalValue) {
        super(cidrPhysicalValue);
    }

    protected String getCountDisplayString(int count) {
        return "count = " + count;
    }

    protected void addElementsTo(EvaluationContext context, List<LLValue> children2, XCompositeNode container) throws ExecutionException {
        ArrayList<CidrValue> values = new ArrayList<CidrValue>(children2.size());
        for (LLValue each : children2) {
            values.add(this.nextElementValue(each, context));
        }
        CidrValue.addAllTo(values, container);
    }

    protected CidrElementValue createElementValue(EvaluationContext context, LLValue var, int index) throws ExecutionException {
        return new CidrElementValue(this.myValue.getProcess(), context, this.myValue.getSourcePosition(), this.myValue, var, "[" + index + "]", index);
    }

    protected final CidrElementValue nextElementValue(LLValue var, EvaluationContext context) throws ExecutionException {
        return this.createElementValue(context, var, this.myCurrentIndex++);
    }

    private CidrDictionaryEntryValue createMapElementValue(EvaluationContext context, LLValue key, LLValue value, int index) throws ExecutionException {
        return new CidrDictionaryEntryValue(this.myValue.getProcess(), context, this.myValue, "[" + index + "]", key, value);
    }

    protected final CidrDictionaryEntryValue nextMapElementValue(EvaluationContext context, LLValue key, LLValue value) throws ExecutionException {
        return this.createMapElementValue(context, key, value, this.myCurrentIndex++);
    }

    protected static String cantParseType(String type) throws DBCannotEvaluateException {
        throw new DBCannotEvaluateException("Can't parse type " + type);
    }

    protected int getCurrentIndex() {
        return this.myCurrentIndex;
    }
}

