/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ContainerValueRenderer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CollectionValueRenderer
extends ContainerValueRenderer {
    public CollectionValueRenderer(CidrPhysicalValue cidrPhysicalValue) {
        super(cidrPhysicalValue);
    }

    @Override
    @NotNull
    protected String doComputeValue(@NotNull EvaluationContext context) throws ExecutionException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/CollectionValueRenderer", "doComputeValue"));
        }
        String string = this.getCountDisplayString(this.computeChildrenCount(context));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/CollectionValueRenderer", "doComputeValue"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/CollectionValueRenderer", "getChildEvaluationExpression"));
        }
        LLValue val = child.getVar();
        String string = EvaluationContext.cast(val.getReferenceExpression(), val.getBestType());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/CollectionValueRenderer", "getChildEvaluationExpression"));
        }
        return string;
    }

    @Override
    public Icon getIcon(boolean hasChildren, CidrPhysicalValue value) {
        return AllIcons.Debugger.Db_array;
    }
}

