/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectVariablesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotLoadVariableException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.ExpiredException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EvaluationContext {
    protected static final int MAX_OBJ_DESCRIPTION_LENGTH = 524288;
    protected final int myThreadId;
    protected final int myFrameNumber;
    private final DebuggerDriver myDriver;
    private final Expirable myExpirable;
    private final CidrStackFrame myFrame;

    public EvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, CidrStackFrame frame) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/jetbrains/cidr/execution/debugger/evaluation/EvaluationContext", "<init>"));
        }
        this.myThreadId = frame.getThreadId();
        this.myFrameNumber = frame.getFrameNumber();
        this.myFrame = frame;
        this.myDriver = driver;
        this.myExpirable = expirable;
    }

    public CidrStackFrame getFrame() {
        return this.myFrame;
    }

    public void checkExpiration() {
        if (this.myExpirable != null && this.myExpirable.isExpired()) {
            throw new ExpiredException(this, this.myExpirable);
        }
    }

    public List<LLValue> arraySlice(LLValue var, int offset, int count) throws ExecutionException, DBCannotEvaluateException, DBCannotCollectVariablesException {
        this.checkExpiration();
        ArrayList<LLValue> res = new ArrayList<LLValue>(count);
        for (int index = offset; index < offset + count; ++index) {
            String expression = "((" + this.mangleType(var.getBestType()) + ")" + var.getPointer() + ")[" + index + "]";
            LLValue value = this.evaluate(expression);
            res.add(value);
        }
        return res;
    }

    public String mangleType(String type) {
        String stars = "";
        type = StringUtil.replace((String)type, (String)"const", (String)"");
        while (type.endsWith("*") || type.endsWith("&")) {
            stars = stars + " " + type.charAt(type.length() - 1);
            type = type.substring(0, type.length() - 1).trim();
        }
        String prefix = "";
        if (type.startsWith("class")) {
            prefix = "class";
            type = type.substring(6);
        }
        if (type.startsWith("struct")) {
            type = type.substring(7);
            prefix = "struct";
        }
        return prefix + " " + type + " " + stars;
    }

    public LLValue evaluate(String expression) throws ExecutionException, DBCannotEvaluateException {
        return this.evaluate(expression, null);
    }

    public LLValue evaluate(String expression, @Nullable DebuggerDriver.DebuggerLanguage language) throws ExecutionException, DBCannotEvaluateException {
        this.checkExpiration();
        return this.myDriver.evaluate(this.myThreadId, this.myFrameNumber, expression, language);
    }

    @NotNull
    public String castIDToNumber(@NotNull String expr, @NotNull String type) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/jetbrains/cidr/execution/debugger/evaluation/EvaluationContext", "castIDToNumber"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/execution/debugger/evaluation/EvaluationContext", "castIDToNumber"));
        }
        String string = EvaluationContext.cast(expr, type);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/EvaluationContext", "castIDToNumber"));
        }
        return string;
    }

    @NotNull
    public abstract String convertToRValue(@NotNull LLValue var1, @NotNull Pair<LLValue, String> var2) throws DBCannotEvaluateException;

    public static String cast(String expr, String type) {
        return "((" + type + ")(" + expr + "))";
    }

    @NotNull
    public static String swiftCast(@NotNull String expr, @NotNull String type) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/jetbrains/cidr/execution/debugger/evaluation/EvaluationContext", "swiftCast"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/execution/debugger/evaluation/EvaluationContext", "swiftCast"));
        }
        String string = "unsafeBitCast(UnsafePointer<Void>(bitPattern:" + expr + "), " + type + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/EvaluationContext", "swiftCast"));
        }
        return string;
    }

    @NotNull
    public LLValue messageSend(LLValue self, String selectorAndArgs, String returnType) throws ExecutionException, DBCannotEvaluateException {
        LLValue lLValue = this.evaluate(EvaluationContext.messageSendExpr(self.getPointer(), selectorAndArgs, returnType), DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS);
        if (lLValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/EvaluationContext", "messageSend"));
        }
        return lLValue;
    }

    private static String messageSendExpr(String expr, String selectorAndArgs) {
        return EvaluationContext.messageSendExpr(expr, selectorAndArgs, "id");
    }

    protected static String messageSendExpr(String expr, String selectorAndArgs, String returnType) {
        return EvaluationContext.cast("[" + EvaluationContext.cast(expr, "id") + " " + selectorAndArgs + "]", returnType);
    }

    public LLValue messageSend(LLValue self, String selectorAndArgs) throws ExecutionException, DBCannotEvaluateException {
        return this.messageSend(self, selectorAndArgs, "id");
    }

    public boolean isKindOfClass(String className, CidrPhysicalValue value) throws ExecutionException, DBCannotEvaluateException {
        return this.evaluate("(unsigned char)((Class)objc_getClass(\"" + className + "\")?" + EvaluationContext.cast("[" + EvaluationContext.cast(value.getVar().getPointer(), "id") + " " + "isKindOfClass:(Class)objc_lookUpClass(\"" + className + "\")" + "]", "unsigned char") + ":0)", DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS).isTrue();
    }

    @NotNull
    public String objectDescription(LLValue value) throws ExecutionException, DBCannotEvaluateException {
        String string = this.stringFromNSString(EvaluationContext.messageSendExpr(value.getPointer(), "description"));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/EvaluationContext", "objectDescription"));
        }
        return string;
    }

    @NotNull
    public String stringFromNSString(LLValue nsstring) throws ExecutionException, DBCannotEvaluateException {
        String string = this.stringFromNSString(nsstring.getPointer());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/EvaluationContext", "stringFromNSString"));
        }
        return string;
    }

    @NotNull
    public String stringFromNSString(String expr) throws ExecutionException, DBCannotEvaluateException {
        String string = StringUtil.unquoteString((String)this.evaluate(EvaluationContext.stringFromNSStringExpr(expr), DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS).getReadableValue());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/EvaluationContext", "stringFromNSString"));
        }
        return string;
    }

    private static String stringFromNSStringExpr(String expr) {
        String lengthExpr = EvaluationContext.messageSendExpr(expr, "length", "int");
        String substringExpr = EvaluationContext.messageSendExpr(expr, "substringToIndex:" + String.format("(((%s) > %d) ? %d : %s)", lengthExpr, 524288, 524288, lengthExpr), "id");
        return EvaluationContext.messageSendExpr(substringExpr, "UTF8String", "char *");
    }

    public String getOCClassName(LLValue aClass) throws ExecutionException, DBCannotEvaluateException {
        LLValue className = this.evaluate(EvaluationContext.cast("class_getName((id)" + aClass.getPointer() + ")", "char *"));
        return StringUtil.unquoteString((String)className.getReadableValue());
    }

    public String getSelectorName(LLValue selector) throws ExecutionException, DBCannotEvaluateException {
        String result2 = this.evaluate("(char *)sel_getName((void *)" + selector.getPointer() + ")").getReadableValue();
        return StringUtil.unescapeStringCharacters((String)StringUtil.unquoteString((String)result2));
    }

    @NotNull
    public String getSwiftClassName(@NotNull LLValue value) throws DBCannotEvaluateException, ExecutionException {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/EvaluationContext", "getSwiftClassName"));
        }
        String casted = EvaluationContext.swiftCast(value.getPointer(), "Swift.AnyObject");
        String string = StringUtil.unquoteString((String)this.evaluate("_stdlib_getDemangledTypeName(" + casted + ")").getReadableValue());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/EvaluationContext", "getSwiftClassName"));
        }
        return string;
    }

    public int getChildrenCount(LLValue var, int max) throws ExecutionException, DBCannotCollectVariablesException {
        this.checkExpiration();
        return this.myDriver.getChildrenCount(var, max);
    }

    public List<LLValue> getVariableChildrenRange(LLValue var, int offset, int size) throws ExecutionException, DBCannotCollectVariablesException {
        this.checkExpiration();
        return this.myDriver.getVariableChildrenRange(var, offset, size);
    }

    public List<LLValue> getVariableChildren(LLValue value) throws ExecutionException, DBCannotCollectVariablesException {
        this.checkExpiration();
        return this.myDriver.getVariableChildren(value);
    }

    public boolean isStructType(@NotNull LLValue value) throws ExecutionException, DBCannotLoadVariableException {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/EvaluationContext", "isStructType"));
        }
        this.checkExpiration();
        return this.myDriver.isStructType(value);
    }

    public CidrStackFrame.CachedTypeInfo getTypeInfo(String typeName) {
        return this.myFrame.getTypeInfo(typeName);
    }
}

