/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Key;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.ImmediateFullValueEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectVariablesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrLocalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrModifiableMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.ValueRendererFactory;
import com.jetbrains.cidr.execution.debugger.evaluation.XValueNodeExpirable;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrValue
extends XNamedValue {
    public static Key<Boolean> DO_NOT_SHOW_ADDRESSES = Key.create((String)"DO_NOT_SHOW_ADDRESSES");
    @NotNull
    protected final CidrDebugProcess myProcess;
    @Nullable
    protected final XSourcePosition myPosition;
    protected ValueRendererFactory myRenderersFactory;
    @NotNull
    private CidrStackFrame myFrame;

    public CidrValue(@NotNull CidrDebugProcess process, @Nullable XSourcePosition position, @NotNull String displayName, @NotNull CidrStackFrame frame) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "<init>"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "<init>"));
        }
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "<init>"));
        }
        super(displayName);
        this.myProcess = process;
        this.myPosition = position;
        this.myFrame = frame;
        this.myRenderersFactory = this.getProcess().getRendererFactory();
    }

    @NotNull
    public CidrStackFrame getFrame() {
        CidrStackFrame cidrStackFrame = this.myFrame;
        if (cidrStackFrame == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "getFrame"));
        }
        return cidrStackFrame;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.myPosition;
    }

    public int getThreadId() {
        return this.myFrame.getThreadId();
    }

    public int getFrameNumber() {
        return this.myFrame.getFrameNumber();
    }

    @NotNull
    public String getEvaluationExpression() {
        String string = this.getEvaluationExpression(false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "getEvaluationExpression"));
        }
        return string;
    }

    @NotNull
    public String getEvaluationExpression(boolean lvalue) {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "getEvaluationExpression"));
        }
        return string;
    }

    @NotNull
    public CidrDebugProcess getProcess() {
        CidrDebugProcess cidrDebugProcess = this.myProcess;
        if (cidrDebugProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "getProcess"));
        }
        return cidrDebugProcess;
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "computeSourcePosition"));
        }
        XSourcePosition position = this.getSourcePosition();
        navigatable.setSourcePosition(position == null ? null : this.doComputePosition(position));
    }

    @Nullable
    protected abstract XSourcePosition doComputePosition(@NotNull XSourcePosition var1);

    public void computePresentation(final @NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "computePresentation"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "computePresentation"));
        }
        this.myProcess.postCommand(new CidrDebugProcess.DebuggerImplicitCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                if (driver == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue$1", "run"));
                }
                if (node.isObsolete()) {
                    return;
                }
                PresentationData data = CidrValue.this.doComputePresentation(CidrValue.this.getContext(driver, new XValueNodeExpirable((Obsolescent)node)));
                String value = data.value;
                if (value.length() > 1000) {
                    value = value.substring(0, 1000);
                    node.setFullValueEvaluator((XFullValueEvaluator)new ImmediateFullValueEvaluator(data.value));
                }
                node.setPresentation(data.icon, data.type, value, data.hasChildren);
            }
        });
    }

    @NotNull
    protected abstract PresentationData doComputePresentation(@NotNull EvaluationContext var1) throws ExecutionException;

    public static void addAllTo(@NotNull CidrDebugProcess process, @NotNull EvaluationContext context, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame, @NotNull Collection<LLValue> vars, @NotNull CidrPhysicalValue parent, @NotNull XCompositeNode toNode, boolean modifiable) throws ExecutionException {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "addAllTo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "addAllTo"));
        }
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "addAllTo"));
        }
        if (vars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vars", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "addAllTo"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "addAllTo"));
        }
        if (toNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toNode", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "addAllTo"));
        }
        if (toNode.isObsolete()) {
            return;
        }
        SmartList values = new SmartList();
        for (LLValue each : vars) {
            values.add(modifiable ? new CidrModifiableMemberValue(process, context, position, frame, each, parent) : new CidrMemberValue(process, context, position, frame, each, parent));
        }
        CidrValue.addAllTo((Collection<CidrValue>)values, toNode);
    }

    public static void addAllTo(@NotNull CidrDebugProcess process, @NotNull EvaluationContext context, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame, @NotNull Collection<LLValue> vars, @NotNull XCompositeNode toNode) throws ExecutionException {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "addAllTo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "addAllTo"));
        }
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "addAllTo"));
        }
        if (vars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vars", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "addAllTo"));
        }
        if (toNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toNode", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "addAllTo"));
        }
        if (toNode.isObsolete()) {
            return;
        }
        SmartList values = new SmartList();
        for (LLValue each : vars) {
            values.add(new CidrLocalValue(process, context, position, frame, each));
        }
        CidrValue.addAllTo((Collection<CidrValue>)values, toNode);
    }

    public static void addAllTo(@NotNull Collection<CidrValue> values, @NotNull XCompositeNode toNode) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "addAllTo"));
        }
        if (toNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toNode", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "addAllTo"));
        }
        if (toNode.isObsolete()) {
            return;
        }
        XValueChildrenList list = values.isEmpty() ? XValueChildrenList.EMPTY : new XValueChildrenList(values.size());
        for (CidrValue each : values) {
            list.add((XNamedValue)each);
        }
        toNode.addChildren(list, true);
    }

    @NotNull
    public abstract StringBuilder getConsoleDescription(EvaluationContext var1) throws ExecutionException, DBCannotEvaluateException, DBCannotCollectVariablesException;

    public EvaluationContext getContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue", "getContext"));
        }
        return this.myRenderersFactory.createEvaluationContext(driver, expirable, this.myFrame);
    }

    protected static class PresentationData {
        @Nullable
        final Icon icon;
        @Nullable
        final String type;
        @NotNull
        final String value;
        final boolean hasChildren;

        public PresentationData(@Nullable Icon icon, @Nullable String type, @NotNull String value, boolean hasChildren) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue$PresentationData", "<init>"));
            }
            this.icon = icon;
            this.type = type;
            this.value = value;
            this.hasChildren = hasChildren;
        }
    }
}

