/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotLoadVariableException;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrDebuggerTypesHelper {
    private static final Pattern OPTIONAL_PATTERN = Pattern.compile("Swift\\.(ImplicitlyUnwrapped)?Optional<(.*?)>");
    protected CidrDebugProcess myProcess;

    public CidrDebuggerTypesHelper(CidrDebugProcess process) {
        this.myProcess = process;
    }

    protected static PsiElement getDefaultContextElement(XSourcePosition sourcePosition, Project project) {
        if (sourcePosition == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(sourcePosition.getFile());
        if (document == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return null;
        }
        return CidrDebuggerTypesHelper.findContextElement(sourcePosition, document, psiFile);
    }

    @Nullable
    private static PsiElement findContextElement(XSourcePosition sourcePosition, Document document, PsiFile psiFile) {
        PsiElement element;
        int offset = sourcePosition.getOffset();
        int lineEndOffset = document.getLineEndOffset(document.getLineNumber(offset));
        while ((element = psiFile.findElementAt(offset)) != null) {
            if (!(element instanceof PsiWhiteSpace) && !(element instanceof PsiComment)) {
                return element;
            }
            offset = element.getTextRange().getEndOffset() + 1;
            if (offset < lineEndOffset) continue;
        }
        return psiFile.findElementAt(sourcePosition.getOffset());
    }

    @Nullable
    public XSourcePosition computeSourcePosition(XSourcePosition position, LLValue var) {
        PsiElement resolved = this.resolveToDeclaration(position, var);
        if (resolved == null) {
            return null;
        }
        return XDebuggerUtil.getInstance().createPositionByOffset(resolved.getContainingFile().getVirtualFile(), resolved.getTextOffset());
    }

    public boolean hasStructType(@NotNull CidrPhysicalValue value, EvaluationContext context) throws ExecutionException {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/CidrDebuggerTypesHelper", "hasStructType"));
        }
        try {
            return context.isStructType(value.getVar());
        }
        catch (DBCannotLoadVariableException e) {
            CidrDebuggerLog.LOG.debug((Throwable)e);
            return false;
        }
    }

    public boolean isCPPThisPsi(CidrPhysicalValue value) {
        return true;
    }

    public boolean isCStringType(CidrPhysicalValue value) {
        return value.getType().equals("char *") || value.getType().matches("char\\[.*\\]");
    }

    public abstract XSourcePosition computeSourcePosition(CidrMemberValue var1);

    public PsiElement getContextElement(XSourcePosition position) {
        return CidrDebuggerTypesHelper.getDefaultContextElement(position, this.myProcess.getProject());
    }

    @Nullable
    public abstract XSourcePosition resolveProperty(@NotNull CidrMemberValue var1, @Nullable String var2);

    public abstract PsiElement resolveToDeclaration(XSourcePosition var1, LLValue var2);

    @Nullable
    public abstract Boolean isImplicitContextVariable(@NotNull XSourcePosition var1, @NotNull LLValue var2);

    @Nullable
    public Boolean isNullableType(@NotNull CidrPhysicalValue value, @Nullable String dynamicTypeName) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/CidrDebuggerTypesHelper", "isNullableType"));
        }
        return null;
    }

    @Nullable
    public static String unwrapSwiftOptionalType(@NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/jetbrains/cidr/execution/debugger/evaluation/CidrDebuggerTypesHelper", "unwrapSwiftOptionalType"));
        }
        Matcher m = OPTIONAL_PATTERN.matcher(typeName);
        return m.matches() ? m.group(2) : null;
    }

    @NotNull
    public static String unwrapSwiftOptionalTypeIfNecessary(@NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/jetbrains/cidr/execution/debugger/evaluation/CidrDebuggerTypesHelper", "unwrapSwiftOptionalTypeIfNecessary"));
        }
        String string = StringUtil.notNullize((String)CidrDebuggerTypesHelper.unwrapSwiftOptionalType(typeName), (String)typeName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrDebuggerTypesHelper", "unwrapSwiftOptionalTypeIfNecessary"));
        }
        return string;
    }
}

