/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrBreakpointHandler;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PendingBreakpointsHandler
extends CidrBreakpointHandler {
    private volatile boolean myShouldPostponeBreakpoints = true;
    private final List<XLineBreakpoint<XBreakpointProperties>> myPending = new ArrayList<XLineBreakpoint<XBreakpointProperties>>();

    public PendingBreakpointsHandler(CidrDebugProcess process) {
        super(process);
    }

    public boolean registerPendingBreakpoints() {
        if (!this.myShouldPostponeBreakpoints) {
            return false;
        }
        this.myShouldPostponeBreakpoints = false;
        for (XLineBreakpoint<XBreakpointProperties> pending : this.myPending) {
            super.registerBreakpoint(pending);
        }
        this.myPending.clear();
        return true;
    }

    @Override
    public void registerBreakpoint(@NotNull XLineBreakpoint<XBreakpointProperties> breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/jetbrains/cidr/execution/debugger/breakpoints/PendingBreakpointsHandler", "registerBreakpoint"));
        }
        if (this.myShouldPostponeBreakpoints) {
            this.myPending.add(breakpoint);
        } else {
            super.registerBreakpoint(breakpoint);
        }
    }

    @Override
    public void unregisterBreakpoint(@NotNull XLineBreakpoint<XBreakpointProperties> breakpoint, boolean temporary) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/jetbrains/cidr/execution/debugger/breakpoints/PendingBreakpointsHandler", "unregisterBreakpoint"));
        }
        if (this.myShouldPostponeBreakpoints) {
            this.myPending.remove(breakpoint);
        } else {
            super.unregisterBreakpoint(breakpoint, temporary);
        }
    }
}

