/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotSetBreakpointException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCodePointHandlerBase;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrWatchpointType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CidrWatchpointHandler
extends CidrCodePointHandlerBase<XBreakpoint<CidrWatchpointType.CidrWatchpointProperties>> {
    public CidrWatchpointHandler(CidrDebugProcess process) {
        super(process, CidrWatchpointType.class);
    }

    @Override
    protected Collection<LLCodepoint> doAddCodepoints(DebuggerDriver driver, XBreakpoint<CidrWatchpointType.CidrWatchpointProperties> breakpoint, int threadId, int frameNumber) throws ExecutionException {
        LLWatchpoint watchpoint;
        CidrWatchpointType.CidrWatchpointProperties properties = (CidrWatchpointType.CidrWatchpointProperties)breakpoint.getProperties();
        if (properties == null || properties.getDebugProcess() != this.myProcess || !this.myProcess.supportsWatchpoints()) {
            return Collections.emptySet();
        }
        try {
            watchpoint = driver.addWatchpoint(threadId, frameNumber, properties.getLLValue(), properties.getExpr(), properties.getLifetime(), properties.getAccessType());
            properties.setError(null);
        }
        catch (DBCannotSetBreakpointException e) {
            properties.setError(e.getMessage());
            return Collections.emptyList();
        }
        return Collections.singleton(watchpoint);
    }

    public void cleanup() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                XBreakpointManager manager = XDebuggerManager.getInstance((Project)CidrWatchpointHandler.this.myProcess.getProject()).getBreakpointManager();
                for (XBreakpoint breakpoint : manager.getBreakpoints(CidrWatchpointHandler.this.getBreakpointTypeClass())) {
                    CidrWatchpointType.CidrWatchpointProperties properties = (CidrWatchpointType.CidrWatchpointProperties)breakpoint.getProperties();
                    if (properties == null || properties.getDebugProcess() != CidrWatchpointHandler.this.myProcess) continue;
                    manager.removeBreakpoint(breakpoint);
                }
            }
        });
    }

    public void handleWatchpointScope(int id) {
        Object breakpoint = this.getCodepoint(id);
        if (breakpoint == null) {
            return;
        }
        this.doUnregisterBreakpoint(breakpoint);
        XDebuggerUtil.getInstance().removeBreakpoint(this.myProcess.getProject(), breakpoint);
    }

    @Override
    protected void removeBreakpointInBackend(DebuggerDriver driver, List<Integer> ids, XBreakpoint<CidrWatchpointType.CidrWatchpointProperties> breakpoint) throws ExecutionException {
        CidrWatchpointType.CidrWatchpointProperties properties = (CidrWatchpointType.CidrWatchpointProperties)breakpoint.getProperties();
        if (properties != null) {
            CidrDebuggerLog.LOG.assertTrue(properties.getDebugProcess() == this.myProcess);
        }
        driver.removeWatchpoint(ids);
    }
}

