/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotSetBreakpointException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCodePointHandlerBase;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CidrExceptionBreakpointHandler
extends CidrCodePointHandlerBase<XBreakpoint<CidrExceptionBreakpointType.Properties>> {
    public CidrExceptionBreakpointHandler(CidrDebugProcess process, Class<? extends CidrExceptionBreakpointType> typeClass) {
        super(process, typeClass);
    }

    @Override
    protected Collection<LLCodepoint> doAddCodepoints(DebuggerDriver driver, XBreakpoint<CidrExceptionBreakpointType.Properties> breakpoint, int threadId, int frameNumber) throws ExecutionException {
        CidrExceptionBreakpointType.Properties properties = (CidrExceptionBreakpointType.Properties)breakpoint.getProperties();
        if (properties == null) {
            return Collections.emptyList();
        }
        ArrayList<LLCodepoint> result2 = new ArrayList<LLCodepoint>();
        for (String symbol : this.getExceptionSymbols(properties)) {
            try {
                result2.add(driver.addSymbolicBreakpoint(symbol));
            }
            catch (DBCannotSetBreakpointException e) {
                return Collections.emptyList();
            }
        }
        return result2;
    }

    private List<String> getExceptionSymbols(@NotNull CidrExceptionBreakpointType.Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrExceptionBreakpointHandler", "getExceptionSymbols"));
        }
        CidrExceptionBreakpointType.Properties.Type thrown = properties.getWhenThrown();
        ArrayList<String> result2 = new ArrayList<String>(2);
        if (thrown != null) {
            if (thrown == CidrExceptionBreakpointType.Properties.Type.OBJC_EXCEPTION) {
                result2.add("objc_exception_throw");
            } else {
                result2.add("__cxa_throw");
            }
        }
        if (properties.getWhenCaught() != null) {
            result2.add("__cxa_begin_catch");
        }
        return result2;
    }
}

