/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.google.protobuf.GeneratedMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformUtils;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.CidrExecUtil;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.GLogOutputReaders;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectFramesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectVariablesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotSetBreakpointException;
import com.jetbrains.cidr.execution.debugger.backend.DBEvaluationTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DBFatalException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBEntityNotValidException;
import com.jetbrains.cidr.execution.debugger.backend.lldb.ProtobufMessageFactory;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Broadcasts;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Model;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Protocol;
import com.jetbrains.cidr.execution.debugger.backend.lldb.lang.LLDBLanguage;
import com.jetbrains.cidr.execution.ipcUtils.ProtobufServer;
import com.jetbrains.cidr.execution.ipcUtils.ProtobufTimeoutException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLDBDriver
extends DebuggerDriver
implements Consumer<GeneratedMessage> {
    public static final Logger LOG = Logger.getInstance(LLDBDriver.class);
    private static Model.DynamicValuesPolicy DEFAULT_DYNAMIC_VALUES_POLICY = Model.DynamicValuesPolicy.DynamicValuesPolicyCanRunTarget;
    public static Key<Boolean> ENABLE_STL_RENDERERS = Key.create((String)"LLDBDriver.synthethicsEnabled");
    public static final String NO_RESULT = "<no result>";
    private static final int MAX_CHILDREN_COUNT_TO_DISPLAY = 100;
    private volatile boolean myRemote;
    private volatile String myArchitectureId;
    private GeneralCommandLine myLLDBCommandLine;
    private OSProcessHandler myLLDBFrontendHandler;
    private final ExecutionResult<ProtobufServer<Protocol.CompositeResponse>> myConnectedClient = new ExecutionResult();
    private final Set<Integer> myTemporaryBreakpoints = new HashSet<Integer>();
    private ProcessInputWriter myProcessInputHandler = new ProcessInputWriter();
    private Integer myAsyncAttachingTo;
    private boolean myIsDetaching;
    private Semaphore myDetachSemaphore = new Semaphore(0);
    private int myStoppedThreadIndex;
    private final DebuggerDriverConfiguration myStarter;
    private Model.DynamicValuesPolicy myDynamicValuesPolicy = DEFAULT_DYNAMIC_VALUES_POLICY;
    private boolean myValuesFilteringEnabled;
    private ProtobufServer<Protocol.CompositeResponse> myProtobufServer;
    private final GLogOutputReaders myGLogOutputReaders;
    private final AtomicReference<DBFatalException> myAsyncFatalException = new AtomicReference();
    private boolean myReadyForCommand = false;

    private void dispatchInput(String input, Model.DispatchTarget target) throws ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.dispatchInput(input, target);
        this.getProtobufClient().sendMessage(request, Protocol.DispatchInput_Res.class, new Consumer<Protocol.DispatchInput_Res>(){

            public void consume(Protocol.DispatchInput_Res dispatchInput_res) {
            }
        }, null);
    }

    protected ProtobufServer<Protocol.CompositeResponse> getProtobufClient() throws ExecutionException {
        this.throwAsyncFatalException();
        return this.myConnectedClient.get();
    }

    protected ProtobufServer<Protocol.CompositeResponse> getProtobufClient(long timeout) throws ExecutionException {
        try {
            this.throwAsyncFatalException();
            return this.myConnectedClient.get(timeout, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new DBFatalException("LLDB connection timeout", e);
        }
    }

    private void storeAsyncFatalException(DBFatalException e) {
        this.myAsyncFatalException.compareAndSet(null, e);
    }

    private void throwAsyncFatalException() throws DBFatalException {
        DBFatalException exception = this.myAsyncFatalException.get();
        if (exception != null) {
            this.myAsyncFatalException.compareAndSet(exception, null);
            throw new DBFatalException((Throwable)((Object)exception));
        }
    }

    public LLDBDriver(DebuggerDriver.Handler handler2, DebuggerDriverConfiguration starter) {
        super(handler2);
        this.myStarter = starter;
        this.myGLogOutputReaders = new GLogOutputReaders(new File(PathManager.getLogPath()), "LLDBFrontend"){

            @Override
            protected void onTextAvailable(@NotNull String text, @NotNull GLogOutputReaders.LogType type) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver$2", "onTextAvailable"));
                }
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver$2", "onTextAvailable"));
                }
                LOG.debug(text);
            }
        };
    }

    @Override
    @NotNull
    public String getName() {
        if ("LLDB" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver", "getName"));
        }
        return "LLDB";
    }

    @Override
    public boolean supportsWatchpointLifetime() {
        return false;
    }

    @Override
    @NotNull
    public Language getConsoleLanguage() {
        LLDBLanguage lLDBLanguage = LLDBLanguage.INSTANCE;
        if (lLDBLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver", "getConsoleLanguage"));
        }
        return lLDBLanguage;
    }

    @Override
    @NotNull
    public ProcessHandler getProcessHandler() {
        OSProcessHandler oSProcessHandler = this.myLLDBFrontendHandler;
        if (oSProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver", "getProcessHandler"));
        }
        return oSProcessHandler;
    }

    @Override
    public void destroyProcessHandler() {
        try {
            Protocol.CompositeRequest request = ProtobufMessageFactory.exit();
            this.getProtobufClient().sendMessage(request, null, null);
            if (this.getProcessHandler().waitFor(10000L)) {
                return;
            }
        }
        catch (ExecutionException e) {
            this.handleDriverException((Exception)((Object)e));
        }
        super.destroyProcessHandler();
    }

    @Override
    public boolean isInPromptMode() {
        return false;
    }

    public int getPort() {
        return this.myProtobufServer.getPort();
    }

    public Model.DynamicValuesPolicy getDynamicValuesPolicy() {
        return this.myDynamicValuesPolicy;
    }

    public void setDynamicValuesPolicy(Model.DynamicValuesPolicy dynamicValuesPolicy) {
        this.myDynamicValuesPolicy = dynamicValuesPolicy;
    }

    @Override
    public void start(@NotNull Installer installer, @NotNull String architecture, boolean isRemote) throws ExecutionException {
        if (installer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installer", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver", "start"));
        }
        if (architecture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "architecture", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver", "start"));
        }
        this.myInstaller = installer;
        this.myRemote = isRemote;
        this.myArchitectureId = architecture;
        try {
            this.myProtobufServer = new ProtobufServer<Protocol.CompositeResponse>((Consumer)this, (ProtobufServer.ProtobufParser)new ProtobufServer.ProtobufParser<Protocol.CompositeResponse>(){

                @Override
                public Protocol.CompositeResponse parse(byte[] buffer) throws IOException {
                    return Protocol.CompositeResponse.parseFrom(buffer);
                }

                @Override
                public boolean decompose(GeneratedMessage response) {
                    return response instanceof Protocol.CompositeResponse || response instanceof Broadcasts.CompositeBroadcast;
                }
            }){

                @Override
                protected void handleIOException(IOException e) {
                    LLDBDriver.this.handleDriverException(e);
                    if (!LLDBDriver.this.myConnectedClient.isDone()) {
                        LLDBDriver.this.myConnectedClient.setException(e);
                    } else {
                        LLDBDriver.this.storeAsyncFatalException(new DBFatalException(e));
                    }
                }
            };
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
        this.myLLDBCommandLine = this.myStarter.createDriverCommandLine(this, installer, architecture);
        Map environment = this.myLLDBCommandLine.getEnvironment();
        environment.put("GLOG_log_dir", PathManager.getLogPath());
        if (LOG.isDebugEnabled()) {
            environment.put("GLOG_minloglevel", "0");
            environment.put("GLOG_logbufsecs", "0");
            environment.put("GLOG_v", "1");
            this.myGLogOutputReaders.init();
        } else {
            environment.put("GLOG_minloglevel", "2");
        }
        Process lldbProcess = this.myLLDBCommandLine.createProcess();
        this.myLLDBFrontendHandler = new OSProcessHandler(lldbProcess, this.myLLDBCommandLine.getCommandLineString()){

            protected boolean useNonBlockingRead() {
                return false;
            }
        };
        this.myLLDBFrontendHandler.setShouldDestroyProcessRecursively(false);
        this.myLLDBFrontendHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            final StringBuilder errOut = new StringBuilder();

            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                LLDBDriver.this.myProtobufServer.tearDown();
            }

            public void processTerminated(ProcessEvent event) {
                CidrExecUtil.checkErrorOnTermination(this.errOut, LLDBDriver.this.myConnectedClient);
                LLDBDriver.this.readOutputFully();
                LLDBDriver.this.closeOutputReaders();
                LLDBDriver.this.myProcessInputHandler.close();
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                super.onTextAvailable(event, outputType);
                if (outputType == ProcessOutputTypes.STDERR) {
                    this.errOut.append(event.getText());
                }
            }
        });
    }

    protected void handleDriverException(Exception e) {
        LOG.warn((Throwable)e);
    }

    @Override
    protected void readOutputFully() {
        super.readOutputFully();
        this.myGLogOutputReaders.readFully();
    }

    @Override
    protected void closeOutputReaders() {
        super.closeOutputReaders();
        this.myGLogOutputReaders.close();
    }

    @Override
    public void setValuesFilteringEnabled(boolean enabled) throws ExecutionException {
        if (this.myValuesFilteringEnabled == enabled) {
            return;
        }
        this.myValuesFilteringEnabled = enabled;
        LLDBDriver.doSetValuesFilteringEnabled(enabled, this.getProtobufClient());
    }

    private static void doSetValuesFilteringEnabled(boolean enabled, ProtobufServer<Protocol.CompositeResponse> client) throws ExecutionException {
        client.sendMessageAndWaitForReply(ProtobufMessageFactory.setValuesFilteringEnabled(enabled), Protocol.ValuesFilteringPolicy_Res.class, new ThrowIfNotValid("couldn't set values filtering policy"));
    }

    @Override
    public void load(boolean forAttach, @Nullable String architecture) throws ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't create target");
        this.myTargetCommandLine = this.myInstaller.install();
        Protocol.CompositeRequest createTargetReq = ProtobufMessageFactory.createTarget(this.myInstaller.getExecutableFile().getPath(), StringUtil.notNullize((String)architecture));
        this.getProtobufClient().sendMessageAndWaitForReply(createTargetReq, Protocol.CreateTarget_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    @Override
    public void loadForRemote(File deviceSupport) throws ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't create target");
        this.myTargetCommandLine = this.myInstaller.install();
        String exePath = this.myInstaller.getExecutableFile().getPath();
        String remoteExePath = this.myTargetCommandLine.getExePath();
        CidrDebuggerLog.LOG.debug("creating remote target: exepath: " + exePath + " remotePath: " + remoteExePath + " arch: " + this.myArchitectureId);
        Protocol.CompositeRequest createTargetReq = ProtobufMessageFactory.createRemoteTarget(exePath, this.myArchitectureId, "remote-ios", new File(deviceSupport, "Symbols"), remoteExePath);
        this.getProtobufClient().sendMessageAndWaitForReply(createTargetReq, Protocol.CreateTarget_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
        this.addShlibPathSubstitutions(DebuggerDriver.getShlibPathSubstitutions(this.myInstaller.getExecutableFile().getAbsolutePath(), new File(this.myTargetCommandLine.getExePath()).getParent(), deviceSupport));
    }

    @Override
    public void launch() throws ExecutionException {
        Protocol.CompositeRequest launchReq;
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't launch process");
        assert (this.myTargetCommandLine != null) : "Not Installed";
        String debugserverSocket = this.getDebugServerSocket();
        CidrDebuggerLog.LOG.assertTrue(debugserverSocket != null || !this.myRemote);
        if (!this.myRemote) {
            File tmpDir;
            if (this.myToRedirect) {
                this.initReaders(!SystemInfo.isWindows);
            }
            String stdoutPath = this.myReaders != null ? this.myReaders.getOutFileAbsolutePath() : null;
            String stderrPath = this.myReaders != null ? this.myReaders.getErrFileAbsolutePath() : null;
            try {
                tmpDir = FileUtil.createTempDirectory((String)"process_pipe_dir", null);
            }
            catch (IOException e) {
                throw new LLDBEntityNotValidException(CidrDebuggerBundle.message("debug.lldb.cannotCreatePipe", new Object[0]));
            }
            this.myProcessInputHandler.initPipeInput(tmpDir, "process_pipe");
            launchReq = ProtobufMessageFactory.launch(this.myTargetCommandLine, new File(tmpDir, "process_pipe").getAbsolutePath(), stdoutPath, stderrPath);
        } else {
            this.myProcessInputHandler.initDispatchInput();
            launchReq = ProtobufMessageFactory.remoteLaunch(this.myInstaller.getExecutableFile().getAbsolutePath(), this.myTargetCommandLine, debugserverSocket);
        }
        this.printTargetCommandLine(this.myTargetCommandLine);
        this.getProtobufClient().sendMessageAndWaitForReply(launchReq, Protocol.Launch_Res.class, responseHandler);
        if (this.myRemote && !responseHandler.isValid() && CidrDebuggerBundle.message("debug.lldb.lockedDeviceResponse", new Object[0]).equals(responseHandler.getMessage())) {
            throw new LLDBEntityNotValidException(CidrDebuggerBundle.message("debug.lldb.lockedDeviceUserMessage", ApplicationNamesInfo.getInstance().getProductName()));
        }
        responseHandler.throwIfNeeded();
        this.handlePrompt();
    }

    @Override
    public void attachTo(int pid) throws ExecutionException {
        this.myAsyncAttachingTo = pid;
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't attach to process");
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.attach(pid), Protocol.Attach_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
        this.handlePrompt();
    }

    @Override
    public void detach() throws ExecutionException {
        this.interrupt();
        if (this.getState() == DebuggerDriver.TargetState.RUNNING) {
            this.myIsDetaching = true;
            try {
                this.myDetachSemaphore.tryAcquire(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                CidrDebuggerLog.LOG.debug((Throwable)e);
            }
        }
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't detach process");
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.detach(), Protocol.Detach_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
        this.handleDetached();
    }

    @Override
    public void attachByName(String name, boolean wait) throws ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't attach to process");
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.attachByName(name, wait), Protocol.AttachByName_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
        this.handlePrompt();
    }

    @Override
    public boolean interrupt() throws ExecutionException {
        final Ref result2 = new Ref();
        Protocol.CompositeRequest req = ProtobufMessageFactory.suspend();
        this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.Suspend_Res.class, (Consumer<Protocol.CompositeResponse>)new Consumer<Protocol.Suspend_Res>(){

            public void consume(Protocol.Suspend_Res suspend_res) {
                result2.set((Object)suspend_res.getCommonResponse().getIsValid());
            }
        });
        return result2.isNull() ? false : (Boolean)result2.get();
    }

    @Override
    public boolean resume() throws ExecutionException {
        final boolean[] res = new boolean[1];
        Protocol.CompositeRequest resume = ProtobufMessageFactory.resume();
        this.getProtobufClient().sendMessageAndWaitForReply(resume, Protocol.Continue_Res.class, (Consumer<Protocol.CompositeResponse>)new Consumer<Protocol.Continue_Res>(){

            public void consume(Protocol.Continue_Res continue_res) {
                res[0] = continue_res.getCommonResponse().getIsValid();
            }
        });
        return res[0];
    }

    @Override
    public void stepOver() throws ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Error stepping over");
        Protocol.CompositeRequest request = ProtobufMessageFactory.stepOver(this.myStoppedThreadIndex);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.StepOver_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    @Override
    public void stepInto() throws ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Error stepping into");
        Protocol.CompositeRequest request = ProtobufMessageFactory.stepInto(this.myStoppedThreadIndex);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.StepInto_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    @Override
    public void stepOut() throws ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Error stepping out");
        Protocol.CompositeRequest request = ProtobufMessageFactory.stepOut(this.myStoppedThreadIndex);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.StepOut_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTo(String path, int line) throws ExecutionException {
        Set<Integer> set = this.myTemporaryBreakpoints;
        synchronized (set) {
            try {
                List<LLBreakpoint> breakpoints = this.addBreakpoint(path, line);
                for (LLBreakpoint breakpoint : breakpoints) {
                    this.myTemporaryBreakpoints.add(breakpoint.getId());
                }
            }
            catch (DBCannotSetBreakpointException e) {
                throw new ExecutionException("Cannot set a breakpoint", (Throwable)e);
            }
            if (!this.resume()) {
                throw new ExecutionException("Couldn't resume program");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTemporaryBreakpoints() throws ExecutionException {
        Set<Integer> set = this.myTemporaryBreakpoints;
        synchronized (set) {
            for (int num : this.myTemporaryBreakpoints) {
                Protocol.CompositeRequest request = LLDBDriver.createRemoveBreakpointRequest(num);
                this.getProtobufClient().sendMessage(request, Protocol.RemoveBreakpoint_Res.class, new Consumer<Protocol.RemoveBreakpoint_Res>(){

                    public void consume(Protocol.RemoveBreakpoint_Res res) {
                        if (!res.getCommonResponse().getIsValid()) {
                            CidrDebuggerLog.LOG.error("Couldn't remove breakpoint. error: " + res.getCommonResponse().getErrorMessage());
                        }
                    }
                }, null);
            }
            this.myTemporaryBreakpoints.clear();
        }
    }

    @Override
    public boolean abort() throws ExecutionException {
        final Ref toThrow = Ref.create();
        final Ref abort = Ref.create((Object)false);
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.kill(), Protocol.Kill_Res.class, (Consumer<Protocol.CompositeResponse>)new Consumer<Protocol.Kill_Res>(){

            public void consume(Protocol.Kill_Res res) {
                Protocol.CommonResponse commonResponse = res.getCommonResponse();
                if (commonResponse.getIsValid()) {
                    abort.set((Object)true);
                } else {
                    String errorMessage = commonResponse.getErrorMessage();
                    if ("process not exist".equals(errorMessage)) {
                        abort.set((Object)false);
                    } else {
                        if (StringUtil.isEmptyOrSpaces((String)errorMessage)) {
                            errorMessage = "Failed to abort process";
                        }
                        toThrow.set((Object)new LLDBEntityNotValidException(errorMessage));
                    }
                }
            }
        });
        return (Boolean)abort.get();
    }

    @Override
    @NotNull
    public LLWatchpoint addWatchpoint(int threadId, int frameNumber, LLValue value, String expr, LLWatchpoint.Lifetime lifetime, LLWatchpoint.AccessType accessType) throws ExecutionException, DBCannotSetBreakpointException {
        final String expression = value.getReferenceExpression();
        Protocol.CompositeRequest request = ProtobufMessageFactory.addWatchpoint(LLDBDriver.valId(value), null, accessType == LLWatchpoint.AccessType.ANY || accessType == LLWatchpoint.AccessType.READ, accessType == LLWatchpoint.AccessType.ANY || accessType == LLWatchpoint.AccessType.WRITE, true);
        final Ref result2 = Ref.create(null);
        final Ref toThrow = Ref.create(null);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.AddWatchpoint_Res.class, (Consumer<Protocol.CompositeResponse>)new Consumer<Protocol.AddWatchpoint_Res>(){

            public void consume(Protocol.AddWatchpoint_Res res) {
                if (!res.getCommonResponse().getIsValid()) {
                    toThrow.set((Object)new DBCannotSetBreakpointException(res.getCommonResponse().getErrorMessage()));
                } else {
                    result2.set((Object)new LLWatchpoint(res.getWatchpointId(), expression));
                }
            }
        });
        if (result2.isNull()) {
            throw (DBCannotSetBreakpointException)toThrow.get();
        }
        LLWatchpoint lLWatchpoint = (LLWatchpoint)result2.get();
        if (lLWatchpoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver", "addWatchpoint"));
        }
        return lLWatchpoint;
    }

    @Override
    @NotNull
    public List<LLBreakpoint> addBreakpoint(final String path, final int line, final @Nullable String condition) throws ExecutionException {
        Protocol.CompositeRequest req = ProtobufMessageFactory.addBreakpoint(path, line + 1, condition);
        final Ref result2 = new Ref();
        this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.AddBreakpoint_Res.class, (Consumer<Protocol.CompositeResponse>)new Consumer<Protocol.AddBreakpoint_Res>(){

            public void consume(Protocol.AddBreakpoint_Res res) {
                result2.set((Object)new LLBreakpoint(res.getId(), path, line, false, condition, null));
            }
        });
        List<Object> list = result2.isNull() ? Collections.emptyList() : Collections.singletonList(result2.get());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver", "addBreakpoint"));
        }
        return list;
    }

    @Override
    @NotNull
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull DebuggerDriver.SymbolicBreakpoint symBreakpoint) throws ExecutionException, DBCannotSetBreakpointException {
        if (symBreakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symBreakpoint", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver", "addSymbolicBreakpoint"));
        }
        Protocol.CompositeRequest req = ProtobufMessageFactory.addBreakpoint(symBreakpoint.getPattern(), symBreakpoint.isRegexpPattern(), symBreakpoint.getModule(), symBreakpoint.getCondition(), symBreakpoint.getThreadId());
        final Ref result2 = new Ref();
        this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.AddBreakpoint_Res.class, (Consumer<Protocol.CompositeResponse>)new Consumer<Protocol.AddBreakpoint_Res>(){

            public void consume(Protocol.AddBreakpoint_Res res) {
                result2.set((Object)new LLSymbolicBreakpoint(res.getId()));
            }
        });
        LLSymbolicBreakpoint lLSymbolicBreakpoint = (LLSymbolicBreakpoint)result2.get();
        if (lLSymbolicBreakpoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver", "addSymbolicBreakpoint"));
        }
        return lLSymbolicBreakpoint;
    }

    @Override
    public void removeCodepoints(@NotNull Collection<Integer> ids) throws ExecutionException {
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver", "removeCodepoints"));
        }
        for (Integer each : ids) {
            ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't remove breakpoint");
            Protocol.CompositeRequest req = LLDBDriver.createRemoveBreakpointRequest(each);
            this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.RemoveBreakpoint_Res.class, responseHandler);
            responseHandler.throwIfNeeded();
        }
    }

    private static Protocol.CompositeRequest createRemoveBreakpointRequest(int num) {
        return ProtobufMessageFactory.removeBreakpoint(num);
    }

    @NotNull
    protected LLFrame newLLFrame(@NotNull Model.LLDBFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver", "newLLFrame"));
        }
        String sourceFilePath = frame.getFile();
        if (sourceFilePath != null) {
            File canonicalFile = new File(FileUtil.toCanonicalPath((String)this.myStarter.convertPath(sourceFilePath), (boolean)true));
            sourceFilePath = ApplicationManager.getApplication().isUnitTestMode() && PlatformUtils.isAppCode() && canonicalFile.getPath().startsWith("/private") ? '/' + FileUtil.getRelativePath((File)new File("/private"), (File)canonicalFile) : canonicalFile.getPath();
        }
        LLFrame lLFrame = new LLFrame(frame.getNumber(), frame.getFunction(), sourceFilePath, frame.getLine() - 1, frame.getPc(), LLDBDriver.convertLanguage(frame.getLanguage()));
        if (lLFrame == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver", "newLLFrame"));
        }
        return lLFrame;
    }

    @Nullable
    protected static DebuggerDriver.DebuggerLanguage convertLanguage(@Nullable Model.Language language) {
        if (language != null) {
            switch (language) {
                case LanguageC: 
                case LanguageC89: 
                case LanguageC99: 
                case LanguageC11: {
                    return DebuggerDriver.StandardDebuggerLanguage.C;
                }
                case LanguageC_plus_plus: 
                case LanguageC_plus_plus_03: 
                case LanguageC_plus_plus_11: 
                case LanguageC_plus_plus_14: {
                    return DebuggerDriver.StandardDebuggerLanguage.C_PLUS_PLUS;
                }
                case LanguageObjC: {
                    return DebuggerDriver.StandardDebuggerLanguage.OBJC;
                }
                case LanguageObjC_plus_plus: {
                    return DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS;
                }
                case LanguageSwift: {
                    return DebuggerDriver.StandardDebuggerLanguage.SWIFT;
                }
            }
            return null;
        }
        return null;
    }

    @Nullable
    protected static Model.Language convertLanguage(@Nullable DebuggerDriver.DebuggerLanguage language) throws DBCannotEvaluateException {
        if (language == null) {
            return null;
        }
        if (language instanceof DebuggerDriver.StandardDebuggerLanguage) {
            switch ((DebuggerDriver.StandardDebuggerLanguage)language) {
                case C: {
                    return Model.Language.LanguageC;
                }
                case C_PLUS_PLUS: {
                    return Model.Language.LanguageC_plus_plus;
                }
                case OBJC: {
                    return Model.Language.LanguageObjC;
                }
                case OBJC_PLUS_PLUS: {
                    return Model.Language.LanguageObjC_plus_plus;
                }
                case SWIFT: {
                    return Model.Language.LanguageSwift;
                }
            }
        }
        throw new DBCannotEvaluateException(language.toString() + " is not supported by LLDB");
    }

    @Override
    @NotNull
    public List<LLFrame> getFrames(int threadId, boolean untilValidLineEntry) throws ExecutionException, DBCannotCollectFramesException {
        final ArrayList<LLFrame> result2 = new ArrayList<LLFrame>();
        Protocol.CompositeRequest request = ProtobufMessageFactory.getFrames(threadId, untilValidLineEntry);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.GetFrames_Res.class, new Consumer<Protocol.GetFrames_Res>(){

            public void consume(Protocol.GetFrames_Res getFrames_res) {
                for (Model.LLDBFrame frame : getFrames_res.getFramesList()) {
                    result2.add(LLDBDriver.this.newLLFrame(frame));
                }
            }
        }, Integer.MAX_VALUE);
        ArrayList<LLFrame> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver", "getFrames"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<LLValue> getVariables(int threadId, int frameNumber) throws ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.getLocals(threadId, frameNumber);
        final ArrayList<LLValue> result2 = new ArrayList<LLValue>();
        final Ref errorMessage = new Ref();
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.GetLocals_Res.class, new Consumer<Protocol.GetLocals_Res>(){

            public void consume(Protocol.GetLocals_Res res) {
                Protocol.CommonResponse commonResponse = res.getCommonResponse();
                if (!commonResponse.getIsValid()) {
                    String message = commonResponse.getErrorMessage();
                    if (message != null) {
                        errorMessage.set((Object)message);
                    }
                } else {
                    List<Model.LLDBValue> valuesList = res.getValuesList();
                    for (Model.LLDBValue lldbValue : valuesList) {
                        result2.add(LLDBDriver.convertValue(lldbValue, null));
                    }
                }
            }
        }, 0L);
        if (!errorMessage.isNull() && !StringUtil.isEmpty((String)((String)errorMessage.get()))) {
            throw new ExecutionException((String)errorMessage.get());
        }
        ArrayList<LLValue> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver", "getVariables"));
        }
        return arrayList;
    }

    @NotNull
    public String getObjectDescription(LLValue value, int length) throws DBCannotEvaluateException, ExecutionException {
        Protocol.CompositeRequest req = ProtobufMessageFactory.getObjectDescription(LLDBDriver.valId(value), length);
        final Ref description = Ref.create();
        final Ref exception = Ref.create();
        this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.GetObjectDescription_Res.class, (Consumer<Protocol.CompositeResponse>)new Consumer<Protocol.GetObjectDescription_Res>(){

            public void consume(Protocol.GetObjectDescription_Res res) {
                Protocol.CommonResponse commonResponse = res.getCommonResponse();
                if (!commonResponse.getIsValid()) {
                    exception.set((Object)new DBCannotEvaluateException(commonResponse.getErrorMessage()));
                    return;
                }
                description.set((Object)res.getDescription());
            }
        });
        if (!exception.isNull()) {
            throw (DBCannotEvaluateException)exception.get();
        }
        String string = (String)description.get();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver", "getObjectDescription"));
        }
        return string;
    }

    @Override
    @NotNull
    public List<LLValue> getVariableChildren(LLValue var) throws ExecutionException, DBCannotCollectVariablesException {
        List<LLValue> list = this.getVariableChildrenRange(var, 0, this.getChildrenCount(var));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver", "getVariableChildren"));
        }
        return list;
    }

    @Override
    public List<LLValue> getVariableChildrenRange(LLValue var, int offset, int count) throws ExecutionException, DBCannotCollectVariablesException {
        if (this.getChildrenCount(var, 1) == 0) {
            return Collections.emptyList();
        }
        CidrDebuggerLog.LOG.assertTrue(count <= 100, (Object)("Too many children to request: " + count));
        Protocol.CompositeRequest request = ProtobufMessageFactory.getValueChildren(LLDBDriver.valId(var), offset, count);
        final Ref errorMessage = new Ref();
        final ArrayList<LLValue> result2 = new ArrayList<LLValue>();
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.GetValueChildren_Res.class, new Consumer<Protocol.GetValueChildren_Res>(){

            public void consume(Protocol.GetValueChildren_Res res) {
                boolean isValid = res.getCommonResponse().getIsValid();
                if (!isValid) {
                    errorMessage.set((Object)res.getCommonResponse().getErrorMessage());
                } else {
                    List<Model.LLDBValue> valuesList = res.getValuesList();
                    LLDBDriver.convertList(valuesList, result2);
                }
            }
        }, 0L);
        String message = (String)errorMessage.get();
        if (message != null) {
            throw new DBCannotCollectVariablesException(message);
        }
        return result2;
    }

    @Override
    public void addSymbolsFile(File dSYM, File module) throws ExecutionException {
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.handleConsoleCommand(-1, -1, "target module add \"" + module.getAbsolutePath() + "\""), Protocol.HandleConsoleCommand_Res.class, new ThrowIfNotValid("couldn't add module: " + module.getAbsolutePath()));
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.handleConsoleCommand(-1, -1, "target symbols add \"" + dSYM.getAbsolutePath() + "\""), Protocol.HandleConsoleCommand_Res.class, new ThrowIfNotValid("couldn't add dSYM: " + dSYM.getAbsolutePath()));
    }

    @Override
    public boolean isStructType(LLValue var) {
        return var.isStruct();
    }

    private static void convertList(List<Model.LLDBValue> valuesList, List<LLValue> result2) {
        for (Model.LLDBValue val : valuesList) {
            LLValue value = LLDBDriver.convertValue(val, null);
            result2.add(value);
        }
    }

    private static int valId(LLValue var) {
        return Integer.parseInt(var.getId());
    }

    public List<LLValue> arraySlice(LLValue var, int offset, int count) throws ExecutionException, DBCannotEvaluateException, DBCannotCollectVariablesException {
        final Ref errorMessage = Ref.create((Object)"unknown error");
        final ArrayList<LLValue> vals = new ArrayList<LLValue>();
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.arraySlice(LLDBDriver.valId(var), offset, count), Protocol.GetArraySlice_Res.class, (Consumer<Protocol.CompositeResponse>)new Consumer<Protocol.GetArraySlice_Res>(){

            public void consume(Protocol.GetArraySlice_Res res) {
                if (!res.getCommonResponse().getIsValid()) {
                    String message = res.getCommonResponse().getErrorMessage();
                    if (message != null) {
                        errorMessage.set((Object)message);
                    }
                    return;
                }
                errorMessage.set(null);
                LLDBDriver.convertList(res.getValuesList(), vals);
            }
        });
        if (!errorMessage.isNull()) {
            throw new DBCannotCollectVariablesException((String)errorMessage.get());
        }
        return vals;
    }

    private static LLValue convertValue(Model.LLDBValue value, @Nullable String expression) {
        LLValue.TypeClass typeClass;
        boolean isNSObject = value.getIsOcObject() != 0;
        String readableValue = isNSObject ? StringUtil.notNullize((String)value.getValue()) : StringUtil.nullize((String)LLDBDriver.unescapeString(value.getSummary()));
        switch (value.getTypeClass()) {
            case TypeClassReference: {
                typeClass = LLValue.TypeClass.REFERENCE;
                break;
            }
            case TypeClassFunction: {
                typeClass = LLValue.TypeClass.FUNCTION;
                break;
            }
            case TypeClassBuiltin: {
                typeClass = LLValue.TypeClass.BUILTIN;
                break;
            }
            default: {
                typeClass = null;
            }
        }
        return new LLValue(String.valueOf(value.getId()), expression == null ? value.getName() : expression, value.getType(), null, value.getValue(), LLValue.Kind.EVALUATED, -1, isNSObject, readableValue, value.getName(), value.getTypeClass() == Model.TypeClass.TypeClassStruct, typeClass);
    }

    @Override
    @NotNull
    public LLValue evaluate(int threadId, int frameNumber, final @NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage language) throws ExecutionException, DBCannotEvaluateException {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver", "evaluate"));
        }
        Protocol.CompositeRequest req = ProtobufMessageFactory.evaluateExpression(frameNumber, threadId, expression, LLDBDriver.convertLanguage(language));
        final Ref result2 = new Ref();
        final Ref errorMessage = new Ref();
        try {
            this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.EvaluateExpression_Res.class, new Consumer<Protocol.EvaluateExpression_Res>(){

                public void consume(Protocol.EvaluateExpression_Res res) {
                    if (res.getCommonResponse().getIsValid()) {
                        if (res.hasResult()) {
                            Model.LLDBValue lldbValue = res.getResult();
                            LLValue value = LLDBDriver.convertValue(lldbValue, expression);
                            result2.set((Object)value);
                        } else {
                            errorMessage.set((Object)LLDBDriver.NO_RESULT);
                        }
                    } else {
                        String error = res.getCommonResponse().getErrorMessage();
                        errorMessage.set((Object)(error != null ? error : "Unknown evaluation error"));
                    }
                }
            }, 0L);
        }
        catch (ProtobufTimeoutException e) {
            throw new DBEvaluationTimedOutException(expression);
        }
        if (!errorMessage.isNull()) {
            String message = (String)errorMessage.get();
            if (NO_RESULT.equals(message)) {
                String id = "_dummy_result__variable_";
                LLValue lLValue = new LLValue(id, "result", "void", null, "void", LLValue.Kind.EVALUATED, 0, false, null, id, false, null);
                if (lLValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver", "evaluate"));
                }
                return lLValue;
            }
            Pattern p = Pattern.compile("error: (.*)\nerror: \\d+ error[s]? parsing expression\n");
            Matcher matcher = p.matcher(message);
            if (matcher.find()) {
                message = matcher.group(1);
            }
            throw new DBCannotEvaluateException(message);
        }
        if (result2.isNull()) {
            throw new ExecutionException("Unknown evaluation error");
        }
        LLValue lLValue = (LLValue)((Object)result2.get());
        if (lLValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver", "evaluate"));
        }
        return lLValue;
    }

    @Override
    @NotNull
    public DebuggerDriver.ShellCommandResult executeShellCommand(@NotNull String command, @Nullable String workingDir, int timeoutSecs) throws ExecutionException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver", "executeShellCommand"));
        }
        final Ref result2 = new Ref();
        final Ref errorMessage = new Ref();
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.executeShellCommand(command, workingDir, timeoutSecs), Protocol.ExecuteShellCommand_Res.class, (Consumer<Protocol.CompositeResponse>)new Consumer<Protocol.ExecuteShellCommand_Res>(){

            public void consume(Protocol.ExecuteShellCommand_Res res) {
                Protocol.CommonResponse commonResponse = res.getCommonResponse();
                if (!commonResponse.getIsValid()) {
                    String message = commonResponse.getErrorMessage();
                    errorMessage.set((Object)(message != null && !StringUtil.isEmpty((String)message) ? message : "Invalid shell command response"));
                } else {
                    result2.set((Object)new DebuggerDriver.ShellCommandResult(res.getOutput(), res.getStatus(), res.getSignal()));
                }
            }
        });
        if (!errorMessage.isNull()) {
            throw new ExecutionException((String)errorMessage.get());
        }
        DebuggerDriver.ShellCommandResult shellCommandResult = (DebuggerDriver.ShellCommandResult)result2.get();
        if (shellCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver", "executeShellCommand"));
        }
        return shellCommandResult;
    }

    @Override
    public void executeConsoleCommand(String command) throws ExecutionException {
        this.executeConsoleCommand(-1, -1, command);
    }

    @Override
    public void executeConsoleCommand(int threadId, int frameNumber, String command) throws ExecutionException {
        if (this.myReadyForCommand) {
            this.doHandleConsoleCommand(threadId, frameNumber, command);
        } else {
            this.dispatchInput(command, Model.DispatchTarget.DispatchTargetDebugger);
        }
    }

    private void doHandleConsoleCommand(int threadId, int frameNumber, String command) throws ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.handleConsoleCommand(threadId, frameNumber, command);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.HandleConsoleCommand_Res.class, (Consumer<Protocol.CompositeResponse>)new Consumer<Protocol.HandleConsoleCommand_Res>(){

            public void consume(Protocol.HandleConsoleCommand_Res res) {
                if (res.hasOut()) {
                    LLDBDriver.this.handleGDBOutput(res.getOut());
                }
                if (res.hasErr()) {
                    LLDBDriver.this.handleGDBOutput(res.getErr());
                }
            }
        });
    }

    @Override
    public void handleCompletion(String command, int pos, final List<String> completions) throws ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.handleCompletion(command, pos);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.HandleCompletion_Res.class, (Consumer<Protocol.CompositeResponse>)new Consumer<Protocol.HandleCompletion_Res>(){

            public void consume(Protocol.HandleCompletion_Res res) {
                completions.addAll(res.getCompletionList());
            }
        });
    }

    @Override
    public void handleSignal(String signalName, boolean stop2, boolean pass, boolean notify) throws ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't handle signal");
        Protocol.CompositeRequest handleSignalReq = ProtobufMessageFactory.handleSignal(signalName, stop2, pass, notify);
        this.getProtobufClient().sendMessageAndWaitForReply(handleSignalReq, Protocol.HandleSignal_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    @Override
    protected String getPromptText() {
        return "lldb";
    }

    @Override
    public OutputStream getProcessInput() {
        return this.myProcessInputHandler;
    }

    @Override
    public void removeWatchpoint(List<Integer> ids) throws ExecutionException {
        int num = ids.get(0);
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't remove watchpoint");
        Protocol.CompositeRequest req = ProtobufMessageFactory.removeWatchpoint(num);
        this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.RemoveWatchpoint_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    @Override
    public int getChildrenCount(LLValue var, int max) throws ExecutionException, DBCannotCollectVariablesException {
        if (var.getChildrenCount() >= max) {
            return max;
        }
        Protocol.CompositeRequest request = ProtobufMessageFactory.getChildrenCount(LLDBDriver.valId(var), max);
        final Ref errorMessage = new Ref();
        final Ref result2 = Ref.create((Object)0);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.GetChildrenCount_Res.class, new Consumer<Protocol.GetChildrenCount_Res>(){

            public void consume(Protocol.GetChildrenCount_Res res) {
                boolean isValid = res.getCommonResponse().getIsValid();
                if (!isValid) {
                    errorMessage.set((Object)res.getCommonResponse().getErrorMessage());
                } else {
                    result2.set((Object)res.getCount());
                }
            }
        }, 0L);
        if (!errorMessage.isNull()) {
            throw new DBCannotCollectVariablesException((String)errorMessage.get());
        }
        var.setChildrenCount((Integer)result2.get());
        return (Integer)result2.get();
    }

    private void addShlibPathSubstitutions(String pathSubsts) throws ExecutionException {
        this.myProtobufServer.sendMessageAndWaitForReply(ProtobufMessageFactory.handleConsoleCommand(-1, -1, "target modules search-paths add " + pathSubsts), Protocol.HandleConsoleCommand_Res.class, new ThrowIfNotValid(CidrDebuggerBundle.message("debug.command.error.cannotAddModulesSearchPaths", new Object[0])), Integer.MAX_VALUE);
    }

    private void haveConnection() {
        try {
            this.myProtobufServer.sendMessage(ProtobufMessageFactory.setDynamicValuesPolicy(this.myDynamicValuesPolicy), Protocol.DynamicValuesPolicy_Res.class, new ThrowIfNotValid<Protocol.DynamicValuesPolicy_Res>("couldn't set dynamic values policy"){

                @Override
                public void consume(Protocol.DynamicValuesPolicy_Res message) {
                    super.consume(message);
                    LLDBDriver.this.myProtobufServer.sendMessage(ProtobufMessageFactory.handleConsoleCommand(-1, -1, "settings set target.prefer-dynamic-value no-dynamic-values"), Protocol.HandleConsoleCommand_Res.class, new ThrowIfNotValid<Protocol.HandleConsoleCommand_Res>("couldn't set dynamic values policy"){

                        @Override
                        public void consume(Protocol.HandleConsoleCommand_Res message) {
                            super.consume(message);
                            LLDBDriver.this.myProtobufServer.sendMessage(ProtobufMessageFactory.setValuesFilteringEnabled(CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED), Protocol.ValuesFilteringPolicy_Res.class, new ThrowIfNotValid<Protocol.ValuesFilteringPolicy_Res>("couldn't set values filtering policy"){

                                @Override
                                public void consume(Protocol.ValuesFilteringPolicy_Res message) {
                                    super.consume(message);
                                    Consumer<Protocol.HandleConsoleCommand_Res> completion = new Consumer<Protocol.HandleConsoleCommand_Res>(){

                                        public void consume(Protocol.HandleConsoleCommand_Res res) {
                                            LLDBDriver.this.myConnectedClient.set(LLDBDriver.this.myProtobufServer);
                                        }
                                    };
                                    if (LLDBDriver.this.myLLDBCommandLine.getUserData(ENABLE_STL_RENDERERS) == Boolean.TRUE) {
                                        LLDBDriver.this.myProtobufServer.sendMessage(ProtobufMessageFactory.handleConsoleCommand(-1, -1, "script import lldb_formatters.jetbrains_stl_formatters"), Protocol.HandleConsoleCommand_Res.class, new Consumer<Protocol.HandleConsoleCommand_Res>((Consumer)completion){
                                            final /* synthetic */ Consumer val$completion;
                                            {
                                                this.val$completion = consumer;
                                            }

                                            public void consume(Protocol.HandleConsoleCommand_Res res) {
                                                if (CidrDebuggerLog.LOG.isDebugEnabled()) {
                                                    String logPath = PathManager.getLogPath() + "/lldb.log";
                                                    LLDBDriver.this.myProtobufServer.sendMessage(ProtobufMessageFactory.handleConsoleCommand(-1, -1, "log enable -f " + logPath + " lldb default"), Protocol.HandleConsoleCommand_Res.class, this.val$completion);
                                                } else {
                                                    this.val$completion.consume(null);
                                                }
                                            }
                                        });
                                    } else {
                                        completion.consume(null);
                                    }
                                }
                            });
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            this.myConnectedClient.setException(e);
        }
    }

    protected void handleModulesLoaded(List<String> modules) {
    }

    public void consume(GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Model.Initialized_Message) {
            this.haveConnection();
        } else if (generatedMessage instanceof Broadcasts.ProcessExited_Broadcast) {
            this.readOutputFully();
            Broadcasts.ProcessExited_Broadcast exit = (Broadcasts.ProcessExited_Broadcast)generatedMessage;
            int exitCode = exit.getExitCode();
            this.handleTargetFinished(exitCode, exit.hasExitDescription() ? exit.getExitDescription() : null);
        } else if (generatedMessage instanceof Broadcasts.ProcessRunning_Broadcast) {
            Integer attachedTo = this.myAsyncAttachingTo;
            this.myAsyncAttachingTo = null;
            if (attachedTo != null) {
                this.handleAttached(attachedTo);
            }
            this.handleRunning();
        } else if (generatedMessage instanceof Broadcasts.ProcessInterrupted_Broadcast) {
            this.readOutputFully();
            if (this.myIsDetaching) {
                this.myDetachSemaphore.release();
                return;
            }
            try {
                this.removeTemporaryBreakpoints();
            }
            catch (ExecutionException attachedTo) {
                // empty catch block
            }
            Model.ProcessInterruptionInfo interruptionInfo = ((Broadcasts.ProcessInterrupted_Broadcast)generatedMessage).getInterruptionInfo();
            int selectedThreadID = interruptionInfo.getSelectedThread();
            ArrayList<LLThread> threads = new ArrayList<LLThread>();
            List<Model.LLDBThread> threadsList = interruptionInfo.getThreadsList();
            int selectedThreadNum = -1;
            for (Model.LLDBThread lldbThread : threadsList) {
                String name = lldbThread.hasName() ? lldbThread.getName() : null;
                threads.add(new LLThread(lldbThread.getId(), null, lldbThread.getQueue(), name));
                if (lldbThread.getId() != selectedThreadID) continue;
                selectedThreadNum = threads.size() - 1;
            }
            this.myStoppedThreadIndex = -1;
            int size = threadsList.size();
            block10: for (int i = 0; i < size && this.myStoppedThreadIndex == -1; ++i) {
                Model.LLDBThread lldbThread = threadsList.get(i);
                Model.ThreadStopReasonData stopReasonData = lldbThread.getStopReasonData();
                if (stopReasonData == null) continue;
                Model.ThreadStopReason stopReason = stopReasonData.getStopReason();
                switch (stopReason) {
                    case ThreadStopReasonBreakpoint: {
                        if (stopReasonData.getBreakpointsStopInfoCount() <= 0) continue block10;
                        Model.BreakpointStopInfo breakpointsStopInfo = stopReasonData.getBreakpointsStopInfo(0);
                        this.myStoppedThreadIndex = i;
                        this.handleBreakpoint(breakpointsStopInfo.getBreakpointId(), threads, i);
                        continue block10;
                    }
                    case ThreadStopReasonWatchpoint: {
                        if (stopReasonData.getWatchpointsStopInfoCount() <= 0) continue block10;
                        Model.WatchpointStopInfo breakpointsStopInfo = stopReasonData.getWatchpointsStopInfo(0);
                        this.myStoppedThreadIndex = i;
                        this.handleWatchpoint(breakpointsStopInfo.getWatchpointId(), threads, i);
                        continue block10;
                    }
                    case ThreadStopReasonSignal: {
                        this.myStoppedThreadIndex = i;
                        int signal = stopReasonData.getSignal();
                        String signalName = stopReasonData.getSignalName();
                        if (LLDBDriver.isTargetTerminationSignal(signal)) {
                            this.handleTargetTerminated();
                            return;
                        }
                        this.handleSignal(threads, i, !signalName.isEmpty() ? signalName : String.valueOf(signal), stopReasonData.getStopDescription());
                        continue block10;
                    }
                    case ThreadStopReasonException: {
                        this.myStoppedThreadIndex = i;
                        this.handleException(threads, i, stopReasonData.getStopDescription());
                        continue block10;
                    }
                    case ThreadStopReasonExec: 
                    case ThreadStopReasonTrace: 
                    case ThreadStopReasonPlanComplete: 
                    case ThreadStopReasonThreadExiting: {
                        this.myStoppedThreadIndex = i;
                        this.handleInterrupted(threads, i);
                        continue block10;
                    }
                }
            }
            if (this.myStoppedThreadIndex == -1) {
                this.myStoppedThreadIndex = selectedThreadNum;
                this.handleInterrupted(threads, selectedThreadNum);
            }
        } else if (generatedMessage instanceof Broadcasts.ChangePrompt_Broadcast) {
            this.handlePrompt(((Broadcasts.ChangePrompt_Broadcast)generatedMessage).getPrompt());
        } else if (generatedMessage instanceof Broadcasts.ReadyForCommands_Broadcast) {
            this.handleReadyForCommands(((Broadcasts.ReadyForCommands_Broadcast)generatedMessage).getReady() != 0);
        } else if (generatedMessage instanceof Broadcasts.CommandsInterpreter_Broadcast) {
            this.handleGDBOutput(((Broadcasts.CommandsInterpreter_Broadcast)generatedMessage).getMessage());
        } else if (generatedMessage instanceof Broadcasts.TargetProcessOutput_Broadcast) {
            Broadcasts.TargetProcessOutput_Broadcast outputBroadcast = (Broadcasts.TargetProcessOutput_Broadcast)generatedMessage;
            this.handleTargetOutput(outputBroadcast.getText(), LLDBDriver.outputType2ProcessOutputKey(outputBroadcast.getOutputType()));
        } else if (generatedMessage instanceof Broadcasts.LogMessage_Broadcast) {
            String message = ((Broadcasts.LogMessage_Broadcast)generatedMessage).getMessage();
            CidrDebuggerLog.LOG.info(message);
        } else if (generatedMessage instanceof Broadcasts.ModulesLoaded_Broadcast) {
            this.handleModulesLoaded(((Broadcasts.ModulesLoaded_Broadcast)generatedMessage).getModulesList());
        }
    }

    private static Key outputType2ProcessOutputKey(Model.OutputType outputType) {
        return outputType == Model.OutputType.OutputTypeStdout ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR;
    }

    private void handleReadyForCommands(boolean ready) {
        this.myReadyForCommand = ready;
        this.handlePrompt(ready ? "(" + this.getPromptText() + ")" : ">");
    }

    public class ProcessInputWriter
    extends OutputStream {
        private final Object myCloseOpLock = new Object();
        private File myInputFileDir;
        private volatile boolean closed;
        private volatile boolean pipeInput;
        private volatile OutputStream myOutputStream;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initPipeInput(final @NotNull File inputFileDir, final @NotNull String inputFileName) {
            if (inputFileDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputFileDir", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver$ProcessInputWriter", "initPipeInput"));
            }
            if (inputFileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputFileName", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver$ProcessInputWriter", "initPipeInput"));
            }
            this.pipeInput = true;
            this.closed = false;
            Object object = this.myCloseOpLock;
            synchronized (object) {
                this.myInputFileDir = inputFileDir;
            }
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    File inputFile = new File(inputFileDir, inputFileName);
                    while (!ProcessInputWriter.this.closed && !inputFile.exists()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            LOG.warn((Throwable)e);
                            break;
                        }
                    }
                    if (ProcessInputWriter.this.closed) {
                        return;
                    }
                    Object object = ProcessInputWriter.this.myCloseOpLock;
                    synchronized (object) {
                        if (inputFile.exists()) {
                            try {
                                ProcessInputWriter.this.myOutputStream = new FileOutputStream(inputFile);
                            }
                            catch (IOException e) {
                                LOG.warn((Throwable)e);
                            }
                        }
                    }
                }
            });
        }

        public void initDispatchInput() {
            this.pipeInput = false;
        }

        @Override
        public void write(int i) throws IOException {
            LOG.error("Shouldn't be here");
        }

        @Override
        public void write(@NotNull byte[] bytes, int i, int i1) throws IOException {
            if (bytes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver$ProcessInputWriter", "write"));
            }
            if (this.pipeInput) {
                if (!this.closed && this.myOutputStream != null) {
                    this.myOutputStream.write(bytes, i, i1);
                }
            } else {
                try {
                    String input = new String(bytes, i, i1, LLDBDriver.this.myLLDBCommandLine.getCharset());
                    LLDBDriver.this.dispatchInput(input, Model.DispatchTarget.DispatchTargetProcess);
                }
                catch (ExecutionException e) {
                    throw new IOException(e);
                }
            }
        }

        File getInputFileDir() {
            return this.myInputFileDir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (!this.pipeInput) {
                return;
            }
            this.closed = true;
            Object object = this.myCloseOpLock;
            synchronized (object) {
                if (this.myOutputStream != null) {
                    try {
                        this.myOutputStream.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                    }
                    if (this.myInputFileDir.exists()) {
                        FileUtil.delete((File)this.myInputFileDir);
                    }
                }
            }
        }
    }

    protected static class ThrowIfNotValid<T extends GeneratedMessage>
    implements Consumer<T> {
        private String myMessage;
        private boolean myIsValid = false;

        public ThrowIfNotValid(String mes) {
            this.myMessage = mes;
        }

        public void consume(T message) {
            Map allFields = message.getAllFields();
            for (Object val : allFields.values()) {
                String errorMessage;
                if (!(val instanceof Protocol.CommonResponse)) continue;
                Protocol.CommonResponse commonResponse = (Protocol.CommonResponse)val;
                this.myIsValid = commonResponse.getIsValid();
                if (this.myIsValid || !commonResponse.hasErrorMessage() || StringUtil.isEmptyOrSpaces((String)(errorMessage = commonResponse.getErrorMessage()))) continue;
                this.myMessage = errorMessage;
            }
        }

        public void throwIfNeeded() throws LLDBEntityNotValidException {
            if (!this.myIsValid) {
                throw new LLDBEntityNotValidException(this.myMessage);
            }
        }

        public String getMessage() {
            return this.myMessage;
        }

        public boolean isValid() {
            return this.myIsValid;
        }
    }
}

