/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBResponseVisitor;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbLexer;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbParser;
import java.util.BitSet;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.misc.Nullable;
import org.antlr.v4.runtime.tree.ParseTree;
import org.jetbrains.annotations.NotNull;

public class GDBResponse {
    public static GDBResponse parse(String s) throws ResponseParseException {
        return new Parser(s).parse();
    }

    private static String formatRecord(RecordCategory kind, RecordType name, GDBTuple resultList) {
        StringBuilder buffer = new StringBuilder(kind.toString());
        buffer.append(name);
        if (!resultList.isEmpty()) {
            buffer.append(",");
            GDBResponse.doFormat(buffer, resultList, false);
        }
        return buffer.toString();
    }

    private static void doFormat(StringBuilder buffer, Object obj, boolean closed) {
        if (obj instanceof Pair) {
            buffer.append(((Pair)obj).first);
            buffer.append("=");
            GDBResponse.doFormat(buffer, ((Pair)obj).second, true);
        } else if (obj instanceof List) {
            if (closed) {
                buffer.append(obj instanceof GDBTuple ? (char)'{' : '[');
            }
            boolean first = true;
            for (Object each : (List)obj) {
                if (!first) {
                    buffer.append(',');
                }
                first = false;
                GDBResponse.doFormat(buffer, each, true);
            }
            if (closed) {
                buffer.append(obj instanceof GDBTuple ? (char)'}' : ']');
            }
        } else if (obj instanceof String) {
            buffer.append("\"").append(StringUtil.escapeQuotes((String)((String)obj))).append("\"");
        } else {
            throw new RuntimeException("unknown object: " + obj);
        }
    }

    public static class ResponseParseException
    extends Exception {
        public ResponseParseException(String text) {
            super(text);
        }
    }

    public static class StreamRecord
    extends GDBResponse {
        private final Category myCategory;
        private final String myText;

        public StreamRecord(@NotNull Category category, @NotNull String text) {
            if (category == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$StreamRecord", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$StreamRecord", "<init>"));
            }
            this.myCategory = category;
            this.myText = text;
        }

        @NotNull
        public Category getCategory() {
            Category category = this.myCategory;
            if (category == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$StreamRecord", "getCategory"));
            }
            return category;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$StreamRecord", "getText"));
            }
            return string;
        }

        public String toString() {
            return this.myCategory.myPrefix + "\"" + StringUtil.escapeStringCharacters((String)this.myText) + "\"";
        }

        public static enum Category {
            console("~"),
            target("@"),
            log("&");

            private final String myPrefix;

            private Category(String prefix) {
                this.myPrefix = prefix;
            }

            public String toString() {
                return this.myPrefix;
            }
        }
    }

    public static class AsyncRecord
    extends Record<Category, Type> {
        public AsyncRecord(@NotNull Category category, @NotNull String type, @NotNull GDBTuple resultList) {
            if (category == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$AsyncRecord", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$AsyncRecord", "<init>"));
            }
            if (resultList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultList", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$AsyncRecord", "<init>"));
            }
            super(category, new Type(type), resultList);
        }

        public static class Type
        implements RecordType {
            @NotNull
            private final String myValue;

            public Type(@NotNull String value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$AsyncRecord$Type", "<init>"));
                }
                this.myValue = value;
            }

            @NotNull
            public String getValue() {
                String string = this.myValue;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$AsyncRecord$Type", "getValue"));
                }
                return string;
            }

            public String toString() {
                return this.myValue;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Type name = (Type)o;
                return this.myValue.equals(name.myValue);
            }

            public int hashCode() {
                return this.myValue.hashCode();
            }
        }

        public static enum Category implements RecordCategory
        {
            exec("*"),
            notify("="),
            status("+");

            private final String myPrefix;

            private Category(String prefix) {
                this.myPrefix = prefix;
            }

            public String toString() {
                return this.myPrefix;
            }
        }
    }

    public static class ResultRecord
    extends Record<Category, Type> {
        public ResultRecord(@NotNull Category kind, @NotNull Type type, @NotNull GDBTuple resultList) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$ResultRecord", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$ResultRecord", "<init>"));
            }
            if (resultList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultList", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$ResultRecord", "<init>"));
            }
            super(kind, type, resultList);
        }

        public static enum Type implements RecordType
        {
            done,
            running,
            connected,
            error,
            exit,
            stepping,
            continuing,
            result,
            tuple_value,
            list_value,
            str_value;

        }

        public static enum Category implements RecordCategory
        {
            kind("^");

            private final String myPrefix;

            private Category(String prefix) {
                this.myPrefix = prefix;
            }

            public String toString() {
                return this.myPrefix;
            }
        }
    }

    public static abstract class Record<CATEGORY_TYPE extends RecordCategory, TYPE_TYPE extends RecordType>
    extends GDBResponse {
        @NotNull
        private final CATEGORY_TYPE myCategory;
        @NotNull
        private final TYPE_TYPE myType;
        @NotNull
        private final GDBTuple myResultList;

        public Record(@NotNull CATEGORY_TYPE category, @NotNull TYPE_TYPE type, @NotNull GDBTuple resultList) {
            if (category == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$Record", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$Record", "<init>"));
            }
            if (resultList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultList", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$Record", "<init>"));
            }
            this.myCategory = category;
            this.myType = type;
            this.myResultList = resultList;
        }

        @NotNull
        public CATEGORY_TYPE getCategory() {
            CATEGORY_TYPE CATEGORY_TYPE = this.myCategory;
            if (CATEGORY_TYPE == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$Record", "getCategory"));
            }
            return CATEGORY_TYPE;
        }

        @NotNull
        public TYPE_TYPE getType() {
            TYPE_TYPE TYPE_TYPE = this.myType;
            if (TYPE_TYPE == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$Record", "getType"));
            }
            return TYPE_TYPE;
        }

        @NotNull
        public GDBTuple getResultList() {
            GDBTuple gDBTuple = this.myResultList;
            if (gDBTuple == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$Record", "getResultList"));
            }
            return gDBTuple;
        }

        public String toString() {
            return GDBResponse.formatRecord(this.getCategory(), this.getType(), this.myResultList);
        }
    }

    public static interface RecordType {
    }

    public static interface RecordCategory {
    }

    private static class Parser {
        String text;

        private Parser(String s) {
            this.text = s;
        }

        public GDBResponse parse() throws ResponseParseException {
            ANTLRInputStream input = new ANTLRInputStream(this.text);
            GdbLexer lexer = new GdbLexer((CharStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            GdbParser parser = new GdbParser((TokenStream)tokens);
            parser.removeErrorListeners();
            parser.addErrorListener(new ANTLRErrorListener(){

                public void syntaxError(Recognizer<?, ?> recognizer, @Nullable Object o, int line, int position, String msg, @Nullable RecognitionException e) {
                    throw new RuntimeException("Syntax error: " + msg + " in \"" + Parser.this.text + "\" line " + line + " position " + position);
                }

                public void reportAmbiguity(@org.antlr.v4.runtime.misc.NotNull org.antlr.v4.runtime.Parser parser, @org.antlr.v4.runtime.misc.NotNull DFA dfa, int startIndex, int stopIndex, boolean b, @org.antlr.v4.runtime.misc.NotNull BitSet bitSet, @org.antlr.v4.runtime.misc.NotNull ATNConfigSet atnConfigs) {
                    CidrDebuggerLog.LOG.debug("Ambiguity in \"" + Parser.this.text + "\" started " + startIndex + " stopped " + stopIndex);
                }

                public void reportAttemptingFullContext(@org.antlr.v4.runtime.misc.NotNull org.antlr.v4.runtime.Parser parser, @org.antlr.v4.runtime.misc.NotNull DFA dfa, int startIndex, int stopIndex, @Nullable BitSet bitSet, @org.antlr.v4.runtime.misc.NotNull ATNConfigSet atnConfigs) {
                    CidrDebuggerLog.LOG.debug("Attempting full context in \"" + Parser.this.text + "\" started " + startIndex + " stopped " + stopIndex);
                }

                public void reportContextSensitivity(@org.antlr.v4.runtime.misc.NotNull org.antlr.v4.runtime.Parser parser, @org.antlr.v4.runtime.misc.NotNull DFA dfa, int startIndex, int stopIndex, int i3, @org.antlr.v4.runtime.misc.NotNull ATNConfigSet atnConfigs) {
                    CidrDebuggerLog.LOG.debug("Context sensitivity in \"" + Parser.this.text + "\" started " + startIndex + " stopped " + stopIndex);
                }
            });
            try {
                GdbParser.ResponseContext tree = parser.response();
                GDBResponseVisitor visitor = new GDBResponseVisitor();
                return (GDBResponse)visitor.visit((ParseTree)tree);
            }
            catch (RuntimeException e) {
                throw new ResponseParseException(e.getMessage());
            }
        }
    }
}

