/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.process.WinProcessManager;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.BidirectionalMap;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectFramesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectVariablesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotLoadVariableException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotSetBreakpointException;
import com.jetbrains.cidr.execution.debugger.backend.DBEvaluationTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DBIllegalStateException;
import com.jetbrains.cidr.execution.debugger.backend.DBTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBCommandException;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBInterruptionFailedException;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBResponse;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBVarsCache;
import com.jetbrains.cidr.execution.debugger.backend.gdb.lang.GDBLanguage;
import com.pty4j.unix.PTYOutputStream;
import com.pty4j.unix.Pty;
import gnu.trove.TLongHashSet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GDBDriver
extends DebuggerDriver {
    public static final Key<String> STL_PRETTY_PRINTERS = Key.create((String)"GDBDriver.stlPrettyPrinters");
    public static final Key<TLongHashSet> INDIRECT_SYMBOL_SET = Key.create((String)"INDIRECT_SYMBOL_SET");
    public static final Key<String> WINBREAK_PATH = Key.create((String)"WINBREAK_PATH");
    public static final int MAX_CHILDREN_COUNT_FOR_LIST = 2000;
    public static final int STEP_CHILDREN_COUNT_FOR_LIST = 2048;
    public static final int PROBE_CHILDREN_COUNT_FOR_LIST = 1;
    public static final int FIRST_CHILDREN_COUNT_FOR_LIST = 8;
    public static final int LAST_CHILDREN_COUNT_FOR_LIST = 32;
    private static final Key<Boolean> LLVALUE_IS_MAP = Key.create((String)"LLVALUE_IS_MAP");
    private static final Key<MapElement> LLVALUE_MAP_ELEMENT = Key.create((String)"LLVALUE_MAP_ELEMENT");
    private static final Key<LLValueLoader> LLVALUE_VALUE_LOADER = Key.create((String)"LLVALUE_VALUE_LOADER");
    private static final String INFERIOR_NOT_EXECUTING = "mi_cmd_exec_interrupt: Inferior not executing.";
    private static volatile Pair<String, String> myMIOutputFilter;
    private static volatile Consumer<String> myFrameVarDisposeListener;
    private static final String MAGIC_LOAD_RULES = "dyld \".*AppKit.*\" all dyld \".*libobjc.*\" all dyld \".*CarbonDataFormatters.*\" all dyld \".*libauto.*\" all dyld \".*PBGDBIntrospectionSupport.*\" all dyld \".*CFDataFormatters.*\" all dyld \".*CoreFoundation.*\" extern dyld \".*libSystem.*\" all dyld \".*/usr/lib/dyld.*\" all dyld \".*Foundation.*\" all dyld \"/System/Library/Frameworks\\\\\\\\|/System/Library/PrivateFrameworks\\\\\\\\|/usr/lib\" extern dyld \".*\" extern exec \".*\" extern";
    private static final String CANNOT_SET_WATCHPOINT_FOR_EXPRESSION = "Cannot set a watchpoint for this expression";
    private static final String STRUCT_VALUE = "{...}";
    private static final String NO_PARENT_REF = "";
    private static final BigInteger INT_MAX_VALUE_BI;
    private static final Pattern ORIGINAL_LOCATION;
    private static final int ALL_AVAILABLE_ELEMENTS = -1;
    @Nullable
    private String myWinBreakPath;
    private volatile GeneralCommandLine myGdbCommandLine;
    @Nullable
    private volatile String myStlPrettyPrinters;
    private volatile OSProcessHandler myProcessHandler;
    private volatile int myProcessID;
    private final DebuggerDriverConfiguration myStarter;
    private volatile boolean myRemoteTarget = false;
    private volatile boolean isInPromptMode;
    private volatile Runnable myPendingBreakpointRunnable = null;
    private final Object myPendingBreakpointLock = new Object();
    private final Alarm myPendingBreakpointAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
    private boolean mySuppressRunningResult;
    private volatile OutputStream mySink;
    @Nullable
    private volatile PTYOutputStream myProcessInput;
    private final OutputStream myProcessInputProxy = new OutputStream(){

        @Override
        public void write(int i) throws IOException {
            PTYOutputStream input = GDBDriver.this.myProcessInput;
            if (input != null) {
                input.write(i);
            }
        }

        @Override
        public void write(byte[] bytes, int i, int i1) throws IOException {
            PTYOutputStream input = GDBDriver.this.myProcessInput;
            if (input != null) {
                input.write(bytes, i, i1);
            }
        }

        @Override
        public void close() throws IOException {
            PTYOutputStream input = GDBDriver.this.myProcessInput;
            if (input != null) {
                input.close();
            }
        }
    };
    private final Semaphore myCommandSemaphore = new Semaphore();
    private final QueueProcessor<Runnable> myCommandProcessor;
    private final BlockingQueue<Ref<GDBResponse.Record>> myResultQueue = new ArrayBlockingQueue<Ref<GDBResponse.Record>>(1);
    private final Semaphore myInterrupted = new Semaphore();
    private final Semaphore myPendingForAttachNotification = new Semaphore();
    @Nullable
    private volatile Integer myStoppedThreadId = null;
    @Nullable
    private volatile Integer myCurrentThreadId = null;
    @Nullable
    private volatile Integer myCurrentFrameNumber = null;
    @Nullable
    private volatile Integer myCurrentAppPID = null;
    @Nullable
    private volatile String myLastCommand = null;
    @NotNull
    private final StringBuffer myLastConsoleOutput = new StringBuffer();
    private volatile boolean mySuppressOutputDuringCommand = false;
    private volatile boolean myTreatStopAsTermination = false;
    private volatile boolean mySuppressTargetFinishedOnDetaching = false;
    private final List<GDBResponse.Record> myVarsDropPool = new ArrayList<GDBResponse.Record>();
    private final GDBVarsCache myVarsCache = new GDBVarsCache(new GDBVarsCache.Delegate(){

        @Override
        public void onDrop(@NotNull GDBResponse.Record var) {
            if (var == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$2", "onDrop"));
            }
            GDBDriver.this.myVarsDropPool.add(var);
        }
    });
    private final BidirectionalMap<String, String> myFrameVarCache = new BidirectionalMap();
    private final HashMap<String, String> myFrameVarValueCache = new HashMap();

    public static void setMIOutputFilter(@Nullable Pair<String, String> miOutputFilter) {
        myMIOutputFilter = miOutputFilter;
    }

    public static void setFrameVarDisposeListener(@Nullable Consumer<String> listener) {
        myFrameVarDisposeListener = listener;
    }

    public GDBDriver(DebuggerDriver.Handler handler2, DebuggerDriverConfiguration starter) {
        super(handler2);
        this.myStarter = starter;
        this.myCommandProcessor = QueueProcessor.createRunnableQueueProcessor();
    }

    @NotNull
    public String getLastConsoleOutput() {
        String string = this.myLastConsoleOutput.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "getLastConsoleOutput"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        if ("GDB" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "getName"));
        }
        return "GDB";
    }

    @Override
    public boolean supportsWatchpointLifetime() {
        return true;
    }

    @Override
    @NotNull
    public Language getConsoleLanguage() {
        GDBLanguage gDBLanguage = GDBLanguage.INSTANCE;
        if (gDBLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "getConsoleLanguage"));
        }
        return gDBLanguage;
    }

    @Override
    @NotNull
    public ProcessHandler getProcessHandler() {
        OSProcessHandler oSProcessHandler = this.myProcessHandler;
        if (oSProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "getProcessHandler"));
        }
        return oSProcessHandler;
    }

    @Override
    @Nullable
    public OutputStream getProcessInput() {
        return this.myProcessInputProxy;
    }

    @Override
    public void removeWatchpoint(List<Integer> ids) throws ExecutionException {
        this.removeCodepoints(ids);
    }

    @Override
    public List<LLValue> getVariableChildrenRange(final LLValue var, final int offset, final int count) throws ExecutionException, DBCannotCollectVariablesException {
        List<LLValue> result2;
        try {
            result2 = this.executeCommand(new SuspendedCommand<List<LLValue>>(){

                @Override
                public List<LLValue> run() throws ExecutionException {
                    SmartList result2 = new SmartList();
                    if (!var.mayHaveChildren()) {
                        return result2;
                    }
                    Processor<LLValue> processor2 = new Processor<LLValue>((List)result2){
                        final /* synthetic */ List val$result;
                        {
                            this.val$result = list;
                        }

                        public boolean process(LLValue value) {
                            this.val$result.add(value);
                            return false;
                        }
                    };
                    GDBDriver.this.doProcessVariableChildren(var, (Processor<LLValue>)((Processor)processor2), offset, count);
                    return result2;
                }
            });
        }
        catch (ExecutionException e) {
            if (ExceptionUtil.causedBy((Throwable)e, RuntimeDBCannotCollectVariablesException.class)) {
                throw new DBCannotCollectVariablesException(e);
            }
            throw e;
        }
        return result2;
    }

    @Override
    public void addSymbolsFile(File file2, File module) {
    }

    @Override
    public boolean isInPromptMode() {
        return this.isInPromptMode;
    }

    @Override
    public String getPromptText() {
        return "gdb";
    }

    @Override
    protected void setState(DebuggerDriver.TargetState state) {
        super.setState(state);
        if (this.getState() == DebuggerDriver.TargetState.SUSPENDED) {
            this.executeAsyncCommand(new Command<Object>(){

                @Override
                public Object run() throws ExecutionException {
                    for (GDBResponse.Record record : GDBDriver.this.myVarsDropPool) {
                        GDBDriver.this.doDeleteVar(record);
                    }
                    GDBDriver.this.myVarsDropPool.clear();
                    return null;
                }
            });
        }
    }

    private void doDeleteVar(GDBResponse.Record var) {
        try {
            String name = var.getResultList().get("name", String.class);
            this.sendRequestAndWait("-var-delete " + name, GDBResponse.ResultRecord.Type.done);
        }
        catch (ExecutionException e) {
            CidrDebuggerLog.LOG.debug((Throwable)e);
        }
    }

    @Override
    public void start(final @NotNull Installer installer, final @NotNull String architecture, final boolean isRemote) throws ExecutionException {
        if (installer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installer", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "start"));
        }
        if (architecture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "architecture", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "start"));
        }
        this.executeCommand(new Command<Object>(){

            @Override
            public Object run() throws ExecutionException {
                assert (GDBDriver.this.myProcessHandler == null);
                GDBDriver.this.myRemoteTarget = isRemote;
                GDBDriver.this.myInstaller = installer;
                GDBDriver.this.myGdbCommandLine = GDBDriver.this.myStarter.createDriverCommandLine(GDBDriver.this, installer, architecture);
                GDBDriver.this.myStlPrettyPrinters = (String)GDBDriver.this.myGdbCommandLine.getUserData(STL_PRETTY_PRINTERS);
                GDBDriver.this.myGdbCommandLine.putUserData(STL_PRETTY_PRINTERS, null);
                GDBDriver.this.myWinBreakPath = (String)GDBDriver.this.myGdbCommandLine.getUserData(WINBREAK_PATH);
                GDBDriver.this.myGdbCommandLine.putUserData(WINBREAK_PATH, null);
                GDBDriver.this.myProcessHandler = new OSProcessHandler(GDBDriver.this.myGdbCommandLine);
                GDBDriver.this.myProcessHandler.setShouldDestroyProcessRecursively(false);
                GDBDriver.this.myProcessID = GDBDriver.getGdbPid(GDBDriver.this.myProcessHandler);
                GDBDriver.this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
                    StringBuilder myBuffer = new StringBuilder();

                    public void onTextAvailable(ProcessEvent event, Key outputType) {
                        if (outputType == ProcessOutputTypes.STDOUT) {
                            int end;
                            this.myBuffer.append(event.getText());
                            String content = this.myBuffer.toString();
                            boolean changed = false;
                            while ((end = content.indexOf("\n")) != -1) {
                                String response = content.substring(0, end).trim();
                                content = content.substring(end + 1);
                                changed = true;
                                if (myMIOutputFilter != null) {
                                    response = response.replaceAll((String)myMIOutputFilter.first, (String)myMIOutputFilter.second);
                                }
                                GDBDriver.this.dispatchOutput(response);
                            }
                            if (changed) {
                                this.myBuffer = new StringBuilder(content);
                            }
                        } else {
                            String text = event.getText();
                            if (text != null) {
                                CidrDebuggerLog.LOG.debug("<" + text);
                            }
                        }
                    }

                    public void processTerminated(ProcessEvent event) {
                        CidrDebuggerLog.LOG.info("Debugger exited with code " + event.getExitCode());
                        GDBDriver.this.dispatchOutput(null);
                    }
                });
                GDBDriver.this.mySink = GDBDriver.this.myProcessHandler.getProcessInput();
                GDBDriver.this.myCommandSemaphore.down();
                GDBDriver.this.executeAsyncCommand(new Command(){

                    public Object run() throws ExecutionException {
                        GDBDriver.this.sendRequestAndWait("-gdb-set print elements 0", GDBResponse.ResultRecord.Type.done);
                        GDBDriver.this.sendRequestAndWait("-gdb-set print repeats 0", GDBResponse.ResultRecord.Type.done);
                        if (SystemInfo.isMac) {
                            GDBDriver.this.sendRequestAndWait("-gdb-set step-mode on", GDBResponse.ResultRecord.Type.done);
                        }
                        String stlPrinters = GDBDriver.this.myStlPrettyPrinters;
                        if (CidrDebuggerSettings.getInstance().STL_RENDERERS_ENABLED && stlPrinters != null) {
                            GDBResponse.Record result2 = GDBDriver.this.sendRequestAndWait("python\nimport sys\nsys.path.insert(0, '" + GDBDriver.convertPath(stlPrinters) + "')\n" + "sys.path.insert(1, '" + GDBDriver.convertPath(new File(stlPrinters, "libstdcxx/v6").getPath()) + "')\n" + "from libstdcxx.v6.printers import register_libstdcxx_printers\n" + "end", null);
                            if (result2.getType() != GDBResponse.ResultRecord.Type.done) {
                                String message = "STL pretty printers are not initialized for " + GDBDriver.this.myGdbCommandLine.getExePath();
                                GDBDriver.this.handleTargetOutput(message + "\n", ProcessOutputTypes.SYSTEM);
                                GDBDriver.this.sendRequestAndWait(GDBDriver.createConsoleCommand("show version"), null);
                                CidrDebuggerLog.LOG.error(message + "\n" + GDBDriver.this.myLastConsoleOutput.toString());
                            } else {
                                GDBDriver.this.sendRequestAndWait("-enable-pretty-printing", GDBResponse.ResultRecord.Type.done);
                            }
                        }
                        return null;
                    }
                });
                GDBDriver.this.handlePrompt();
                CidrDebuggerLog.LOG.info("Debugger started");
                return null;
            }
        });
    }

    @NotNull
    protected static String convertPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "convertPath"));
        }
        String string = GDBDriver.escapeString(path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "convertPath"));
        }
        return string;
    }

    @NotNull
    protected static String escapeString(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "escapeString"));
        }
        String string = StringUtil.escapeStringCharacters((String)text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "escapeString"));
        }
        return string;
    }

    @Override
    public void setValuesFilteringEnabled(boolean enabled) throws ExecutionException {
    }

    private static int getGdbPid(@NotNull OSProcessHandler handler2) throws ExecutionException {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "getGdbPid"));
        }
        try {
            if (SystemInfo.isUnix) {
                return UnixProcessManager.getProcessPid((Process)handler2.getProcess());
            }
            if (SystemInfo.isWindows) {
                return WinProcessManager.getProcessPid((Process)handler2.getProcess());
            }
            throw new ExecutionException("Unsupported platform");
        }
        catch (Exception e) {
            throw new ExecutionException("Cannot get GDB PID", (Throwable)e);
        }
    }

    @Override
    public void load(boolean forAttach, @Nullable String architecture) throws ExecutionException {
        if (forAttach) {
            return;
        }
        this.executeCommand(new Command<Object>(){

            @Override
            public Object run() throws ExecutionException {
                GDBDriver.this.doLoad();
                return null;
            }
        }, false, null, GDBDriver.getLoadTimeout());
    }

    private static long getLoadTimeout() {
        return StringUtil.parseInt((String)System.getProperty("cpp.debugger.timeout.load"), (int)30000);
    }

    protected void doLoad() throws ExecutionException {
        this.myTargetCommandLine = this.myInstaller.install();
        this.myIndirectSymbols = (TLongHashSet)this.myTargetCommandLine.getUserData(INDIRECT_SYMBOL_SET);
        String exePath = this.myInstaller.getExecutableFile().getAbsolutePath();
        exePath = FileUtil.toSystemIndependentName((String)exePath);
        this.sendRequestAndWait("-file-exec-and-symbols \"" + exePath + "\"", GDBResponse.ResultRecord.Type.done);
    }

    @Override
    public void loadForRemote(final File deviceSupport) throws ExecutionException {
        this.executeCommand(new Command<Object>(){

            @Override
            public Object run() throws ExecutionException {
                GDBDriver.this.doLoad();
                GDBDriver.this.doSetVar(null, "shlib-path-substitutions", DebuggerDriver.getShlibPathSubstitutions(GDBDriver.this.myInstaller.getExecutableFile().getAbsolutePath(), new File(GDBDriver.this.myTargetCommandLine.getExePath()).getParent(), deviceSupport));
                GDBDriver.this.doSetVar(VarDomain.REMOTE, "max-packet-size", "1024");
                GDBDriver.this.doSetVar(VarDomain.SHARED_LIBRARY, "check-uuids", "off");
                GDBDriver.this.doSetVar(VarDomain.REMOTE, "executable-directory", new File(GDBDriver.this.myTargetCommandLine.getExePath()).getParent());
                GDBDriver.this.doSetVar(VarDomain.SHARED_LIBRARY, "load-rules", GDBDriver.MAGIC_LOAD_RULES);
                GDBDriver.this.doApplyLoadRules();
                GDBDriver.this.doMarkMem("0x1000", "0x3fffffff", "cache");
                GDBDriver.this.doMarkMem("0x40000000", "0xffffffff", "none");
                GDBDriver.this.doMarkMem("0x00000000", "0x0fff", "none");
                GDBDriver.this.doSetVar(null, "inferior-auto-start-dyld", "0");
                GDBDriver.this.doSetVar(null, "inferior-auto-start-cfm", "off");
                GDBDriver.this.doSetVar(null, "minimal-signal-handling", "0");
                GDBDriver.this.doSetVar(VarDomain.REMOTE, "noack-mode", "1");
                GDBDriver.this.doSetVar(null, "trust-readonly-sections", "1");
                GDBDriver.this.sendRequestAndWait("target remote-mobile " + GDBDriver.this.getDebugServerSocket(), GDBResponse.ResultRecord.Type.done);
                return null;
            }
        });
    }

    @Override
    public void launch() throws ExecutionException {
        this.executeCommand(new Command<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws ExecutionException {
                CidrDebuggerLog.LOG.assertTrue(GDBDriver.this.myTargetCommandLine != null, (Object)"target not loaded");
                boolean error = true;
                try {
                    boolean unbufferedIO;
                    GDBDriver.this.printTargetCommandLine(GDBDriver.this.myTargetCommandLine);
                    if (!GDBDriver.this.myTargetCommandLine.isPassParentEnvironment()) {
                        GDBDriver.this.sendRequestAndWait(GDBDriver.createConsoleCommand("unset env"), GDBResponse.ResultRecord.Type.done);
                    }
                    Map env = GDBDriver.this.myTargetCommandLine.getEnvironment();
                    for (Map.Entry each : env.entrySet()) {
                        String key = (String)each.getKey();
                        String value = (String)each.getValue();
                        GDBDriver.this.sendRequestAndWait("-gdb-set env " + key + "=" + ("PATH".equalsIgnoreCase(key) ? GDBDriver.convertPath(value) : value), GDBResponse.ResultRecord.Type.done);
                    }
                    if (SystemInfo.isMac && !(unbufferedIO = "YES".equalsIgnoreCase((String)env.get("NSUnbufferedIO")))) {
                        String message = "NSUnbufferedIO is not set, output may be delayed";
                        CidrDebuggerLog.LOG.warn(new Throwable(message));
                        GDBDriver.this.handleTargetOutput((String)message + "\n", ProcessOutputTypes.SYSTEM);
                    }
                    StringBuilder params = new StringBuilder();
                    for (String each : GDBDriver.this.myTargetCommandLine.getParametersList().getParameters()) {
                        params.append("\"").append(GDBDriver.escapeString(each)).append("\" ");
                    }
                    if (!GDBDriver.this.myRemoteTarget && !SystemInfo.isWindows) {
                        try {
                            Pty pty = new Pty(true);
                            PTYOutputStream processInput = pty.getOutputStream();
                            String slaveName = pty.getSlaveName();
                            GDBDriver.this.sendRequestAndWait("-inferior-tty-set " + slaveName, GDBResponse.ResultRecord.Type.done);
                            GDBDriver.this.myProcessInput = processInput;
                        }
                        catch (IOException e) {
                            CidrDebuggerLog.LOG.error((Throwable)e);
                        }
                    }
                    String execArguments = "-exec-arguments " + params.toString();
                    if (GDBDriver.this.myToRedirect) {
                        if (SystemInfo.isWindows) {
                            GDBDriver.this.sendRequestAndWait("-gdb-set new-console on", GDBResponse.ResultRecord.Type.done);
                        } else {
                            GDBDriver.this.initReaders(true);
                            if (GDBDriver.this.myReaders != null) {
                                String stderrPath = GDBDriver.this.myReaders.getErrFileAbsolutePath();
                                String stdoutPath = GDBDriver.this.myReaders.getOutFileAbsolutePath();
                                execArguments = execArguments + " 1> \"" + stdoutPath + "\"";
                                execArguments = execArguments + " 2> \"" + stderrPath + "\"";
                            } else {
                                CidrDebuggerLog.LOG.error("stderr/stdout readers are not initialized");
                            }
                        }
                    }
                    GDBDriver.this.doLaunch(execArguments);
                    error = false;
                }
                finally {
                    if (error) {
                        GDBDriver.this.closeOutputReaders();
                    }
                }
                return null;
            }
        });
    }

    protected void doLaunch(String execArgumentsCommand) throws ExecutionException {
        this.sendRequestAndWait(execArgumentsCommand, GDBResponse.ResultRecord.Type.done);
        this.sendRequestAndWait("-exec-run", GDBResponse.ResultRecord.Type.running);
    }

    @Override
    public void attachTo(final int pid) throws ExecutionException {
        this.executeCommand(new Command<Object>(){

            @Override
            public Object run() throws ExecutionException {
                GDBDriver.this.myPendingForAttachNotification.down();
                try {
                    GDBDriver.this.sendRequestAndWait("-target-attach " + pid, GDBResponse.ResultRecord.Type.done);
                    GDBDriver.waitForSemaphore(GDBDriver.this.myPendingForAttachNotification);
                    GDBDriver.this.handleAttached(pid);
                    GDBDriver.this.doResume();
                }
                finally {
                    GDBDriver.this.myPendingForAttachNotification.up();
                }
                return null;
            }
        });
    }

    @Override
    public void detach() throws ExecutionException {
        this.executeCommand(new Command<Object>(){

            @Override
            public Object run() throws ExecutionException {
                GDBDriver.this.doInterruptAndWait();
                try {
                    GDBDriver.this.mySuppressTargetFinishedOnDetaching = true;
                    int take = 1;
                    while (true) {
                        try {
                            GDBDriver.this.sendRequestAndWait("-target-detach", GDBResponse.ResultRecord.Type.done);
                        }
                        catch (GDBCommandException e) {
                            CidrDebuggerLog.LOG.info("Cannot detach on take " + take, (Throwable)((Object)e));
                            if (take == 5) {
                                throw e;
                            }
                            ++take;
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    GDBDriver.this.mySuppressTargetFinishedOnDetaching = false;
                }
                GDBDriver.this.handleDetached();
                return null;
            }
        });
    }

    @Override
    public void attachByName(String name, boolean wait) {
        CidrDebuggerLog.LOG.error("Attaching by name not implemented for gdb front-ent");
    }

    private GDBResponse.Record doSetVar(@Nullable VarDomain domain, String name, String value) throws ExecutionException {
        return this.sendRequestAndWait("-gdb-set " + (domain != null ? domain.getGDBParam() + " " : NO_PARENT_REF) + name + " " + value, GDBResponse.ResultRecord.Type.done);
    }

    private GDBResponse.Record doMarkMem(String hexFrom, String hexTo, String label) throws ExecutionException {
        return this.sendRequestAndWait("mem " + hexFrom + " " + hexTo + " " + label, GDBResponse.ResultRecord.Type.done);
    }

    private void doApplyLoadRules() throws ExecutionException {
        this.sendRequestAndWait("sharedlibrary apply-load-rules all", GDBResponse.ResultRecord.Type.done);
    }

    @Override
    public boolean interrupt() throws ExecutionException {
        return this.executeCommand(new Command<Boolean>(){

            @Override
            public Boolean run() throws ExecutionException {
                return GDBDriver.this.doInterrupt();
            }
        });
    }

    private boolean doInterrupt() throws ExecutionException {
        Integer currentAppID = this.myCurrentAppPID;
        if (currentAppID == null || this.getState() != DebuggerDriver.TargetState.RUNNING) {
            return false;
        }
        if (this.myRemoteTarget) {
            this.doInterruptRemote();
        } else if (SystemInfo.isWindows) {
            assert (this.myWinBreakPath != null);
            GeneralCommandLine winBreakCL = new GeneralCommandLine(new String[]{this.myWinBreakPath});
            winBreakCL.addParameter(Integer.toString(currentAppID));
            CapturingProcessHandler handler2 = new CapturingProcessHandler(winBreakCL);
            ProcessOutput output = handler2.runProcess();
            String stderr = output.getStderr();
            CidrDebuggerLog.LOG.debug(stderr);
            int exitCode = output.getExitCode();
            if (exitCode != 0) {
                CidrDebuggerLog.LOG.debug("winbreak failed with exit code " + exitCode);
                Scanner scanner = new Scanner(new ByteArrayInputStream(stderr.getBytes(Charset.forName("UTF-8"))));
                StringBuilder errorMessage = new StringBuilder();
                while (scanner.hasNext()) {
                    if (scanner.findInLine("ERROR: (.*)") != null) {
                        MatchResult result2 = scanner.match();
                        if (errorMessage.length() > 0) {
                            errorMessage.append('\n');
                        }
                        errorMessage.append(result2.group(1));
                    }
                    scanner.nextLine();
                }
                throw new ExecutionException(errorMessage.toString());
            }
        } else {
            try {
                UnixProcessManager.sendSignal((int)currentAppID, (int)2);
            }
            catch (Throwable e) {
                throw new ExecutionException(e);
            }
        }
        return true;
    }

    protected void doInterruptRemote() throws ExecutionException {
        String signalCommand = "Sending 'SIGINT' to " + this.myProcessID;
        CidrDebuggerLog.LOG.debug(">" + signalCommand);
        UnixProcessManager.sendSignal((int)this.myProcessID, (int)2);
        this.sendRequest("-exec-interrupt", false);
        try {
            GDBResponse.Record record = this.waitForResponse(signalCommand, GDBResponse.ResultRecord.Type.done);
        }
        catch (ExecutionException e) {
            if (GDBDriver.messageContains(e, INFERIOR_NOT_EXECUTING)) {
                return;
            }
            if (GDBDriver.messageContains(e, "Quit")) {
                GDBResponse.Record response = this.waitForResponse(signalCommand, null);
                if (!GDBDriver.messageContains(GDBDriver.getErrorMessage(response), INFERIOR_NOT_EXECUTING)) {
                    CidrDebuggerLog.LOG.error("Unexpected response from -exec-interrupt after receiving '^Quit' message: " + response);
                }
                throw new GDBInterruptionFailedException();
            }
            throw e;
        }
    }

    private boolean doInterruptAndWait() throws ExecutionException {
        this.myInterrupted.down();
        try {
            if (this.doInterrupt()) {
                GDBDriver.waitForSemaphore(this.myInterrupted);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.myInterrupted.up();
        }
    }

    @Override
    public boolean resume() throws ExecutionException {
        return this.executeCommand(new Command<Boolean>(){

            @Override
            public Boolean run() throws ExecutionException {
                return GDBDriver.this.doResume();
            }
        });
    }

    private Boolean doResume() throws ExecutionException {
        try {
            return this.sendRequestAndWaitWhileSuspended("-exec-continue");
        }
        catch (ExecutionException e) {
            if (GDBDriver.messageContains(e, "The program is not being run.")) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public void stepOver() throws ExecutionException {
        this.executeCommand(new Command<Object>(){

            @Override
            public Object run() throws ExecutionException {
                try {
                    List currentFrames;
                    Integer currentThreadId = GDBDriver.this.myCurrentThreadId;
                    if (SystemInfo.isMac && currentThreadId != null && (currentFrames = GDBDriver.this.doGetFrames(currentThreadId)).size() > 0 && ((LLFrame)currentFrames.get(0)).getFile() == null) {
                        boolean noFrameWithDebug = true;
                        for (LLFrame frame : currentFrames) {
                            if (frame.getFile() == null) continue;
                            noFrameWithDebug = false;
                            break;
                        }
                        if (noFrameWithDebug) {
                            GDBDriver.this.doResume();
                            return null;
                        }
                    }
                    return GDBDriver.this.sendRequestAndWaitOnCurrentSuspendedStack("-exec-next");
                }
                catch (ExecutionException e) {
                    if (GDBDriver.messageContains(e, "Cannot find bounds of current function")) {
                        return GDBDriver.this.doResume();
                    }
                    throw e;
                }
            }
        });
    }

    @Override
    public void stepInto() throws ExecutionException {
        this.executeCommand(new Command<Object>(){

            @Override
            public Object run() throws ExecutionException {
                return GDBDriver.this.sendRequestAndWaitOnCurrentSuspendedStack("-exec-step");
            }
        });
    }

    private void selectStoppedThread() throws ExecutionException {
        Integer stoppedThread = this.myStoppedThreadId;
        if (stoppedThread != null) {
            this.doSelectThread(stoppedThread);
        }
    }

    @Override
    public void stepOut() throws ExecutionException {
        this.executeCommand(new Command<Object>(){

            @Override
            public Object run() throws ExecutionException {
                GDBDriver.this.selectStoppedThread();
                GDBResponse.Record response = GDBDriver.this.sendRequestAndWait("-stack-info-depth", null);
                try {
                    int stackDepth = Integer.parseInt(response.getResultList().get("depth", String.class));
                    if (stackDepth != 1) {
                        return GDBDriver.this.sendRequestAndWaitWhileSuspended("-exec-finish");
                    }
                    return GDBDriver.this.sendRequestAndWaitWhileSuspended("-exec-continue");
                }
                catch (NumberFormatException e) {
                    throw GDBDriver.throwGDBError(response);
                }
            }
        });
    }

    @Override
    public void runTo(final String path, final int line) throws ExecutionException {
        this.executeCommand(new Command<Object>(){

            @Override
            public Object run() throws ExecutionException {
                return GDBDriver.this.sendRequestAndWaitOnCurrentSuspendedStack("-exec-until \"" + path + ":" + (line + 1) + "\"");
            }
        });
    }

    private boolean sendRequestAndWaitOnCurrentSuspendedStack(String request) throws ExecutionException {
        this.selectStoppedThread();
        return this.sendRequestAndWaitWhileSuspended(request);
    }

    private boolean sendRequestAndWaitWhileSuspended(String request) throws ExecutionException {
        try {
            this.sendRequestAndWait(request, GDBResponse.ResultRecord.Type.running);
            return true;
        }
        catch (ExecutionException e) {
            if (GDBDriver.messageContains(e, "GDB has restored the context to what it was before the call.")) {
                CidrDebuggerLog.LOG.info((Throwable)e);
                this.handleTargetOutput("Debug session will be aborted because the program was signalled and GDB lost the debug context.\n", ProcessOutputTypes.SYSTEM);
                this.doAbort();
                return false;
            }
            throw e;
        }
    }

    @Override
    public boolean abort() throws ExecutionException {
        return this.executeCommand(new Command<Boolean>(){

            @Override
            public Boolean run() throws ExecutionException {
                return GDBDriver.this.doAbort();
            }
        });
    }

    private boolean doAbort() throws ExecutionException {
        this.doInterruptAndWait();
        try {
            this.sendRequestAndWait("-interpreter-exec console \"signal 6\"", false, true, GDBResponse.ResultRecord.Type.running);
            return true;
        }
        catch (ExecutionException e) {
            if (GDBDriver.messageContains(e, "The program is not being run.")) {
                return false;
            }
            throw e;
        }
    }

    @Override
    @NotNull
    public LLWatchpoint addWatchpoint(final int threadId, final int frameNumber, LLValue value, final String expr, final LLWatchpoint.Lifetime lifetime, final LLWatchpoint.AccessType accessType) throws ExecutionException, DBCannotSetBreakpointException {
        LLWatchpoint lLWatchpoint;
        try {
            lLWatchpoint = this.executeCommand(new Command<LLWatchpoint>(){

                @Override
                public LLWatchpoint run() throws ExecutionException {
                    GDBResponse.Record response;
                    if (GDBDriver.this.getState() == DebuggerDriver.TargetState.RUNNING) {
                        throw new RuntimeDBCannotSetBreakpointException("Cannot set watchpoint while program is running");
                    }
                    String watchpointExpression = GDBDriver.this.doGetWatchpointExpression(threadId, frameNumber, lifetime, expr);
                    try {
                        response = GDBDriver.this.sendRequestAndWait("-break-watch " + accessType.getParamString() + " \"" + watchpointExpression + "\"", GDBResponse.ResultRecord.Type.done);
                    }
                    catch (GDBCommandException e) {
                        String message = e.getMessage();
                        if (message.startsWith("mi_cmd_break_watch: Garbage following <expression>")) {
                            message = GDBDriver.CANNOT_SET_WATCHPOINT_FOR_EXPRESSION;
                        }
                        throw new RuntimeDBCannotSetBreakpointException(message, (Throwable)((Object)e));
                    }
                    return GDBDriver.this.readWatchpoint(response.getResultList(), accessType);
                }
            });
        }
        catch (ExecutionException e) {
            if (ExceptionUtil.causedBy((Throwable)e, RuntimeDBCannotSetBreakpointException.class)) {
                throw new DBCannotSetBreakpointException(e);
            }
            throw e;
        }
        if (lLWatchpoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "addWatchpoint"));
        }
        return lLWatchpoint;
    }

    @NotNull
    private String doGetWatchpointExpression(int threadId, int frameNumber, LLWatchpoint.Lifetime lifetime, String expression) throws ExecutionException {
        if (lifetime == LLWatchpoint.Lifetime.PERSISTENT) {
            LLValue evaluated;
            try {
                evaluated = this.doEvaluate(threadId, frameNumber, "&(" + expression + ")", null);
            }
            catch (RuntimeDBCannotEvaluateException e) {
                throw new RuntimeDBCannotSetBreakpointException(e.getMessage(), e);
            }
            if (evaluated.getValue().isEmpty()) {
                throw new RuntimeDBCannotSetBreakpointException(CANNOT_SET_WATCHPOINT_FOR_EXPRESSION);
            }
            expression = "*" + evaluated.getValue();
        }
        String string = expression;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doGetWatchpointExpression"));
        }
        return string;
    }

    private LLWatchpoint readWatchpoint(GDBTuple resultList, LLWatchpoint.AccessType accessType) throws ExecutionException {
        String wpt = accessType.getTupleKey();
        GDBTuple tuple = resultList.get(wpt, GDBTuple.class);
        int id = this.getInt(tuple, "number");
        String expr = tuple.get("exp", String.class);
        return new LLWatchpoint(id, expr);
    }

    @Override
    @NotNull
    public List<LLBreakpoint> addBreakpoint(final String path, final int line, final @Nullable String condition) throws ExecutionException, DBCannotSetBreakpointException {
        List<LLBreakpoint> list;
        try {
            list = this.executeCommand(new Command<List<LLBreakpoint>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public List<LLBreakpoint> run() throws ExecutionException {
                    boolean interrupted = GDBDriver.this.doInterruptAndWait();
                    try {
                        GDBResponse.Record result2;
                        try {
                            result2 = GDBDriver.this.sendRequestAndWait("-break-insert -f \"" + path + ":" + (line + 1) + "\"", GDBResponse.ResultRecord.Type.done);
                        }
                        catch (GDBCommandException e) {
                            if (GDBDriver.messageContains(e, "Cannot access memory at address")) {
                                throw new RuntimeDBCannotSetBreakpointException(e.getMessage());
                            }
                            throw e;
                        }
                        GDBTuple pairs = result2.getResultList();
                        ArrayList<LLBreakpoint> breakpoints = new ArrayList<LLBreakpoint>(pairs.size());
                        for (Pair each : pairs) {
                            GDBTuple bkpt = (GDBTuple)each.second;
                            if (bkpt == null) continue;
                            String error = null;
                            if (condition != null) {
                                try {
                                    GDBDriver.this.sendRequestAndWait("-break-condition " + GDBDriver.this.getInt(bkpt, "number") + " " + condition, GDBResponse.ResultRecord.Type.done);
                                }
                                catch (GDBCommandException e) {
                                    error = e.getMessage();
                                }
                            }
                            breakpoints.add(GDBDriver.this.readBreakpoint(bkpt, path, condition, error));
                        }
                        if (breakpoints.isEmpty()) {
                            throw new RuntimeDBCannotSetBreakpointException("No code at this line");
                        }
                        ArrayList<LLBreakpoint> arrayList = breakpoints;
                        return arrayList;
                    }
                    finally {
                        if (interrupted) {
                            GDBDriver.this.doResume();
                        }
                    }
                }
            });
        }
        catch (ExecutionException e) {
            if (ExceptionUtil.causedBy((Throwable)e, RuntimeDBCannotSetBreakpointException.class)) {
                throw new DBCannotSetBreakpointException(e);
            }
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "addBreakpoint"));
        }
        return list;
    }

    @Override
    @NotNull
    public LLSymbolicBreakpoint addSymbolicBreakpoint(final @NotNull DebuggerDriver.SymbolicBreakpoint symBreakpoint) throws ExecutionException, DBCannotSetBreakpointException {
        LLSymbolicBreakpoint lLSymbolicBreakpoint;
        if (symBreakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symBreakpoint", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "addSymbolicBreakpoint"));
        }
        try {
            lLSymbolicBreakpoint = this.executeCommand(new Command<LLSymbolicBreakpoint>(){

                @Override
                public LLSymbolicBreakpoint run() throws ExecutionException {
                    StringBuilder commandSb = new StringBuilder();
                    commandSb.append("-break-insert -f ").append(symBreakpoint.getPattern());
                    if (symBreakpoint.getThreadId() != 0) {
                        commandSb.append(" -p ").append(symBreakpoint.getThreadId());
                    }
                    GDBResponse.Record result2 = GDBDriver.this.sendRequestAndWait(commandSb.toString(), GDBResponse.ResultRecord.Type.done);
                    GDBTuple pairs = result2.getResultList();
                    for (Pair each : pairs) {
                        GDBTuple bkpt = (GDBTuple)each.second;
                        if (bkpt == null) continue;
                        int number = GDBDriver.this.getInt(bkpt, "number");
                        return new LLSymbolicBreakpoint(number);
                    }
                    throw new RuntimeDBCannotSetBreakpointException("No code at this line");
                }
            });
        }
        catch (ExecutionException e) {
            if (ExceptionUtil.causedBy((Throwable)e, RuntimeDBCannotSetBreakpointException.class)) {
                throw new DBCannotSetBreakpointException(e);
            }
            throw e;
        }
        if (lLSymbolicBreakpoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "addSymbolicBreakpoint"));
        }
        return lLSymbolicBreakpoint;
    }

    @Override
    public void removeCodepoints(final @NotNull Collection<Integer> ids) throws ExecutionException {
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "removeCodepoints"));
        }
        this.executeCommand(new Command<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws ExecutionException {
                boolean interrupted = GDBDriver.this.doInterruptAndWait();
                try {
                    for (Integer each : ids) {
                        GDBDriver.this.sendRequestAndWait("-break-delete " + each, GDBResponse.ResultRecord.Type.done);
                    }
                    Iterator iterator = null;
                    return iterator;
                }
                finally {
                    if (interrupted) {
                        GDBDriver.this.doResume();
                    }
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private LLBreakpoint readBreakpoint(GDBTuple info, @NotNull String path, String condition, String error) throws ExecutionException {
        boolean multipleLocations;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "readBreakpoint"));
        }
        int number = this.getInt(info, "number");
        int line = -1;
        boolean pending = info.get("pending", String.class) != null;
        String addr = info.get("addr", String.class);
        boolean bl = multipleLocations = addr != null && addr.equals("<MULTIPLE>");
        if (multipleLocations) {
            String originalLocation = info.get("original-location", String.class);
            if (originalLocation != null) {
                Matcher matcher = ORIGINAL_LOCATION.matcher(originalLocation);
                if (!matcher.find()) return new LLBreakpoint(number, path, line, pending, condition, error);
                line = Integer.parseInt(matcher.group(2)) - 1;
                return new LLBreakpoint(number, path, line, pending, condition, error);
            }
            CidrDebuggerLog.LOG.warn("Invalid response: " + info.toString());
            throw new RuntimeDBCannotSetBreakpointException("GDB does not allow to set breakpoint here");
        }
        if (pending) return new LLBreakpoint(number, path, line, pending, condition, error);
        Integer lineVal = this.getInt(info, "line", true);
        line = lineVal == null ? -1 : lineVal - 1;
        return new LLBreakpoint(number, path, line, pending, condition, error);
    }

    @Nullable
    private static String toSourcePath(@Nullable String file2, @Nullable String fullname) {
        if (file2 != null && FileUtil.isAbsolutePlatformIndependent((String)file2)) {
            return file2;
        }
        return fullname;
    }

    private void processBreakpoint(final int num, @Nullable Integer currentThreadId) {
        this.processBreakpointOrInteruption(currentThreadId, new Consumer<Pair<List<LLThread>, Integer>>(){

            public void consume(Pair<List<LLThread>, Integer> threads) {
                GDBDriver.this.handleBreakpoint(num, (List)threads.first, (Integer)threads.second);
            }
        });
    }

    private void processWatchpoint(final int num, @Nullable Integer currentThreadId) {
        this.processBreakpointOrInteruption(currentThreadId, new Consumer<Pair<List<LLThread>, Integer>>(){

            public void consume(Pair<List<LLThread>, Integer> threads) {
                GDBDriver.this.handleWatchpoint(num, (List)threads.first, (Integer)threads.second);
            }
        });
    }

    private void processInterruption(@Nullable Integer currentThreadId, final @Nullable Couple<String> signalAndMeaning) {
        this.processBreakpointOrInteruption(currentThreadId, new Consumer<Pair<List<LLThread>, Integer>>(){

            public void consume(Pair<List<LLThread>, Integer> threads) {
                if (signalAndMeaning != null) {
                    GDBDriver.this.handleSignal((List)threads.first, (Integer)threads.second, (String)signalAndMeaning.first, (String)signalAndMeaning.second);
                } else {
                    GDBDriver.this.handleInterrupted((List)threads.first, (Integer)threads.second);
                }
            }
        });
    }

    private void processUnknownInterruption(@Nullable Integer currentThreadId) {
        this.processBreakpointOrInteruption(currentThreadId, new Consumer<Pair<List<LLThread>, Integer>>(){

            public void consume(Pair<List<LLThread>, Integer> threads) {
                GDBDriver.this.handleInterrupted((List)threads.first, (Integer)threads.second);
            }
        });
    }

    private void processBreakpointOrInteruption(final @Nullable Integer currentThreadId, final @NotNull Consumer<Pair<List<LLThread>, Integer>> handler2) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "processBreakpointOrInteruption"));
        }
        this.executeAsyncCommand(new Command(){

            public Object run() throws ExecutionException {
                block2: {
                    try {
                        handler2.consume((Object)GDBDriver.this.doSelectAndGetThreads(currentThreadId));
                    }
                    catch (GDBCommandException e) {
                        if (e.getMessage().matches("Cannot execute command .* while target running")) break block2;
                        throw e;
                    }
                }
                return null;
            }
        });
    }

    private Pair<List<LLThread>, Integer> doSelectAndGetThreads(@Nullable Integer currentThreadId) throws ExecutionException {
        this.sendRequestAndWait("-thread-select " + currentThreadId, GDBResponse.ResultRecord.Type.done);
        GDBResponse.Record response = this.sendRequestAndWait("-thread-list-ids", GDBResponse.ResultRecord.Type.done);
        List<String> threads = response.getResultList().get("thread-ids", GDBTuple.class).getAll("thread-id", String.class);
        ArrayList<LLThread> result2 = new ArrayList<LLThread>(threads.size());
        for (String each : threads) {
            int id = Integer.parseInt(each);
            result2.add(new LLThread(id, NO_PARENT_REF, NO_PARENT_REF));
        }
        Collections.sort(result2, new Comparator<LLThread>(){

            @Override
            public int compare(LLThread o1, LLThread o2) {
                return o1.getId() - o2.getId();
            }
        });
        int currentThreadIndex = -1;
        for (int i = 0; i < result2.size(); ++i) {
            int eachThreadId = ((LLThread)result2.get(i)).getId();
            if (currentThreadId == null) {
                currentThreadId = eachThreadId;
            }
            if (eachThreadId != currentThreadId) continue;
            currentThreadIndex = i;
        }
        if (currentThreadIndex == -1) {
            CidrDebuggerLog.LOG.warn("current frame " + currentThreadId + " not found in " + result2);
            currentThreadIndex = 0;
        }
        this.myStoppedThreadId = currentThreadId;
        this.myCurrentThreadId = currentThreadId;
        this.myCurrentFrameNumber = 0;
        return Pair.create(result2, (Object)currentThreadIndex);
    }

    @Override
    @NotNull
    public List<LLFrame> getFrames(final int threadId, boolean untilValidLineEntry) throws ExecutionException, DBCannotCollectFramesException {
        List<LLFrame> list;
        try {
            list = this.executeCommand(new Command<List<LLFrame>>(){

                @Override
                public List<LLFrame> run() throws ExecutionException {
                    return GDBDriver.this.doGetFrames(threadId);
                }
            });
        }
        catch (ExecutionException e) {
            if (ExceptionUtil.causedBy((Throwable)e, RuntimeDBCannotCollectFramesException.class)) {
                throw new DBCannotCollectFramesException(e);
            }
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "getFrames"));
        }
        return list;
    }

    private List<LLFrame> doGetFrames(int threadId) throws ExecutionException {
        this.doSelectThread(threadId);
        GDBResponse.Record response = this.sendRequestAndWait("-stack-list-frames", null);
        GDBTuple stack = response.getResultList().get("stack", GDBTuple.class);
        List<GDBTuple> frames = stack == null ? null : stack.getAll("frame", GDBTuple.class);
        String msg = GDBDriver.getErrorMessage(response);
        if (frames == null) {
            throw new RuntimeDBCannotCollectFramesException(msg != null ? msg : CidrDebuggerBundle.message("debug.gdb.cannotCollectFrames", new Object[0]));
        }
        if (msg != null) {
            this.handleTargetOutput(msg + "\n", ProcessOutputTypes.SYSTEM);
        }
        SmartList result2 = new SmartList();
        boolean invalid = false;
        for (GDBTuple each : frames) {
            int level = this.getInt(each, "level");
            String func = each.get("func", String.class);
            String addrStr = each.get("addr", String.class);
            String file2 = FileUtil.toCanonicalPath((String)this.myStarter.convertPath(GDBDriver.toSourcePath(each.get("file", String.class), each.get("fullname", String.class))), (boolean)true);
            int line = -1;
            if (file2 != null) {
                line = this.getInt(each, "line") - 1;
            }
            if (func == null) {
                invalid = true;
                func = "<unknown routine>";
            }
            long addr = 0L;
            if (addrStr != null) {
                addr = GDBDriver.parseAddress(addrStr);
            }
            result2.add(new LLFrame(level, func, file2, line, addr, null));
        }
        if (invalid) {
            CidrDebuggerLog.LOG.error("Unexpected frames:\n" + StringUtil.join(frames, (Function)new Function<GDBTuple, String>(){

                public String fun(GDBTuple tuple) {
                    return String.valueOf(tuple);
                }
            }, (String)"\n"));
        }
        return result2;
    }

    @Override
    @NotNull
    public List<LLValue> getVariables(final int threadId, final int frameNumber) throws ExecutionException {
        List<LLValue> list = this.executeCommand(new SuspendedCommand<List<LLValue>>(){

            @Override
            public List<LLValue> run() throws ExecutionException {
                GDBDriver.this.doSelectFrame(threadId, frameNumber);
                return GDBDriver.this.doCollectVariables(threadId, frameNumber);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "getVariables"));
        }
        return list;
    }

    @Override
    public boolean isStructType(@NotNull LLValue var) throws ExecutionException, DBCannotLoadVariableException {
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "isStructType"));
        }
        this.loadVariable(var);
        return var.isStruct();
    }

    private void doSelectThread(int threadId) throws ExecutionException {
        Integer currentThreadId = this.myCurrentThreadId;
        if (currentThreadId == null || currentThreadId != threadId) {
            this.sendRequestAndWait("-thread-select " + threadId, GDBResponse.ResultRecord.Type.done);
            this.myCurrentThreadId = threadId;
        }
    }

    private void doSelectFrame(int threadId, int frameNumber) throws ExecutionException {
        this.doSelectThread(threadId);
        Integer currentFrameNumber = this.myCurrentFrameNumber;
        if (currentFrameNumber == null || currentFrameNumber != frameNumber) {
            this.sendRequestAndWait("-stack-select-frame " + frameNumber, GDBResponse.ResultRecord.Type.done);
            this.myCurrentFrameNumber = frameNumber;
        }
    }

    @NotNull
    private String doGetFrameAddr(int thread, int frame) throws ExecutionException {
        GDBResponse.Record response = this.sendRequestAndWait("-data-evaluate-expression --thread " + thread + " --frame " + frame + " $fp", GDBResponse.ResultRecord.Type.done);
        String frameAddr = response.getResultList().get("value", String.class);
        if (frameAddr == null) {
            throw new GDBCommandException("Cannot evaluate frame address for thread: " + thread + " frame: " + frame);
        }
        String string = frameAddr;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doGetFrameAddr"));
        }
        return string;
    }

    private List<LLValue> doCollectVariables(int thread, int frame) throws ExecutionException {
        SmartList result2 = new SmartList();
        String currentFrameAddr = this.doGetFrameAddr(thread, frame);
        this.doCollectVariables(this.doLoadFrameVariables(thread, frame, currentFrameAddr), (Processor<LLValue>)new CommonProcessors.CollectProcessor((Collection)result2), LLValue.Kind.LOCAL, LLValue.Access.PUBLIC, NO_PARENT_REF, 0, -1, currentFrameAddr);
        return result2;
    }

    @Override
    @NotNull
    public List<LLValue> getVariableChildren(LLValue var) throws ExecutionException, DBCannotCollectVariablesException {
        List<LLValue> list = this.getVariableChildrenRange(var, 0, -1);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "getVariableChildren"));
        }
        return list;
    }

    private void doProcessVariableChildren(LLValue var, Processor<LLValue> processor2, int offset, int count) throws ExecutionException {
        if (!var.mayHaveChildren()) {
            return;
        }
        MapElement mapElement = (MapElement)var.getUserData(LLVALUE_MAP_ELEMENT);
        if (mapElement != null) {
            processor2.process((Object)mapElement.getKey());
            processor2.process((Object)mapElement.getValue());
        } else if (this.doLoadVariable(var)) {
            this.doProcessVariableChildren(var.getId(), processor2, var.getKind(), var.getAccess(), var.getReferenceExpression(), offset, count, this.doCheckIsMap(var));
        }
    }

    private boolean doCheckIsMap(LLValue var) throws ExecutionException {
        Boolean isMap = (Boolean)var.getUserData(LLVALUE_IS_MAP);
        if (isMap != null) {
            return isMap;
        }
        GDBResponse.Record response = this.sendRequestAndWait("-var-list-children \"" + var.getId() + "\" 0 0", GDBResponse.ResultRecord.Type.done);
        isMap = GDBDriver.isMapElements(response.getResultList().get("displayhint", String.class));
        var.putUserData(LLVALUE_IS_MAP, isMap);
        return isMap;
    }

    private void doProcessVariableChildren(String gdbVarName, Processor<LLValue> processor2, LLValue.Kind kind, LLValue.Access access, String parentRef, int offset, int count, boolean isMap) throws ExecutionException {
        GDBTuple childList;
        int numchild;
        try {
            int endPos = offset + count;
            if (isMap) {
                offset *= 2;
                endPos *= 2;
            }
            GDBResponse.Record response = this.sendRequestAndWait("-var-list-children \"" + gdbVarName + "\" " + Integer.toString(offset) + " " + Integer.toString(endPos), GDBResponse.ResultRecord.Type.done);
            numchild = this.doGetNumchild(response.getResultList());
            childList = response.getResultList().get("children", GDBTuple.class);
            offset = 0;
        }
        catch (GDBCommandException e) {
            if (GDBDriver.messageContains(e, "Duplicate variable object name")) {
                throw new RuntimeDBCannotCollectVariablesException((Throwable)((Object)e));
            }
            throw e;
        }
        if (numchild > 0) {
            this.doCollectVariables(childList, processor2, kind, access, parentRef, isMap, offset, count, null);
        }
    }

    private int doGetNumchild(GDBTuple tuple) throws ExecutionException {
        try {
            return this.getInt(tuple, "numchild");
        }
        catch (ExecutionException e) {
            CidrDebuggerLog.LOG.debug(CidrDebuggerBundle.message("debug.gdb.cannotCountChildren", new Object[0]) + ": " + e.getMessage());
            throw new RuntimeDBCannotCollectVariablesException(CidrDebuggerBundle.message("debug.gdb.cannotCountChildren", new Object[0]));
        }
    }

    private static GDBTuple getChildTuple(GDBTuple varObjList, Object o) throws GDBCommandException {
        if (!(o instanceof Pair)) {
            throw new GDBCommandException("Invalid object in the list: " + varObjList);
        }
        Pair p = (Pair)o;
        if (!"child".equals(p.first)) {
            throw new GDBCommandException("pair.first required to be \"child\": " + p.toString());
        }
        return (GDBTuple)p.second;
    }

    private void doCollectVariables(GDBTuple varObjList, Processor<LLValue> processor2, LLValue.Kind scope, LLValue.Access access, String parentRef, boolean isMap, int offset, int count, @Nullable String currentFrameAddr) throws ExecutionException {
        if (isMap) {
            int i = offset * 2;
            int uBnd = varObjList.size();
            if (count != -1) {
                uBnd = Math.min(uBnd, i + count * 2);
            }
            while (i < uBnd) {
                LLValue mapValue;
                Object o = varObjList.get(i++);
                GDBTuple keyTuple = GDBDriver.getChildTuple(varObjList, o);
                if (i >= uBnd) {
                    String name = keyTuple.get("name", String.class);
                    if (name != null && name.matches(".*\\.<error at.*")) {
                        CidrDebuggerLog.LOG.debug("Variable " + parentRef + " has corrupted members");
                        throw new RuntimeDBCannotCollectVariablesException("Variable has corrupted members");
                    }
                    throw new GDBCommandException("Odd number of objects in the list:" + varObjList);
                }
                o = varObjList.get(i++);
                GDBTuple valueTuple = GDBDriver.getChildTuple(varObjList, o);
                LLValue key = this.doReadVariable(keyTuple, scope, access, parentRef, currentFrameAddr);
                key.setName("first");
                LLValue value = this.doReadVariable(valueTuple, scope, access, parentRef, currentFrameAddr);
                value.setName("second");
                if (!this.doLoadVariable(key) || !this.doLoadVariable(value)) {
                    mapValue = GDBDriver.doCreateErrorLLValue(NO_PARENT_REF, CidrDebuggerBundle.message("debug.gdb.cannotCollectVariable", new Object[0]), scope, access);
                } else {
                    mapValue = new LLValue(value.getId(), "[" + key.getValue() + "]", "<" + key.getType() + ", " + value.getType() + ">", null, value.getValue(), value.getKind(), 2, false, null, value.getReferenceExpression(), true, null, access);
                    mapValue.putUserData(LLVALUE_MAP_ELEMENT, new MapElement(key, value));
                }
                processor2.process((Object)mapValue);
            }
        } else {
            this.doCollectVariables(varObjList, processor2, scope, access, parentRef, offset, count, currentFrameAddr);
        }
    }

    private static boolean isMapElements(String displayHint) {
        return displayHint != null && "map".equals(displayHint);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doCollectVariables(GDBTuple varObjList, Processor<LLValue> processor2, LLValue.Kind scope, LLValue.Access access, String parentRef, int offset, int count, @Nullable String currentFrameAddr) throws ExecutionException {
        int i = offset;
        int uBnd = varObjList.size();
        if (count != -1) {
            uBnd = Math.min(uBnd, i + count);
        }
        while (true) {
            block9: {
                GDBTuple each;
                block11: {
                    Object o;
                    block10: {
                        if (i >= uBnd) {
                            return;
                        }
                        o = varObjList.get(i);
                        if (!(o instanceof GDBTuple)) break block10;
                        each = (GDBTuple)o;
                        break block11;
                    }
                    each = GDBDriver.getChildTuple(varObjList, o);
                    if (each.get("type", String.class) != null) break block11;
                    String gdbVarName = each.get("name", String.class);
                    if (gdbVarName == null) {
                        CidrDebuggerLog.LOG.debug(CidrDebuggerBundle.message("debug.gdb.missingVarName", new Object[0]) + ": " + each.toString());
                        processor2.process((Object)GDBDriver.doCreateErrorLLValue(NO_PARENT_REF, CidrDebuggerBundle.message("debug.gdb.missingVarName", new Object[0]), scope, access));
                        break block9;
                    } else {
                        String exp = each.get("exp", String.class);
                        LLValue.Access childAccess = LLValue.Access.valueFor(exp);
                        if (childAccess == null) {
                            CidrDebuggerLog.LOG.debug(CidrDebuggerBundle.message("debug.gdb.invalidVarExpr", new Object[0]) + ": " + each.toString());
                            processor2.process((Object)GDBDriver.doCreateErrorLLValue(StringUtil.notNullize((String)exp), CidrDebuggerBundle.message("debug.gdb.invalidVarExpr", new Object[0]), scope, access));
                            break block9;
                        } else {
                            try {
                                this.doProcessVariableChildren(gdbVarName, processor2, scope, childAccess, parentRef + "." + childAccess.toString(), 0, -1, false);
                            }
                            catch (RuntimeDBCannotCollectVariablesException e) {
                                CidrDebuggerLog.LOG.debug(CidrDebuggerBundle.message("debug.gdb.cannotCollectChildren", new Object[0]) + ": " + e.getMessage());
                                processor2.process((Object)GDBDriver.doCreateErrorLLValue(StringUtil.notNullize((String)exp), CidrDebuggerBundle.message("debug.gdb.cannotCollectChildren", new Object[0]), scope, access));
                            }
                        }
                    }
                    break block9;
                }
                LLValue gdbVariable = this.doReadVariable(each, scope, access, parentRef, currentFrameAddr);
                processor2.process((Object)gdbVariable);
            }
            ++i;
        }
    }

    @NotNull
    private LLValue doReadEvalResult(@NotNull GDBTuple varTuple, @Nullable GDBResponse.Record updateResponce) throws ExecutionException {
        if (varTuple == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varTuple", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doReadEvalResult"));
        }
        LLValue lLValue = this.doReadVariable(varTuple, LLValue.Kind.EVALUATED, LLValue.Access.PUBLIC, NO_PARENT_REF, null);
        if (lLValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doReadEvalResult"));
        }
        return lLValue;
    }

    public void loadVariable(final @NotNull LLValue var) throws ExecutionException, DBCannotLoadVariableException {
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "loadVariable"));
        }
        try {
            this.executeCommand(new Command<Void>(){

                @Override
                public Void run() throws ExecutionException {
                    if (!GDBDriver.this.doLoadVariable(var)) {
                        throw new RuntimeDBCannotLoadVariableException(var.getValue());
                    }
                    return null;
                }
            });
        }
        catch (ExecutionException e) {
            if (ExceptionUtil.causedBy((Throwable)e, RuntimeDBCannotLoadVariableException.class)) {
                throw new DBCannotLoadVariableException(e.getMessage());
            }
            throw e;
        }
    }

    private boolean doLoadVariable(@NotNull LLValue llValue) throws ExecutionException {
        if (llValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "llValue", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doLoadVariable"));
        }
        LLValueLoader valueLoader = (LLValueLoader)llValue.getUserData(LLVALUE_VALUE_LOADER);
        if (valueLoader == null) {
            return true;
        }
        llValue.putUserData(LLVALUE_VALUE_LOADER, null);
        return valueLoader.doLoadValue(llValue);
    }

    @NotNull
    private LLValue doReadVariable(@NotNull GDBTuple varTuple, @NotNull LLValue.Kind scope, @NotNull LLValue.Access access, @NotNull String parentRef, @Nullable String currentFrameAddr) throws ExecutionException {
        String value;
        boolean hasNoParent;
        boolean isInComplete;
        if (varTuple == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varTuple", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doReadVariable"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doReadVariable"));
        }
        if (access == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "access", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doReadVariable"));
        }
        if (parentRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentRef", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doReadVariable"));
        }
        String name = varTuple.get("name", String.class);
        if (name == null) {
            CidrDebuggerLog.LOG.debug(CidrDebuggerBundle.message("debug.gdb.cannotCollectVariable", new Object[0]) + ": No name information for variable");
            LLValue lLValue = GDBDriver.doCreateErrorLLValue(NO_PARENT_REF, CidrDebuggerBundle.message("debug.gdb.cannotCollectVariable", new Object[0]), scope, access);
            if (lLValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doReadVariable"));
            }
            return lLValue;
        }
        String id = name;
        String type = varTuple.get("type", String.class);
        if (type == null) {
            CidrDebuggerLog.LOG.debug(CidrDebuggerBundle.message("debug.gdb.cannotCollectVariable", new Object[0]) + ": No type information for variable");
            LLValue lLValue = GDBDriver.doCreateErrorLLValue(name, CidrDebuggerBundle.message("debug.gdb.cannotCollectVariable", new Object[0]), scope, access);
            if (lLValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doReadVariable"));
            }
            return lLValue;
        }
        String dynamicType = varTuple.get("dynamic_type", String.class);
        if (StringUtil.isEmptyOrSpaces((String)dynamicType)) {
            dynamicType = null;
        }
        boolean bl = isInComplete = (hasNoParent = NO_PARENT_REF.equals(parentRef)) && scope != LLValue.Kind.EVALUATED;
        if (isInComplete) {
            if (currentFrameAddr == null) {
                CidrDebuggerLog.LOG.debug(CidrDebuggerBundle.message("debug.gdb.cannotCollectVariable", new Object[0]) + ": No type frame address for variable");
                LLValue lLValue = GDBDriver.doCreateErrorLLValue(name, CidrDebuggerBundle.message("debug.gdb.cannotCollectVariable", new Object[0]), scope, access);
                if (lLValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doReadVariable"));
                }
                return lLValue;
            }
            id = NO_PARENT_REF;
            value = varTuple.get("value", String.class);
        } else {
            name = varTuple.get("exp", String.class);
            GDBResponse.Record varObj = this.sendRequestAndWait("-var-evaluate-expression \"" + id + "\"", GDBResponse.ResultRecord.Type.done);
            value = varObj.getResultList().get("value", String.class);
        }
        String pointer = LLValue.getPointer(value);
        String referenceIdentity = scope == LLValue.Kind.EVALUATED ? (pointer != null ? "(" + type + ")" + pointer : id) : (hasNoParent ? name : parentRef + "." + name);
        String notNullValue = StringUtil.notNullize((String)value);
        LLValue llValue = new LLValue(id, StringUtil.notNullize((String)name), GDBDriver.fixType(type), GDBDriver.fixType(dynamicType), notNullValue, scope, -1, false, null, referenceIdentity, false, notNullValue.startsWith("@") ? LLValue.TypeClass.REFERENCE : null, access);
        if (isInComplete) {
            llValue.putUserData(LLVALUE_VALUE_LOADER, new LLValueLoader(currentFrameAddr));
        }
        LLValue lLValue = llValue;
        if (lLValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doReadVariable"));
        }
        return lLValue;
    }

    @NotNull
    private static LLValue doCreateErrorLLValue(@NotNull String name, @NotNull String value, @NotNull LLValue.Kind kind, @NotNull LLValue.Access access) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doCreateErrorLLValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doCreateErrorLLValue"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doCreateErrorLLValue"));
        }
        if (access == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "access", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doCreateErrorLLValue"));
        }
        LLValue llValue = new LLValue(name, name, NO_PARENT_REF, null, value, kind, 0, false, null, NO_PARENT_REF, false, null, access);
        llValue.setValid(false);
        LLValue lLValue = llValue;
        if (lLValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doCreateErrorLLValue"));
        }
        return lLValue;
    }

    @Override
    public int getChildrenCount(final LLValue var, final int max) throws ExecutionException, DBCannotCollectVariablesException {
        try {
            return this.executeCommand(new SuspendedCommand<Integer>(){

                @Override
                public Integer run() throws ExecutionException {
                    int count = GDBDriver.this.doGetChildrenCount(var);
                    return Math.min(count, max);
                }
            });
        }
        catch (ExecutionException e) {
            if (ExceptionUtil.causedBy((Throwable)e, RuntimeDBCannotCollectVariablesException.class)) {
                throw new DBCannotCollectVariablesException(e);
            }
            throw e;
        }
    }

    Pair<Integer, Boolean> getNumMore(GDBTuple tuple) {
        boolean m;
        int n;
        try {
            n = this.getInt(tuple, "numchild");
            m = this.getBool(tuple, "has_more");
        }
        catch (ExecutionException e) {
            CidrDebuggerLog.LOG.debug(CidrDebuggerBundle.message("debug.gdb.cannotCountChildren", new Object[0]) + ": " + e.getMessage());
            throw new RuntimeDBCannotCollectVariablesException(CidrDebuggerBundle.message("debug.gdb.cannotCountChildren", new Object[0]));
        }
        return Pair.create((Object)n, (Object)m);
    }

    private int doGetChildrenCountForPlainVar(LLValue var) throws ExecutionException {
        int accumSize = 0;
        int approxStep = 2048;
        int num = 1;
        boolean expand = true;
        do {
            GDBResponse.Record varObj;
            try {
                varObj = this.sendRequestAndWait("-var-list-children \"" + var.getId() + "\" " + Integer.toString(accumSize + approxStep) + " " + Integer.toString(accumSize + approxStep + num), GDBResponse.ResultRecord.Type.done);
            }
            catch (GDBCommandException e) {
                throw new RuntimeDBCannotCollectVariablesException((Throwable)((Object)e));
            }
            Pair<Integer, Boolean> numMore = this.getNumMore(varObj.getResultList());
            if (expand) {
                if (((Boolean)numMore.second).booleanValue() && approxStep < 2000) {
                    approxStep *= 2;
                    continue;
                }
                if ((Integer)numMore.first > 0) {
                    accumSize = approxStep + (Integer)numMore.first;
                    break;
                }
                expand = false;
                approxStep /= 2;
                continue;
            }
            if (approxStep < 32) {
                num = 32;
            }
            if (((Boolean)numMore.second).booleanValue()) {
                accumSize += approxStep;
            } else if ((Integer)numMore.first > 0) {
                accumSize += approxStep + (Integer)numMore.first;
                break;
            }
            approxStep /= 2;
        } while (accumSize < 2000);
        return accumSize < 2000 ? accumSize : 2000;
    }

    private int doGetChildrenCount(LLValue var) throws ExecutionException {
        String displayHint;
        boolean isMapElements;
        GDBResponse.Record varObj;
        if (!var.mayHaveChildren()) {
            return 0;
        }
        int childrenCount = var.getChildrenCount();
        if (childrenCount != -1) {
            return childrenCount;
        }
        if (!this.doLoadVariable(var)) {
            throw new RuntimeDBCannotCollectVariablesException(var.getValue());
        }
        try {
            varObj = this.sendRequestAndWait("-var-list-children \"" + var.getId() + "\" 0 " + Integer.toString(8), GDBResponse.ResultRecord.Type.done);
        }
        catch (GDBCommandException e) {
            throw new RuntimeDBCannotCollectVariablesException((Throwable)((Object)e));
        }
        GDBTuple cTuple = varObj.getResultList().get("children", GDBTuple.class);
        if (cTuple != null) {
            childrenCount = 0;
            boolean hasAccessChild = false;
            List<GDBTuple> children2 = cTuple.getAll("child", GDBTuple.class);
            for (GDBTuple child : children2) {
                if (child.get("type", String.class) == null && child.get("name", String.class) != null && LLValue.Access.valueFor(child.get("exp", String.class)) != null) {
                    childrenCount += this.doGetNumchild(child);
                    hasAccessChild = true;
                    continue;
                }
                if (hasAccessChild) {
                    CidrDebuggerLog.LOG.info("Variable has both access and non access children: " + children2.toString());
                }
                childrenCount = -1;
                break;
            }
        }
        if (childrenCount == -1) {
            Pair<Integer, Boolean> numMore = this.getNumMore(varObj.getResultList());
            childrenCount = (Boolean)numMore.second == false ? ((Integer)numMore.first).intValue() : this.doGetChildrenCountForPlainVar(var);
        }
        childrenCount = (isMapElements = GDBDriver.isMapElements(displayHint = varObj.getResultList().get("displayhint", String.class))) ? childrenCount / 2 : childrenCount;
        var.setChildrenCount(childrenCount);
        var.putUserData(LLVALUE_IS_MAP, isMapElements);
        return childrenCount;
    }

    private static String fixType(@Nullable String type) {
        return type == null ? null : type.replace("'", NO_PARENT_REF);
    }

    @Override
    @NotNull
    public LLValue evaluate(final int threadId, final int frameNumber, final @NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage language) throws ExecutionException, DBCannotEvaluateException {
        LLValue lLValue;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "evaluate"));
        }
        final String debuggerLanguage = GDBDriver.convertLanguage(language);
        try {
            lLValue = this.executeCommand(new SuspendedCommand<LLValue>(){

                @Override
                public LLValue run() throws ExecutionException {
                    return GDBDriver.this.doEvaluate(threadId, frameNumber, expression, debuggerLanguage);
                }
            }, true, expression, 30000L);
        }
        catch (ExecutionException e) {
            if (ExceptionUtil.causedBy((Throwable)e, RuntimeDBCannotEvaluateException.class)) {
                throw new DBCannotEvaluateException(e);
            }
            throw e;
        }
        if (lLValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "evaluate"));
        }
        return lLValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LLValue doEvaluate(int threadId, int frameNumber, String expression, @Nullable String language) throws ExecutionException {
        GDBResponse.Record updateResponse;
        GDBResponse.Record response;
        block9: {
            this.doSelectFrame(threadId, frameNumber);
            response = this.myVarsCache.getFromCache(expression);
            updateResponse = null;
            try {
                if (response != null) {
                    String name = response.getResultList().get("name", String.class);
                    updateResponse = this.sendRequestAndWait("-var-update " + name, GDBResponse.ResultRecord.Type.done);
                    break block9;
                }
                if (language != null) {
                    this.sendRequestAndWait("-gdb-set language " + language, GDBResponse.ResultRecord.Type.done);
                }
                try {
                    response = this.sendRequestAndWait("-var-create - * \"" + GDBDriver.escapeString(expression) + "\"", GDBResponse.ResultRecord.Type.done);
                    this.myVarsCache.putIntoCache(expression, response);
                }
                finally {
                    if (language != null) {
                        this.sendRequestAndWait("-gdb-set language auto", GDBResponse.ResultRecord.Type.done);
                    }
                }
            }
            catch (GDBCommandException e) {
                String message = e.getMessage();
                if (message == null || message.contains("mi_cmd_var_create: unable to create variable object")) {
                    message = "Cannot evaluate the expression.";
                }
                throw new RuntimeDBCannotEvaluateException(message, (Throwable)((Object)e));
            }
        }
        return this.doReadEvalResult(response.getResultList(), updateResponse);
    }

    @Nullable
    private static String convertLanguage(@Nullable DebuggerDriver.DebuggerLanguage language) throws DBCannotEvaluateException {
        if (language == null) {
            return null;
        }
        if (language instanceof DebuggerDriver.StandardDebuggerLanguage) {
            switch ((DebuggerDriver.StandardDebuggerLanguage)language) {
                case C: {
                    return "c";
                }
                case C_PLUS_PLUS: {
                    return "c++";
                }
                case OBJC: {
                    return "objective-c";
                }
            }
        }
        throw new DBCannotEvaluateException(language.toString() + " is not supported by GDB");
    }

    @Override
    @NotNull
    public DebuggerDriver.ShellCommandResult executeShellCommand(@NotNull String command, @Nullable String workingDir, int timeoutSecs) throws ExecutionException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "executeShellCommand"));
        }
        throw new ExecutionException("Not implemented yet");
    }

    @Override
    public void executeConsoleCommand(String command) throws ExecutionException {
        this.executeConsoleCommand(-1, -1, command);
    }

    @Override
    public void executeConsoleCommand(final int threadId, final int frameNumber, final String command) throws ExecutionException {
        this.executeCommand(new ConsoleCommand<Object>(){

            @Override
            public Object run() throws ExecutionException {
                if (threadId > 0) {
                    GDBDriver.this.doSelectFrame(threadId, frameNumber);
                } else {
                    GDBDriver.this.selectStoppedThread();
                }
                if (GDBDriver.this.isInPromptMode) {
                    GDBDriver.this.sendRequestAndWait(command, null);
                } else {
                    String trimmed = command.trim();
                    if ("run".equals(trimmed)) {
                        GDBDriver.this.handleGDBOutput("Command '" + trimmed + "' is not supported.\n");
                        return null;
                    }
                    GDBDriver.this.sendRequestAndWait(GDBDriver.createConsoleCommand(trimmed), null);
                }
                return null;
            }
        }, true, command, 30000L);
    }

    @Override
    public void handleCompletion(String command, int pos, List<String> completions) throws ExecutionException {
    }

    private boolean getBool(@NotNull GDBTuple tuple, @NotNull String key) throws ExecutionException {
        if (tuple == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tuple", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "getBool"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "getBool"));
        }
        Integer val = this.getInt(tuple, key, false);
        assert (val != null);
        if (val < 0 || val > 1) {
            throw new ExecutionException("Invalid boolean data for key " + key + " in: " + tuple + "\n\tlast command:" + this.myLastCommand);
        }
        return val == 1;
    }

    @Override
    public void handleSignal(String signalName, boolean stop2, boolean pass, boolean notify) throws ExecutionException {
        ArrayList<String> options = new ArrayList<String>(3);
        options.add(GDBDriver.handleSignalOption(stop2, "stop"));
        options.add(GDBDriver.handleSignalOption(pass, "pass"));
        options.add(GDBDriver.handleSignalOption(notify, "print"));
        String command = String.format("handle %s %s", signalName, StringUtil.join(options, (String)" "));
        this.sendRequestAndWait(GDBDriver.createConsoleCommand(command), GDBResponse.ResultRecord.Type.done);
    }

    private static String handleSignalOption(boolean on, String option) {
        String prefix = NO_PARENT_REF;
        if (!on) {
            prefix = "no";
        }
        return prefix + option;
    }

    private int getInt(@NotNull GDBTuple tuple, @NotNull String key) throws ExecutionException {
        if (tuple == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tuple", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "getInt"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "getInt"));
        }
        return this.getInt(tuple, key, false);
    }

    @Nullable
    private Integer getInt(@NotNull GDBTuple tuple, @NotNull String key, boolean mayBeNull) throws ExecutionException {
        if (tuple == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tuple", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "getInt"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "getInt"));
        }
        String value = tuple.get(key, String.class);
        if (value == null) {
            if (mayBeNull) {
                return null;
            }
            throw new ExecutionException("Null data for key " + key + " in: " + tuple + "\n\tlast command:" + this.myLastCommand);
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ExecutionException("Unexpected response data for key " + key + " in: " + tuple + "\n\tlast command:" + this.myLastCommand);
        }
    }

    @NotNull
    protected static String createConsoleCommand(String request) {
        String string = "-interpreter-exec console \"" + GDBDriver.escapeString(request) + "\"";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "createConsoleCommand"));
        }
        return string;
    }

    @NotNull
    protected GDBResponse.Record sendRequestAndWait(@NotNull String command, @Nullable GDBResponse.ResultRecord.Type expectedType) throws ExecutionException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "sendRequestAndWait"));
        }
        GDBResponse.Record record = this.sendRequestAndWait(command, false, false, expectedType);
        if (record == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "sendRequestAndWait"));
        }
        return record;
    }

    @NotNull
    protected GDBResponse.Record sendRequestAndWait(@NotNull String command, boolean suppressOutput, boolean treatStopAsTermination, @Nullable GDBResponse.ResultRecord.Type expectedType) throws ExecutionException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "sendRequestAndWait"));
        }
        this.sendRequest(command, suppressOutput, treatStopAsTermination);
        GDBResponse.Record record = this.waitForResponse(command, expectedType);
        if (record == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "sendRequestAndWait"));
        }
        return record;
    }

    protected void sendRequest(@NotNull String command, boolean suppressOutput) throws ExecutionException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "sendRequest"));
        }
        this.sendRequest(command, suppressOutput, false);
    }

    protected void sendRequest(@NotNull String command, boolean suppressOutput, boolean treatStopAsTermination) throws ExecutionException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "sendRequest"));
        }
        GDBDriver.waitForSemaphore(this.myCommandSemaphore);
        this.myCommandSemaphore.down();
        this.myLastCommand = command;
        this.myLastConsoleOutput.setLength(0);
        this.mySuppressOutputDuringCommand = suppressOutput;
        this.myTreatStopAsTermination = treatStopAsTermination;
        if (this.isTerminated()) {
            throw new ExecutionFinishedException();
        }
        CidrDebuggerLog.LOG.debug(">" + command);
        try {
            this.mySink.write((command + "\n").getBytes(this.myGdbCommandLine.getCharset()));
            this.mySink.flush();
        }
        catch (IOException e) {
            if (this.isTerminated()) {
                throw new ExecutionFinishedException((Throwable)e);
            }
            throw new ExecutionException("Cannot send request", (Throwable)e);
        }
    }

    private boolean isTerminated() {
        return this.myProcessHandler.isProcessTerminating() || this.myProcessHandler.isProcessTerminated();
    }

    @NotNull
    private GDBResponse.Record waitForResponse(@NotNull String command, @Nullable GDBResponse.ResultRecord.Type expectedType) throws ExecutionException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "waitForResponse"));
        }
        GDBResponse.Record result2 = this.doWaitForResponse();
        Object resultType = result2.getType();
        if (expectedType == null || Comparing.equal((Object)expectedType, resultType)) {
            GDBResponse.Record record = result2;
            if (record == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "waitForResponse"));
            }
            return record;
        }
        if (!"-exec-interrupt".equals(command) || !INFERIOR_NOT_EXECUTING.equals(GDBDriver.getErrorMessage(result2))) {
            CidrDebuggerLog.LOG.warn(">" + command);
            CidrDebuggerLog.LOG.warn("<" + result2);
        }
        if (resultType == GDBResponse.ResultRecord.Type.error) {
            throw GDBDriver.throwGDBError(result2);
        }
        throw GDBDriver.unexpectedResponse(result2);
    }

    private static ExecutionException throwGDBError(GDBResponse.Record result2) throws GDBCommandException {
        String error = GDBDriver.getErrorMessage(result2);
        if (error == null) {
            error = "Cannot execute GDB command";
        }
        throw new GDBCommandException(error);
    }

    @Nullable
    private static String getErrorMessage(@NotNull GDBResponse.Record result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "getErrorMessage"));
        }
        return result2.getResultList().get("msg", String.class);
    }

    @NotNull
    private GDBResponse.Record doWaitForResponse() throws ExecutionException {
        GDBResponse.Record record;
        try {
            GDBResponse.Record result2 = (GDBResponse.Record)this.myResultQueue.take().get();
            if (result2 == null) {
                throw new ExecutionFinishedException();
            }
            record = result2;
        }
        catch (InterruptedException e) {
            throw new ExecutionException("Execution interrupted", (Throwable)e);
        }
        if (record == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doWaitForResponse"));
        }
        return record;
    }

    private static ExecutionException unexpectedResponse(Object response) throws ExecutionException {
        return new ExecutionException("Unexpected response: " + response);
    }

    private static boolean messageContains(@NotNull ExecutionException e, @NotNull String string) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "messageContains"));
        }
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "messageContains"));
        }
        String message = e.getMessage();
        return message != null && message.contains(string);
    }

    private static boolean messageContains(@Nullable String message, @NotNull String contains) {
        if (contains == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contains", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "messageContains"));
        }
        return message != null && message.contains(contains);
    }

    private static void waitForSemaphore(Semaphore s) throws ExecutionException {
        try {
            s.waitForUnsafe();
        }
        catch (InterruptedException e) {
            throw new ExecutionException("Execution interrupted", (Throwable)e);
        }
    }

    private void dispatchOutput(@Nullable String output) {
        try {
            this.doDispatchOutput(output);
        }
        catch (Throwable e) {
            CidrDebuggerLog.LOG.error(e);
        }
    }

    private void doDispatchOutput(@Nullable String output) throws GDBResponse.ResponseParseException, ExecutionException, InterruptedException {
        GDBResponse.AsyncRecord r;
        if (output != null) {
            CidrDebuggerLog.LOG.debug("<" + output);
        }
        this.readOutputFully();
        if (output == null) {
            this.cleanupOnTermination();
            this.handleExited();
            return;
        }
        if ("(gdb)".equals(output)) {
            this.myCommandSemaphore.up();
            return;
        }
        GDBResponse response = GDBResponse.parse(output);
        if (response instanceof GDBResponse.StreamRecord) {
            GDBResponse.StreamRecord stream = (GDBResponse.StreamRecord)response;
            GDBResponse.StreamRecord.Category category = stream.getCategory();
            if (category == GDBResponse.StreamRecord.Category.target) {
                this.handleTargetOutput(stream.getText(), ProcessOutputTypes.STDOUT);
            } else if (category == GDBResponse.StreamRecord.Category.console || category == GDBResponse.StreamRecord.Category.log) {
                if (category == GDBResponse.StreamRecord.Category.console) {
                    this.myLastConsoleOutput.append(stream.getText());
                }
                if (!this.mySuppressOutputDuringCommand) {
                    this.handleGDBOutput(stream.getText());
                }
            }
            return;
        }
        boolean enteredPromptMode = false;
        if (response instanceof GDBResponse.AsyncRecord && (r = (GDBResponse.AsyncRecord)response).getCategory() == GDBResponse.AsyncRecord.Category.notify && ((GDBResponse.AsyncRecord.Type)r.getType()).getValue().equals("read-one-line")) {
            enteredPromptMode = true;
            this.isInPromptMode = true;
            this.handlePrompt(r.getResultList().get("prompt", String.class));
            this.myResultQueue.put((Ref<GDBResponse.Record>)Ref.create((Object)((GDBResponse.Record)response)));
            this.myCommandSemaphore.up();
        }
        if (enteredPromptMode) {
            return;
        }
        if (this.isInPromptMode) {
            this.isInPromptMode = false;
            this.handlePrompt();
        }
        if (response instanceof GDBResponse.ResultRecord) {
            GDBTuple tuple;
            String reason;
            Object type = ((GDBResponse.ResultRecord)response).getType();
            if (type == GDBResponse.ResultRecord.Type.continuing || type == GDBResponse.ResultRecord.Type.stepping) {
                return;
            }
            if (type == GDBResponse.ResultRecord.Type.running && !this.mySuppressRunningResult) {
                this.handleRunning();
            }
            if (type == GDBResponse.ResultRecord.Type.error && "breakpoint-hit".equals(reason = (tuple = ((GDBResponse.ResultRecord)response).getResultList()).get("reason", String.class))) {
                this.processBreakpointHit(tuple);
            }
            if (type != GDBResponse.ResultRecord.Type.running || !this.mySuppressRunningResult) {
                this.myResultQueue.put((Ref<GDBResponse.Record>)Ref.create((Object)((GDBResponse.Record)response)));
            }
            this.mySuppressRunningResult = false;
            return;
        }
        if (response instanceof GDBResponse.AsyncRecord) {
            GDBResponse.AsyncRecord asyncResponse = (GDBResponse.AsyncRecord)response;
            GDBResponse.AsyncRecord.Category category = (GDBResponse.AsyncRecord.Category)asyncResponse.getCategory();
            String type = ((GDBResponse.AsyncRecord.Type)asyncResponse.getType()).getValue();
            GDBTuple resultTuple = asyncResponse.getResultList();
            if (category == GDBResponse.AsyncRecord.Category.notify) {
                if (type.equals("breakpoint-command-completed") && this.myPendingBreakpointRunnable != null) {
                    this.myPendingBreakpointAlarm.cancelAllRequests();
                    this.myPendingBreakpointRunnable.run();
                } else {
                    if (type.equals("thread-group-exited")) {
                        String value = resultTuple.get("exit-code", String.class);
                        int code = 1;
                        try {
                            BigInteger biCode;
                            code = value != null ? ((biCode = new BigInteger(value, 8).abs()).compareTo(INT_MAX_VALUE_BI) == -1 ? biCode.intValue() : Integer.MAX_VALUE) : 0;
                        }
                        catch (NumberFormatException e) {
                            CidrDebuggerLog.LOG.warn("Cannot parse result code: " + value);
                        }
                        if (!this.mySuppressTargetFinishedOnDetaching) {
                            this.handleTargetFinished(code, null);
                        }
                        return;
                    }
                    if (type.equals("thread-group-started")) {
                        String value = resultTuple.get("pid", String.class);
                        this.myCurrentAppPID = Integer.parseInt(value);
                    }
                }
            } else if (category == GDBResponse.AsyncRecord.Category.exec && type.equals("stopped")) {
                String reason = resultTuple.get("reason", String.class);
                if ("exited-normally".equals(reason)) {
                    this.handleTargetFinished(0, null);
                    return;
                }
                if ("exited-signalled".equals(reason)) {
                    this.handleTargetTerminated();
                    return;
                }
                if (this.myTreatStopAsTermination) {
                    this.handleTargetTerminated();
                    return;
                }
                if ("signal-received".equals(reason)) {
                    if (this.myInterrupted.tryUp()) {
                        return;
                    }
                    int thread = this.getInt(resultTuple, "thread-id");
                    String name = resultTuple.get("signal-name", String.class);
                    String meaning = resultTuple.get("signal-meaning", String.class);
                    if (GDBDriver.isTargetTerminationSignal(name)) {
                        this.handleTargetTerminated();
                        return;
                    }
                    this.processInterruption(thread, name != null && meaning != null ? Couple.of((Object)name, (Object)meaning) : null);
                    return;
                }
                if ("breakpoint-hit".equals(reason)) {
                    this.processBreakpointHit(resultTuple);
                    return;
                }
                if ("end-stepping-range".equals(reason) || "function-finished".equals(reason) || "location-reached".equals(reason)) {
                    int thread = this.getInt(resultTuple, "thread-id");
                    GDBTuple frameTuple = resultTuple.get("frame", GDBTuple.class);
                    if (this.myIndirectSymbols != null && frameTuple != null) {
                        String addr = frameTuple.get("addr", String.class);
                        String func = frameTuple.get("func", String.class);
                        String file2 = frameTuple.get("file", String.class);
                        if (file2 == null && "??".equals(func) && addr != null && this.myIndirectSymbols.contains(GDBDriver.parseAddress(addr))) {
                            this.mySuppressRunningResult = true;
                            this.executeAsyncCommand(new Command<Object>(){

                                @Override
                                public Object run() throws ExecutionException {
                                    GDBDriver.this.sendRequest("-exec-step", true);
                                    return null;
                                }
                            });
                            return;
                        }
                    }
                    this.processInterruption(thread, null);
                    return;
                }
                if ("watchpoint-trigger".equals(reason) || "read-watchpoint-trigger".equals(reason) || "access-watchpoint-trigger".equals(reason)) {
                    String tupleKey;
                    String[] tupleKeys = new String[]{"wpt", "hw-rwpt", "hw-awpt"};
                    GDBTuple wpt = null;
                    String[] addr = tupleKeys;
                    int func = addr.length;
                    for (int i = 0; i < func && (wpt = resultTuple.get(tupleKey = addr[i], GDBTuple.class)) == null; ++i) {
                    }
                    if (wpt != null) {
                        int number = this.getInt(wpt, "number");
                        int thread = this.getInt(resultTuple, "thread-id");
                        this.processWatchpoint(number, thread);
                        return;
                    }
                }
                if ("watchpoint-scope".equals(reason)) {
                    int wpnum = this.getInt(resultTuple, "wpnum");
                    this.handleWatchpointScope(wpnum);
                    return;
                }
                if (this.myPendingForAttachNotification.tryUp()) {
                    return;
                }
                Integer threadId = this.getInt(resultTuple, "thread-id", true);
                this.processUnknownInterruption(threadId);
                return;
            }
            return;
        }
        throw GDBDriver.unexpectedResponse(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBreakpointHit(GDBTuple resultTuple) throws ExecutionException {
        final int num = this.getInt(resultTuple, "bkptno");
        final int thread = this.getInt(resultTuple, "thread-id");
        if ("yes".equals(resultTuple.get("commands", String.class))) {
            Object object = this.myPendingBreakpointLock;
            synchronized (object) {
                this.myPendingBreakpointRunnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = GDBDriver.this.myPendingBreakpointLock;
                        synchronized (object) {
                            if (GDBDriver.this.myPendingBreakpointRunnable != null && GDBDriver.this.getState() != DebuggerDriver.TargetState.EXITED && GDBDriver.this.getState() != DebuggerDriver.TargetState.FINISHED) {
                                GDBDriver.this.processBreakpoint(num, thread);
                                GDBDriver.this.myPendingBreakpointRunnable = null;
                            }
                        }
                    }
                };
                this.myPendingBreakpointAlarm.addRequest(this.myPendingBreakpointRunnable, 1000);
            }
        } else {
            this.processBreakpoint(num, thread);
        }
    }

    private void cleanupOnTermination() {
        this.readOutputFully();
        this.closeOutputReaders();
        PTYOutputStream processInput = this.myProcessInput;
        if (processInput != null) {
            try {
                processInput.close();
            }
            catch (IOException e) {
                CidrDebuggerLog.LOG.warn((Throwable)e);
            }
        }
        this.myProcessInput = null;
        try {
            this.myResultQueue.put((Ref<GDBResponse.Record>)new Ref(null));
        }
        catch (InterruptedException e) {
            CidrDebuggerLog.LOG.error((Throwable)e);
        }
        this.myCommandSemaphore.up();
        this.myInterrupted.up();
        this.myPendingForAttachNotification.up();
    }

    protected <T> T executeCommand(Command<T> c) throws ExecutionException {
        return this.executeCommand(c, false, null, 30000L);
    }

    protected <T> T executeCommand(Command<T> c, boolean isEvaluation, @Nullable String expression, long timeout) throws ExecutionException {
        try {
            return this.doExecuteCommand(c, false).get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            if (isEvaluation) {
                throw new DBEvaluationTimedOutException(expression);
            }
            throw new DBTimedOutException(CidrDebuggerBundle.message("debug.command.error.timedOut", new Object[0]));
        }
    }

    private void executeAsyncCommand(Command<?> c) {
        this.doExecuteCommand(c, true);
    }

    private <T> ExecutionResult<T> doExecuteCommand(final Command<T> c, final boolean async) {
        final ExecutionResult result2 = new ExecutionResult();
        this.myCommandProcessor.add((Object)new Runnable(){

            @Override
            public void run() {
                try {
                    if (c instanceof SuspendedCommand && GDBDriver.this.getState() != DebuggerDriver.TargetState.SUSPENDED) {
                        throw new DBIllegalStateException(CidrDebuggerBundle.message("debug.command.error.notSuspended", new Object[0]));
                    }
                    if (!(c instanceof ConsoleCommand) && GDBDriver.this.isInPromptMode) {
                        throw new DBIllegalStateException(CidrDebuggerBundle.message("debug.command.error.inPrompt", new Object[0]));
                    }
                    result2.set(c.run());
                }
                catch (Throwable e) {
                    if (async) {
                        if (ExceptionUtil.causedBy((Throwable)e, ExecutionFinishedException.class)) {
                            CidrDebuggerLog.LOG.info("Cannot execute async command because execution has finished", e);
                        } else {
                            CidrDebuggerLog.LOG.error("Cannot execute async command", e);
                        }
                    }
                    result2.setException(e);
                }
            }
        });
        return result2;
    }

    @NotNull
    private GDBTuple doLoadFrameVariables(int thread, int frame, @NotNull String currentFrameAddr) throws ExecutionException {
        if (currentFrameAddr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentFrameAddr", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doLoadFrameVariables"));
        }
        GDBResponse.Record updateResponse = this.sendRequestAndWait("-var-update --all-values *", GDBResponse.ResultRecord.Type.done);
        GDBTuple changeList = updateResponse.getResultList().get("changelist", GDBTuple.class);
        for (Object each : changeList) {
            GDBTuple change = (GDBTuple)each;
            String inScope = StringUtil.notNullize((String)change.get("in_scope", String.class));
            String typeChanged = StringUtil.notNullize((String)change.get("type_changed", String.class));
            if (!inScope.equals("false") && !typeChanged.equals("true")) continue;
            String fVar = StringUtil.notNullize((String)change.get("name", String.class));
            this.myFrameVarCache.removeValue((Object)fVar);
            this.myFrameVarValueCache.remove(fVar);
            this.sendRequestAndWait("-var-delete \"" + fVar + "\"", GDBResponse.ResultRecord.Type.done);
            if (myFrameVarDisposeListener == null) continue;
            myFrameVarDisposeListener.consume((Object)fVar);
        }
        GDBResponse.Record response = this.sendRequestAndWait("-stack-list-variables --thread " + thread + " --frame " + frame + " 2", GDBResponse.ResultRecord.Type.done);
        HashSet<String> uniqueSet = new HashSet<String>();
        GDBTuple result2 = new GDBTuple();
        GDBTuple variables = response.getResultList().get("variables", GDBTuple.class);
        assert (variables != null);
        for (Object each : variables) {
            String value;
            String fVar;
            GDBTuple gdbTuple = (GDBTuple)each;
            String name = StringUtil.notNullize((String)gdbTuple.get("name", String.class));
            String fvKey = GDBDriver.makeFVKey(currentFrameAddr, name);
            if (uniqueSet.contains(name)) {
                fVar = (String)this.myFrameVarCache.remove((Object)fvKey);
                if (fVar == null) continue;
                this.myFrameVarValueCache.remove(fVar);
                this.sendRequestAndWait("-var-delete " + fVar, GDBResponse.ResultRecord.Type.done);
                if (myFrameVarDisposeListener == null) continue;
                myFrameVarDisposeListener.consume((Object)fVar);
                continue;
            }
            fVar = (String)this.myFrameVarCache.get((Object)fvKey);
            if (fVar != null && (value = gdbTuple.get("value", String.class)) != null) {
                this.myFrameVarValueCache.put(fVar, value);
            }
            uniqueSet.add(name);
            result2.add(each);
        }
        GDBTuple gDBTuple = result2;
        if (gDBTuple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doLoadFrameVariables"));
        }
        return gDBTuple;
    }

    @NotNull
    private Pair<String, String> doGetFrameVariableAndValue(@NotNull String frameAddr, @NotNull String name) throws DBCannotCollectVariablesException, ExecutionException {
        String value;
        if (frameAddr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameAddr", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doGetFrameVariableAndValue"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doGetFrameVariableAndValue"));
        }
        String fVKey = GDBDriver.makeFVKey(frameAddr, name);
        String fVar = (String)this.myFrameVarCache.get((Object)fVKey);
        if (fVar == null) {
            GDBResponse.Record varObj = this.sendRequestAndWait("-var-create - \"" + frameAddr + "\" \"" + name + "\"", null);
            if (varObj.getType() != GDBResponse.ResultRecord.Type.done) {
                throw new DBCannotCollectVariablesException("Cannot create variable object: " + varObj.toString());
            }
            fVar = varObj.getResultList().get("name", String.class);
            this.myFrameVarCache.put((Object)fVKey, (Object)fVar);
            value = StringUtil.notNullize((String)varObj.getResultList().get("value", String.class));
            this.myFrameVarValueCache.put(fVar, value);
        } else {
            value = this.myFrameVarValueCache.get(fVar);
        }
        Pair pair = Pair.create((Object)fVar, (Object)value);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "doGetFrameVariableAndValue"));
        }
        return pair;
    }

    @NotNull
    private static String makeFVKey(@NotNull String frameAddr, @NotNull String name) {
        if (frameAddr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameAddr", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "makeFVKey"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "makeFVKey"));
        }
        String string = frameAddr + "-" + name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver", "makeFVKey"));
        }
        return string;
    }

    static {
        INT_MAX_VALUE_BI = BigInteger.valueOf(Integer.MAX_VALUE);
        ORIGINAL_LOCATION = Pattern.compile("(.*):(\\d+)");
    }

    private class LLValueLoader {
        @NotNull
        private final String frameAddr;

        public LLValueLoader(String frameAddr) {
            if (frameAddr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameAddr", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$LLValueLoader", "<init>"));
            }
            this.frameAddr = frameAddr;
        }

        public boolean doLoadValue(LLValue llValue) throws ExecutionException {
            try {
                Pair gdbVarValue = GDBDriver.this.doGetFrameVariableAndValue(this.frameAddr, llValue.getName());
                llValue.setId((String)gdbVarValue.first);
                llValue.setValue((String)gdbVarValue.second);
                llValue.setStruct(GDBDriver.STRUCT_VALUE.equals(gdbVarValue.second));
            }
            catch (DBCannotCollectVariablesException e) {
                CidrDebuggerLog.LOG.debug(e.getMessage());
                llValue.setValue(CidrDebuggerBundle.message("debug.gdb.cannotCollectVariable", new Object[0]));
                llValue.setValid(false);
                llValue.setChildrenCount(0);
                return false;
            }
            return true;
        }
    }

    private static class MapElement {
        @NotNull
        private final LLValue myKey;
        @NotNull
        private final LLValue myValue;

        public MapElement(@NotNull LLValue key, @NotNull LLValue value) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$MapElement", "<init>"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$MapElement", "<init>"));
            }
            this.myKey = key;
            this.myValue = value;
        }

        @NotNull
        public LLValue getKey() {
            LLValue lLValue = this.myKey;
            if (lLValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$MapElement", "getKey"));
            }
            return lLValue;
        }

        @NotNull
        public LLValue getValue() {
            LLValue lLValue = this.myValue;
            if (lLValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$MapElement", "getValue"));
            }
            return lLValue;
        }
    }

    private static class RuntimeDBCannotLoadVariableException
    extends RuntimeException {
        private RuntimeDBCannotLoadVariableException(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$RuntimeDBCannotLoadVariableException", "<init>"));
            }
            super(message);
        }
    }

    private static class RuntimeDBCannotSetBreakpointException
    extends RuntimeException {
        private RuntimeDBCannotSetBreakpointException(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$RuntimeDBCannotSetBreakpointException", "<init>"));
            }
            super(message);
        }

        private RuntimeDBCannotSetBreakpointException(@NotNull String message, @NotNull Throwable cause) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$RuntimeDBCannotSetBreakpointException", "<init>"));
            }
            if (cause == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cause", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$RuntimeDBCannotSetBreakpointException", "<init>"));
            }
            super(message, cause);
        }
    }

    private static class RuntimeDBCannotEvaluateException
    extends RuntimeException {
        private RuntimeDBCannotEvaluateException(@NotNull String message, @NotNull Throwable cause) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$RuntimeDBCannotEvaluateException", "<init>"));
            }
            if (cause == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cause", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$RuntimeDBCannotEvaluateException", "<init>"));
            }
            super(message, cause);
        }
    }

    private static class RuntimeDBCannotCollectFramesException
    extends RuntimeException {
        private RuntimeDBCannotCollectFramesException(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$RuntimeDBCannotCollectFramesException", "<init>"));
            }
            super(message);
        }
    }

    private static class RuntimeDBCannotCollectVariablesException
    extends RuntimeException {
        private RuntimeDBCannotCollectVariablesException(@NotNull Throwable cause) {
            if (cause == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cause", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$RuntimeDBCannotCollectVariablesException", "<init>"));
            }
            super(cause.getMessage(), cause);
        }

        private RuntimeDBCannotCollectVariablesException(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$RuntimeDBCannotCollectVariablesException", "<init>"));
            }
            super(message);
        }
    }

    private static interface ConsoleCommand<T>
    extends SuspendedCommand<T> {
    }

    private static interface SuspendedCommand<T>
    extends Command<T> {
    }

    protected static interface Command<T> {
        @Nullable
        public T run() throws ExecutionException;
    }

    private static enum VarDomain {
        SHARED_LIBRARY("sharedLibrary"),
        REMOTE("remote");

        @NotNull
        private final String myGDBParam;

        private VarDomain(String gdbParam) {
            if (gdbParam == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gdbParam", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$VarDomain", "<init>"));
            }
            this.myGDBParam = gdbParam;
        }

        @NotNull
        public String getGDBParam() {
            String string = this.myGDBParam;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$VarDomain", "getGDBParam"));
            }
            return string;
        }
    }
}

