/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLFrame {
    public static final String UNKNOWN_FUNCTION = "<unknown routine>";
    private final int myNumber;
    @NotNull
    private final String myFunction;
    @Nullable
    private final String myFile;
    private final int myLine;
    private final long myProgramCounter;
    @Nullable
    private final DebuggerDriver.DebuggerLanguage myLanguage;

    /*
     * WARNING - void declaration
     */
    public LLFrame(int number, @NotNull String function, @Nullable String file2, int line, long pc, @Nullable DebuggerDriver.DebuggerLanguage debuggerLanguage) {
        void language;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/cidr/execution/debugger/backend/LLFrame", "<init>"));
        }
        this.myNumber = number;
        this.myFunction = function;
        this.myFile = file2;
        this.myLine = line;
        this.myProgramCounter = pc;
        this.myLanguage = language;
    }

    public int getNumber() {
        return this.myNumber;
    }

    @NotNull
    public String getFunction() {
        String string = this.myFunction;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/LLFrame", "getFunction"));
        }
        return string;
    }

    @Nullable
    public String getFile() {
        return this.myFile;
    }

    public int getLine() {
        return this.myLine;
    }

    public long getProgramCounter() {
        return this.myProgramCounter;
    }

    @Nullable
    public DebuggerDriver.DebuggerLanguage getLanguage() {
        return this.myLanguage;
    }

    public String toString() {
        return String.format("%d: 0x%X %s@%s:%d (%s)", this.myNumber, this.myProgramCounter, this.myFunction, this.myFile, this.myLine, this.myLanguage);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LLFrame gdbFrame = (LLFrame)o;
        if (this.myLine != gdbFrame.myLine) {
            return false;
        }
        if (this.myNumber != gdbFrame.myNumber) {
            return false;
        }
        if (!this.myFunction.equals(gdbFrame.myFunction)) {
            return false;
        }
        if (this.myFile != null ? !this.myFile.equals(gdbFrame.myFile) : gdbFrame.myFile != null) {
            return false;
        }
        if (this.myProgramCounter != gdbFrame.myProgramCounter) {
            return false;
        }
        return !(this.myLanguage != null ? !this.myLanguage.equals(gdbFrame.myLanguage) : gdbFrame.myLanguage != null);
    }

    public int hashCode() {
        int result2 = this.myNumber;
        result2 = 31 * result2 + this.myFunction.hashCode();
        result2 = 31 * result2 + (this.myFile != null ? this.myFile.hashCode() : 0);
        result2 = 31 * result2 + this.myLine;
        result2 = 31 * result2 + Long.valueOf(this.myProgramCounter).hashCode();
        result2 = 31 * result2 + (this.myLanguage != null ? this.myLanguage.hashCode() : 0);
        return result2;
    }
}

