/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBValueRendererFactory;
import com.jetbrains.cidr.execution.debugger.evaluation.ValueRendererFactory;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLDBDriverConfiguration
extends DebuggerDriverConfiguration {
    private static File myLLDBFrontedExecutable;

    @Override
    @NotNull
    public DebuggerDriver createDriver(@NotNull DebuggerDriver.Handler handler2) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/jetbrains/cidr/execution/debugger/backend/LLDBDriverConfiguration", "createDriver"));
        }
        LLDBDriver lLDBDriver = new LLDBDriver(handler2, this);
        if (lLDBDriver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/LLDBDriverConfiguration", "createDriver"));
        }
        return lLDBDriver;
    }

    @NotNull
    protected File getLLDBFrameworkFile() {
        File file2 = this.getLLDBBinFile(SystemInfo.isWindows ? "liblldb.dll" : (SystemInfo.isLinux ? "lib/liblldb.so.3" : "LLDB.framework"));
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/LLDBDriverConfiguration", "getLLDBFrameworkFile"));
        }
        return file2;
    }

    @NotNull
    protected File getLLDBBinFile(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/jetbrains/cidr/execution/debugger/backend/LLDBDriverConfiguration", "getLLDBBinFile"));
        }
        File file2 = CidrDebuggerPathManager.getLLDBBinFile(relativePath);
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/LLDBDriverConfiguration", "getLLDBBinFile"));
        }
        return file2;
    }

    @Override
    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver, @NotNull Installer installer, @NotNull String architecture) throws ExecutionException {
        File frontendExecutable;
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/jetbrains/cidr/execution/debugger/backend/LLDBDriverConfiguration", "createDriverCommandLine"));
        }
        if (installer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installer", "com/jetbrains/cidr/execution/debugger/backend/LLDBDriverConfiguration", "createDriverCommandLine"));
        }
        if (architecture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "architecture", "com/jetbrains/cidr/execution/debugger/backend/LLDBDriverConfiguration", "createDriverCommandLine"));
        }
        File lldbFrameworkFile = this.getLLDBFrameworkFile();
        if (!lldbFrameworkFile.exists()) {
            throw new ExecutionException(lldbFrameworkFile + " not found");
        }
        File file2 = myLLDBFrontedExecutable != null ? myLLDBFrontedExecutable : (frontendExecutable = this.getLLDBBinFile(SystemInfo.isWindows ? "LLDBFrontend.exe" : "LLDBFrontend"));
        if (!frontendExecutable.exists()) {
            throw new ExecutionException(frontendExecutable.getAbsolutePath() + " not found");
        }
        GeneralCommandLine result2 = new GeneralCommandLine();
        result2.setExePath(frontendExecutable.getAbsolutePath());
        result2.addParameter(String.valueOf(((LLDBDriver)driver).getPort()));
        LLDBDriverConfiguration.setupCommonParameters(result2);
        Map env = result2.getEnvironment();
        if (SystemInfo.isLinux) {
            env.put("LD_LIBRARY_PATH", lldbFrameworkFile.getParent());
        } else if (SystemInfo.isWindows) {
            env.put("PATH", lldbFrameworkFile.getParent() + ";" + frontendExecutable.getParent());
        } else if (SystemInfo.isMac) {
            env.put("DYLD_FRAMEWORK_PATH", lldbFrameworkFile.getParent());
            File debugserver = new File(lldbFrameworkFile, "Resources/debugserver");
            if (!debugserver.exists()) {
                throw new ExecutionException(debugserver.getAbsolutePath() + " not found");
            }
            env.put("LLDB_DEBUGSERVER_PATH", debugserver.getAbsolutePath());
            env.put("LLDB_DEBUGSERVER_EXTRA_ARG_1", "--reverse-connect");
            env.put("NSUnbufferedIO", "YES");
            File pythonDir = CidrDebuggerPathManager.getSystemPythonBinDir();
            if (pythonDir != null) {
                env.put("PATH", pythonDir.getAbsolutePath());
            } else {
                CidrDebuggerLog.LOG.warn("Python bin dir not found");
            }
            result2.putUserData(LLDBDriver.ENABLE_STL_RENDERERS, (Object)true);
            env.put("PYTHONPATH", CidrDebuggerPathManager.getBundledLLDBSTLPrettyPrinters().getAbsolutePath());
        }
        this.configureDriverCommandLine(result2);
        GeneralCommandLine generalCommandLine = result2;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/LLDBDriverConfiguration", "createDriverCommandLine"));
        }
        return generalCommandLine;
    }

    protected void configureDriverCommandLine(@NotNull GeneralCommandLine result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/execution/debugger/backend/LLDBDriverConfiguration", "configureDriverCommandLine"));
        }
    }

    public static void setLLDBFrontedExecutable(@Nullable File LLDBFrontedExecutable) {
        myLLDBFrontedExecutable = LLDBFrontedExecutable;
    }

    @Override
    @NotNull
    public ValueRendererFactory getValueRenderersFactory() {
        LLDBValueRendererFactory lLDBValueRendererFactory = new LLDBValueRendererFactory();
        if (lLDBValueRendererFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/LLDBDriverConfiguration", "getValueRenderersFactory"));
        }
        return lLDBValueRendererFactory;
    }
}

