/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrEvaluatorHelper;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCProtocolExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCEvaluatorHelper
extends CidrEvaluatorHelper {
    @NotNull
    private static Pair<OCType, String> convertExpressionPrivate(CidrDebugProcess process, String originalExpression, @Nullable XSourcePosition position) throws CidrEvaluatorHelper.ConversionException {
        String text;
        PsiFile psiFile;
        OCType resolvedType = null;
        if (position == null) {
            throw new CidrEvaluatorHelper.ConversionException(CidrBundle.message("debug.evaluate.error.noExecutionPoint", new Object[0]));
        }
        PsiElement context = process.getTypesHelper().getContextElement(position);
        if (context == null) {
            throw new CidrEvaluatorHelper.ConversionException(CidrBundle.message("debug.evaluate.error.debugInfoIsOutdated", new Object[0]));
        }
        OCFile fragment = OCElementFactory.expressionCodeFragment(originalExpression, context.getProject(), context, false, false);
        if (PsiTreeUtil.hasErrorElements((PsiElement)fragment.getContainingFile()) && PsiTreeUtil.hasErrorElements((PsiElement)(fragment = OCElementFactory.expressionCodeFragmentCpp(originalExpression, context.getProject(), context, false, false)).getContainingFile())) {
            throw new CidrEvaluatorHelper.ConversionException(CidrBundle.message("debug.evaluate.error.invalidExpression", new Object[0]));
        }
        if (PsiTreeUtil.hasErrorElements((PsiElement)(fragment = OCEvaluatorHelper.preConvertExpression(fragment)).getContainingFile())) {
            throw new CidrEvaluatorHelper.ConversionException(CidrBundle.message("debug.evaluate.error.invalidExpression", new Object[0]));
        }
        OCExpression expression = (OCExpression)PsiTreeUtil.findChildOfType((PsiElement)fragment, OCExpression.class);
        if (expression != null && !(expression instanceof OCCastExpression) && (psiFile = PsiManager.getInstance((Project)process.getProject()).findFile(position.getFile())) != null) {
            Language language = psiFile.getLanguage();
            if (language != OCLanguage.getInstance()) {
                throw new CidrEvaluatorHelper.ConversionException(CidrBundle.message("debug.evaluate.error.cannotEvaluateExpressionForLanguage", language.getDisplayName()));
            }
            resolvedType = expression.getType().resolve(psiFile);
        }
        if ((text = (fragment = OCEvaluatorHelper.postConvertExpression(fragment)).getText()) == null) {
            CidrDebuggerLog.LOG.error("Fragment text is 'null'" + fragment + "\noriginal expression: " + originalExpression);
            throw new CidrEvaluatorHelper.ConversionException(CidrBundle.message("debug.evaluate.error.invalidExpression", new Object[0]));
        }
        Pair pair = Pair.create(resolvedType, (Object)text);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/OCEvaluatorHelper", "convertExpressionPrivate"));
        }
        return pair;
    }

    @NotNull
    private static OCFile preConvertExpression(@NotNull OCFile original) throws CidrEvaluatorHelper.ConversionException {
        OCMacroCall macro;
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/jetbrains/cidr/execution/debugger/OCEvaluatorHelper", "preConvertExpression"));
        }
        LinkedHashSet<String> recursionGuard = new LinkedHashSet<String>();
        while ((macro = (OCMacroCall)PsiTreeUtil.findChildOfType((PsiElement)original, OCMacroCall.class)) != null) {
            String replacement = macro.getReplacementText();
            TextRange range = macro.getTextRange();
            String originalText = original.getText();
            if (!recursionGuard.add(originalText) || recursionGuard.size() > 1000) {
                CidrDebuggerLog.LOG.info("Cannot expands macros. Recursion guard (" + recursionGuard.size() + "):\n" + StringUtil.join(recursionGuard, (String)"\n"));
                throw new CidrEvaluatorHelper.ConversionException(CidrBundle.message("debug.evaluate.error.cannotSubstituteMacros", new Object[0]));
            }
            String newText = StringUtil.replaceSubstring((String)originalText, (TextRange)range, (String)replacement);
            original = OCElementFactory.expressionCodeFragment(newText, original.getProject(), original.getContext(), false, false);
        }
        original.accept(new PreConverter());
        OCFile oCFile = original;
        if (oCFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/OCEvaluatorHelper", "preConvertExpression"));
        }
        return oCFile;
    }

    @NotNull
    private static OCFile postConvertExpression(@NotNull OCFile original) throws CidrEvaluatorHelper.ConversionException {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/jetbrains/cidr/execution/debugger/OCEvaluatorHelper", "postConvertExpression"));
        }
        original.accept(new PostConverter());
        OCFile oCFile = original;
        if (oCFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/OCEvaluatorHelper", "postConvertExpression"));
        }
        return oCFile;
    }

    @Override
    public String convertExpression(@NotNull CidrDebugProcess process, String originalExpression, @Nullable XSourcePosition position) throws CidrEvaluatorHelper.ConversionException {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/jetbrains/cidr/execution/debugger/OCEvaluatorHelper", "convertExpression"));
        }
        return (String)OCEvaluatorHelper.convertExpressionPrivate((CidrDebugProcess)process, (String)originalExpression, (XSourcePosition)position).second;
    }

    @Override
    public Pair<LLValue, String> convertAndEvaluate(final @NotNull CidrDebugProcess process, @NotNull DebuggerDriver driver, final @NotNull XExpression expression, final @Nullable XSourcePosition sourcePosition, int frameNumber, int threadId) throws ExecutionException, DBCannotEvaluateException {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/jetbrains/cidr/execution/debugger/OCEvaluatorHelper", "convertAndEvaluate"));
        }
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/jetbrains/cidr/execution/debugger/OCEvaluatorHelper", "convertAndEvaluate"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/cidr/execution/debugger/OCEvaluatorHelper", "convertAndEvaluate"));
        }
        final Ref convertedExpression = new Ref();
        final Ref resolvedType = new Ref();
        final LinkedHashSet expressions = new LinkedHashSet(3);
        final Ref lastException = new Ref();
        new WriteAction(){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/execution/debugger/OCEvaluatorHelper$1", "run"));
                }
                try {
                    Pair converted = OCEvaluatorHelper.convertExpressionPrivate(process, expression.getExpression(), sourcePosition);
                    convertedExpression.set(converted.second);
                    resolvedType.set(converted.first);
                }
                catch (CidrEvaluatorHelper.ConversionException e) {
                    lastException.set((Object)new DBCannotEvaluateException(e));
                    return;
                }
                expressions.add(convertedExpression.get());
                OCType type = (OCType)resolvedType.get();
                PsiElement debuggerContext = process.getDebuggerContext(sourcePosition);
                if (!resolvedType.isNull() && !type.isUnknown()) {
                    PsiFile file2;
                    PsiFile psiFile = file2 = debuggerContext != null ? debuggerContext.getContainingFile() : null;
                    if (file2 != null) {
                        if (process.getRendererFactory().supportsArrayEvaluation() && type instanceof OCArrayType) {
                            type = type.convertArrayToPointer(file2);
                        }
                        if (type instanceof OCCppReferenceType && ((OCCppReferenceType)type).isRvalueRef()) {
                            type = ((OCCppReferenceType)type).getRefType();
                        }
                        if (!(type instanceof OCArrayType)) {
                            OCType baseType = type;
                            while (baseType instanceof OCPointerType) {
                                baseType = ((OCPointerType)baseType).getRefType();
                            }
                            if (baseType instanceof OCStructType) {
                                expressions.add("((" + type.getCanonicalName((PsiElement)file2) + ")(" + (String)convertedExpression.get() + "))");
                                return;
                            }
                        }
                        expressions.add("((" + type.getCanonicalName((PsiElement)file2) + ")(" + (String)convertedExpression.get() + "))");
                    } else {
                        CidrDebuggerLog.LOG.warn("Cannot get PsiFile for " + (sourcePosition != null ? sourcePosition.toString() : "UNKNOWN POSITION"));
                    }
                    expressions.add("((" + type.getName() + ")(" + (String)convertedExpression.get() + "))");
                }
            }
        }.execute();
        if (expressions.isEmpty()) {
            DBCannotEvaluateException exception = (DBCannotEvaluateException)lastException.get();
            if (exception == null) {
                CidrDebuggerLog.LOG.error("exception is null for: " + expression);
                throw new DBCannotEvaluateException(CidrBundle.message("debug.evaluate.error.invalidExpression", new Object[0]));
            }
            throw exception;
        }
        LLValue result2 = null;
        String actualExpression = null;
        for (String each : ContainerUtil.iterateBackward(new ArrayList(expressions))) {
            try {
                result2 = driver.evaluate(threadId, frameNumber, each);
                actualExpression = each;
                break;
            }
            catch (DBCannotEvaluateException e) {
                lastException.set((Object)e);
            }
        }
        CidrDebuggerLog.LOG.assertTrue(result2 != null || !lastException.isNull());
        if (result2 == null) {
            CidrDebuggerLog.LOG.debug((Throwable)lastException.get());
            throw (DBCannotEvaluateException)lastException.get();
        }
        return Pair.create((Object)((Object)result2), actualExpression);
    }

    private static class PostConverter
    extends MyVisitor {
        private PostConverter() {
        }

        @Override
        public void visitReferenceExpression(OCReferenceExpression expression) {
            OCSymbolKind kind;
            OCSymbol symbol = expression.resolveToSymbol();
            OCSymbolKind oCSymbolKind = kind = symbol == null ? null : symbol.getKind();
            if (kind == OCSymbolKind.INTERFACE || kind == OCSymbolKind.IMPLEMENTATION ? this.replaceAndVisitClass(expression, symbol.getName()) : kind == OCSymbolKind.PROTOCOL && this.replaceAndVisitProtocol(expression, symbol.getName())) {
                return;
            }
            super.visitReferenceExpression(expression);
        }

        @Override
        public void visitProtocolExpression(OCProtocolExpression expression) {
            OCTypeElement type = expression.getTypeElement();
            if (type != null && this.replaceAndVisitProtocol(expression, type.getText())) {
                return;
            }
            super.visitProtocolExpression(expression);
        }

        private boolean replaceAndVisitClass(OCReferenceExpression expression, String name) {
            return this.replaceAndVisit(expression, "(id)NSClassFromString(@\"" + name + "\")");
        }

        private boolean replaceAndVisitProtocol(OCExpression expression, String name) {
            return this.replaceAndVisit(expression, "(id)NSProtocolFromString(@\"" + name + "\")");
        }
    }

    private static class PreConverter
    extends MyVisitor {
        private PreConverter() {
        }

        @Override
        public void visitReferenceExpression(OCReferenceExpression expression) {
            OCSymbolKind kind;
            OCSymbol symbol = expression.resolveToSymbol();
            OCSymbolKind oCSymbolKind = kind = symbol == null ? null : symbol.getKind();
            if (kind == OCSymbolKind.INSTANCE_VARIABLE) {
                String name = symbol.getName();
                if (!"self".equals(name) && this.replaceAndVisit(expression, "self->" + name)) {
                    return;
                }
            } else if (kind == OCSymbolKind.ENUM_CONST) {
                Integer value = OCExpressionEvaluator.evaluateEnumConst(symbol, expression.getContainingFile());
                String converted = "((int)" + (value == null ? expression.getText() : String.valueOf(value)) + ")";
                OCParenthesizedExpression result2 = MyVisitor.replace(expression, converted);
                if (result2 != null) {
                    return;
                }
            }
            super.visitReferenceExpression(expression);
        }

        @Override
        public void visitQualifiedExpression(OCQualifiedExpression expression) {
            Prop prop = PreConverter.getProp(expression);
            if (prop != null && prop.getter != null && this.replaceAndVisit(expression, "[" + prop.receiver + " " + prop.getter + "]")) {
                return;
            }
            super.visitQualifiedExpression(expression);
        }

        @Override
        public void visitAssignmentExpression(OCAssignmentExpression expression) {
            Prop prop = PreConverter.getProp(expression.getReceiverExpression());
            OCExpression argExp = expression.getSourceExpression();
            if (prop != null && prop.isReadWrite() && argExp != null) {
                String arg = argExp.getText();
                String sign = expression.getOperationSign().getName();
                if (sign.endsWith("=") && sign.length() == 2) {
                    arg = "([" + prop.receiver + " " + prop.getter + "]" + sign.substring(0, 1) + arg + ")";
                }
                if (this.replaceAndVisit(expression, "[" + prop.receiver + " " + prop.setter + " " + arg + "]")) {
                    return;
                }
            }
            super.visitAssignmentExpression(expression);
        }

        @Override
        public void visitPrefixExpression(OCPrefixExpression expression) {
            if (this.doVisitXFixExpression(expression, true)) {
                return;
            }
            super.visitPrefixExpression(expression);
        }

        @Override
        public void visitPostfixExpression(OCPostfixExpression expression) {
            if (this.doVisitXFixExpression(expression, false)) {
                return;
            }
            super.visitPostfixExpression(expression);
        }

        private boolean doVisitXFixExpression(OCExpression expression, boolean isPrefix) {
            Prop prop = PreConverter.getProp(isPrefix ? ((OCPrefixExpression)expression).getOperand() : ((OCPostfixExpression)expression).getOperand());
            if (prop == null || !prop.isReadWrite()) {
                return false;
            }
            String sign = (isPrefix ? ((OCPrefixExpression)expression).getOperationSign() : ((OCPostfixExpression)expression).getOperationSign()).getName();
            String fix = sign.equals("--") ? "-1" : "+1";
            String getExpr = "[" + prop.receiver + " " + prop.getter + "]" + fix;
            return this.replaceAndVisit(expression, "[" + prop.receiver + " " + prop.setter + " " + getExpr + "]");
        }

        @Nullable
        private static Prop getProp(@Nullable OCExpression exp) {
            if (exp instanceof OCQualifiedExpression) {
                OCSymbol symbol = ((OCQualifiedExpression)exp).resolveToSymbol();
                String receiver = ((OCQualifiedExpression)exp).getQualifier().getText();
                if (symbol instanceof OCPropertySymbol) {
                    return new Prop(receiver, ((OCPropertySymbol)symbol).getGetterName(), ((OCPropertySymbol)symbol).getSetterName());
                }
                if (symbol instanceof OCMethodSymbol) {
                    OCMethodSymbol method = (OCMethodSymbol)symbol;
                    String name = symbol.getName();
                    return new Prop(receiver, method.isGetter() ? name : OCNameSuggester.getObjCGetterFromSetter(name), method.isSetter() ? name : OCNameSuggester.getObjCSetterFromGetter(name));
                }
            }
            return null;
        }

        private static class Prop {
            @NotNull
            public final String receiver;
            @Nullable
            public final String getter;
            @Nullable
            public final String setter;

            private Prop(@NotNull String receiver, @Nullable String getter, @Nullable String setter) {
                if (receiver == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "com/jetbrains/cidr/execution/debugger/OCEvaluatorHelper$PreConverter$Prop", "<init>"));
                }
                this.receiver = receiver;
                this.getter = getter;
                this.setter = setter;
            }

            public boolean isReadWrite() {
                return this.getter != null && this.setter != null;
            }
        }
    }

    private static abstract class MyVisitor
    extends OCRecursiveVisitor {
        private MyVisitor() {
        }

        protected boolean replaceAndVisit(@NotNull OCExpression expression, @NotNull String converted) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/cidr/execution/debugger/OCEvaluatorHelper$MyVisitor", "replaceAndVisit"));
            }
            if (converted == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converted", "com/jetbrains/cidr/execution/debugger/OCEvaluatorHelper$MyVisitor", "replaceAndVisit"));
            }
            super.visitParenthesizedExpression(MyVisitor.replace(expression, converted));
            return true;
        }

        @Nullable
        protected static OCParenthesizedExpression replace(@NotNull OCExpression expression, @NotNull String converted) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/cidr/execution/debugger/OCEvaluatorHelper$MyVisitor", "replace"));
            }
            if (converted == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converted", "com/jetbrains/cidr/execution/debugger/OCEvaluatorHelper$MyVisitor", "replace"));
            }
            OCExpression replacement = OCElementFactory.expressionFromText("(" + converted + ")", expression, false);
            if (replacement == null) {
                return null;
            }
            return (OCParenthesizedExpression)expression.replace(replacement);
        }
    }
}

