/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.cidr.execution.debugger.OCDebuggerTypesHelper;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDebuggerEditorsProvider
extends XDebuggerEditorsProvider {
    @NotNull
    public FileType getFileType() {
        OCFileType oCFileType = OCFileType.INSTANCE;
        if (oCFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/OCDebuggerEditorsProvider", "getFileType"));
        }
        return oCFileType;
    }

    @NotNull
    public Document createDocument(final @NotNull Project project, final @NotNull String text, @Nullable XSourcePosition sourcePosition, final @NotNull EvaluationMode mode) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/execution/debugger/OCDebuggerEditorsProvider", "createDocument"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/execution/debugger/OCDebuggerEditorsProvider", "createDocument"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/jetbrains/cidr/execution/debugger/OCDebuggerEditorsProvider", "createDocument"));
        }
        final PsiElement context = OCDebuggerTypesHelper.getContextElement(sourcePosition, project);
        if (context != null && context.getLanguage() == OCLanguage.getInstance()) {
            Document document = (Document)new WriteAction<Document>(){

                protected void run(@NotNull Result<Document> result2) throws Throwable {
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/execution/debugger/OCDebuggerEditorsProvider$1", "run"));
                    }
                    OCCodeFragment fragment = mode == EvaluationMode.EXPRESSION ? OCElementFactory.expressionCodeFragment(text, project, context, true, false) : OCElementFactory.expressionOrStatementsCodeFragment(text, project, context, true, false);
                    result2.setResult((Object)PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment));
                }
            }.execute().getResultObject();
            if (document == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/OCDebuggerEditorsProvider", "createDocument"));
            }
            return document;
        }
        LightVirtualFile plainTextFile = new LightVirtualFile("oc-debug-editor-when-no-source-position-available.txt", (CharSequence)text);
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)plainTextFile);
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/OCDebuggerEditorsProvider", "createDocument"));
        }
        return document;
    }
}

