/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionAdapter;
import com.intellij.xdebugger.XDebugSessionListener;
import com.jetbrains.cidr.execution.debugger.BackendConsoleInjectionHelper;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.lang.GDBExpressionPlaceholder;
import com.jetbrains.cidr.lang.editor.OCInjectionListener;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBackendConsoleInjectionHelper
implements BackendConsoleInjectionHelper {
    @Override
    public void subscribeToInjection(@NotNull XDebugSession session) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/cidr/execution/debugger/OCBackendConsoleInjectionHelper", "subscribeToInjection"));
        }
        final MessageBusConnection connection = session.getProject().getMessageBus().connect();
        class Listener
        extends XDebugSessionAdapter
        implements OCInjectionListener {
            private volatile Pair<Document, OCCodeFragment> myDocumentAndFragment;

            Listener() {
            }

            @Override
            public void didInject(@NotNull OCFile injected, PsiLanguageInjectionHost host) {
                Document document;
                if (injected == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injected", "com/jetbrains/cidr/execution/debugger/OCBackendConsoleInjectionHelper$1Listener", "didInject"));
                }
                if (host instanceof GDBExpressionPlaceholder && (document = host.getContainingFile().getOriginalFile().getViewProvider().getDocument()) != null) {
                    this.myDocumentAndFragment = Pair.create((Object)document, (Object)((OCCodeFragment)injected));
                    OCBackendConsoleInjectionHelper.updateContextInGDBConsole((Pair<Document, OCCodeFragment>)this.myDocumentAndFragment);
                }
            }

            public void stackFrameChanged() {
                OCBackendConsoleInjectionHelper.updateContextInGDBConsole((Pair<Document, OCCodeFragment>)this.myDocumentAndFragment);
            }

            public void sessionStopped() {
                connection.disconnect();
            }
        }
        Listener listener = new Listener();
        connection.subscribe(OCInjectionListener.INJECTION_TOPIC, (Object)listener);
        session.addSessionListener((XDebugSessionListener)listener);
    }

    private static void updateContextInGDBConsole(@Nullable Pair<Document, OCCodeFragment> documentAndFragment) {
        if (documentAndFragment == null) {
            return;
        }
        CidrDebugProcess process = (CidrDebugProcess)((Document)documentAndFragment.first).getUserData(CidrDebugProcess.DEBUG_PROCESS_KEY);
        if (process != null) {
            ((OCCodeFragment)documentAndFragment.second).setContext(process.getDebuggerContext());
        }
    }
}

