/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLanguageSupportFactory;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.XValueNodeExpirable;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrStackFrame
extends XStackFrame {
    @NotNull
    private final CidrDebugProcess myProcess;
    private final int myThreadId;
    @NotNull
    private final LLFrame myFrame;
    @NotNull
    private final LLFrame mySourcePositionFrame;
    @Nullable
    private final CidrSuspensionCause mySuspensionCause;
    private final Map<String, CachedTypeInfo> myCachedTypeInfo;

    public CidrStackFrame(@NotNull CidrDebugProcess process, int threadId, @NotNull LLFrame frame, @Nullable CidrStackFrame nextFrame, @Nullable CidrSuspensionCause suspensionCause) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/jetbrains/cidr/execution/debugger/CidrStackFrame", "<init>"));
        }
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/jetbrains/cidr/execution/debugger/CidrStackFrame", "<init>"));
        }
        this.myCachedTypeInfo = new HashMap();
        this.myProcess = process;
        this.myThreadId = threadId;
        this.myFrame = frame;
        this.mySuspensionCause = suspensionCause;
        LLFrame suspendFrame = this.myFrame;
        if (CidrStackFrame.getSourcePosition(suspendFrame) == null && nextFrame != null) {
            suspendFrame = nextFrame.mySourcePositionFrame;
        }
        this.mySourcePositionFrame = suspendFrame;
    }

    public int getThreadId() {
        return this.myThreadId;
    }

    @NotNull
    public LLFrame getFrame() {
        LLFrame lLFrame = this.myFrame;
        if (lLFrame == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/CidrStackFrame", "getFrame"));
        }
        return lLFrame;
    }

    @NotNull
    public LLFrame getSourcePositionFrame() {
        LLFrame lLFrame = this.mySourcePositionFrame;
        if (lLFrame == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/CidrStackFrame", "getSourcePositionFrame"));
        }
        return lLFrame;
    }

    public int getFrameNumber() {
        return this.mySourcePositionFrame.getNumber();
    }

    public Object getEqualityObject() {
        return this.myThreadId + 31 * this.mySourcePositionFrame.getNumber();
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return CidrStackFrame.getSourcePosition(this.mySourcePositionFrame);
    }

    @Nullable
    private static XSourcePosition getSourcePosition(final LLFrame frame) {
        final String file2 = frame.getFile();
        if (file2 == null) {
            return null;
        }
        return (XSourcePosition)ApplicationManager.getApplication().runReadAction((Computable)new Computable<XSourcePosition>(){

            public XSourcePosition compute() {
                VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(file2);
                return vFile == null ? null : XDebuggerUtil.getInstance().createPosition(vFile, frame.getLine());
            }
        });
    }

    @Nullable
    public PsiElement getContext() {
        return (PsiElement)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<PsiElement>(){

            public PsiElement compute() {
                return CidrStackFrame.this.myProcess.getTypesHelper().getContextElement(CidrStackFrame.this.getSourcePosition());
            }
        });
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/cidr/execution/debugger/CidrStackFrame", "customizePresentation"));
        }
        XSourcePosition pos = CidrStackFrame.getSourcePosition(this.myFrame);
        if (pos != null) {
            component.append(this.myFrame.getFunction(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            component.append(" " + pos.getFile().getName() + ":" + (this.myFrame.getLine() + 1), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        } else {
            component.append(this.myFrame.getFunction(), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/execution/debugger/CidrStackFrame", "computeChildren"));
        }
        this.myProcess.postCommand(new CidrDebugProcess.DebuggerImplicitCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                if (driver == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/jetbrains/cidr/execution/debugger/CidrStackFrame$3", "run"));
                }
                if (node.isObsolete()) {
                    return;
                }
                if (CidrStackFrame.this.mySuspensionCause != null) {
                    XValueChildrenList list = new XValueChildrenList(1);
                    list.add(new XNamedValue(((CidrStackFrame)CidrStackFrame.this).mySuspensionCause.type){

                        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                            if (node == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/execution/debugger/CidrStackFrame$3$1", "computePresentation"));
                            }
                            if (place == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/jetbrains/cidr/execution/debugger/CidrStackFrame$3$1", "computePresentation"));
                            }
                            node.setPresentation(((CidrStackFrame)CidrStackFrame.this).mySuspensionCause.icon, null, ((CidrStackFrame)CidrStackFrame.this).mySuspensionCause.reason, false);
                        }
                    });
                    node.addChildren(list, false);
                }
                final XSourcePosition framePosition = CidrStackFrame.this.getSourcePosition();
                driver.setValuesFilteringEnabled(CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED);
                List vars = driver.getVariables(CidrStackFrame.this.myThreadId, CidrStackFrame.this.mySourcePositionFrame.getNumber());
                vars = ContainerUtil.filter(vars, (Condition)new Condition<LLValue>(){

                    public boolean value(final LLValue value) {
                        if (framePosition == null) {
                            value.setValid(false);
                            return true;
                        }
                        final boolean[] resolved = new boolean[1];
                        final boolean[] special = new boolean[]{false};
                        Integer variableLine = (Integer)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Integer>(){

                            public Integer compute() {
                                PsiElement declarator = CidrStackFrame.this.myProcess.getTypesHelper().resolveToDeclaration(framePosition, value);
                                boolean bl = resolved[0] = declarator != null;
                                if (declarator == null) {
                                    Boolean thisSelfSupper = CidrStackFrame.this.myProcess.getTypesHelper().isImplicitContextVariable(framePosition, value);
                                    special[0] = thisSelfSupper != null ? thisSelfSupper : false;
                                    return null;
                                }
                                PsiFile targetFile = declarator.getContainingFile();
                                if (!Comparing.equal((Object)targetFile.getVirtualFile(), (Object)framePosition.getFile())) {
                                    return null;
                                }
                                int endOffset = declarator.getTextRange().getEndOffset();
                                Document document = PsiDocumentManager.getInstance((Project)targetFile.getProject()).getDocument(targetFile);
                                if (document == null) {
                                    return null;
                                }
                                return document.getLineNumber(endOffset);
                            }
                        });
                        value.setValid(special[0] || resolved[0] && variableLine != null && variableLine < framePosition.getLine());
                        return !CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED || resolved[0] || special[0];
                    }
                });
                EvaluationContext evaluationContext = CidrStackFrame.this.getProcess().getRendererFactory().createEvaluationContext(driver, new XValueNodeExpirable((Obsolescent)node), CidrStackFrame.this);
                CidrValue.addAllTo(CidrStackFrame.this.myProcess, evaluationContext, framePosition, CidrStackFrame.this, vars, node);
            }
        });
    }

    public CidrEvaluator getEvaluator() {
        for (CidrDebuggerLanguageSupportFactory factory : (CidrDebuggerLanguageSupportFactory[])CidrDebuggerLanguageSupportFactory.EP_NAME.getExtensions()) {
            CidrEvaluator evaluator = factory.createEvaluator(this);
            if (evaluator == null) continue;
            return evaluator;
        }
        return null;
    }

    public String toString() {
        return this.myFrame + " (" + this.mySourcePositionFrame.toString() + ")";
    }

    @NotNull
    public CidrDebugProcess getProcess() {
        CidrDebugProcess cidrDebugProcess = this.myProcess;
        if (cidrDebugProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/CidrStackFrame", "getProcess"));
        }
        return cidrDebugProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedTypeInfo getTypeInfo(String type) {
        Map<String, CachedTypeInfo> map = this.myCachedTypeInfo;
        synchronized (map) {
            if (type.equals("id")) {
                return new CachedTypeInfo();
            }
            CachedTypeInfo info = this.myCachedTypeInfo.get(type);
            if (info == null) {
                info = new CachedTypeInfo();
                this.myCachedTypeInfo.put(type, info);
            }
            return info;
        }
    }

    public static class CachedTypeInfo {
        @Nullable
        Long size;
        @Nullable
        String canonicalCppName;
        private Boolean myStruct;
        private Boolean myNSCollection;
        private Boolean mySwiftFastCollection;
        private Boolean mySwiftSlowCollection;
        private boolean mySwiftDictionary;
        private Boolean myNSObject;
        private Boolean myNSManagedObject;

        @Nullable
        public Long getSize() {
            return this.size;
        }

        public void setSize(@Nullable Long size) {
            this.size = size;
        }

        public Boolean getNSManagedObject() {
            return this.myNSManagedObject;
        }

        public void setNSManagedObject(Boolean NSManagedObject) {
            this.myNSManagedObject = NSManagedObject;
        }

        @Nullable
        public String getCanonicalCppName() {
            return this.canonicalCppName;
        }

        public void setCanonicalCppName(@Nullable String canonicalCppName) {
            this.canonicalCppName = canonicalCppName;
        }

        public void setStruct(Boolean struct) {
            this.myStruct = struct;
        }

        public Boolean isStruct() {
            return this.myStruct;
        }

        public Boolean isNSCollection() {
            return this.myNSCollection;
        }

        public void setNSCollection(Boolean NSCollection) {
            this.myNSCollection = NSCollection;
        }

        public Boolean isSwiftFastCollection() {
            return this.mySwiftFastCollection;
        }

        public void setSwiftFastCollection(Boolean swiftFastCollection) {
            this.mySwiftFastCollection = swiftFastCollection;
        }

        public Boolean isSwiftSlowCollection() {
            return this.mySwiftSlowCollection;
        }

        public void setSwiftSlowCollection(Boolean swiftSlowCollection) {
            this.mySwiftSlowCollection = swiftSlowCollection;
        }

        public boolean isSwiftDictionary() {
            return this.mySwiftDictionary;
        }

        public void setSwiftDictionary(boolean swiftDictionary) {
            this.mySwiftDictionary = swiftDictionary;
        }

        public Boolean isNSObject() {
            return this.myNSObject;
        }

        public void setNSObject(Boolean isNSObject) {
            this.myNSObject = isNSObject;
        }
    }
}

