/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrEvaluatorHelper;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectVariablesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrEvaluatedValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrEvaluator
extends XDebuggerEvaluator {
    @NotNull
    protected final CidrStackFrame myFrame;

    public CidrEvaluator(@NotNull CidrStackFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/jetbrains/cidr/execution/debugger/CidrEvaluator", "<init>"));
        }
        this.myFrame = frame;
    }

    public static StringBuilder getConsoleDescriptionWithErrors(CidrPhysicalValue value, EvaluationContext context) throws ExecutionException {
        StringBuilder result2 = new StringBuilder();
        try {
            result2.append((CharSequence)value.getConsoleDescription(context));
        }
        catch (DBCannotEvaluateException e) {
            result2.append("error: ").append(e.getMessage());
        }
        catch (DBCannotCollectVariablesException e) {
            result2.append("error: ").append(e.getMessage());
        }
        return result2;
    }

    @NotNull
    public CidrEvaluatedValue doEvaluate(@NotNull DebuggerDriver driver, @Nullable XSourcePosition valuePosition, @NotNull XExpression expression) throws ExecutionException, DBCannotEvaluateException {
        String expr;
        LLValue val;
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/jetbrains/cidr/execution/debugger/CidrEvaluator", "doEvaluate"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/cidr/execution/debugger/CidrEvaluator", "doEvaluate"));
        }
        EvaluationContext context = this.getContext(driver);
        if (expression.getMode() == EvaluationMode.EXPRESSION) {
            Pair<LLValue, String> pair = CidrEvaluatorHelper.getInstance().convertAndEvaluate(this.myFrame.getProcess(), driver, expression, valuePosition, this.myFrame.getFrameNumber(), this.myFrame.getThreadId());
            val = (LLValue)((Object)pair.first);
            expr = (String)pair.second;
        } else {
            val = context.evaluate(expression.getExpression());
            expr = expression.getExpression();
        }
        CidrEvaluatedValue cidrEvaluatedValue = new CidrEvaluatedValue(this.myFrame.getProcess(), context, valuePosition, this.myFrame, val, expr);
        if (cidrEvaluatedValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/CidrEvaluator", "doEvaluate"));
        }
        return cidrEvaluatedValue;
    }

    protected EvaluationContext getContext(DebuggerDriver driver) {
        return this.myFrame.getProcess().getRendererFactory().createEvaluationContext(driver, null, this.myFrame);
    }
}

