/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.XStackFrame;
import org.jetbrains.annotations.NotNull;

public class CidrErrorStackFrame
extends XStackFrame {
    @NotNull
    private final String myErrorMessage;

    public CidrErrorStackFrame(@NotNull String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/jetbrains/cidr/execution/debugger/CidrErrorStackFrame", "<init>"));
        }
        this.myErrorMessage = errorMessage;
    }

    @NotNull
    public String getErrorMessage() {
        String string = this.myErrorMessage;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/CidrErrorStackFrame", "getErrorMessage"));
        }
        return string;
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/cidr/execution/debugger/CidrErrorStackFrame", "customizePresentation"));
        }
        component.append(this.myErrorMessage, SimpleTextAttributes.ERROR_ATTRIBUTES);
    }
}

